#include <musashi.h>
#include <xtclassify.h>
#include <tree.h>
#include <exHash.h>
#include <priorityQueue.h>
#include <math.h>
#include <string.h>

extern MssOptFLD optPAT;
extern MssOptFLD optNUM;
extern MssOptFLD optCAT;
extern MssOptFLD optCLS;
extern MssOptINF optTRN;
extern MssOptINF optTST;
extern MssOptSTR optDLM;
extern MssOptFLG optTXT;
extern MssOptINF optCST;
extern MssOptSEL optMDL;
extern MssOptFLG optSEQ;
extern MssOptINT optEND;
extern MssOptINT optBGN;
extern MssOptINT optSIZ;
extern MssOptINT optSED;
extern MssOptINT optCAN;
extern MssOptINT optTRY;
extern MssOptSEL optSPL;
extern MssOptSEL optPRB;
extern MssOptSEL optPMD;
extern MssOptINF optPRN;
extern MssOptDBL optCNF;

extern struct mssFields *fpat;
extern struct mssFields *fnum;
extern struct mssFields *fcat;
extern struct mssFields *fcls;

extern int ClassSize;

int usedRandSeed;

struct RegBest{
  struct PQnode *pqNode;
  int    cnt;
  int    maxCnt;
  double maxVal; /*ߤbest nǤκ(ǰ)sv(value for splitting criteria)*/
};

/*############################################################################*/
/*# Ƽܴؿ                                                             #*/
/*############################################################################*/
/*----------------------------------------------------------------------------*/
/* Log2η׻                                                                 */
/*----------------------------------------------------------------------------*/
double Log2(double x){
  if(x==0){
    return(0);
  }else{
    return(log(x)/log(2));
  }
}

void prnStr(FILE *fp, usint *str){

  while(*str!=0){
    fprintf(fp,"%d ",*str);
    str++;
  }
}

/*----------------------------------------------------------------------------*/
/* strcpyƱǽint                                                */
/*----------------------------------------------------------------------------*/
void StrCpy(usint *to, usint *from){
  while(*from!=0) *(to++)=*(from++);
  *to=*from;
}

/*----------------------------------------------------------------------------*/
/* strlenƱǽint                                                */
/* ANSI C/C++ŵp.618                                                        */
/*----------------------------------------------------------------------------*/
int StrLen(usint *dat){
  int i=0;
  for(i=0;dat[i];i++);
  return(i);
}

/*----------------------------------------------------------------------------*/
/* strchrƱǽint                                                */
/* ANSI C/C++ŵp.609                                                        */
/*----------------------------------------------------------------------------*/
usint *StrChr(usint *s, usint c){

  while(*s!=c){
    if(*s==0)return(NULL);
    s++;
  }
  return(s);
}

/*----------------------------------------------------------------------------*/
/* strstrƱǽint                                                */
/* ANSI C/C++ŵp.625                                                        */
/*----------------------------------------------------------------------------*/
usint *StrStr(usint *s1,usint *s2){

  if(*s2==0) return(s1);
  for(;(s1=StrChr(s1,*s2))!=NULL;s1++){
    usint *ss1=s1;
    usint *ss2=s2;
    do{
      ss2++;
      if(*ss2==0) return(s1);
      ss1++;
    }while(*ss1==*ss2);
  }
  return(NULL);
}

/*----------------------------------------------------------------------------*/
/* strcmpƱǽint                                                */
/* ANSI C/C++ŵp.620                                                        */
/*----------------------------------------------------------------------------*/
int StrCmp(usint *s1,usint *s2){

  while(*s1==*s2){
    if(*s1==0)return(0);
    s1++; s2++;
  }
  return(*s1-*s2);
}

/*----------------------------------------------------------------------------*/
/* strncmpƱǽint                                               */
/* ANSI C/C++ŵp.620                                                        */
/*----------------------------------------------------------------------------*/
int StrnCmp(usint *s1,usint *s2,int n){

  while(n && *s1 && *s2){
    int d=*s1-*s2;
    if(d) return(d);
    s1++; s2++; n--;
  }
  if(!n ) return( 0);
  if(*s1) return( 1);
  else    return(-1);
}

/*----------------------------------------------------------------------------*/
/* intꥹΰν                                                   */
/*----------------------------------------------------------------------------*/
struct StrTbl *initStrTbl(){
  struct StrTbl *st;
  st=mssMalloc(sizeof(struct StrTbl),"initStrTbl");
  st->top       =NULL;
  st->pointer   =NULL;
  st->lineCnt   =0;
  st->size      =0;
  return(st);
}
/*----------------------------------------------------------------------------*/
/* ʸꥹΰγ                                                     */
/*----------------------------------------------------------------------------*/
void freeStrTbl(struct StrTbl *st){
  if(st==NULL)return;
  mssFree(st->top);
  mssFree(st->pointer);
  mssFree(st);
}

/*----------------------------------------------------------------------------*/
/* ʸꥹΰʸϿ                                         */
/*----------------------------------------------------------------------------*/
void putStrTbl(struct StrTbl *st, usint *str){
  int i;
  int len;
  usint *ptr;

  /*ʸ󥵥Υ*/
  len=StrLen(str);

  /*ʸǼΰ*/
  st->top=mssRealloc(st->top,sizeof(usint)*(st->size+len+1),"putStrTbl");
  ptr=st->top+st->size;

  /*ʸγǼ*/
  for(i=0; i<len; i++){
    *ptr=*(str+i); ptr++;
  }
  *ptr=0;

  /*ݥ󥿤Ͽ*/
  st->pointer=mssRealloc(st->pointer,sizeof(int)*(st->lineCnt+1),"putStrTbl");
  *(st->pointer+st->lineCnt)=st->size;

  /*ԿΥȥå*/
  st->lineCnt++;
  st->size += len+1; /*ߥ͡()ʬܣ*/
}

/*----------------------------------------------------------------------------*/
/* ʸꥹΰ褫nܤint֤                                     */
/*----------------------------------------------------------------------------*/
usint *getStrTbl(struct StrTbl *st,int n){
  return( st->top+*(st->pointer+n) );
}

/*############################################################################*/
/*# ǡƼѿ˥åȤϤδؿ                                     #*/
/*#   ʤԸΨʼˤʤäƤ                                         #*/
/*############################################################################*/
/*------------------------------*/
/* ǡ򥫥Ȥؿ */
/*------------------------------*/
int bonGetCnt(struct mssFPR *fpr){
  struct mssRec *rec=NULL; /*ԥХåե¤*/
  int i=0;

  rec=mssInitRec();
  mssSeekTopFPR(fpr);
  while(EOF != mssReadRec(fpr,rec)) i++;
  mssFreeRec(rec);

  return(i);
}

/*------------------------------------------*/
/* 饹ʸ顢ֹ֤ؿ */
/*------------------------------------------*/
static char bonGetClsNum(struct BonCls *cls, char *str){
  int i;

  for(i=0; i<ClassSize; i++){
    if(0==strcmp(cls->str[i],str)) return(i);
  }
  return(-1);
}

/*----------------------------------------------------------------------*/
/* ǡǻȤƤ륯饹ͤ򥻥åȤ                         */
/* Ǥϡȥ졼˥󥰤ȥƥȤξꤦ륯饹ͤ */
/*----------------------------------------------------------------------*/
struct BonCls *bonGetCls(struct mssFPR *trn, struct mssFPR *tst, struct mssHeader *hd){

  struct BonCls *cls;    /*饹ʸ¤*/
  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  char *str;
  int flg;
  int i;
  int recCnt;

  cls=mssCalloc(sizeof(struct BonCls), "bonSetCls");
  cls->cnt=0;
  cls->chr=NULL;

  /*ȥ졼˥󥰤Υ饹*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  recCnt=0;
  while( EOF != mssReadFldRec(trn,fr) ){

    /*饹ܤͤ򥻥å*/
    str=*(fr->pnt+MssFlds2num(fcls,0));

    /*ϿƤ륯饹ܤʸ򸡺ʤflg=1*/
    flg=1;
    for(i=0; i<cls->cnt; i++){
      if(0==strcmp(cls->str[i],str)){ flg=0; break; }
    }

    /*Ͽ*/
    if(flg){
      cls->str[cls->cnt]=mssMalloc(sizeof(char)*(strlen(str)+1),"bonSetCls");
      strcpy(cls->str[cls->cnt],str);
      cls->cnt++;
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤΥ饹*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  recCnt=0;
  while( EOF != mssReadFldRec(tst,fr) ){

    /*饹ܤͤ򥻥å*/
    str=*(fr->pnt+MssFlds2num(fcls,0));

    /*ϿƤ륯饹ܤʸ򸡺ʤflg=1*/
    flg=1;
    for(i=0; i<cls->cnt; i++){
      if(0==strcmp(cls->str[i],str)){ flg=0; break; }
    }

    /*Ͽ*/
    if(flg){
      cls->str[cls->cnt]=mssMalloc(sizeof(char)*(strlen(str)+1),"bonSetCls");
      strcpy(cls->str[cls->cnt],str);
      cls->cnt++;
    }
  }
  mssFreeFldRec(fr);

  /* 饹ɽ(for debug) */
  /*
  for(i=0; i<cls->cnt; i++){
    printf("cls%d = %s\n",i,cls->str[i]);
  }
  */
  return(cls);
}

void bonFreeCls(struct BonCls *cls){
  int i;
  for(i=0; i<cls->cnt; i++){
    mssFree(cls->str[i]);
  }
  mssFree(cls);
}

/*--------------------------------------------------------------------*/
/*str򥹥ڡ(ʣϰ)ǥȡʬ䤷ƹܤdat[]˥åȤ*/
/*֤ܿ                                                        */
/*ꤵ줿ܿξnĶ-1֤                           */
/*--------------------------------------------------------------------*/
static int setToken(char *dat[],char *str,int n){
  int i=0;

  while(*str!='\n'){
    if(*str==' '){
      *str++='\0';
    }else{
      dat[i++]=str;
      if(i>=MaxClsLen) return(-1);
      while(*str!=' ' && *str!='\n') str++;
    }
  }
  *str='\0';
  return(i);
}

/*----------------------------------------------------------------------*/
/* ȥեɤ߹                                             */
/*----------------------------------------------------------------------*/
struct Cost *readCost(char *fname,struct BonCls *cls){
  struct Cost *cost;
  FILE *fp;
  char buf[256];
  char *dat[MaxClsLen]; /*̥ݥ*/

  int   cnt;
  int   actNum[MaxClsLen];
  int   prdNum[MaxClsLen];
  int   clsCnt;
  int i,j;

  /*ȥեλ꤬ʤХǥեȤǺ*/
  if(fname==NULL){
    cost=mssCalloc(sizeof(struct Cost),"readCost");
    for(i=0; i<ClassSize; i++){
      for(j=0; j<ClassSize; j++){
        if(i==j) cost->tbl[i][j]=0;
        else     cost->tbl[i][j]=1;
      }
      cost->actTtl[i] = ClassSize-1;
    }
    /*bonCls򥻥å*/
    cost->cls=cls;

    return(cost);
  }

  /*ȥե륪ץ*/
  if(NULL==(fp=fopen(fname,"r"))){
      mssShowErrMsg("can not open the cost file");
      exit(mssErrorNoDefault);
  }

  /*ºݤɽΰ֤ޤǥå*/
  while(NULL!=fgets(buf,sizeof buf,fp)){
    if(buf[0]=='\\') break;
  }

  /*ܤpredictΥ饹̾ɤ߹*/
  if(-1 == (cnt=setToken(dat,buf,MaxClsLen)) ){
    mssShowErrMsg("exceed Maximum number of class in cost file");
    exit(mssErrorNoDefault);
  }
  clsCnt=cnt-1; /* \ʬޥʥ*/

  if(ClassSize!=clsCnt){
    mssShowErrMsg("different number of class in data and cost file");
    exit(mssErrorNoDefault);
  }

  /*ºݤ̾-cls¤ξֹбȤ*/
  for(i=0; i<clsCnt; i++){
    prdNum[i]=bonGetClsNum(cls,dat[i+1]);
    if(prdNum[i]==-1) {
      mssShowErrMsg("class name not found");
      exit(mssErrorNoDefault);
    }
    printf("%d:%s,%d\n",i,dat[i+1],prdNum[i]);
  }

  /*ΰ+*/
  cost=mssCalloc(sizeof(struct Cost),"readCost");

  /*ºݤɽɤ߹*/
  i=0;
  while(NULL!=fgets(buf,sizeof buf,fp)){
    if(buf[0]=='#') continue;

    /*ԥȡʬ*/
    if(-1 == (cnt=setToken(dat,buf,MaxClsLen)) ){
      mssShowErrMsg("exceed Maximum number of class in cost file");
      exit(mssErrorNoDefault);
    }

    /*ܿå*/
    if(cnt!=clsCnt+1) {
      mssShowErrMsg("different number of class");
      exit(mssErrorNoDefault);
    }

    /*actClsֹ̾bonCls饻å*/
    actNum[i]=bonGetClsNum(cls,dat[0]); /*actClsֹ̾*/

    /*Ȥͤơ֥˥å*/
    for(j=0; j<clsCnt; j++){
      cost->tbl[actNum[i]][prdNum[j]] = atof(dat[j+1]);
    }
    i++;
  }
  fclose(fp);

  if(i!=clsCnt){
    mssShowErrMsg("different size between actual class and predicted class");
    exit(mssErrorNoDefault);
  }

  /*actClassΥȡ륳Ȥ׻*/
  for(i=0; i<clsCnt; i++){
    for(j=0; j<clsCnt; j++){
      cost->actTtl[i]+=cost->tbl[i][j];
    }
  }

  /*bonCls򥻥å*/
  cost->cls=cls;

  return(cost);
}


/*----------------------------------------------------------------------*/
/* ȥǡɽ                                                   */
/*----------------------------------------------------------------------*/
void showCost(struct Cost *cost){
  int i,j;

  if(cost==NULL) return;

  printf("\n[Cost Matrix]\n");
  printf("         Predicted As ...\n");
  printf("      \\");
  for(j=0; j<ClassSize; j++){
    printf("%7s",cost->cls->str[j]);
  }
  printf("  Total\n");

  for(i=0; i<ClassSize; i++){
    printf("%7s",cost->cls->str[i]);
    for(j=0; j<ClassSize; j++){
      printf("%7g",cost->tbl[i][j]);
    }
    printf("%7g\n",cost->actTtl[i]);
  }
}


/*----------------------------------------------------------------------*/
/* ե٥åȤ򸵤οͤˤä¤ٴ                           */
/* ȤѡˤʤȤˤ®ʥȤ!!                     */
/*----------------------------------------------------------------------*/
static void sortAlp(struct Map *map){
  struct mssHashNode *node;
  int i,j;
  int n;
  char *x;
  char **a;

  a=map->numAlp;
  n=map->alpSiz;

  for(i=0; i<n; i++){
    x=a[i];
    for(j=i-1; j>=0 && atof(a[j])>atof(x); j--){
      a[j+1]=a[j];
    }
    a[j+1]=x;
  }

  for(i=0; i<n; i++){
    node=(struct mssHashNode *)mssHashMember(map->alpOrg,a[i]);
    node->val.v.usi=(usint)(i+1);
  }
}

char **setNumAlp( struct Map *map ){
  struct mssHashNode *node;
  char **tbl;
  int i;

  tbl=mssMalloc(sizeof(char *)*map->alpSiz,"setNumAlp");

  for(i=0; i<map->alpOrg->hashVal; i++){
    if( NULL != (node=*(map->alpOrg->node+i)) ){
      while(node!=NULL){
        *(tbl+node->val.v.usi-1)=node->str;
        node=node->next;
      }
    }
  }

/*
  for(i=0; i<j; i++){
    printf("%d : %s\n",i,*(tbl+i));
  }
*/

  return(tbl);
}

static char **bonTokByChr(char *str,char dlm,int *cnt){
  char **list;
  char *buf;
  int i;
  int len;

  if(dlm=='\0'){
    len=strlen(str);
    buf=mssMalloc(sizeof(char)*len*2,"bonTokByChr");
    list=mssMalloc(sizeof(char *)*len,"bonTokByChr");
    for(i=0; i<len; i++){
      *(buf+i*2  )=*(str+i);
      *(buf+i*2+1)='\0';
      *(list+i)=buf+i*2;
    }
    *cnt=len;
  }else{
    list=mssTokByChr(str,dlm,cnt,1);
  }
  return(list);
}

/*----------------------------------------------------------------------*/
/* ǡǻȤƤѥͤ򥻥åȤ                       */
/* Ǥϡȥ졼˥󥰤ȥƥȤξꤦѥͤ */
/*----------------------------------------------------------------------*/
struct Map **bonGetAlp(
  struct mssFPR *trn,
  struct mssFPR *tst,
  struct mssHeader *hd){

  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  char         *str; /*ѥȤΰŪݥ*/
  int i,j;
  struct Map **map;
  struct Map *mapi;
  MssValue *alpNum;
  char **list;
  int cnt;

  if(fpat->cnt==0)return(NULL);

  map=mssMalloc(sizeof(struct Map *)*fpat->cnt,"bonGetAlp");
  for(i=0; i<fpat->cnt; i++){
    *(map+i)=mssCalloc(sizeof(struct Map),"bonGetAlp");
    (*(map+i))->alpOrg=mssInitHash(1001);
    (*(map+i))->alp=NULL;
    (*(map+i))->idx=NULL;
    (*(map+i))->alpSiz=0;
  }

  alpNum=mssMalloc(sizeof(MssValue)*fpat->cnt,"bonGetAlp");
  for(i=0; i<fpat->cnt; i++){
    mssVinit(alpNum+i,USI);
    (alpNum+i)->v.usi=1;
  }

  /*ȥ졼˥󥰤Υե٥åȤ*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  while( EOF != mssReadFldRec(trn,fr) ){
    for(i=0; i<fpat->cnt; i++){
      str=*(fr->pnt+MssFlds2num(fpat,i));
      list=bonTokByChr(str,*optDLM.str,&cnt);
      mapi=*(map+i);
      for(j=0;j<cnt;j++){
        if( mssHashInsert((*(map+i))->alpOrg, *(list+j), *(alpNum+i)) ){
          mapi->alpSiz++;
          mapi->alp=mssRealloc(mapi->alp,
                      sizeof(usint)*mapi->alpSiz,"bonGetAlp");
          *(mapi->alp+mapi->alpSiz-1)=(alpNum+i)->v.usi;
          (alpNum+i)->v.usi++;
        }
      }
      mssFree(*list); mssFree(list);
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤΥե٥åȤ*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  while( EOF != mssReadFldRec(tst,fr) ){
    for(i=0; i<fpat->cnt; i++){
      str=*(fr->pnt+MssFlds2num(fpat,i));
      list=bonTokByChr(str,*optDLM.str,&cnt);
      mapi=*(map+i);
      for(j=0;j<cnt;j++){
        if( mssHashInsert((*(map+i))->alpOrg, *(list+j), *(alpNum+i)) ){
          mapi->alpSiz++;
          mapi->alp=mssRealloc(mapi->alp,
                      sizeof(usint)*mapi->alpSiz,"bonGetAlp");
          *(mapi->alp+mapi->alpSiz-1)=(alpNum+i)->v.usi;
          (alpNum+i)->v.usi++;
        }
      }
      mssFree(*list); mssFree(list);
    }
  }
  mssFreeFldRec(fr);

  for(i=0; i<fpat->cnt; i++){
    /*ǥåΰ*/
    (*(map+i))->idx=mssCalloc(sizeof(usint)*((*(map+i))->alpSiz+1), "bonGetAlp");

    /*ե٥åȤ˥ߥ͡ɲ*/
    (*(map+i))->alp=
      mssRealloc((*(map+i))->alp,
        sizeof(usint)*((*(map+i))->alpSiz+1),"bonGetAlp");
    *((*(map+i))->alp+(*(map+i))->alpSiz)=0;

    /*hashϿ줿alphabet(ʸ->Ϳ)ͤǤȤ
      Ͽ*/
    (*(map+i))->numAlp=setNumAlp( *(map+i) );

    /*ͥѥξ硢ե٥åȤͽ¤ٴ*/
    if(mssIsFldOptOn(&optPAT,0,'n')){
      sortAlp(*(map+i));
    }

    /*ǥåĴ*/
    if(optSIZ.val>(*(map+i))->alpSiz) (*(map+i))->idxSiz=(*(map+i))->alpSiz;
    else                              (*(map+i))->idxSiz=optSIZ.val;
  }

  mssFree(alpNum);

  return(map);
}

void freeMap(struct Map **map){
  int i;
  if(map==NULL)return;
  for(i=0; i<fpat->cnt; i++){
    mssFreeHash((*(map+i))->alpOrg);
    mssFree((*(map+i))->alp);
    mssFree((*(map+i))->idx);
    mssFree((*(map+i))->numAlp);
    mssFree(*(map+i));
  }
  mssFree(map);
}

/*------------------------------------------*/
/* ƥ꡼°ʸhashɽ˥åȤ */
/*------------------------------------------*/
struct Category *bonGetCatHash(
  struct mssFPR *trn,
  struct mssFPR *tst,
  struct mssHeader *hd){

  struct Category *cat;
  struct Category *cat_i;
  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  int i;
  char *fldStr;
  MssValue val;

  mssVinit(&val,INT);

  /*ƥ°λ̵꤬NULL֤*/
  if(!optCAT.set) return(NULL);

  cat = mssMalloc(sizeof(struct Category)*fcat->cnt,"bonGetCatHash");
  for(i=0; i<fcat->cnt; i++){
   (cat+i)->val     = NULL; /*ǤvalϥåȤbonGetDatǥå*/
   (cat+i)->name    = mssInitHash(101);
   (cat+i)->cnt     = 0;
   (cat+i)->valName = NULL;
  }

  /*ȥ졼˥󥰤category°*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(trn);
  while( EOF != mssReadFldRec(trn,fr) ){
    for(i=0; i<fcat->cnt; i++){
      cat_i=cat+i;
      fldStr=*(fr->pnt+MssFlds2num(fcat,i));

      /*ͤhashơ֥˥å*/
      mssVclear(&val);
      val.v.i=cat_i->cnt;
      /*hashơ֥줿ʤ,-(հ)ɽϿ&cnt++*/
      if(1 == mssHashInsert(cat_i->name,fldStr,val) ){
        cat_i->valName=mssRealloc(cat_i->valName,
          sizeof(char *)*(cat_i->cnt+1),"bonGetCatHash2");
        *(cat_i->valName+cat_i->cnt)=mssHashMemberAdd(cat_i->name,fldStr);
        cat_i->cnt++;
      }
    }
  }
  mssFreeFldRec(fr);

  /*ƥȤcategory°*/
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(tst);
  while( EOF != mssReadFldRec(tst,fr) ){
    for(i=0; i<fcat->cnt; i++){
      cat_i=cat+i;
      fldStr=*(fr->pnt+MssFlds2num(fcat,i));

      /*ͤhashơ֥˥å*/
      mssVclear(&val);
      val.v.i=cat_i->cnt;
      /*hashơ֥줿ʤ,-(հ)ɽϿ&cnt++*/
      if(1 == mssHashInsert(cat_i->name,fldStr,val) ){
        cat_i->valName=mssRealloc(cat_i->valName,
          sizeof(char *)*(cat_i->cnt+1),"bonGetCatHash2");
        *(cat_i->valName+cat_i->cnt)=mssHashMemberAdd(cat_i->name,fldStr);
        cat_i->cnt++;
      }
    }
  }
  mssFreeFldRec(fr);


  return(cat);
}

/*--------------------*/
/* ǡ򥻥åȤ */
/*--------------------*/
struct Data *bonSetDat(
  struct mssFPR *fpr,
  struct mssHeader *hd,
  struct BonCls *cls,   /*饹ʸ-Τ*/
  int            cnt,   /*ǡ*/
  struct Map   **map,   /*ƥѥ°Υޥå*/
  struct Category *cat){

  struct mssFldRec *fr;  /*бΥ쥳ɥХåե*/
  int i,j,k;
  struct Data *dat;
  char *fldStr;
  MssValue val;
  char **list;
  int    listCnt;
  char *str;
  struct mssHashNode *node;
  usint alpha[MaxPatLen];

  mssVinit(&val,INT);
  dat=mssCalloc(sizeof(struct Data),"bonSetDat");

  /*饹ΰγݤȡ饹ʸ-Υԡ*/
  dat->cls=mssCalloc(sizeof(struct BonCls),"bonSetDat");
  for(i=0; i<cls->cnt; i++) dat->cls->str[i]=cls->str[i];
  dat->cls->cnt=cls->cnt;
  dat->cls->chr=mssCalloc(sizeof(char)*cnt,"bonGetDat1");

  /*°ΰγ*/
  dat->numCnt=fnum->cnt;
  dat->num=mssCalloc(sizeof(double *)*dat->numCnt,"bonGetDat2");
  for(i=0; i<dat->numCnt; i++){
    *(dat->num+i) = mssCalloc(sizeof(double)*cnt,"bonGetDat3" );
  }

  /*ƥ꡼°ǡΰγ*/
  dat->catCnt=fcat->cnt;
  dat->cat=mssCalloc(sizeof(struct Category)*dat->catCnt,"bonGetDat5" );
  for(i=0; i<dat->catCnt; i++){
    (dat->cat+i)->name   =(cat+i)->name;
    (dat->cat+i)->valName=(cat+i)->valName;
    (dat->cat+i)->cnt    =(cat+i)->cnt;
    (dat->cat+i)->val = mssCalloc(sizeof(int)*cnt,"bonGetDat5" );
  }

  /*ѥ°ΰγݤmapΥԡ*/
  dat->patCnt=fpat->cnt;
  dat->pat=mssCalloc(sizeof(struct Pattern)*dat->patCnt ,"bonGetDat6" );
  for(i=0; i<dat->patCnt; i++){
    /*mapΥå*/
    (dat->pat+i)->map=*(map+i);
    /*ͥѥǤ뤫ɤΥå*/
    (dat->pat+i)->numPat=mssIsFldOptOn(&optPAT,0,'n');
    /*¥ǡΰν*/
    (dat->pat+i)->patAlp=initStrTbl();
    (dat->pat+i)->patIdx=initStrTbl();
    /*ǥåη*/
    if(optSIZ.val > (*(map+i))->alpSiz || optSIZ.val==0 )
      (dat->pat+i)->map->idxSiz=(*(map+i))->alpSiz;
    else
      (dat->pat+i)->map->idxSiz=optSIZ.val;

  }    

  /*¥ǡ˳Ǽ*/
  i=0;
  fr=mssInitFldRec(hd->flds->cnt);
  mssSeekTopFPR(fpr);
  while( EOF != mssReadFldRec(fpr,fr) ){

    /*饹ܤͤ򥻥å*/
    *(dat->cls->chr+i)=bonGetClsNum(cls,*(fr->pnt+MssFlds2num(fcls,0)));

    /*°γǼ*/
    for(j=0; j<fnum->cnt; j++){
      *(*(dat->num+j)+i)=atof(*(fr->pnt+MssFlds2num(fnum,j)));
    }

    /*ƥ꡼°γǼ*/
    for(j=0; j<dat->catCnt; j++){

      /*ܤ(ʸ)Υɥ쥹򥻥å*/
      fldStr = *(fr->pnt+MssFlds2num(fcat,j));

      /*쥳ɤΥǡͤȤϿ*/
      mssVclear(&val);
      val=mssHashMemberVal( (dat->cat+j)->name, fldStr );
      if(val.nul) *((dat->cat+j)->val + i) = 0;
      else        *((dat->cat+j)->val + i) = val.v.i;
    }

    /*ѥγǼ*/
    for(j=0; j<fpat->cnt; j++){
      str=*(fr->pnt+MssFlds2num(fpat,j));
      list=bonTokByChr(str,*optDLM.str,&listCnt);
      /*k(ex.1024)ۤ饨顼ˤ*/
      for(k=0;k<listCnt;k++){
        node=(struct mssHashNode *)mssHashMember((*(map+j))->alpOrg,*(list+k));
        if( NULL == node ){
          mssShowErrMsg("internal error1");
          exit(mssErrorNoDefault);
        }else{
          alpha[k]=node->val.v.usi;
        }
      }
      mssFree(*list); mssFree(list);
      alpha[k]=0; /*ߥ͡*/
      putStrTbl((dat->pat+j)->patAlp,alpha);
    }

    /*ȥå*/
    i++;
  }
  mssFreeFldRec(fr);

  /*եݥ󥿤Υԡ*/
  dat->fpr=fpr;

  /*ǡΥå*/
  dat->cnt=cnt;

  return(dat);
}

void freeDat(struct Data *dat){
  int i;
  if(dat==NULL)return;
  for(i=0; i<dat->patCnt; i++){
    freeStrTbl((dat->pat+i)->patAlp);
    freeStrTbl((dat->pat+i)->patIdx);
  }
  mssFree(dat->pat);

  for(i=0; i<dat->catCnt; i++){
    mssFree((dat->cat+i)->val);
  }
  mssFree(dat->cat);

  for(i=0; i<dat->numCnt; i++){
    mssFree(*(dat->num+i));
  }
  mssFree(dat->num);

  mssFree(dat->cls->chr);
  mssFree(dat->cls);
  mssFree(dat);
}


/*############################################################################*/
/*# ե٥åȡݥǥåϢδؿ                                   #*/
/*############################################################################*/
/*------------------------------------------------------------------*/
/* 륵ΥǥåȤŬڤǤ1else 0֤*/
/*  Ŭ:ǥåΥʬμѤƤ륤ǥå     */
/*------------------------------------------------------------------*/
static int goodInitIdx( usint *idx, int cnt){
  int len;
  int i;
  char buf[256];

  for(i=1; i<=cnt; i++) buf[i]=-1;

  len=StrLen(idx);
  for(i=0; i<len; i++){
    buf[*(idx+i)]=1;
  }
  for(i=1; i<=cnt; i++){
    if(buf[i]==-1)return(0);
  }
  return(1);
}

/*-----------------------------------------------*/
/* ǥåȤŬڤǤ1else 0֤ */
/* ƤƱˤʤ륤ǥåŬڤǤʤ      */
/*-----------------------------------------------*/
static int goodIdx(usint *idx){
  int i;
  usint chr;

  chr=*idx;
  for(i=1; i<StrLen(idx); i++){
    if( chr!=*(idx+i) ) return(1);
  }
  return(0);
}

/*------------------------------------------------*/
/* ǥå򥢥ե٥åȤƱѰդ */
/*   ǥåʤξѤ             */
/*------------------------------------------------*/
struct Idxs *initIdxs0(struct Data *dat){
  int i,j,k;
  int size;
  struct Idxs *idxs;
  usint *str;

  usedRandSeed=mssInitRand(optSED.val); /**/

  idxs=mssMalloc(sizeof(struct Idxs),"initIdxs01");
  idxs->idx=mssMalloc(sizeof(usint **)*1,"initIdxs02");
  for(i=0; i<1; i++){
    *(idxs->idx+i)=mssMalloc(sizeof(usint *)*dat->patCnt,"initIdxs03");
  }
  idxs->cnt=1;
  idxs->patCnt=dat->patCnt;

  for(j=0; j<dat->patCnt; j++){

    size=(dat->pat+j)->map->alpSiz;
    *(*(idxs->idx+0)+j)=mssCalloc(sizeof(usint)*(size+1),"initIdxs04");
    str=*(*(idxs->idx+0)+j);

    for(k=0; k<size; k++){
      *(str+k) = 1+k;
    }
    *(str+k) = 0;
  }
  return(idxs);
}

/*----------------------------------*/
/* ǥå˷ꤹ */
/*----------------------------------*/
struct Idxs *initIdxs(struct Data *dat){
  int i,j,k;
  int size;
  struct Idxs *idxs;
  int unit;
  usint num;
  usint *str;
  int numCnt;
  int digits;

  usedRandSeed=mssInitRand(optSED.val); /**/

  idxs=mssMalloc(sizeof(struct Idxs),"initIdxs1");
  idxs->idx=mssMalloc(sizeof(usint **)*1,"initIdxs2");
  for(i=0; i<1; i++){
    *(idxs->idx+i)=mssMalloc(sizeof(usint *)*dat->patCnt,"initIdxs3");
  }
  idxs->cnt=1;
  idxs->patCnt=dat->patCnt;

  for(j=0; j<dat->patCnt; j++){
    unit=RAND_MAX/(dat->pat+j)->map->idxSiz;

    size=(dat->pat+j)->map->alpSiz;
    *(*(idxs->idx+0)+j)=mssCalloc(sizeof(usint)*(size+1),"initIdxs4");
    str=*(*(idxs->idx+0)+j);

    /*ͥѥξ*/
    if((dat->pat+j)->numPat){
      numCnt=0;
      while(numCnt<(dat->pat+j)->map->idxSiz-1){
        digits=rand()/(RAND_MAX/((dat->pat+j)->map->alpSiz-1))+1;
        if( *(str+digits) != 0 ) continue;
        *(str+digits) = 9999;
        numCnt++;
      }
      num=1;
      for(i=0; i<size; i++){
        if(*(str+i)==9999) num+=1;
        *(str+i)=num;
      }

    /*ʸѥξ*/
    }else{
      while(1){
        for(k=0; k<size; k++){
          *(str+k) = 1+rand()/unit;
        }
        *(str+k) = 0;
        if( goodInitIdx(str, (dat->pat+j)->map->idxSiz) )break;
      }
    }
  }
  return(idxs);
}

/*--------------------------*/
/* ǥåꥹȤγ */
/*--------------------------*/
static void freeIdxsSub(usint **add, int cnt){
  int i;
  for(i=0; i<cnt; i++){
    mssFree(*(add+i));
  }
  mssFree(add);
}

void freeIdxs(struct Idxs *idxs){
  int i;

  for(i=0; i<idxs->cnt; i++){
    freeIdxsSub( *(idxs->idx+i),idxs->patCnt );
  }
  mssFree(idxs->idx);
  mssFree(idxs);
}

static struct Idxs *malNextIdxs(struct Idxs *idxs, struct Data *dat){
  int i;

  /*ΰ*/
  idxs->idx=mssRealloc(idxs->idx,sizeof(usint **)*(idxs->cnt+1),"malIdxs1");
  *(idxs->idx+idxs->cnt)=mssCalloc(sizeof(usint *)*dat->patCnt,"malIdxs2");

  /*öȤalpha-index򥳥ԡ*/
  for(i=0; i<dat->patCnt; i++){
    *(*(idxs->idx+idxs->cnt)+i)
      =mssCalloc(sizeof(usint)*((dat->pat+i)->map->alpSiz+1),"malIdxs3");
    StrCpy( *(*(idxs->idx+idxs->cnt)+i), (dat->pat+i)->map->idx );
  }
  return(idxs);
}

struct Idxs *setNextIdxs(struct Data *dat){
  int i,j,k;
  struct Idxs *idxs;
  int numPat;
  char chr;
  char prv;
  char nxt;

  idxs=mssCalloc(sizeof(struct Idxs),"nextIdxs1");
  idxs->cnt=0;
  idxs->patCnt=dat->patCnt;

  /*ǥåѹܤǲ*/
  for(i=0; i<dat->patCnt; i++){
    numPat=(dat->pat+i)->numPat; /*ͥѥ󤫤ɤ*/
    for(j=0; j<(dat->pat+i)->map->alpSiz; j++){ /*alphaĹ*/
      chr=*((dat->pat+i)->map->idx+j); /*оݤʸ*/
      if(!numPat){
        for(k=1; k<=(dat->pat+i)->map->idxSiz; k++){ /*indexμ*/
          if(k==chr) continue;
          idxs=malNextIdxs(idxs,dat);
          *(*(*(idxs->idx+idxs->cnt)+i)+j)=k;
          if( !goodIdx( *(*(idxs->idx+idxs->cnt)+i) ) ){
            freeIdxsSub( *(idxs->idx+idxs->cnt),dat->patCnt );
            continue; /*idxs->cnt򥫥ȥåפʤΤϿʤƱ*/
          }
          idxs->cnt++;
        }
      }else{
        if(j==0) prv=0;
        else     prv=*((dat->pat+i)->map->idx+j-1);
        if(j==(dat->pat+i)->map->alpSiz-1) nxt=0;
        else nxt=*((dat->pat+i)->map->idx+j+1);
        if(prv!=chr && prv!=0){
          idxs=malNextIdxs(idxs,dat);
          *(*(*(idxs->idx+idxs->cnt)+i)+j)=prv;
          if( !goodIdx( *(*(idxs->idx+idxs->cnt)+i) ) ){
            freeIdxsSub( *(idxs->idx+idxs->cnt),dat->patCnt );
            continue; /*idxs->cnt򥫥ȥåפʤΤϿʤƱ*/
          }
          idxs->cnt++;
        }
        if(nxt!=chr && nxt!=0){
          idxs=malNextIdxs(idxs,dat);
          *(*(*(idxs->idx+idxs->cnt)+i)+j)=nxt;
          if( !goodIdx( *(*(idxs->idx+idxs->cnt)+i) ) ){
            freeIdxsSub( *(idxs->idx+idxs->cnt),dat->patCnt );
            continue; /*idxs->cnt򥫥ȥåפʤΤϿʤƱ*/
          }
          idxs->cnt++;
        }
      }
    }
  }
  return(idxs);
}


/*==============================================================================
 ʣǥå¤Τν
==============================================================================*/
void printIdxs(struct Idxs *idxs){
  int i,j;
  for(i=0; i<idxs->cnt; i++){
    printf("No[%02d] ",i);
    for(j=0; j<idxs->patCnt; j++){
      prnStr(stdout, *(*(idxs->idx+i)+j) );
    }
    printf("\n");
  }
}

/*==============================================================================
 ʣǥådat¤ΤؤΥԡ
==============================================================================*/
void cpyIdx(struct Data *dat, usint **idx){
  int j;

  for(j=0; j<dat->patCnt; j++){
    StrCpy( (dat->pat+j)->map->idx, *(idx+j) );
  }
}

/*----------------------------------------------------------------------------*/
/*Ϳ줿alphabetбindex֤                                     */
/*----------------------------------------------------------------------------*/
char alp2idx(struct Map *map, usint alpha){
  int i;
  for(i=0; i<map->alpSiz; i++){
    if(*(map->alp+i)==alpha) return (*(map->idx+i));
  }
  mssShowErrMsg("internal error2");
  exit(mssErrorNoDefault);
  return(1);
}

/*----------------------------------------------------------------------------*/
/*Ϳ줿alphabetʸбindexʸ򥻥åȤ                   */
/*----------------------------------------------------------------------------*/
void alpStr2idxStr(usint index[],usint *alpha, struct Map *map){
  int i=0;

  while(*alpha!=0){
    index[i++]=alp2idx(map,*(alpha++));
  }
  index[i]=0;
}


/*==============================================================================
 dat¤ΤΥǡ򥤥ǥå
==============================================================================*/
void datIndexing( struct Data *dat ){

  usint          alpha;            /*ե٥åʸ*/
  usint          index[MaxPatLen]; /*ǥå줿ʸ*/
  usint         *str;              /*ѥȤΰŪݥ*/
  int i,j,k;

  for(i=0; i<dat->patCnt; i++){ /*ѥܿ*/
    freeStrTbl((dat->pat+i)->patIdx);
    (dat->pat+i)->patIdx=initStrTbl();/*index줿ǡѿ*/
  }

  for(i=0; i<dat->patCnt; i++){ /*ѥܿ*/
    for(j=0; j<dat->cnt; j++){  /*ǡ*/
      k=0;                      /*ǥåθʸ*/
      str=getStrTbl((dat->pat+i)->patAlp,j); /*iܹܤjܥǡʸ*/
      while(*str!='\0'){
        alpha=*(str++);
        index[k++]=alp2idx((dat->pat+i)->map,alpha);
      }
      index[k]=0; /*ߥ͡*/
      putStrTbl( (dat->pat+i)->patIdx, index); /*ѥγǼ*/
    }
  }
}

/*============================================================================*/
/* ɽ°Ȥơ֥                                         */
/*============================================================================*/
void mkAtt( struct Data *dat ){

  int i,j,k;

  freeAtt(dat);

  /*ѥ°ΰγ*/
  for(i=0; i<dat->patCnt; i++){
    (dat->pat+i)->attCnt = (dat->pat+i)->regTbl->cnt;

    for(j=0; j<(dat->pat+i)->attCnt; j++){
      (dat->pat+i)->att[j]= mssCalloc(sizeof(char)*dat->cnt,"AttTblAtt");
    }
  }

  /*ɽ°*/
  for(i=0; i<dat->patCnt; i++){ /*ѥܿ*/
    for(j=0; j<dat->cnt; j++){ /*ץǡ*/
      for(k=0; k<(dat->pat+i)->attCnt; k++){ /*ɽ*/
      *((dat->pat+i)->att[k]+j) =
         (char)regCmp( getStrTbl((dat->pat+i)->patIdx,j),
                     (dat->pat+i)->regTbl->reg+k );
      }
    }
  }
}

void freeAtt( struct Data *dat ){
  int i,j;

  for(i=0; i<dat->patCnt; i++){
    for(j=0; j<(dat->pat+i)->attCnt; j++){
      mssFree((dat->pat+i)->att[j]);
    }
  }
}

/*############################################################################*/
/*# ѥɽϢ                                               #*/
/*# ɸ饤֥(ѥɽǵ)->٤ΤǤ᤿       #*/
/*#  algorithm by                                                            #*/
/*#    M. Hirao, H.Hoshino, A.Shinohara, M.Takeda, and S.Arikawa,            #*/
/*#    "A Practical Algorithm to Find the Best Subsequence Patterns"         #*/
/*############################################################################*/
/*----------------------------------*/
/*Regexp¤δϢΰ賫        */
/*Regexp¤ΤΤΤMallocʤ*/
/*reg->regStrMalloc         */
/*----------------------------------*/
void freeReg(struct Regexp *reg){
;
}

/*--------------------*/
/*Regexp¤ΤΥԡ*/
/*--------------------*/
void cpReg(struct Regexp *to, struct Regexp *from){

  StrCpy(to->str,from->str);
  to->type=from->type;
  to->bgnRng=from->bgnRng;
  to->endRng=from->endRng;
  to->objVal=from->objVal;
}


/*ʸstrκǸnʸǽʸreg뤫ɤ*/
static int atEndRng(usint *str,usint *reg,int n){
  int l=StrLen(str); /*strĹ*/
  int s=StrLen(reg); /*regĹ*/
  int i;
  int start; /*strθϰ*/
  int end;   /*strθλ*/

  start=l-n-s+1;
  if(start<0){start=0;end=start+l-s+1;}
  else       {        end=start+n    ;}
  for(i=start; i<end; i++){
    if(0==StrnCmp(str+i,reg,s)) return(1);
  }
  return(0);
}

/*------------------------*/
/*substringΥޥå   */
/*------------------------*/
int regCmpStr(usint *str,struct Regexp *reg){
  usint *bgnPos; /*ǽθǤΰװ*/

  /*substringmatch֤򸡺*/
  if( NULL == (bgnPos=StrStr(str,reg->str)) ) return(0);

  /*Ƭפλ꤬*/
  if(reg->bgnRng!=0){
    if(bgnPos-str >= reg->bgnRng) return(0);
  }

  /*פλ꤬*/
  if(reg->endRng!=0){
    if(0==atEndRng(str,reg->str,reg->endRng)) return(0);
  }

  /*嵭ξ˰äʤаפȤ*/
  return(1);
}

/*------------------------*/
/*subsequenceΥޥå */
/*------------------------*/
int regCmpSeq(usint *str,struct Regexp *reg){
  usint *strPnt=str;
  usint *regPnt=reg->str;
  usint *strEnd; /*strend*/
  usint *regEnd; /*reg->strend*/
  int   flg;
  int   i;

  /*subsequenceȤưפ뤫Ĵ٤*/
  while(*regPnt!=0 && *strPnt!=0){
    if(NULL==(strPnt=StrChr(strPnt,*regPnt))){
      return(0);
    }
    strPnt++;
    regPnt++;
  }

  /*ѥʸɤڤäƤʤ*/
  if(*regPnt!=0) return(0);

  /*Ƭפλ꤬,ѥκǽʸbgnRngˤ뤫Ĵ٤*/
  if(reg->bgnRng!=0){
    flg=0;
    for(i=0; i<reg->bgnRng; i++){
      if(*reg->str == *(str+i))flg=1;
    }
    if(!flg) return(0);
  }

  /*פλ꤬,ѥκǽʸendRngˤ뤫Ĵ٤*/
  if(reg->endRng!=0){
    flg=0;
    strEnd=     str+StrLen(     str)-1;
    regEnd=reg->str+StrLen(reg->str)-1;
    for(i=0; i<reg->endRng; i++){
      if(*regEnd == *(strEnd-i))flg=1;
    }
    if(!flg) return(0);
  }

  /*嵭ξ˰äʤаפȤ*/
  return(1);
}

/*--------------------------------------------------*/
/*ѥͿ줿ʸ˥ޥå뤫ɤ*/
/* ޥå:1 ޥå:0                            */
/*--------------------------------------------------*/
int regCmp(usint *str, struct Regexp *reg){

  switch(reg->type){
    case 0: /*substring*/
      return( regCmpStr(str,reg) );
      break;
    case 1: /*subsequence*/
      return( regCmpSeq(str,reg) );
      break;
  }
  return(0);
}

/*############################################################################*/
/*CndCnt(ˤʬơ֥)Ϣ                                    */
/*############################################################################*/
/*----------------------*/
/* CndCnt¤Τν */
/*----------------------*/
void iniCndCnt( struct CndCnt *cnt, struct Cost *cost){
  int i;
  for(i=0; i<ClassSize; i++){
    cnt->uCnt[i]=0;
    cnt->mCnt[i]=0;
    cnt->tCnt[i]=0;
    cnt->uShrRN[i]=0;
    cnt->mShrRN[i]=0;
    cnt->tShrRN[i]=0;
    cnt->uShrRC[i]=0;
    cnt->mShrRC[i]=0;
    cnt->tShrRC[i]=0;
    cnt->uShrLN[i]=0;
    cnt->mShrLN[i]=0;
    cnt->tShrLN[i]=0;
    cnt->uShrLC[i]=0;
    cnt->mShrLC[i]=0;
    cnt->tShrLC[i]=0;
  }
  cnt->utCnt     =0;
  cnt->utCnt     =0;
  cnt->mtCnt     =0;
  cnt->mtCnt     =0;
  cnt->total     =0;
  cnt->splitType =atoi(optSPL.str);
  cnt->splitBefor=0;
  cnt->splitAfter=0;
  cnt->cost      =cost;

  switch(*optPRB.str){
  case '0':
    cnt->uShr=cnt->uShrRN;
    cnt->mShr=cnt->mShrRN;
    cnt->tShr=cnt->tShrRN;
    break;
  case '1':
    cnt->uShr=cnt->uShrRC;
    cnt->mShr=cnt->mShrRC;
    cnt->tShr=cnt->tShrRC;
    break;
  case '2':
    cnt->uShr=cnt->uShrLN;
    cnt->mShr=cnt->mShrLN;
    cnt->tShr=cnt->tShrLN;
    break;
  case '3':
    cnt->uShr=cnt->uShrLC;
    cnt->mShr=cnt->mShrLC;
    cnt->tShr=cnt->tShrLC;
    break;
  }

}

/*----------------------*/
/* CndCnt¤Τɽ   */
/*----------------------*/
void prnCndCnt( struct CndCnt *cnt){
  int i;

  printf("       ");
  for(i=0; i<ClassSize; i++) printf("  CLS%d",i);
  printf(" TOTAL\n");

  printf("  match");
  for(i=0; i<ClassSize; i++) printf("%6d",cnt->mCnt[i]);
  printf("%6d\n",cnt->mtCnt);

  printf("unmatch");
  for(i=0; i<ClassSize; i++) printf("%6d",cnt->uCnt[i]);
  printf("%6d\n",cnt->utCnt);

  printf("  TOTAL");
  for(i=0; i<ClassSize; i++) printf("%6d",cnt->tCnt[i]);
  printf("%6d\n",cnt->total);


  printf("---- share -----------------------\n");
  printf("\nshare          match");
  for(i=0; i<ClassSize; i++) printf(" %g",*(cnt->mShr+i));
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",*(cnt->uShr+i));

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrRN[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrRN[i]);

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrRC[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrRC[i]);

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrLN[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrLN[i]);

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrLC[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrLC[i]);

  printf("splitType=%d\n",cnt->splitType);
  printf("splitBefor=%f\n",cnt->splitBefor);
  printf("splitAfter=%f\n",cnt->splitAfter);
}

/*----------------------*/
/* CndCnt¤Τν */
/* uCnt,mCntΤ߽  */
/*----------------------*/
void clearCndCntCel(struct CndCnt *cnt){
  int i;
  for(i=0; i<ClassSize; i++){
    cnt->uCnt[i]=0;
    cnt->mCnt[i]=0;
  }
  cnt->utCnt=0;
  cnt->mtCnt=0;
}

/*----------------------*/
/* CndCnt¤ΤΥԡ */
/*----------------------*/
void cpyCndCnt(struct CndCnt *cntTo, struct CndCnt *cntFrom){
  int i;
  for(i=0; i<ClassSize; i++){
    cntTo->uCnt[i]=cntFrom->uCnt[i];
    cntTo->mCnt[i]=cntFrom->mCnt[i];
    cntTo->tCnt[i]=cntFrom->tCnt[i];
    cntTo->uShrRN[i]=cntFrom->uShrRN[i];
    cntTo->mShrRN[i]=cntFrom->mShrRN[i];
    cntTo->tShrRN[i]=cntFrom->tShrRN[i];
    cntTo->uShrRC[i]=cntFrom->uShrRC[i];
    cntTo->mShrRC[i]=cntFrom->mShrRC[i];
    cntTo->tShrRC[i]=cntFrom->tShrRC[i];
    cntTo->uShrLN[i]=cntFrom->uShrLN[i];
    cntTo->mShrLN[i]=cntFrom->mShrLN[i];
    cntTo->tShrLN[i]=cntFrom->tShrLN[i];
    cntTo->uShrLC[i]=cntFrom->uShrLC[i];
    cntTo->mShrLC[i]=cntFrom->mShrLC[i];
    cntTo->tShrLC[i]=cntFrom->tShrLC[i];
  }
  cntTo->utCnt     =cntFrom->utCnt;
  cntTo->utShr     =cntFrom->utShr;
  cntTo->mtShr     =cntFrom->mtShr;
  cntTo->mtCnt     =cntFrom->mtCnt;
  cntTo->total     =cntFrom->total;
  cntTo->splitType =cntFrom->splitType;
  cntTo->splitBefor=cntFrom->splitBefor;
  cntTo->splitAfter=cntFrom->splitAfter;
  cntTo->cost      =cntFrom->cost;
  
  switch(*optPRB.str){
  case '0':
    cntTo->uShr      =cntTo->uShrRN;
    cntTo->mShr      =cntTo->mShrRN;
    cntTo->tShr      =cntTo->tShrRN;
    break;
  case '1':
    cntTo->uShr      =cntTo->uShrRC;
    cntTo->mShr      =cntTo->mShrRC;
    cntTo->tShr      =cntTo->tShrRC;
    break;
  case '2':
    cntTo->uShr      =cntTo->uShrLN;
    cntTo->mShr      =cntTo->mShrLN;
    cntTo->tShr      =cntTo->tShrLN;
    break;
  case '3':
    cntTo->uShr      =cntTo->uShrLC;
    cntTo->mShr      =cntTo->mShrLC;
    cntTo->tShr      =cntTo->tShrLC;
    break;
  }
}

/*--------------------*/
/* giniη׻         */
/*--------------------*/
static void gini(struct CndCnt *cnt){
  double mGini=1;    /*   match gini */
  double uGini=1;    /* unmatch gini */
  double tGini=1;    /* total   gini */
  int i;

  for(i=0; i<ClassSize; i++){
    mGini -= *(cnt->mShr+i) * *(cnt->mShr+i);
    uGini -= *(cnt->uShr+i) * *(cnt->uShr+i);
    tGini -= *(cnt->tShr+i) * *(cnt->tShr+i);
  }
  cnt->splitBefor = tGini;
  cnt->splitAfter = cnt->mtShr*mGini + cnt->utShr*uGini;
}

/*--------------------*/
/* entropyη׻      */
/*--------------------*/
static void entropy(struct CndCnt *cnt){
  double mEnt=0;    /*   match entropy */
  double uEnt=0;    /* unmatch entropy */
  double tEnt=0;    /* total   entropy */
  int i;

  for(i=0; i<ClassSize; i++){
    mEnt += *(cnt->mShr+i) * Log2(*(cnt->mShr+i)) * (double)(-1);
    uEnt += *(cnt->uShr+i) * Log2(*(cnt->uShr+i)) * (double)(-1);
    tEnt += *(cnt->tShr+i) * Log2(*(cnt->tShr+i)) * (double)(-1);
  }
  cnt->splitBefor = tEnt;
  cnt->splitAfter = cnt->mtShr*mEnt + cnt->utShr*uEnt;
}

/*--------------------*/
/* geoMeanη׻      */
/* 2饹Τ߲ǽ    */
/*--------------------*/
static void geoMean(struct CndCnt *cnt){
  double mGeo;    /*   match geoMean */
  double uGeo;    /* unmatch geoMean */
  double tGeo;    /* total   geoMean */

  mGeo = *(cnt->mShr+0) * *(cnt->mShr+1);
  uGeo = *(cnt->uShr+0) * *(cnt->uShr+1);
  tGeo = *(cnt->tShr+0) * *(cnt->tShr+1);
  cnt->splitBefor = tGeo;
  cnt->splitAfter = cnt->mtShr*mGeo + cnt->utShr*uGeo;
}

/*--------------------------------*/
/* splitting criteria η׻      */
/*--------------------------------*/
void calCndCntSplit( struct CndCnt *cnt){

  switch(cnt->splitType){
    /* Gini */
    case 0:
      gini(cnt)   ; break;

    /* Entropy */
    case 1:
      entropy(cnt); break;

    /* GeoMean */
    case 2:
      geoMean(cnt); break;

    default:
      gini(cnt)   ; break;
  }
}

/*-----------------------------------*/
/* CndCnt¤ΤdominantClassη */
/*-----------------------------------*/
int dominantClass(struct CndCnt *cnt){
  double domClassShr;
  int    domClass;
  int    i;

  domClassShr=*(cnt->tShr+0);
  domClass=0;
  for(i=1; i<ClassSize; i++){
    if( domClassShr < *(cnt->tShr+i)){
      domClassShr = *(cnt->tShr+i);
      domClass    = i;
    }
  }
  return(domClass);
}

static double divDef(double d1, double d2, double def){
  if(d2==0) return(def);
  return(d1/d2);
}

/*-------------------------------*/
/* CndCnt ¤Τηפ */
/*-------------------------------*/
void calCndCnt( struct CndCnt *cnt){
  int i;
  double uCost=0;
  double mCost=0;
  double tCost=0;

  /*Υ*/
  cnt->mtCnt =0;
  cnt->utCnt =0;
  cnt->total=0;
  for(i=0; i<ClassSize; i++){
    cnt->tCnt[i] = cnt->mCnt[i] + cnt->uCnt[i];
    cnt->mtCnt += cnt->mCnt[i];
    cnt->utCnt += cnt->uCnt[i];
    cnt->total += cnt->tCnt[i];
  }

  /*ޥåޥåη׻*/
  cnt->mtShr = divDef((double)cnt->mtCnt, (double)cnt->total, 0);
  cnt->utShr = divDef((double)cnt->utCnt, (double)cnt->total, 0);

  /*-------------------------------------------------*/
  /*ޥåޥå̳ƥ饹иΨη׻         */
  /*-------------------------------------------------*/

  switch(*optPRB.str){
  /*-------------------------------------------------*/
  /*                                       */
  /*-------------------------------------------------*/
  case '0':
  case '1':
    for(i=0; i<ClassSize; i++){
      cnt->uShrRN[i]=divDef( (double)cnt->uCnt[i],(double)cnt->utCnt,0 );
      cnt->mShrRN[i]=divDef( (double)cnt->mCnt[i],(double)cnt->mtCnt,0 );
      cnt->tShrRN[i]=divDef( (double)cnt->tCnt[i],(double)cnt->total,0 );
    }
    break;

  /*-------------------------------------------------*/
  /*Laplace Estimate+Ȥˤ׻                */
  /*p(i)=(Ni+1)/(k+N)                                */
  /* k:饹=ClassSize                            */
  /* Ni: 饹iη=cnt->xCnt[]                   */
  /* N :                                       */
  /*-------------------------------------------------*/
  case '2':
  case '3':
    for(i=0; i<ClassSize; i++){
      cnt->uShrLN[i]
        =divDef((double)(cnt->uCnt[i]+1), (double)(ClassSize+cnt->utCnt), 0);
      cnt->mShrLN[i]
        =divDef((double)(cnt->mCnt[i]+1), (double)(ClassSize+cnt->mtCnt), 0);
      cnt->tShrLN[i]
        =divDef((double)(cnt->tCnt[i]+1), (double)(ClassSize+cnt->total), 0);
    }
    break;
  }

  switch(*optPRB.str){
  /*-------------------------------------------------*/
  /*Ȥˤ륷η׻                         */
  /*xShrC=C(j)*xShr(j)/SUMi(C(i)*xShr(i))            */
  /* C(j)=SUMi(cost(j,i))                            */
  /* cost(j,i)Ȥϥ饹jiͽ¬ȤΥ   */
  /*-------------------------------------------------*/
  case '1':
    /*SUMi(C(i)*xShr(i))η׻*/
    for(i=0; i<ClassSize; i++){
      uCost+=cnt->cost->actTtl[i]*cnt->uShrRN[i];
      mCost+=cnt->cost->actTtl[i]*cnt->mShrRN[i];
      tCost+=cnt->cost->actTtl[i]*cnt->tShrRN[i];
    }

    /*xShrC=C(j)*xShr(j)/xCost η׻*/
    for(i=0; i<ClassSize; i++){
      cnt->uShrRC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->uShrRN[i], uCost, cnt->uShrRN[i]);
      cnt->mShrRC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->mShrRN[i], mCost, cnt->mShrRN[i]);
      cnt->tShrRC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->tShrRN[i], tCost, cnt->tShrRN[i]);
    }
    break;

  case '3':
    /*SUMi(C(i)*xShr(i))η׻*/
    for(i=0; i<ClassSize; i++){
      uCost+=cnt->cost->actTtl[i]*cnt->uShrLN[i];
      mCost+=cnt->cost->actTtl[i]*cnt->mShrLN[i];
      tCost+=cnt->cost->actTtl[i]*cnt->tShrLN[i];
    }
    /*xShrC=C(j)*xShr(j)/xCost η׻*/
    for(i=0; i<ClassSize; i++){
      cnt->uShrLC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->uShrLN[i], uCost, cnt->uShrLN[i]);
      cnt->mShrLC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->mShrLN[i], mCost, cnt->mShrLN[i]);
      cnt->tShrLC[i]
        =divDef(cnt->cost->actTtl[i]*cnt->tShrLN[i], tCost, cnt->tShrLN[i]);
    }
    break;
  }
}

/*-------------------------------------------------------*/
/*롼(Ρ)ˤclassͽ¬Ȥ*/
/*-------------------------------------------------------*/
double calCndCntCost(struct CndCnt *cnt, struct Cost *cost, int class){

  double totalCost=0;
  int i;

  for(i=0; i<ClassSize; i++){
    if(i!=class) totalCost+=cost->tbl[i][class]*cnt->tCnt[i];
  }
  return(totalCost);
}

/*============================================================================*/
/* ѥϢ                                                           */
/*============================================================================*/
/*---------------------------------------------------------------*/
/*饹̥ޥåޥåɽ顢upperBound       */
/* upperBound : оݤȤʤѥĥɤsv */
/*---------------------------------------------------------------*/
static double calUpperBound( struct CndCnt *cnt){

  double svMin, sv; /*value for splitting criteria*/
  int x,y,xMax,yMax;

  x=cnt->mCnt[0];
  y=cnt->mCnt[1];
  xMax=cnt->mCnt[0]+cnt->uCnt[0];
  yMax=cnt->mCnt[1]+cnt->uCnt[1];

  /*f(0,y)*/
  cnt->mCnt[0] = 0; cnt->uCnt[0] = xMax-cnt->mCnt[0];
  cnt->mCnt[1] = y; cnt->uCnt[1] = yMax-cnt->mCnt[1];
  calCndCnt(cnt);
  calCndCntSplit(cnt);
  svMin=cnt->splitAfter;

  /*f(x,0)*/
  cnt->mCnt[0] = x; cnt->uCnt[0] = xMax-cnt->mCnt[0];
  cnt->mCnt[1] = 0; cnt->uCnt[1] = yMax-cnt->mCnt[1];
  calCndCnt(cnt);
  calCndCntSplit(cnt);
  sv=cnt->splitAfter;
  if(svMin>sv) svMin=sv;

  /*f(0,0)*/
  cnt->mCnt[0] = 0; cnt->uCnt[0] = xMax-cnt->mCnt[0];
  cnt->mCnt[1] = 0; cnt->uCnt[1] = yMax-cnt->mCnt[1];
  calCndCnt(cnt);
  calCndCntSplit(cnt);
  sv=cnt->splitAfter;
  if(svMin>sv) svMin=sv;

  /*f(x,y)*/
  cnt->mCnt[0] = x; cnt->uCnt[0] = xMax-cnt->mCnt[0];
  cnt->mCnt[1] = y; cnt->uCnt[1] = yMax-cnt->mCnt[1];
  calCndCnt(cnt);
  calCndCntSplit(cnt);
  sv=cnt->splitAfter;
  if(svMin>sv) svMin=sv;

  return(svMin);
}

/*------------------------------------------------------------------*/
/* ѥΥǡФ륨ȥԡupperBound */
/* ѥ󤬰ޥåʤ1,Ǥʤ0֤      */
/*------------------------------------------------------------------*/
static int regCnt(
  struct PQkey   *pqKey,   /*ѥ*/
  struct StrTbl  *patIdx,  /*index줿training dataΥѥܥǡ*/
  struct BonCls  *cls,     /*饹ܥǡ*/
  struct Cost    *cost){   /*ȥǡ*/

  struct CndCnt  cnt; /*饹̥ޥåޥåɽ*/

  int i;

  /*cntν*/
  iniCndCnt(&cnt,cost);

  /*ǡƤѥƤϤᡢCndCnt¤Τ˷򥻥åȤ*/
  for(i=0; i<patIdx->lineCnt; i++){

    /*ιԤޥåƤ*/
    if(regCmp(getStrTbl(patIdx,i),&pqKey->reg)){
      cnt.mCnt[(int)*(cls->chr+i)]++;

    /*ιԤޥåʤ*/
    }else{
      cnt.uCnt[(int)*(cls->chr+i)]++;
    }
  }

  /**/
  calCndCnt(&cnt);

  /*ȥԡη׻*/
  calCndCntSplit(&cnt);
  pqKey->reg.objVal = cnt.splitAfter;

  /*upperBoundη׻*/
  pqKey->upperBound = calUpperBound(&cnt);

  if(cnt.mtCnt==0) return(1);
  else             return(0);
}

/*----------------------------------*/
/* ѥ٥ȥ塼Ͽ */
/*----------------------------------*/
static void setRegBest(struct PQkey *pqKey, struct RegBest *regBest){
  struct PQnode *worst;

  worst=PQworstMember(regBest->pqNode->left);

  /* ޤϿƤʤ⤷ϺãƤʤ */
  /* ñϿ */
  if( worst == NULL || regBest->cnt <regBest->maxCnt){
    PQinsert(pqKey, regBest->pqNode->left);
    regBest->cnt++;

  /* worstsvɤСworstƿϿ */
  } else if ( pqKey->reg.objVal < regBest->maxVal ) {
    PQdeleteNode(worst);
    PQinsert(pqKey, regBest->pqNode->left);

    /*regBest->maxValι(upperboundȤӤʤɤ)*/
    worst=PQworstMember(regBest->pqNode->left);
    regBest->maxVal=worst->key.reg.objVal;
  }
}

/*-------------------------------------------*/
/* 塼regBestƵŪõơ֥Ͽ */
/*-------------------------------------------*/
static int RegPQ2Tbl_Cnt;
static void regPQ2TblSub(
  struct PQnode *pqNode,
  struct RegTbl *regTbl){

  /*꡼հʳΥΡɤϺƵŪ˸ƤӽФ*/
  if(!PQisExternalNode(pqNode)){

    /*(left)귫*/
    regPQ2TblSub(pqNode->left,regTbl);

    /*塼ΥΡɤtable˥ԡ*/
    cpReg(regTbl->reg+RegPQ2Tbl_Cnt,&pqNode->key.reg);

    /*tableηȥå*/
    RegPQ2Tbl_Cnt++;

    /*礭(right)귫*/
    regPQ2TblSub(pqNode->right,regTbl);
  }
}

/*---------------------------------------------------------------*/
/* 塼regBestϿ줿ѥơ֥Ѵ */
/*---------------------------------------------------------------*/
static struct RegTbl *regPQ2Tbl( struct RegBest *regBest ){

  struct RegTbl *regTbl;

  /*ΰ*/
  regTbl=mssMalloc(sizeof(struct RegTbl), "regPQ2Tbl");
  regTbl->reg=mssCalloc(sizeof(struct Regexp) * regBest->maxCnt, "regPQ2Tbl");

  RegPQ2Tbl_Cnt=0;
  regPQ2TblSub(regBest->pqNode->left,regTbl);
  regTbl->cnt=RegPQ2Tbl_Cnt;
  return(regTbl);
}


/*----------------------------------------------------------------*/
/*ػߥꥹȤϿƤ뤫ɤΤ                    */
/*  reg->regStr="abcd"ΤȤ                                      */
/*                "bcd","cd","d"  ػߥꥹȤˤ뤫Ĵ٤      */
/*----------------------------------------------------------------*/
static int isForbid(struct Regexp *reg,struct cell **forbidden){
  int i;
  usint *pos;

  /*ƬפפξȽǤʤ(ػߥꥹȤˤʤΤȤߤʤ)*/
  if(reg->bgnRng!=0 || reg->bgnRng!=0) return(0);

  pos=reg->str;
  for(i=1; i<StrLen(reg->str); i++){
    pos++;  /* ʸ */

    if(EHmember(pos,forbidden)) return(1);
  }
  return(0);
}

/*--------------------------------------------------------*/
/*ߤΤʤѥforbidden listϿ          */
/*ϿʸɽѴʸ(Regexp->regStr)*/
/*--------------------------------------------------------*/
static void putForbid(struct Regexp *reg,struct cell **forbidden){

  /*Ƭפפξ϶ػߥꥹȤʤ*/
  if(reg->bgnRng!=0 || reg->bgnRng!=0) return;
  /*ϥåꥹȤϿ*/
  EHinsert(reg->str,forbidden);
}

/*---------------------------------------------------------------------------*/
/*оݤȤʤѥ(pqKey)ˤĤưʲΥƥȾ夫˹Ԥ            */
/* pqTop,regBest,ForbiddenListϿ                                     */
/* 1. ʬѥForbiddenListˤ               -> ⤷ʤ  &return */
/* 2. ѥ󤬰ޥåʤ                -> ForbidenList&return */
/* 3. ѥregBestޤ                 -> regBest&pqTop&return*/
/* 4. ѥUpperBoundregBestޤǤʤ -> ForbidenList&return */
/* 5. ѥĹĹã              -> ⤷ʤ&return   */
/* 6. 嵭ƤϤޤʤ                        -> pqTop&return        */
/*---------------------------------------------------------------------------*/
/*put Priority queue or Forbidden list or Best regular pattern*/
static void putPFB(
  struct PQkey *pqKey,       /*оݤȤʤѥ*/
  struct cell  *forbidden[], /*õػߥꥹ*/
  struct Data *dat,
  struct Cost *cost,
  struct Pattern *pat,
  struct PQnode *pqTop,      /*õоݥꥹ*/
  struct RegBest *regBest){  /*٥nꥹ*/
  int noMatch; /*ѥ󤬰ޥåʤե饰*/
  double upperBound; /*fobidden list뤫ɤη׻*/

  /*(1) ѥʬѥforbiddenꥹȤˤreturn*/
  if(isForbid(&pqKey->reg,forbidden)){
    return;
  }

  /*split rule,upperbound׻*/
  noMatch=regCnt(pqKey,pat->patIdx,dat->cls,cost);

  /*(2) ޥåʤforbidenꥹȤϿ&return*/
  if(noMatch){
    putForbid(&pqKey->reg,forbidden);
    return;
  }

  /*(3) ߤBest nʤregBest˥å*/
  if(pqKey->reg.objVal < regBest->maxVal){
    setRegBest(pqKey, regBest);
    if(StrLen(pqKey->reg.str)<MaxRegLen){
      PQinsert(pqKey,pqTop->left);
    }
    return;
  }

  /*upperBoundη׻classSize2λΤͭʤΤ            */
  /*classSize2礭upperBoundη׻Ωʤ  */
  /*ΤǡǤɤsvupperBoundȤƤ                */
  /*ʤupperBoundˤforbidenϿΥ르ꥺȤʤ*/
  if(ClassSize==2) upperBound=pqKey->upperBound;
  else             upperBound=0;

  /*(4) ѥUpperBoundregBestޤǤʤ*/
  if(upperBound > regBest->maxVal){
    putForbid(&pqKey->reg,forbidden);
    return;
  }

  /*(5) ѥĹĹã*/
  if(StrLen(pqKey->reg.str)>=MaxRegLen){
    return;
  }

  /*(6)嵭ƤϤޤʤ->塼ơ*/
  PQinsert(pqKey,pqTop->left);
}

/*----------------------------*/
/*ʸ(str)˰ʸ(chr)ɲ*/
/*----------------------------*/
static void addStrChr(usint *str,usint chr){
  int len;

  len=StrLen(str);
  *(str+len)=chr;
  *(str+len+1)=0;

}

/*----------------------------------------------------------------*/
/* ѥ (dat->pat+patNo)->regTbl ˥åȤ */
/*----------------------------------------------------------------*/
void setRegTbl(struct Data *dat, struct Cost *cost){

  struct Regexp reg;
  double upperBound;
  struct PQnode *pqTop;
  struct PQkey   pqKey;
  int i,j;
  struct RegBest regBest;
  struct cell *forbidden[EHbucket];
  int patNo;
  struct Pattern *pat;

  freeRegTbl(dat);
  for(patNo=0; patNo<dat->patCnt; patNo++){
    pat=dat->pat+patNo;

    /*hash bucket*/
    for(j=0; j<EHbucket; j++) forbidden[j]=NULL;

    /*Best nĤɽ빽¤Τν*/
    /*ǥѤѥ䤬Ǽ*/
    regBest.pqNode               = PQmakeNode();
    regBest.pqNode->parent       = regBest.pqNode;
    regBest.pqNode->right        = NULL;
    regBest.pqNode->rank         = 0;
    regBest.pqNode->left         = PQmakeNode();
    regBest.pqNode->left->parent = regBest.pqNode;
    regBest.cnt                  = 0;
    regBest.maxVal               = 9999;
    regBest.maxCnt               = optCAN.val;

    /*priority queueν*/
    /*ͭ˾ѥŪ˳Ǽ*/
    /*Υ塼ˤʤޤѥõ³*/
    pqTop               = PQmakeNode();
    pqTop->parent       = pqTop;
    pqTop->right        = NULL;
    pqTop->rank         = 0;
    pqTop->left         = PQmakeNode();
    pqTop->left->parent = pqTop;

    /*-------------------------------------------------------------*/
    /* ᥤ롼                                              */
    /* pqTop   : ȤʤɽƤpriority queue      */
    /* regBest : ȤʤnĤpatternsv㤤ߤ  */
    /* fobidden: θߤΤʤpatternߤƤϥå */
    /*-------------------------------------------------------------*/

    /*ޤʸѥͤȤpqTop˳Ǽ*/
    for(i=0; i<pat->map->idxSiz; i++){
      /*̾ѥ*/
      pqKey.reg.str[0]=i+1;
      pqKey.reg.str[1]=0;
      pqKey.reg.bgnRng=0;
      pqKey.reg.endRng=0;
      pqKey.reg.type  =optSEQ.set;
      putPFB(&pqKey,forbidden,dat,cost,pat,pqTop,&regBest);

      /*Ƭ*/
      for(j=1; j<=optBGN.val; j++){
        pqKey.reg.bgnRng=j;
        putPFB(&pqKey,forbidden,dat,cost,pat,pqTop,&regBest);
      }
      pqKey.reg.bgnRng=0;

      /**/
      for(j=1; j<=optEND.val; j++){
        pqKey.reg.endRng=j;
        putPFB(&pqKey,forbidden,dat,cost,pat,pqTop,&regBest);
      }
      pqKey.reg.endRng=0;

      /*Ƭξ*/
      /*ϼ
      for(j=1; j<=optBGN.val; j++){
        for(k=1; k<=optEND.val; k++){
          pqKey.reg.bgnRng=j;
          pqKey.reg.endRng=k;
          putPFB(&pqKey,forbidden,dat,cost,pat,pqTop,&regBest);
        }
      }
      */
    }
    pqKey.reg.bgnRng=0;
    pqKey.reg.endRng=0;

    /* priority queue(pqTop)ˤʤޤǥ롼פ */
    while(PQisEmpty(pqTop->left) != 1){
      /*priority queueͥѥФ*/
      /*regupperBound򥻥å*/
      PQpop(&reg,&upperBound,pqTop->left);
      /*popUB٥nʲΤȤõ*/
      if(upperBound <= regBest.maxVal){

        /*Фɽ˰ʸɲ*/
        for(i=0; i<pat->map->idxSiz; i++){
          cpReg(&pqKey.reg,&reg);
          addStrChr(pqKey.reg.str,i+1);
          putPFB(&pqKey,forbidden,dat,cost,pat,pqTop,&regBest);
        }
      }
    }
  
    /*ץ饤ƥ塼ơ֥Ѵ*/
    (dat->pat+patNo)->regTbl=regPQ2Tbl(&regBest);

    /*ΰ賫*/
    PQfree(pqTop);
    PQfree(regBest.pqNode);
    EHfree(forbidden);

  }/* for patNo */
}

void freeRegTbl(struct Data *dat){
  int i;
  for(i=0; i<dat->patCnt; i++){
    if( (dat->pat+i)->regTbl == NULL) return;
    mssFree((dat->pat+i)->regTbl->reg);
    mssFree((dat->pat+i)->regTbl);
  }
}

/*############################################################################*/
/*# Classification Table ط                                                #*/
/*############################################################################*/
/*============================================================================*/
/* Classification Tableν                                               */
/*============================================================================*/
void iniClsTbl(struct ClsTbl *ct){

  int i,j;

  /*ơ֥ν*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct-> cnt[i][j] = 0;
      ct->aShr[i][j] = 0;
      ct->pShr[i][j] = 0;
      ct-> cst[i][j] = 0;
    }
    ct->atCnt[i]=0;
    ct->atShr[i]=0;
    ct->atCst[i]=0;
    ct->ptCnt[i]=0;
    ct->ptShr[i]=0;
    ct->ptCst[i]=0;
  }
  ct->tCnt=0;
  ct->tCst=0;
  ct->accCnt=0;
  ct->errCnt=0;
  ct->accRate=0;
  ct->errRate=0;
  ct->geoMean =0;
}

/*============================================================================*/
/* ̷¤Τactual-predictơ֥ϸ˳Ƽɸη׻             */
/*============================================================================*/
void calClsTbl(struct ClsTbl *ct, struct Cost *cost){

  int i,j;
  /*ȷ׻*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->cst[i][j] = (double)ct->cnt[i][j]*cost->tbl[i][j];
    }
  }

  /*actualClass,predictedClassιפȤ*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->atCnt[i] += ct->cnt[i][j];
      ct->ptCnt[i] += ct->cnt[j][i];
      ct->tCnt     += ct->cnt[i][j];
      ct->atCst[i] += ct->cst[i][j];
      ct->ptCst[i] += ct->cst[j][i];
      ct->tCst     += ct->cst[i][j];
    }
  }

  /*Ƽ亮ι*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->aShr[i][j]=divDef((double)ct->cnt[i][j],(double)ct->atCnt[i],0);
      ct->pShr[i][j]=divDef((double)ct->cnt[i][j],(double)ct->ptCnt[j],0);
    }
    ct->atShr[i]=divDef((double)ct->atCnt[i],(double)ct->tCnt,0);
    ct->ptShr[i]=divDef((double)ct->ptCnt[i],(double)ct->tCnt,0);
  }

  /*顼η׻*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      if(i==j) ct->accCnt += ct->cnt[i][j];
      else     ct->errCnt += ct->cnt[i][j];
    }
  }

  /*Ψ顼Ψη׻*/
  ct->accRate=divDef((double)ct->accCnt,(double)ct->tCnt,0);
  ct->errRate=divDef((double)ct->errCnt,(double)ct->tCnt,0);

  /*ʿѤη׻*/
  ct->geoMean=1;
  for(i=0; i<ClassSize; i++){
    ct->geoMean*=ct->aShr[i][i];
  }
}

/*============================================================================*/
/* Classification Tableɽ                                                 */
/*============================================================================*/
void showClsTbl(struct ClsTbl *ct,struct Data *dat){

  int i,j;

  printf("\n[Classification Table]\n");
  printf("   ## by count\n");
  printf("         Predicted As ...\n");
  printf("       ");
  for(j=0; j<ClassSize; j++){
    printf("%7s",dat->cls->str[j]);
  }
  printf("  Total\n");

  for(i=0; i<ClassSize; i++){
    printf("%7s",dat->cls->str[i]);
    for(j=0; j<ClassSize; j++){
      printf("%7d",ct->cnt[i][j]);
    }
    printf("%7d\n",ct->atCnt[i]);
  }
  printf("  Total");
  for(i=0; i<ClassSize; i++){
    printf("%7d",ct->ptCnt[i]);
  }
  printf("%7d\n",ct->tCnt);

  printf("   ## by cost\n");
  printf("         Predicted As ...\n");
  printf("       ");
  for(j=0; j<ClassSize; j++){
    printf("%7s",dat->cls->str[j]);
  }
  printf("  Total\n");

  for(i=0; i<ClassSize; i++){
    printf("%7s",dat->cls->str[i]);
    for(j=0; j<ClassSize; j++){
      printf("%7.1f",ct->cst[i][j]);
    }
    printf("%7.1f\n",ct->atCst[i]);
  }
  printf("  Total");
  for(i=0; i<ClassSize; i++){
    printf("%7.1f",ct->ptCst[i]);
  }
  printf("%7.1f\n",ct->tCst);


  printf("\n[Summary]\n");
  printf("accuracyRate=%g\n",ct->accRate);
  printf("errorRate=%g\n",ct->errRate);
  printf("totalCost=%g\n",ct->tCst);
  printf("cost/cnt=%g\n",ct->tCst/(double)ct->tCnt);
  printf("geoMean=%g\n",ct->geoMean);
}



/*############################################################################*/
/*# Ϸ                                                                   #*/
/*############################################################################*/
/*----------------------------------------------------------------------*/
/* ޥåפɽ                                                         */
/*----------------------------------------------------------------------*/
void showMap(struct Map *map){
  
  printf("\n[Alphabet-Index]\n");
  printf("alphabet : ");
  prnStr(stdout,map->alp );
  printf("\n");
  printf("index    : ");
  prnStr(stdout,map->idx );
  printf("\n");
}


/*--------------------------------*/
/* ե٥åȤɽ(в) */
/*--------------------------------*/
void showAlphabet(struct Data *dat){
  int i;

  fprintf(stderr,"alphabet : ");
  for(i=0; i<dat->patCnt; i++){
    prnStr(stderr, (dat->pat+i)->map->alp );
  }
  fprintf(stderr,"\n");
}

/*------------------------------------*/
/* ǥå٤ɽ(в) */
/*------------------------------------*/
void showIndex(struct Data *dat){
  int i;

  fprintf(stderr,"index    : ");
  for(i=0; i<dat->patCnt; i++){
    prnStr(stderr, (dat->pat+i)->map->idx );
  }
}

/*------------------------------------*/
/* ǡɽ                   */
/*------------------------------------*/
void bonPrnDat( struct Data *dat){

  int i,j,k;

  printf("=========================================\n");
  printf(" Data of \"%s\"\n",dat->fpr->fName);
  printf("=========================================\n");
  printf(" number of lines  : %d\n",dat->cnt);
  printf(" number of patFld : %d\n",dat->patCnt);
  printf(" number of numFld : %d\n",dat->numCnt);
  printf(" number of catFld : %d\n",dat->catCnt);
  for(i=0; i<ClassSize; i++){
    printf(" cls[%d]=%s, ",i,dat->cls->str[i]);
  }
  printf("\n");
  for(i=0; i<dat->patCnt; i++){
    printf(" alphabet on pattern field[%d] numFlg=%d : ",i,(dat->pat+i)->numPat);

    if( (dat->pat+i)->map->idxSiz==0){
      prnStr(stdout,(dat->pat+i)->map->alp);
      printf("\n");
    }else{
      prnStr(stdout,(dat->pat+i)->map->alp);
      printf("(");
      prnStr(stdout,(dat->pat+i)->map->idx);
      printf(")\n");
    }
  }
  printf("-----------------------------------------\n");
  for(i=0; i<dat->cnt; i++){
    /*ѥ*/
    for(j=0; j<dat->patCnt; j++){
      if((dat->pat+j)->patIdx->lineCnt==0){
        prnStr(stdout,getStrTbl((dat->pat+j)->patAlp,i));
      }else{
        prnStr(stdout,getStrTbl((dat->pat+j)->patAlp,i));
        printf("(");
        prnStr(stdout,getStrTbl((dat->pat+j)->patIdx,i));
        printf(")");
      }
    }
    /*͹*/
    for(j=0; j<dat->numCnt; j++){
      printf("%g ",*(*(dat->num+j)+i) );
    }
    /*ƥ꡼*/
    for(j=0; j<dat->catCnt; j++){
      printf("%s(%d) ",*((dat->cat+j)->valName+*((dat->cat+j)->val+i)),
                       *((dat->cat+j)->val+i) );
    }
    /*饹*/
    printf("cls=%d\n",(int)*(dat->cls->chr+i) );
  }

  /*ѥν*/
  if(dat->pat->regTbl!=NULL){
    printf("-----------------------------------------\n");
    for(i=0; i<dat->patCnt; i++){
      printf("pattern #%d\n",i);
      for(j=0; j<(dat->pat+i)->regTbl->cnt; j++){
        printf("#%02d=",j);
        prnStr(stdout,((dat->pat+i)->regTbl->reg+j)->str);
        printf("(%g)\n", ((dat->pat+i)->regTbl->reg+j)->objVal);
      }
    }
  }


  /*ѥ°Ȥǡν*/
  if(dat->pat->attCnt!=0){
    printf("-----------------------------------------\n");
    for(i=0; i<dat->patCnt; i++){ /*ѥܿ*/
      printf("----- pat #%d\n",i);
      for(j=0; j<dat->cnt; j++){ /*ץǡ*/
        for(k=0; k<(dat->pat+i)->attCnt; k++){ /*ɽ*/
          if(*((dat->pat+i)->att[k]+j) ) printf("1");
          else                           printf("0");
        }
        printf("cls=%d\n",*(dat->cls->chr+j) );
      }
    }
  }
  printf("=========================================\n");
}
