
/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/07/19                                           */
/*============================================================================*/

#include <musashi.h>
#include <xtclassify.h>
#include <xtclassifyHelp.h>
#include <tree.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

struct mssComHelp comHelp={
  "xtclassify",   /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

int ClassSize;
int PatFlg=0;

/*----------------------------------------------------------------------------*/
/* ѥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optPAT={
    OFLD,   /* ץ󥿥                                             */
    "p",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    PATT,   /* ΥץΥȥ(Helpɽ)                         */
    PATC,   /* ΥץΥ(Helpɽ)                         */
    PATF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ͹                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNUM={
    OFLD,   /* ץ󥿥                                             */
    "n",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    NUMT,   /* ΥץΥȥ(Helpɽ)                         */
    NUMC,   /* ΥץΥ(Helpɽ)                         */
    NUMF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ƥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCAT={
    OFLD,   /* ץ󥿥                                             */
    "d",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    CATT,   /* ΥץΥȥ(Helpɽ)                         */
    CATC,   /* ΥץΥ(Helpɽ)                         */
    CATF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* °                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCLS={
    OFLD,   /* ץ󥿥                                             */
    "c",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                         */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    CLST,   /* ΥץΥȥ(Helpɽ)                         */
    CLSC,   /* ΥץΥ(Helpɽ)                         */
    CLSF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ȥ졼˥󥰥ե                                                       */
/*----------------------------------------------------------------------------*/
  MssOptINF optTRN={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    TRNT,   /* ΥץΥȥ(Helpɽ)                         */
    TRNC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ƥȥե                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optTST={
    OINF,   /* ץ󥿥                                             */
    "I",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    TSTT,   /* ΥץΥȥ(Helpɽ)                         */
    TSTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ǥߥ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDLM={
    OSTR,   /* ץ󥿥                                             */
    "D",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "",     /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    1,      /* ʸκĹ                                               */
    DLMT,   /* ΥץΥȥ(Helpɽ)                         */
    DLMC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ȥե                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optCST={
    OINF,   /* ץ󥿥                                             */
    "C",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    CSTT,   /* ΥץΥȥ(Helpɽ)                         */
    CSTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ǥμ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSEL optMDL={
    OSEL,   /* ץ󥿥                                             */
    "m",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "0",    /* ǥե(ʸˤ)                                       */
    "0",    /* ǽͥꥹ                                           */
    MDLT,   /* ΥץΥȥ(Helpɽ)                         */
    MDLC,   /* ΥץΥ(Helpɽ)                         */
    MDLF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ֥                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* ץ󥿥                                             */
    "q",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    SEQT,   /* ΥץΥȥ(Helpɽ)                         */
    SEQC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ü                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optEND={
    OINT,   /* ץ󥿥                                             */
    "E",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    0,      /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    10,     /*                                                        */
    ENDT,   /* ΥץΥȥ(Helpɽ)                         */
    ENDC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* Ƭ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optBGN={
    OINT,   /* ץ󥿥                                             */
    "B",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    0,      /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    10,     /*                                                        */
    BGNT,   /* ΥץΥȥ(Helpɽ)                         */
    BGNC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptINT optSIZ={
    OINT,   /* ץ󥿥                                             */
    "s",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    2,      /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    10,     /*                                                        */
    SIZT,   /* ΥץΥȥ(Helpɽ)                         */
    SIZC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* μ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optSED={
    OINT,   /* ץ󥿥                                             */
    "S",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    -1,     /* ǥե(ͤȤƻ)                                   */
    -1,     /* Ǿ                                                       */
    INT_MAX,/*                                                        */
    SEDT,   /* ΥץΥȥ(Helpɽ)                         */
    SEDC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ѥ                                                         */
/*----------------------------------------------------------------------------*/
  MssOptINT optCAN={
    OINT,   /* ץ󥿥                                             */
    "L",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    30,     /* ǥե(ͤȤƻ)                                   */
    1,      /* Ǿ                                                       */
    256,    /*                                                        */
    CANT,   /* ΥץΥȥ(Helpɽ)                         */
    CANC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* 륵ޥȲ                                           */
/*----------------------------------------------------------------------------*/
  MssOptINT optTRY={
    OINT,   /* ץ󥿥                                             */
    "l",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǥե(ͤȤƻ)                                   */
    1,      /* Ǿ                                                       */
    5,      /*                                                        */
    TRYT,   /* ΥץΥȥ(Helpɽ)                         */
    TRYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* splitting rule                                                             */
/*----------------------------------------------------------------------------*/
  MssOptSEL optSPL={
    OSEL,   /* ץ󥿥                                             */
    "g",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "0",    /* ǥե(ʸˤ)                                       */
    "0,1,2",/* ǽͥꥹ                                           */
    SPLT,   /* ΥץΥȥ(Helpɽ)                         */
    SPLC,   /* ΥץΥ(Helpɽ)                         */
    SPLF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* Ψ׻ˡ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSEL optPRB={
    OSEL,   /* ץ󥿥                                             */
    "P",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "0",    /* ǥե(ʸˤ)                                       */
    "0,1,2,3",/* ǽͥꥹ                                           */
    PRBT,   /* ΥץΥȥ(Helpɽ)                         */
    PRBC,   /* ΥץΥ(Helpɽ)                         */
    PRBF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ޴ˡ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSEL optPMD={
    OSEL,   /* ץ󥿥                                             */
    "r",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "1",    /* ǥե(ʸˤ)                                       */
    "1,2",  /* ǽͥꥹ                                           */
    PMDT,   /* ΥץΥȥ(Helpɽ)                         */
    PMDC,   /* ΥץΥ(Helpɽ)                         */
    PMDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ޴ե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optPRN={
    OINF,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    PRNT,   /* ΥץΥȥ(Helpɽ)                         */
    PRNC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptDBL optCNF={
    ODBL,   /* ץ󥿥                                             */
    "F",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    25,     /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    100,    /*                                                        */
    CNFT,   /* ΥץΥȥ(Helpɽ)                         */
    CNFC    /* ΥץΥ(Helpɽ)                         */
  };

void *opt[]={&optPAT,&optNUM,&optCAT,&optCLS,&optTRN,&optTST,&optDLM,&optTXT,
             &optCST,&optMDL,&optSEQ,&optEND,&optBGN,&optSIZ,&optSED,
             &optCAN,&optTRY,&optSPL,&optPRB,&optPMD,&optPRN,&optCNF,
             NULL};

struct mssFields *fpat; /*ܹ¤*/
struct mssFields *fnum; /*ܹ¤*/
struct mssFields *fcat; /*ܹ¤*/
struct mssFields *fcls; /*ܹ¤*/

char catCombi[1024][10];
void catMUtbl(){
  int rui[] ={1,2,4,8,16,32,64,128,256,512};
  int loop[]={512,256,128,64,32,16,8,4,2,1};
  int i,j,k,cnt;

  for(i=0; i<10; i++){
    cnt=0;
    for(j=0; j<loop[i]; j++){
      for(k=0; k<rui[i]; k++){
        catCombi[cnt++][i]='M';
      }
      for(k=0; k<rui[i]; k++){
        catCombi[cnt++][i]='U';
      }
    }
  }
  /*
  for(i=0; i<1024; i++){
    printf("i=%d : ",i);
    for(j=0; j<10; j++){
      printf("%c ",catCombi[i][j]);
    }
    printf("\n");
  }
  */
}

int main(int argc, char *argv[]){

  struct mssHeader *hdi; /*ϥե<head>Ǽ¤*/

  struct mssFPR    *trn=NULL; /*ϥե빽¤*/
  struct mssFPR    *tst=NULL; /*ϥե빽¤*/
  struct mssFPR    *prn=NULL; /*ϥե빽¤*/

  int try=0;
  int trnCnt=0;
  int tstCnt=0;
  int prnCnt=0;
  struct BonCls  *cls;
  struct Cost    *cost;
  struct Map    **map;
  struct Category *category;
  struct Data    *trnDat;
  struct Data    *tstDat;
  struct Data    *prnDat;
  struct Idxs    *idxs;
  struct Tree    *bestTree=NULL;
  struct Tree    *betterTree;
  struct Tree    *tree=NULL;
  int improved;
  int i;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */

/*mssShowOption(opt);*/

  /*----------------------------*/
  /*ѥ᡼֤ΰ¸å*/
  /*----------------------------*/
  /*°ʤȤĤϻꤵƤ뤫*/
  if(!optPAT.set && !optNUM.set && !optCAT.set){
    mssShowErrMsg("it is needed at least one attriute on -p, -n or -d.");
    exit(mssErrorNoDefault);
  }

  /*ѥ°ꤵƤPatFlgonˤ*/
  if(optPAT.set) PatFlg=1;
  else           PatFlg=0;

  /*ѥ᡼ͥå*/
  /*ѥ᡼ְ¸å*/
  /*ȤȤΤˡȥեλʤå*/
  if((0==strcmp(optPRB.str,"1") || 0==strcmp(optPRB.str,"3")) && !optCST.set){
    mssShowErrMsg("cost file must be specified");
    exit(mssErrorNoDefault);
  }

  /*ǥåʤʤΤ˥ޥȥå*/
  if(optSIZ.val==0 && optTRY.val>1)
    optTRY.val=1;

  /*޴ǡλ꤬ʤ-r2ϻǤʤ*/
  if( !optPRN.set && 0==strcmp(optPMD.str,"2") ){
    mssShowErrMsg("error reduced pruning(-r1) needs pruning data(-R)");
    exit(mssErrorNoDefault);
  }

  /*ѥ᡼ά*/
  /*ƥȥǡλ꤬ʤХȥ졼˥󥰤ƥȤȤ*/
  if(!optTST.set)optTST.str=mssStrdup(optTRN.str);

  /*ƥ꡼°ꤵƤcatMUtbl򥻥åȤ*/
  if(optCAT.set) catMUtbl();

  /*----------------------------------------------*/
  /*ϥե륪ץإåܾΥå*/
  /*----------------------------------------------*/
  trn=mssOpenFPR(optTRN.str,4); /*training File open*/
  tst=mssOpenFPR(optTST.str,4); /*test     File open*/
  if(optPRN.set)
  prn=mssOpenFPR(optPRN.str,4); /*pruning  File open*/
  hdi=mssReadHeader(trn);            /*̾ɤ߹*/

  mssSetOptFld(&optPAT, hdi);     /* -p ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optNUM, hdi);     /* -n ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optCAT, hdi);     /* -d ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optCLS, hdi);     /* -c ܤإåܤ˴ϢŤ     */
/*mssShowHeader(hdi);*/
  fpat=optPAT.flds; /*ܹ¤*/
  fnum=optNUM.flds; /*ܹ¤*/
  fcat=optCAT.flds; /*ܹ¤*/
  fcls=optCLS.flds; /*ܹ¤*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  trnCnt=bonGetCnt(trn);            /*ȥ졼˥󥰤η*/
  tstCnt=bonGetCnt(tst);            /*ƥȤη*/
  if(optPRN.set)
    prnCnt=bonGetCnt(prn);          /*޴ѥǡη*/

  cls   =bonGetCls(trn,tst,hdi);    /*饹ο-ʸ¤Υå*/
  ClassSize=cls->cnt;               /*饹򥰥Х*/

  /*geoMeanϥ饹2λΤѲǽ*/
  if(0==strcmp(optSPL.str,"2") && ClassSize!=2){
    mssShowErrMsg("geoMean as splitting rule can be used only when class size is two");
    exit(mssErrorNoDefault);
  }

  cost  =readCost(optCST.str,cls);  /*ȥեɤ߹*/
  map   =bonGetAlp(trn,tst,hdi);    /*ե٥åȤΥå*/

/*showMap(*map);*/

  category = bonGetCatHash(trn,tst,hdi); /*ƥ°ʸhashɽϿ*/
  trnDat=bonSetDat(trn,hdi,cls,trnCnt,map,category); /*trainingΥå*/
  tstDat=bonSetDat(tst,hdi,cls,tstCnt,map,category); /*testΥå*/

 /*޴ǡΥå*/
  if(optPRN.set)prnDat=bonSetDat(prn,hdi,cls,prnCnt,map,category);
  else          prnDat=NULL;
/*bonPrnDat(trnDat);*/
/*bonPrnDat(tstDat);*/

  /*--------------------------------------*/
  /*ѥܤ̵̤ηں*/
  if(!PatFlg){
    switch(*optMDL.str){
    case '0':
      /*ĥ꡼ updateTreeǳ*/
      tree = decisionTree(trnDat,tstDat,prnDat,cost);
      break;
    }
    bestTree=updateTree(tree,bestTree);   /*٥ȥĥ꡼ι(Ȥꤢ)*/

  }else{

    /*------------------------------*/
    /*ѥܤbonsai*/
    /*륵 ޥ*/
    bestTree=NULL;
    for(try=0; try<optTRY.val; try++){
      fprintf(stderr,"============================================\n");
      fprintf(stderr,"Local Search Start trial#%d\n",try);
      fprintf(stderr,"============================================\n");

      betterTree=NULL;
      /*indexSize==0ʤСalphabetƱΥǥå*/
      /*ʳʤ顢˥ǥåѰ (ǳ)   */
      if(optSIZ.val==0) idxs=initIdxs0(trnDat);
      else              idxs=initIdxs(trnDat);

     /*ʤʤޤǲ*/
      while(1){
        improved=0;
        showAlphabet(trnDat);  /*вɽ*/

        /*ʸۤʤindexǲ*/
        for(i=0; i<idxs->cnt; i++){
          /*index򥳥ԡ*/
          cpyIdx(trnDat,*(idxs->idx+i));

          /*alphabetǡindexǡѴ(ʤ)*/
          datIndexing(trnDat);

          /*ѥκ updateTreeǲ*/
          setRegTbl(trnDat,cost);

          /*ѥ䤬̵ͭ° Ȥǳ*/
          mkAtt(trnDat);
          /*bonPrnDat(trnDat); bonPrnDat(tstDat);*/

          /*ǥμˤʬ(for future)*/
          switch(*optMDL.str){
          case '0':
            /*ĥ꡼ updateTreeǳ*/
            tree = decisionTree(trnDat,tstDat,prnDat,cost);
            break;
          }

          /*вɽ*/
          showIndex(trnDat);
          showTreeSum(tree);
          /*showTree(tree,cost);*/
  
          /*ɤǥι*/
          betterTree=updateTree(tree,betterTree);
          if(betterTree==tree){
            improved=1;
            fprintf(stderr," --\n");
          }else{
            fprintf(stderr,"\n");
          }
        } /*for*/
        freeIdxs(idxs);
  
        /*ʤ⤷indexSize==0λϥ֥졼*/
        if(!improved || optSIZ.val==0){
          break;
  
        /*ХǥåѤƤõ*/
        }else{
          idxs=setNextIdxs(betterTree->dat);
          continue;
        }
      }/*while*/
  
      bestTree=updateTree(betterTree,bestTree);   /*٥ȥĥ꡼ι*/
  
    } /*try*/
    freeAtt(trnDat);
    freeRegTbl(trnDat);
  } /*bonsai*/

  /*̤ɽ*/
  showTree(bestTree,cost);

  /*ΰ賫*/
  freeTree(bestTree);
  freeDat(prnDat);
  freeDat(tstDat);
  freeDat(trnDat);
  for(i=0; i<fcat->cnt; i++){
    mssFree((category+i)->name);
    mssFree((category+i)->valName);
  }
  mssFree(category);
  freeMap(map);
  mssFree(cost);
  bonFreeCls(cls);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(trn);       /*Training File close         */
  mssCloseFPR(tst);       /*Test     File close         */
  if(optPRN.set){
    mssCloseFPR(prn);     /*Pruning  File close         */
  }
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
