#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "exHash.h"
#include "xtclassify.h"

int EHhash(usint *x){
  int i, hash;
  hash=0;
  for(i=0; i<StrLen(x); i++){
    hash=hash+(int)x[i];
  }
  hash=hash%EHbucket;
  return(hash);
}

void EHinsert(usint *x, struct cell **A){
  int k;
  struct cell *p, *q, *r;

  k=EHhash(x);
  q=A[k];
  p=(struct cell *)mssMalloc(sizeof(struct cell),"EHinsert");
  if(q==NULL){
    A[k]=p;
  }else{
    while(q!=NULL){
      if(StrCmp(q->name,x)==0){
        return;
      }else{
        r=q;
        q=q->next;
      }
    }
    r->next=p;
  }
  StrCpy(p->name,x);
  p->next=NULL;
  return;
}

void EHprint(struct cell **A){
  int i;
  struct cell *nx;
  i=0;
  for(i=0; i<EHbucket; i++){
    if(A[i]==NULL) continue;
    printf("%03d ",i);
    prnStr(stdout,A[i]->name);
    nx=A[i]->next;
    while(nx != NULL){
      printf("- ");
      prnStr(stdout,nx->name);
      nx=nx->next;
    }
    printf("\n");
  }
}

void EHdelete(usint *x, struct cell **A){
  int k;
  struct cell *q, *r;
  k=EHhash(x);
  q=A[k];
  r=NULL;
  while(q!=NULL){
    if(StrCmp(q->name,x)==0){
      if(r==NULL){
        A[k]=q->next;
      }else{
        r->next=q->next;
      }
      return;
    }
    r=q; q=q->next;
  }
  return;
}

int EHmember(usint *x, struct cell **A){
  struct cell *q, *r;
  q=A[EHhash(x)];
  while(q!=NULL){
    if(StrCmp(q->name,x)==0){
      return(1);
    }
    r=q; q=q->next;
  }
  return(0);
}

void EHfree(struct cell **A){
  struct cell *q, *next;
  int i;
  for(i=0; i<EHbucket; i++){
    if(*(A+i)==NULL)continue;
    q=*(A+i);
    while(q!=NULL){
      next=q->next;
      mssFree(q);
      q=next;
    }
  }
  return;
}

/*
void main(void) {
  struct cell *A[EHbucket];
  int flag;
  int j;
  char str[20];
  for(j=0; j<EHbucket; j++) A[j]=NULL;

 
  flag = 0;
  while(flag != 5){
    printf("\nPlease input number\n");
    printf("(1:ins 2:del 3:mem 4:prn 5:end)\n");
    scanf("%d",&flag);
    switch(flag){
    case 1:
      printf("Please input the key (string).\n");
      scanf("%s",str);
      EHinsert(str, A);
      break;
    case 2:
      printf("Please input the key.\n");
      scanf("%s",str);
      EHdelete(str,A);
      break;
    case 3:
      printf("Please input the key.\n");
      scanf("%s",str );
      if(no == EHmember(str,A))
        printf("Not found in exhash: %s\n",str);
      else
        printf("Found in exhash: %s\n",str);
      break;
    case 4:
      EHprint(A);
      break;
    case 5:
      printf("Good-bye.\n");
      break;
    }
  }
}
*/
