/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/06/20                                           */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>

#include <xtsubstrHelp.h>
struct mssComHelp comHelp={
  "xtsubstr",     /* ޥ̾       */
  "1.0",          /* С       */                                    
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */                                    
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */ 
};  

extern struct mssGlobalVariables mssGV;

MssOptRNG *RNG;

/*----------------------------------------------------------------------------*/
/* substr񤭽Ф                                                     */
/*----------------------------------------------------------------------------*/
void writeSubStr(char *str, struct mssFPW *fpw){
  struct mssStrings *subStr;
  int i;
  int from,to;
  int len;

  if(MssIsNull(str)){
    mssWriteNull(fpw);
    return;
  }

  len=strlen(str);
  subStr=mssInitStrings();
  for(i=0; i<RNG->cnt; i++){
    from=*(RNG->from+i);
    to  =*(RNG->to  +i);
    if( from>len ) continue;
    if( from>to  ) continue;
    mssCatnStrings(subStr,str+from-1,to-from+1);
  }

  if(subStr->str==NULL) mssWriteNull(fpw);
  else                  mssWriteStr(subStr->str,fpw);
  mssFreeStrings(subStr);
}


int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* оݹ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                         */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ϰ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptRNG optRNG={
    ORNG,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե(ʸȤƻꤹ)                             */
    50,     /* ޤǶڤǿκ                             */
    1,      /* ͤκǾ                                                   */
    MssFieldMaxLen,/* ͤκ                                            */
    RNGT,   /* ΥץΥȥ(Helpɽ)                         */
    RNGC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ܤȤƽϤ                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNEW={
    OFLG,   /* ץ󥿥                                             */
    "A",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    NEWT,   /* ΥץΥȥ(Helpɽ)                         */
    NEWC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optRNG,&optNEW,
               &optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*ϥե<head>Ǽ¤*/
  struct mssHeader *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR    *fpr; /*ϥե빽¤                */
  struct mssFPW    *fpw; /*ϥե빽¤                */
  struct mssFldRec *fr;  /*-ԥХåե¤             */

  int fldNo;
  int i;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */
  mssSetOptFld(&optFLD, hdi);        /* -f ܤإåܤ˴ϢŤ     */

  RNG=&optRNG;
  fldNo=MssFlds2num(optFLD.flds,0); /*-fܤιֹ楻å*/

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdi);

  /*ϥإåܤɲ*/

  /*̾ɲä*/
  if(optNEW.set){
    mssAddFieldsByFields(hdo->flds,hdi->flds);
    mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*-fǻꤵ줿ܤ-f顢¾ϥإåܤɲä*/
  }else{ 
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);
  }
  
  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/

  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    /*ܤȤư*/
    if(optNEW.set){
      mssWriteFld(fr->pnt,fr->fldCnt,"",fpw);
      mssWriteDlm(fpw);
      writeSubStr(*(fr->pnt+fldNo),fpw);
      mssWriteRet(fpw);

    /*ܤִ*/
    }else{
      /*writeFld֤뤳*/
      for(i=0; i<hdi->flds->cnt; i++){
        if(fldNo==MssFlds2num(hdi->flds,i)){
          writeSubStr(*(fr->pnt+fldNo),fpw);
        }else{
          mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
        }
        if(i==hdi->flds->cnt-1) mssWriteRet(fpw);
        else                    mssWriteDlm(fpw);

      }
    }
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);     /* եåν             */
  mssCloseFPR(fpr);        /* ϥեΥ     */
  mssCloseFPW(fpw);        /* ϥեΥ     */
  mssFreeHeader(hdi);      /* ϥإåΰ賫         */
  mssFreeHeader(hdo);      /* ϥإåΰ賫         */
  mssFreeOption(opt);      /* ץΰ賫         */
  mssShowEndMsg();         /* λå             */
  mssEnd(mssExitSuccess);  /* λ                       */
  return(0);               /* to avoid warning message   */
}
