/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤ륪ץϢδؿ
 * ============================================================================
 */

#include <mssOption.h>
#include <mssBase.h>
#include <mssXml.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <float.h>
#include <limits.h>
#include <glob.h>

extern struct mssGlobalVariables mssGV;

/**
 * # FUNCTION #
 * ʸꥹstrListcntĤγʸˤĤơܤ˽иȡ(tok)
 * ʬ䤷θʸꥹȤ֤
 *
 * ex.)
 * strList={"aaa:bbb","ccc:ddd","eee:fff"}
 *   ->
 * strList={"aaa","ccc","eee"}  ={"bbb","ddd","fff"}
 */
static char **getNextStr(char **strList, int cnt, char tok)
{
  char *colPos;
  char **list=NULL;
  int i;

  if(strList==NULL) return(NULL);

  list=mssMalloc(sizeof(char *)*cnt,"tokCol");
  for(i=0; i<cnt; i++){
    if( *(strList+i)!=NULL ){
      colPos=strchr(*(strList+i),tok);
      if(colPos!=NULL){
        *colPos='\0';
        *(list+i)=++colPos;
      }else{
        *(list+i)=NULL;
      }
    }else{
      *(list+i)=NULL;
    }
  }
  return(list);
}

/**
 * # FUNCTION #
 * Ƽ索ץι¤Τΰ롣
 * ۤ륪ץι¤Τvoidݥ󥿤ͿǤΥפȽǤ
 * ƥץ˱¸Ƥ롣
 */
void mssFreeOption(void *opt[])
{
  int i,j;

  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;

  i=0;
  while(opt[i]!=NULL){
    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        mssFree(optSTR->str);
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        mssFree(optSEL->str);
        break;

      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        mssFree(optSLS->str    );
        if(optSLS->strList!=NULL){
          mssFree(*optSLS->strList);
        }
        mssFree(optSLS->strList);
        mssFree(optSLS->colList);
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        mssFree(optINT->str );
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        mssFree(optILS->str );
        mssFree(optILS->val );
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        mssFree(optRNG->str );
        mssFree(optRNG->from);
        mssFree(optRNG->to  );
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        mssFree(optDBL->str);
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        mssFree(optDLS->str );
        mssFree(optDLS->val );
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        mssFree(optFLD->str);
        if(optFLD->nam!=NULL){
          mssFree(*optFLD->nam);
        }
        mssFree(optFLD->nam   );
        mssFree(optFLD->newNam);
        mssFree(optFLD->fldOpt);
        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        mssFree(optKEY->str);
        if(optKEY->nam!=NULL){
          mssFree(*optKEY->nam);
        }
        mssFree(optKEY->nam   );
        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        mssFree(optINF->str);
        if(optINF->strList!=NULL){
          for(j=0; j<optINF->cnt; j++){
            mssFree(*(optINF->strList+j));
          }
          mssFree(optINF->strList);
        }
        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        mssFree(optOTF->str);
        break;

      case OFLG:
        break;
    }
    i++;
  }
}

/**
 * # FUNCTION #
 * ץ¤Τsetե饰mustե饰顢ɬܻѥ᡼
 * ꤵƤ뤫ɤå롣
 * ꤵƤʤС顼åϤƽλ롣
 * xmlTableξϡmust==1 && set!=1ǥ顼(ɬܻѥ᡼ʤ)Ȥʤ롣
 * plain textξϡxmlTableξξ˲äơ
 * must==2 && set==1Ǥ⥨顼(Υѥ᡼ɬפʤ)Ȥʤ롣
 */
static void chkMust(char *keyWord, int set, int must)
{

  if(!mssGV.txtFlg){
    if(!set && must){
      mssShowErrMsg("option -%s is mandatory",keyWord);
      exit(mssErrorNoDefault);
    }
  }else{
    if(set && must==2){
      mssShowErrMsg("option -%s is not needed with -t option",keyWord);
      exit(mssErrorNoDefault);
    }
    if(!set && must==1){
      mssShowErrMsg("option -%s is mandatory",keyWord);
      exit(mssErrorNoDefault);
    }
  }
}

/**
 * # FUNCTION #
 * ޥ¦ʣΥץ¤(opt[])̤Сѿ
 * 򥳥ޥɥ饤Ѥꤹ롣
 * ޥɥ饤ΤʲΥѥ᡼ꥷܥüʰ̣
 * ȤƲᤵ롣
 * -Q : λåɽʤ
 * -t : xmlTableǤʤplainTextϥǡȤѤ롣
 * ޤ̾mssHelpDocؿƤӽФȤˤ-h,-x,-Xüʰ̣ȤƲ
 * 롣
 */
void mssSetOption(void *opt[], int argc, char *argv[])
{
  int optCnt=-1;
  enum OptType *optType;
  char *optLst;
  int i,j;
  int c;
  int err;
  int len;
  char **list1;
  char **list2;
  int cnt;
  glob_t fname;

  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;
  MssOptFLG *optFLG;

  /* -tꤵƤmssGV.txtFlgonˤ */
  for(i=1; i<argc; i++) if(*argv[i]=='-' && *(argv[i]+1)=='t') mssGV.txtFlg=1;

  /* getoptؿ˥顼åϤʤ */
  opterr=0;

  /* ץο򥫥Ȥ */
  while( opt[++optCnt]!=NULL );

  /* ƥץηoptType˥åȤ */
  optType=mssMalloc(sizeof(enum OptType)*optCnt,"setOption");
  for(i=0; i<optCnt; i++){
    /*ǽtypeޤǤϹ¤ƱʤΤMssOptKEYɽƻȤ*/
    *(optType+i)=((MssOptKEY *)opt[i])->type;
  }

  /* getoptѤΥץꥹȤ */
  /* -k key -f fld -n -z -> ":k:f:nz" */
  optLst=mssMalloc(sizeof(char)*optCnt*2+3,"setOption");
  /* ǽ餬:ȤȤϡɬפʥץǰʤ */
  /* '?'Τ':'֤Ȥˤʤ롣 */
  strcpy(optLst,":");
  for(i=0; i<optCnt; i++){
    if( *(optType+i)==OFLG ){ /*ȼʤץ*/
      strcat(optLst,((MssOptKEY *)opt[i])->keyWord);
    }else{                    /*ȼץ*/
      strcat(optLst,((MssOptKEY *)opt[i])->keyWord);
      strcat(optLst,":");
    }
  }
  strcat(optLst,"Q");
  mssFree(optType);

  /*ޥɥ饤ե饰ν*/
  for(i=0; i<optCnt; i++){
    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR: ((MssOptSTR *)opt[i])->set=0; break;
      case OSEL: ((MssOptSEL *)opt[i])->set=0; break;
      case OSLS: ((MssOptSLS *)opt[i])->set=0; break;
      case OINT: ((MssOptINT *)opt[i])->set=0; break;
      case OILS: ((MssOptILS *)opt[i])->set=0; break;
      case ORNG: ((MssOptRNG *)opt[i])->set=0; break;
      case ODBL: ((MssOptDBL *)opt[i])->set=0; break;
      case ODLS: ((MssOptDLS *)opt[i])->set=0; break;
      case OFLD: ((MssOptFLD *)opt[i])->set=0; break;
      case OKEY: ((MssOptKEY *)opt[i])->set=0; break;
      case OINF: ((MssOptINF *)opt[i])->set=0; break;
      case OOTF: ((MssOptOTF *)opt[i])->set=0; break;
      case OFLG: ((MssOptFLG *)opt[i])->set=0; break;
    }
  }

  /* getoptǥץ򥻥åȤ */
  while(1){
    c=getopt(argc,argv, optLst);
    if(c==-1) break;

    if(c==':'){
      mssShowErrMsg("option -%c needs a value",optopt);
      exit(mssErrorNoDefault);
    }

    if(c=='?'){
      mssShowErrMsg("unknown option: -%c",optopt);
      exit(mssErrorNoDefault);
    }

    if(c=='Q'){ /* åɽ̵⡼*/
      mssGV.quiet=1;
      continue;
    }

    /*ޥɥ饤ե饰(set)ȥѥ᡼ʸΥå(str)*/
    for(i=0; i<optCnt; i++){
      if( c == *((MssOptKEY *)opt[i])->keyWord ){
        switch( ((MssOptKEY *)opt[i])->type ){
          case OSTR:
            optSTR=(MssOptSTR *)opt[i];
            optSTR->set=1;
            optSTR->str=mssStrdup(optarg);
            break;
          case OSEL:
            optSEL=(MssOptSEL *)opt[i];
            optSEL->set=1;
            optSEL->str=mssStrdup(optarg);
            break;
           case OSLS:
            optSLS=(MssOptSLS *)opt[i];
            optSLS->set=1;
            optSLS->str=mssStrdup(optarg);
            break;
          case OINT:
            optINT=(MssOptINT *)opt[i];
            optINT->set=1;
            optINT->str=mssStrdup(optarg);
            break;
          case OILS:
            optILS=(MssOptILS *)opt[i];
            optILS->set=1;
            optILS->str=mssStrdup(optarg);
            break;
          case ORNG:
            optRNG=(MssOptRNG *)opt[i];
            optRNG->set=1;
            optRNG->str=mssStrdup(optarg);
            break;
          case ODBL:
            optDBL=(MssOptDBL *)opt[i];
            optDBL->set=1;
            optDBL->str=mssStrdup(optarg);
            break;
          case ODLS:
            optDLS=(MssOptDLS *)opt[i];
            optDLS->set=1;
            optDLS->str=mssStrdup(optarg);
            break;
          case OFLD:
            optFLD=(MssOptFLD *)opt[i];
            optFLD->set=1;
            optFLD->str=mssStrdup(optarg);
            break;
          case OKEY:
            optKEY=(MssOptKEY *)opt[i];
            optKEY->set=1;
            optKEY->str=mssStrdup(optarg);
            break;
          case OINF:
            optINF=(MssOptINF *)opt[i];
            optINF->set=1;
            optINF->str=mssStrdup(optarg);
            break;
          case OOTF:
            optOTF=(MssOptOTF *)opt[i];
            optOTF->set=1;
            optOTF->str=mssStrdup(optarg);
            break;
          case OFLG:
            optFLG=(MssOptFLG *)opt[i];
            optFLG->set=1;
            break;
        }
      }
    }
  }
  mssFree(optLst);

  /* 1: mustˤå                                        */
  /* 2: ΤʤäץˤĤƥǥեͤstr˥å */
  /*      MssOptINF,MssOptOTF,MssOptFLDϥǥեȤʤʤΤNULL򥻥å  */
  /*      MssOptKEYdef1or2Ȥ뤬strˤNULL򥻥åȡ        */
  /*      MssOptFLGdefsetȤƥåȤ롣                      */
  /* 3: Ʒ˱ơstrƤϤƼѿ˥åȤ     */
  err=0;
  for(i=0; i<optCnt; i++){
    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        chkMust(optSTR->keyWord,optSTR->set,optSTR->must);
        if(!optSTR->set && optSTR->def!=NULL) optSTR->str=mssStrdup(optSTR->def);

        /*å*/
        if(optSTR->set){
          len=strlen(optSTR->str);
          if(len<optSTR->minLen || len >optSTR->maxLen){
            mssShowErrMsg("length of option value is out of range : -%s %s (%d,%d)", optSTR->keyWord,optSTR->str,optSTR->minLen,optSTR->maxLen);
            exit(mssErrorNoDefault);
          }
        }
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        chkMust(optSEL->keyWord,optSEL->set,optSEL->must);
        if(!optSEL->set && optSEL->def!=NULL) optSEL->str=mssStrdup(optSEL->def);

        /*å*/
        if(optSEL->set){
          cnt=0;
          list1=mssTokByChr(optSEL->selList,',',&cnt,1);
          for(j=0;j<cnt;j++){
            if(0==strcmp(*(list1+j),optSEL->str)) break;
          }
          if(j==cnt) {
            mssShowErrMsg("argument must be one of \"%s\" on option -%s",optSEL->selList,optSEL->keyWord);
            exit(mssErrorNoDefault);
          }
          mssFree(*list1);
          mssFree(list1);
        }
        break;

      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        chkMust(optSLS->keyWord,optSLS->set,optSLS->must);
        if(!optSLS->set && optSLS->def!=NULL) optSLS->str=mssStrdup(optSLS->def);

        /**/
        optSLS->strList=NULL;
        optSLS->colList=NULL;
        optSLS->cnt=0;

        /*strNULLʤ꥿*/
        if( optSLS->str==NULL ) break;

        /*ޤˤȡʬ*/
        optSLS->strList=mssTokByChr(optSLS->str,',',&optSLS->cnt,1);

        /*ˤȡʬ*/
        optSLS->colList=getNextStr(optSLS->strList,optSLS->cnt,':');

        /*å*/
        if(optSLS->set){
          if(optSLS->cnt>optSLS->maxCnt){
            mssShowErrMsg("the max number of elements in the option is %d: -%s %s", optSLS->maxCnt,optSLS->keyWord,optSLS->str);
            exit(mssErrorNoDefault);
          } 
          for(j=0; j<optSLS->cnt; j++){
            if(*(optSLS->strList+j)==NULL || **(optSLS->strList+j)=='\0')
              len=0;
            else
              len=strlen(*(optSLS->strList+j));
            if(len<optSLS->minLen || len >optSLS->maxLen){
              mssShowErrMsg("length of %dth element of the option is out of range : -%s %s (%d,%d)", j+1,optSLS->keyWord,optSLS->str,optSLS->minLen,optSLS->maxLen);
              exit(mssErrorNoDefault);
            }
          }
          if(!optSLS->colFlg){
            for(j=0; j<optSLS->cnt; j++){
              if(*(optSLS->colList+j)!=NULL){
              mssShowErrMsg("can not use ':' in the %dth element : -%s %s)",
                j+1,optSLS->keyWord,optSLS->str);
              exit(mssErrorNoDefault);
              }
            }
          }
        }
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        chkMust(optINT->keyWord,optINT->set,optINT->must);
        if(!optINT->set){
          optINT->str=NULL;
          optINT->val=optINT->def;
        }else{
          optINT->val=atoi(optINT->str);
        }

        /*å*/
        if(optINT->min>optINT->val || optINT->max<optINT->val){
          mssShowErrMsg("the value of option -%s is out of range : %d(%d,%d)",
            optINT->keyWord,optINT->val,optINT->min,optINT->max);
          exit(mssErrorNoDefault);
        }
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        chkMust(optILS->keyWord,optILS->set,optILS->must);
        if(!optILS->set && optILS->def!=NULL) optILS->str=mssStrdup(optILS->def);

        /**/
        optILS->val=NULL;
        optILS->cnt=0;

        /*strNULLʤ꥿*/
        if( optILS->str==NULL ) break;

        /*ޤˤȡʬ*/
        list1=mssTokByChr(optILS->str,',',&optILS->cnt,1);

        /*list1ʸͥꥹȤѴ*/
        optILS->val=mssMalloc(sizeof(int)*optILS->cnt,"option");
        for(j=0; j<optILS->cnt; j++){
                if(0==strcmp(*(list1+j),"MIN")){
            *(optILS->val+j)=optILS->min;
          }else if(0==strcmp(*(list1+j),"MAX")){
            *(optILS->val+j)=optILS->max;
          }else{
            *(optILS->val+j)=atoi(*(list1+j));
          }
        }

        /*å*/
        if(optILS->set){
          if(optILS->cnt>optILS->maxCnt){
            mssShowErrMsg("the max number of elements in the option is %d: -%s %s", optILS->maxCnt,optILS->keyWord,optILS->str);
            exit(mssErrorNoDefault);
          }
          for(j=0; j<optILS->cnt; j++){
            if(*(list1+j)==NULL || **(list1+j)=='\0'){
              mssShowErrMsg("%dth element is empty : -%s %s",
                j+1,optILS->keyWord,optILS->str);
              exit(mssErrorNoDefault);
            }
          }
          for(j=0; j<optILS->cnt; j++){
            if(*(optILS->val+j)<optILS->min || *(optILS->val+j)>optILS->max ){
              mssShowErrMsg("%dth element value is out of range : -%s %s (%d,%d)", j+1,optILS->keyWord,optILS->str,optILS->min,optILS->max);
              exit(mssErrorNoDefault);
            }
          }
        }
        mssFree(*list1);
        mssFree(list1);
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        chkMust(optRNG->keyWord,optRNG->set,optRNG->must);
        if(!optRNG->set && optRNG->def!=NULL) optRNG->str=mssStrdup(optRNG->def);

        /**/
        optRNG->from=NULL;
        optRNG->to  =NULL;
        optRNG->cnt =0;

        /*strNULLʤ꥿*/
        if( optRNG->str==NULL ) break;

        /*ޤˤȡʬ*/
        list1=mssTokByChr(optRNG->str,',',&optRNG->cnt,1);

        /*Сˤȡʬ*/
        list2=getNextStr(list1,optRNG->cnt,'_');

        /*list1,list2ʸϰϤѴ*/
        optRNG->from=mssMalloc(sizeof(int)*optRNG->cnt,"option");
        optRNG->to  =mssMalloc(sizeof(int)*optRNG->cnt,"option");
        for(j=0; j<optRNG->cnt; j++){
                if(0==strcmp(*(list1+j),"MIN")){
            *(optRNG->from+j)=optRNG->min;
          }else if(0==strcmp(*(list1+j),"MAX")){
            *(optRNG->from+j)=optRNG->max;
          }else{
            *(optRNG->from+j)=atoi(*(list1+j));
          }
          if(*(list2+j) == NULL){
            *(optRNG->to+j)=*(optRNG->from+j);
          }else if(0==strcmp(*(list2+j),"MIN")){
            *(optRNG->to+j)=optRNG->min;
          }else if(0==strcmp(*(list2+j),"MAX")){
            *(optRNG->to+j)=optRNG->max;
          }else{
            *(optRNG->to+j)=atoi(*(list2+j));
          }
        }

        /*å*/
        if(optRNG->set){
          if(optRNG->cnt>optRNG->maxCnt){
            mssShowErrMsg("the max number of elements in the option is %d: -%s %s", optRNG->maxCnt,optRNG->keyWord,optRNG->str);
            exit(mssErrorNoDefault);
          }
          for(j=0; j<optRNG->cnt; j++){
            if(*(list1+j)==NULL || **(list1+j)=='\0'){
              mssShowErrMsg("%dth element is empty : -%s %s",
                j+1,optRNG->keyWord,optRNG->str);
              exit(mssErrorNoDefault);
            }
          }
          for(j=0; j<optRNG->cnt; j++){
            if(*(optRNG->from+j)<optRNG->min || *(optRNG->to+j)>optRNG->max ||
               *(optRNG->from+j)>optRNG->max || *(optRNG->to+j)<optRNG->min ){
              mssShowErrMsg("%dth element value is out of range : -%s %s (%d,%d)", j+1,optRNG->keyWord,optRNG->str,optRNG->min,optRNG->max);
              exit(mssErrorNoDefault);
            }
          }
        }

        mssFree(*list1);
        mssFree(list1);
        mssFree(list2);
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        chkMust(optDBL->keyWord,optDBL->set,optDBL->must);
        if(!optDBL->set){
          optDBL->str=NULL;
          optDBL->val=optDBL->def;
        }else{
          optDBL->val=atof(optDBL->str);
        }

        /*å*/
        if(optDBL->min>optDBL->val || optDBL->max<optDBL->val){
          mssShowErrMsg("the value of option -%s is out of range : %g(%g,%g)",
            optDBL->keyWord,optDBL->val,optDBL->min,optDBL->max);
          exit(mssErrorNoDefault);
        }
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        chkMust(optDLS->keyWord,optDLS->set,optDLS->must);
        if(!optDLS->set && optDLS->def!=NULL) optDLS->str=mssStrdup(optDLS->def);

        /**/
        optDLS->val=NULL;
        optDLS->cnt=0;

        /*strNULLʤ꥿*/
        if( optDLS->str==NULL ) break;

        /*ޤˤȡʬ*/
        list1=mssTokByChr(optDLS->str,',',&optDLS->cnt,1);

        /*list1ʸͥꥹȤѴ*/
        optDLS->val=mssMalloc(sizeof(double)*optDLS->cnt,"option");
        for(j=0; j<optDLS->cnt; j++){
                if(0==strcmp(*(list1+j),"MIN")){
            *(optDLS->val+j)=optDLS->min;
          }else if(0==strcmp(*(list1+j),"MAX")){
            *(optDLS->val+j)=optDLS->max;
          }else{
            *(optDLS->val+j)=atof(*(list1+j));
          }
        }

        /*å*/
        if(optDLS->set){
          if(optDLS->cnt>optDLS->maxCnt){
            mssShowErrMsg("the max number of elements in the option is %d: -%s %s", optDLS->maxCnt,optDLS->keyWord,optDLS->str);
             exit(mssErrorNoDefault);
          }
          for(j=0; j<optDLS->cnt; j++){
            if(*(list1+j)==NULL || **(list1+j)=='\0'){
              mssShowErrMsg("%dth element is empty : -%s %s",
                j+1,optDLS->keyWord,optDLS->str);
              exit(mssErrorNoDefault);
            }
          }
          for(j=0; j<optDLS->cnt; j++){
            if(*(optDLS->val+j)<optDLS->min || *(optDLS->val+j)>optDLS->max ){
              mssShowErrMsg("%dth element value is out of range : -%s %s (%g,%g)", j+1,optDLS->keyWord,optDLS->str,optDLS->min,optDLS->max);
              exit(mssErrorNoDefault);
            }
          }
        }
        mssFree(*list1);
        mssFree(list1);
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        chkMust(optFLD->keyWord,optFLD->set,optFLD->must);
        if(!optFLD->set) optFLD->str=NULL;

        /**/
        optFLD=(MssOptFLD *)opt[i];
        optFLD->nam=NULL;
        optFLD->newNam=NULL;
        optFLD->fldOpt=NULL;
        optFLD->cnt=0;

        /*strNULLʤ꥿*/
        if( optFLD->str==NULL ) break;

        /*ޤˤȡʬ*/
        optFLD->nam=mssTokByChr(optFLD->str,',',&optFLD->cnt,1);

        /*:ˤȡʬ*/
        optFLD->newNam=getNextStr(optFLD->nam,optFLD->cnt,':');

        /*%ˤȡʬ*/
        optFLD->fldOpt=getNextStr(optFLD->nam,optFLD->cnt,'%');

        /*å*/
        /*maxCntĶƤХ顼*/
        if(optFLD->set){
          if(optFLD->cnt>optFLD->maxCnt){
            mssShowErrMsg("the max number of fields in the option is %d: -%s %s", optFLD->maxCnt,optFLD->keyWord,optFLD->str);
            exit(mssErrorNoDefault);
          }
        }
        /*̾ǤʤΤ˻ꤷƤХ顼*/
        if(!optFLD->newFlg){
          for(j=0; j<optFLD->cnt; j++){
            if(*(optFLD->newNam+j)!=NULL){
              mssShowErrMsg("can't use new field name : -%s %s",optFLD->keyWord,optFLD->str);
              exit(mssErrorNoDefault);
            }
          }
        }
        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        chkMust(optKEY->keyWord,optKEY->set,optKEY->must);
        if(!optKEY->set) optKEY->str=NULL;

        /**/
        optKEY=(MssOptKEY *)opt[i];
        optKEY->nam=NULL;
        optKEY->diffSame=0;
        optKEY->cnt=0;

        /*strNULLʤdiffSamedef饻åȤƥ꥿*/
        if( optKEY->str==NULL ){
          optKEY->diffSame=optKEY->def;
          break;

        /*str#diff#,#same#ʤ餽줾1,2򥻥å */
        /* set=0,str=NULL ʤ-kǻꤷʤäȤȤ */
        }else{
          if( 0==strcmp(optKEY->str,"#diff#") ){
            optKEY->diffSame=1;
            optKEY->set=0;
            mssFree(optKEY->str);
            optKEY->str=NULL;
            break;
          }
          if( 0==strcmp(optKEY->str,"#same#") ){
            optKEY->diffSame=2;
            optKEY->set=0;
            mssFree(optKEY->str);
            optKEY->str=NULL;
            break;
          }
        }

        /*ޤˤȡʬ*/
        optKEY->nam=mssTokByChr(optKEY->str,',',&optKEY->cnt,1);

        /*å*/
        if(optKEY->set){
          if(optKEY->cnt>optKEY->maxCnt){
            mssShowErrMsg("the max number of fields in the option is %d: -%s %s", optKEY->maxCnt,optKEY->keyWord,optKEY->str);
            exit(mssErrorNoDefault);
          }
        }
        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        chkMust(optINF->keyWord,optINF->set,optINF->must);
        if(!optINF->set) optINF->str=NULL;

        /**/
        optINF->strList=NULL;
        optINF->cnt=0;

        /*strNULLʤ꥿*/
        if(optINF->str==NULL) break;

        /*ޤˤȡʬ*/
        optINF->strList=mssTokByChr(optINF->str,',',&optINF->cnt,1);

        /*å*/
        if(optINF->set){
          if(optINF->cnt>optINF->maxCnt){
            mssShowErrMsg("the max number of elements in the option is %d: -%s %s", optINF->maxCnt,optINF->keyWord,optINF->str);
            exit(mssErrorNoDefault);
          }
        }

        /*磻ɥɤŸ*/
        fname.gl_pathc=0;
        for(j=0; j<optINF->cnt; j++){
          if(fname.gl_pathc==0){
            glob(*(optINF->strList+j),0, NULL, &fname);
          }else{
            glob(*(optINF->strList+j),GLOB_APPEND, NULL, &fname);
          }
        }

        mssFree(*optINF->strList);
        mssFree(optINF->strList);
        optINF->cnt=fname.gl_pathc;
        if(optINF->cnt!=0){
          optINF->strList=mssMalloc(sizeof(char *)*optINF->cnt,"option");
          for(j=0; j<optINF->cnt; j++){
            *(optINF->strList+j)=mssStrdup(*(fname.gl_pathv+j));
          }
        }else{
          optINF->strList=NULL;
          if(!optINF->fnf) {
            mssShowErrMsg("file not found : -%s %s",optINF->keyWord,optINF->str);
            exit(mssErrorNoDefault);
          }
        }
        globfree(&fname);
        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        chkMust(optOTF->keyWord,optOTF->set,optOTF->must);
        if(!optOTF->set) optOTF->str=NULL;
        break;

      case OFLG:
        optFLG=(MssOptFLG *)opt[i];
        if(!optFLG->set) optFLG->set=optFLG->def;
        break;
    }
  }
}

/**
 * # FUNCTION #
 * ץ¤ΤƤɽ(debug)
 */
void mssShowOption(void *opt[])
{
  int i,j;
  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;
  MssOptFLG *optFLG;

  i=0;
  while(opt[i]!=NULL){
    fprintf(stderr,"option=%s ",((MssOptSLS *)opt[i])->keyWord);

    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        fprintf(stderr,"(STR) ");
        /* ####### set */
        if( optSTR->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optSTR->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optSTR->str);
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        fprintf(stderr,"(SEL) ");
        /* ####### set */
        if( optSEL->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optSEL->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optSEL->str);
        break;

      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        fprintf(stderr,"(SLS) ");
        /* ####### set */
        if( optSLS->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optSLS->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optSLS->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optSLS->cnt);

        /* ####### strList,colList */
        fprintf(stderr,"  strList,colList:\n");
        for(j=0; j<optSLS->cnt; j++){
          fprintf(stderr,"    [%d]=\"%s\",\"%s\"\n",j,
            *(optSLS->strList+j),
            *(optSLS->colList+j));
        }
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        fprintf(stderr,"(INT) ");
        /* ####### set */
        if( optINT->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### val */
        fprintf(stderr,"  val=%d\n",optINT->val );
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        fprintf(stderr,"(ILS) ");
        /* ####### set */
        if( optILS->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optILS->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optILS->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optILS->cnt);

        /* ####### val */
        fprintf(stderr,"  val:\n");
        for(j=0; j<optILS->cnt; j++){
          fprintf(stderr,"    [%d]=%d\n",j,*(optILS->val+j));
        }
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        fprintf(stderr,"(RNG) ");
        /* ####### set */
        if( optRNG->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optRNG->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optRNG->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optRNG->cnt);

        /* ####### from,to */
        fprintf(stderr,"  from,to:\n");
        for(j=0; j<optRNG->cnt; j++){
          fprintf(stderr,"    [%d]=%d,%d\n",j,
            *(optRNG->from+j),
            *(optRNG->to  +j));
        }
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        fprintf(stderr,"(DBL) ");
        /* ####### set */
        if( optDBL->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### val */
        fprintf(stderr,"  val=%g\n",optDBL->val );
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        fprintf(stderr,"(DLS) ");
        /* ####### set */
        if( optDLS->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optDLS->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optDLS->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optDLS->cnt);

        /* ####### val */
        fprintf(stderr,"  val:\n");
        for(j=0; j<optDLS->cnt; j++){
          fprintf(stderr,"    [%d]=%g\n",j,*(optDLS->val+j));
        }
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        fprintf(stderr,"(FLD) ");
        /* ####### set */
        if( optFLD->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optFLD->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optFLD->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optFLD->cnt);

        /* ####### nam,fldOpt,newNam */
        fprintf(stderr,"  nam,fldOpt,newNam:\n");
        for(j=0; j<optFLD->cnt; j++){
          fprintf(stderr,"    [%d]=%s,%s,%s\n",j, *(optFLD->nam   +j),
                                                  *(optFLD->fldOpt+j),
                                                  *(optFLD->newNam+j));
        }

        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        fprintf(stderr,"(KEY) ");
        /* ####### set */
        if( optKEY->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optKEY->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optKEY->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optKEY->cnt);

        /* ####### nam,fldOpt,newNam */
        for(j=0; j<optKEY->cnt; j++){
          fprintf(stderr,"  nam[%d]=%s\n",j, *(optKEY->nam   +j));
        }

        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        fprintf(stderr,"(INF) ");
        /* ####### set */
        if( optINF->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optINF->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optINF->str);

        /* ####### cnt */
        fprintf(stderr,"  cnt=%d\n",optINF->cnt);

        /* ####### strList */
        fprintf(stderr,"  strList:\n");
        for(j=0; j<optINF->cnt; j++){
          fprintf(stderr,"    [%d]=%s\n",j, *(optINF->strList+j));
        }

        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        fprintf(stderr,"(OTF) ");
        /* ####### set */
        if( optOTF->set ) fprintf(stderr,"--> set in command line\n");
        else              fprintf(stderr,"--> not set in command line\n");

        /* ####### str */
        if(optOTF->str==NULL) break;
        fprintf(stderr,"  str=\"%s\"\n",optOTF->str);
        break;

      case OFLG:
        optFLG=(MssOptFLG *)opt[i];
        fprintf(stderr,"(FLG) ");
        /* ####### set */
        if( optFLG->set )
          fprintf(stderr,"--> set in command line\n");
        else
          fprintf(stderr,"--> not set in command line\n");
        break;
    }

    i++;
  }
}

/**
 * # FUNCTION #
 * mssComHelp¤ΤƤ饳ޥɥإפɽ롣
 */
static void prnComHlp(void *opt[], struct mssComHelp *comHelp)
{
  int optCnt=-1;
  int i,j;
  char *tmp;
  char *tmp2;
  char **list1;
  int    list1Cnt;
  struct mssFPW *fpw;
  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;
  MssOptFLG *optFLG;

  fpw=mssOpenFPW((char *)1,0,0);

  /* ץο򥫥Ȥ */
  while( opt[++optCnt]!=NULL );

  /* ####### name */
  mssWriteStr("NAME:\n",fpw);
  mssWriteStr(comHelp->name,fpw);
  mssWriteStr(" ", fpw);

  /* ####### version */
  mssWriteStr("version: ",fpw);
  mssWriteStr(comHelp->version,fpw);
  mssWriteStr(" ", fpw);

  /* ####### title */
  if(mssIsValidStr(comHelp->title)){
    mssWriteStr(comHelp->title,fpw);
  }
  mssWriteRet(fpw);
  mssWriteRet(fpw);

  /* ####### USAGE: */
  mssWriteStr("USAGE:\n",fpw);
  mssWriteStr(comHelp->name,fpw);
  mssWriteStr(" ", fpw);

  /* ####### OPTION */
  for(i=0; i<optCnt; i++){
    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        if(!optSTR->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSTR->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSTR->title,fpw);
        if(!optSTR->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        if(!optSEL->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSEL->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSEL->title,fpw);
        mssWriteStr("{",fpw);
        tmp=mssStrdup(optSEL->selList);
        tmp2=tmp;
        while(*tmp2!='\0'){
          if(*tmp2==',')*tmp2='|';
          tmp2++;
        }
        mssWriteStr(tmp,fpw);
        mssFree(tmp);
        mssWriteStr("}",fpw);
        if(!optSEL->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        if(!optSLS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSLS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSLS->title,fpw);
        if(!optSLS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        if(!optINT->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optINT->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optINT->title,fpw);
        if(!optINT->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        if(!optILS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optILS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optILS->title,fpw);
        if(!optILS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        if(!optRNG->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optRNG->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optRNG->title,fpw);
        if(!optRNG->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        if(!optDBL->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optDBL->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optDBL->title,fpw);
        if(!optDBL->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        if(!optDLS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optDLS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optDLS->title,fpw);
        if(!optDLS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        if(!optFLD->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optFLD->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optFLD->title,fpw);
        if(mssIsValidStr(optFLD->fldOptSel)){
          list1Cnt=0;
          list1=mssTokByChr(optFLD->fldOptSel,',',&list1Cnt,1);
          mssWriteStr("[%{",fpw);
          for(j=0; j<list1Cnt-1; j++){
            mssWriteStr(*(list1+j),fpw);
            mssWriteStr("|",fpw);
          }
          mssWriteStr(*(list1+j),fpw);
          mssWriteStr("}]",fpw);
          mssFree(*list1);
          mssFree(list1);
        } 
        if(!optFLD->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        if(!optKEY->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optKEY->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optKEY->title,fpw);
        if(!optKEY->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        if(!optINF->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optINF->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optINF->title,fpw);
        if(!optINF->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        if(!optOTF->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optOTF->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optOTF->title,fpw);
        if(!optOTF->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OFLG:
        optFLG=(MssOptFLG *)opt[i];
        mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optFLG->keyWord,fpw);
        mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;
    }
  }
  mssWriteRet(fpw);
  mssWriteRet(fpw);

  /* ####### summary */
  if(mssIsValidStr(comHelp->summary)){
    mssWriteStr("SUMMARY:\n",fpw);
    mssWriteStr(comHelp->summary,fpw);
    mssWriteRet(fpw);
    mssWriteRet(fpw);
  }

  mssWriteStr("OPTION:\n",fpw);
  /* ####### OPTION */
  for(i=0; i<optCnt; i++){
    if( ((MssOptKEY *)opt[i])->type == OFLG ){
      optFLG=(MssOptFLG *)opt[i];
      mssWriteStr("-",fpw);
      mssWriteStr(optFLG->keyWord,fpw);
      mssWriteStr(": ",fpw);
      mssWriteStr(optFLG->title,fpw);
      mssWriteRet(fpw);
    }
  }
  mssWriteRet(fpw);

  /* ####### example */
  if(mssIsValidStr(comHelp->example)){
    mssWriteStr("EXAMPLES:\n",fpw);
    mssWriteStr(comHelp->example,fpw);
    mssWriteRet(fpw);
  }

  /* ####### homepage */
  if(mssIsValidStr(comHelp->homepage)){
    mssWriteStr("INFORMATION: <",fpw);
    mssWriteStr(comHelp->homepage,fpw);
    mssWriteStr(">\n",fpw);
  }

  /* ####### bugReport */
  if(mssIsValidStr(comHelp->bugReport)){
    mssWriteStr("BUG  REPORT: <",fpw);
    mssWriteStr(comHelp->bugReport,fpw);
    mssWriteStr(">\n",fpw);
  }

  mssWriteRet(fpw);
}

/**
 * # FUNCTION #
 * mssComHelp¤ΤƤmanɥ(groff)Ϥ롣
 */
static void prnMan(void *opt[], struct mssComHelp *comHelp)
{
  int optCnt=-1;
  int i,j;
  char *tmp;
  char *tmp2;
  char **list1;
  int    list1Cnt;
  struct mssFPW *fpw;
  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;
  MssOptFLG *optFLG;

  time_t  long_time;
  struct tm     *nt;
  char msg[100];


  fpw=mssOpenFPW((char *)1,0,0);

  /* ץο򥫥Ȥ */
  while( opt[++optCnt]!=NULL );

  /* ####### comment */
  mssWriteStr(".\\Generated by xtcmd(",fpw);
  mssWriteStr("). Modify the source.\n\n",fpw);

  /* ####### .TH*/
  time(&long_time);
  nt = localtime(&long_time);
  mssWriteStr(".TH ",fpw);
  mssWriteStr(comHelp->name,fpw);
  mssWriteStr(" 1 \"",fpw);
  sprintf(msg, "%04d-%02d-%02d", nt->tm_year+1900,nt->tm_mon+1,nt->tm_mday);
  mssWriteStr(msg,fpw);
  mssWriteStr("\" ",fpw);
  mssWriteStr("MUSASHI",fpw);
  mssWriteRet(fpw); mssWriteRet(fpw);

  /* ####### .SH ̾ */
  /*mssWriteStr(".SH ̾\n",fpw);*/
  mssWriteStr(".SH NAME\n",fpw);
  mssWriteStr(comHelp->name,fpw);
  mssWriteStr(" \\- ",fpw);
  if(mssIsValidStr(comHelp->title)){
    mssWriteStr(comHelp->title,fpw);
    mssWriteRet(fpw);
  }else{
    mssWriteStr("noData\n",fpw);
  }
  mssWriteRet(fpw);

  /* ####### .SH : */
  /*mssWriteStr(".SH \n",fpw);*/
  mssWriteStr(".SH SYNOPSIS\n",fpw);
  mssWriteStr(comHelp->name,fpw);
  mssWriteStr(" ", fpw);

  for(i=0; i<optCnt; i++){
    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        if(!optSTR->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSTR->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSTR->title,fpw);
        if(!optSTR->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        if(!optSEL->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSEL->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSEL->title,fpw);
        mssWriteStr("{",fpw);
        tmp=mssStrdup(optSEL->selList);
        tmp2=tmp;
        while(*tmp2!='\0'){
          if(*tmp2==',')*tmp2='|';
          tmp2++;
        }
        mssWriteStr(tmp,fpw);
        mssFree(tmp);
        mssWriteStr("}",fpw);
        if(!optSEL->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        if(!optSLS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optSLS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optSLS->title,fpw);
        if(!optSLS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        if(!optINT->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optINT->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optINT->title,fpw);
        if(!optINT->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        if(!optILS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optILS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optILS->title,fpw);
        if(!optILS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        if(!optRNG->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optRNG->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optRNG->title,fpw);
        if(!optRNG->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        if(!optDBL->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optDBL->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optDBL->title,fpw);
        if(!optDBL->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        if(!optDLS->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optDLS->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optDLS->title,fpw);
        if(!optDLS->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        if(!optFLD->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optFLD->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optFLD->title,fpw);
        if(mssIsValidStr(optFLD->fldOptSel)){
          list1Cnt=0;
          list1=mssTokByChr(optFLD->fldOptSel,',',&list1Cnt,1);
          mssWriteStr("[%{",fpw);
          for(j=0; j<list1Cnt-1; j++){
            mssWriteStr(*(list1+j),fpw);
            mssWriteStr("|",fpw);
          }
          mssWriteStr(*(list1+j),fpw);
          mssWriteStr("}]",fpw);
          mssFree(*list1);
          mssFree(list1);
        } 
        if(!optFLD->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        if(!optKEY->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optKEY->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optKEY->title,fpw);
        if(!optKEY->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        if(!optINF->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optINF->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optINF->title,fpw);
        if(!optINF->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        if(!optOTF->must ) mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optOTF->keyWord,fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(optOTF->title,fpw);
        if(!optOTF->must ) mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;

      case OFLG:
        optFLG=(MssOptFLG *)opt[i];
        mssWriteStr("[",fpw);
        mssWriteStr("-",fpw);
        mssWriteStr(optFLG->keyWord,fpw);
        mssWriteStr("]",fpw);
        mssWriteStr(" ", fpw);
        break;
    }
  }
  mssWriteRet(fpw);
  mssWriteRet(fpw);

  /* ####### .SH  */
  if(mssIsValidStr(comHelp->summary)){
    /*mssWriteStr(".SH \n",fpw);*/
    mssWriteStr(".SH DESCRIPTION\n",fpw);
    mssWriteStr(comHelp->summary,fpw);
    mssWriteRet(fpw);
    mssWriteRet(fpw);
  }


  /* ####### .SH ѥ᡼ */
  /*mssWriteStr(".SH ѥ᡼\n",fpw);*/
  mssWriteStr(".SH PARAMETERS\n",fpw);
  for(i=0; i<optCnt; i++){
    if( ((MssOptKEY *)opt[i])->type != OFLG ){
      switch( ((MssOptKEY *)opt[i])->type ){
        case OSTR:
          optSTR=(MssOptSTR *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optSTR->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optSTR->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optSTR->comment,fpw); mssWriteRet(fpw);
          break;
        case OSEL:
          optSEL=(MssOptSEL *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optSEL->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optSEL->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optSEL->comment,fpw); mssWriteRet(fpw);
          break;
        case OSLS:
          optSLS=(MssOptSLS *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optSLS->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optSLS->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optSLS->comment,fpw); mssWriteRet(fpw);
          break;
        case OINT:
          optINT=(MssOptINT *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optINT->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optINT->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optINT->comment,fpw); mssWriteRet(fpw);
          break;
        case OILS:
          optILS=(MssOptILS *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optILS->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optILS->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optILS->comment,fpw); mssWriteRet(fpw);
          break;
        case ORNG:
          optRNG=(MssOptRNG *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optRNG->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optRNG->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optRNG->comment,fpw); mssWriteRet(fpw);
          break;
        case ODBL:
          optDBL=(MssOptDBL *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optDBL->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optDBL->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optDBL->comment,fpw); mssWriteRet(fpw);
          break;
        case ODLS:
          optDLS=(MssOptDLS *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optDLS->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optDLS->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optDLS->comment,fpw); mssWriteRet(fpw);
          break;
        case OFLD:
          optFLD=(MssOptFLD *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optFLD->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optFLD->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optFLD->comment,fpw); mssWriteRet(fpw);
          break;
        case OKEY:
          optKEY=(MssOptKEY *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optKEY->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optKEY->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optKEY->comment,fpw); mssWriteRet(fpw);
          break;
        case OINF:
          optINF=(MssOptINF *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optINF->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optINF->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optINF->comment,fpw); mssWriteRet(fpw);
          break;
        case OOTF:
          optOTF=(MssOptOTF *)opt[i];
          mssWriteStr(".IP \"-",fpw);
          mssWriteStr(optOTF->keyWord,fpw); mssWriteStr(" ",fpw);
          mssWriteStr(optOTF->title,fpw)  ; mssWriteStr("\"\n",fpw);
          mssWriteStr(optOTF->comment,fpw); mssWriteRet(fpw);
          break;
        case OFLG:
          break;
      }
    }
  }
  mssWriteRet(fpw);

  /* ####### .SH ץ */
  /*mssWriteStr(".SH ץ\n",fpw);*/
  mssWriteStr(".SH OPTIONS\n",fpw);
  for(i=0; i<optCnt; i++){
    if( ((MssOptKEY *)opt[i])->type == OFLG ){
      optFLG=(MssOptFLG *)opt[i];
      mssWriteStr(".IP \"-",fpw);
      mssWriteStr(optFLG->keyWord,fpw);
      mssWriteStr("\"\n",fpw);
      mssWriteStr(optFLG->title,fpw);
      mssWriteStr(": ",fpw);
      mssWriteStr(optFLG->comment,fpw);
      mssWriteRet(fpw);
    }
  }
  mssWriteRet(fpw);

  /* ####### .SH  */
  if(mssIsValidStr(comHelp->example)){
    /*mssWriteStr(".SH \n",fpw);*/
    mssWriteStr(".SH EXAMPLE\n",fpw);
    list1Cnt=0;
    list1=mssTokByChr(comHelp->example,'\n',&list1Cnt,1);
    for(j=0; j<list1Cnt; j++){
      if(mssIsValidStr(*(list1+j)) ){
        mssWriteStr(".P\n",fpw);
        mssWriteStr(" ", fpw);
        mssWriteStr(*(list1+j),fpw);
        mssWriteRet(fpw);
      }
    }
    mssFree(*list1);
    mssFree(list1);
    mssWriteRet(fpw);
  }

  /* ####### .SH  */
  if(mssIsValidStr(comHelp->example)){
    /*mssWriteStr(".SH \n",fpw);*/
    mssWriteStr(".SH SEE ALSO\n",fpw);
    list1Cnt=0;
    list1=mssTokByChr(comHelp->reference,',',&list1Cnt,1);
    for(j=0; j<list1Cnt; j++){
      if(mssIsValidStr(*(list1+j)) ){
        mssWriteStr(".BR ",fpw);
        mssWriteStr(*(list1+j),fpw);
        if(j==list1Cnt-1){
          mssWriteStr(" (1)\n",fpw);
        }else{
          mssWriteStr(" (1),\n",fpw);
        }
      }
    }
    mssFree(*list1);
    mssFree(list1);
    mssWriteRet(fpw);
  }


  /* ####### .SH webڡ */
  if(mssIsValidStr(comHelp->homepage)){
    /*mssWriteStr(".SH webڡ\n",fpw);*/
    mssWriteStr(".SH WEB PAGE\n",fpw);
    mssWriteStr(comHelp->homepage,fpw);
    mssWriteRet(fpw); mssWriteRet(fpw);
  }

  /* ####### .SH Х */
  if(mssIsValidStr(comHelp->bugReport)){
    /*mssWriteStr(".SH Х\n",fpw);*/
    mssWriteStr(".SH BUG REPORT\n",fpw);
    mssWriteStr(comHelp->bugReport,fpw);
    mssWriteRet(fpw); mssWriteRet(fpw);
  }

  /* ####### .SH  */
  if(mssIsValidStr(comHelp->example)){
    /*mssWriteStr(".SH \n",fpw);*/
    mssWriteStr(".SH AUTHORS\n",fpw);
    mssWriteStr(comHelp->author,fpw);
    mssWriteRet(fpw);
  }
}

/**
 * # FUNCTION #
 * mssComHelp¤ΤƤXMLɥȤϤ롣
 */
static void prnComXml(void *opt[], struct mssComHelp *comHelp)
{
  int optCnt=-1;
  int i,j;
  struct mssFPW *fpw;
  char **list1;
  int    list1Cnt;
  char **list2;
  int    list2Cnt;
  MssOptSTR *optSTR;
  MssOptSEL *optSEL;
  MssOptSLS *optSLS;
  MssOptINT *optINT;
  MssOptILS *optILS;
  MssOptRNG *optRNG;
  MssOptDBL *optDBL;
  MssOptDLS *optDLS;
  MssOptFLD *optFLD;
  MssOptKEY *optKEY;
  MssOptINF *optINF;
  MssOptOTF *optOTF;
  MssOptFLG *optFLG;

  struct mssXmlTag *commandTag;
  struct mssXmlTag *referTag;
  struct mssXmlTag *authorTag;
  struct mssXmlTag *exampleTag;
  struct mssXmlTag *optionTag;
  struct mssXmlTag *xmlTag;
  struct mssXmlTag *manTag;

  fpw=mssOpenFPW((char *)1,0,0);
  manTag=mssInitXmlTag("mandatory",NULL);

  /* ץο򥫥Ȥ */
  while( opt[++optCnt]!=NULL );

  /* <?xml version="1.0" encoding="EUC-JP"?> */
  mssWriteXmlDeclaration( MssXmlDefVer, MssXmlDefEnc ,fpw);

  /* <command name="xtcut" version="3.00"> */
  commandTag=mssInitXmlTag("command",NULL);
  mssAddXmlTagAttributeStr(commandTag,"name"   ,comHelp->name,NULL);
  mssAddXmlTagAttributeStr(commandTag,"version",comHelp->version,NULL);
  mssWriteXmlStartTag(commandTag,NULL,fpw);
  mssWriteRet(fpw);

  /* ####### title */
  if(mssIsValidStr(comHelp->title)){
    mssWriteXmlTagStr(1,"title",comHelp->title,1,NULL,fpw);
  }

  /* ####### summary */
  if(mssIsValidStr(comHelp->summary)){
    mssWriteXmlTagStr(1,"summary",comHelp->summary,1,NULL,fpw);
  }

  /* ####### reference */
  if(mssIsValidStr(comHelp->reference)){
    list1Cnt=0;
    list1=mssTokByChr(comHelp->reference,',',&list1Cnt,1);
    for(j=0; j<list1Cnt; j++){
      mssWriteXmlIndent(1,fpw);
      referTag=mssInitXmlTag("reference",NULL);
      mssAddXmlTagAttributeInt(referTag,"no", j+1,NULL);
      mssWriteXmlStartTag(referTag,NULL,fpw);
      mssWriteXmlContent(*(list1+j),NULL,fpw);
      mssWriteXmlEndTag(referTag,NULL,fpw);
      mssWriteRet(fpw);
      mssFreeXmlTag(referTag);
    }
    mssFree(*list1);
    mssFree(list1);
  }
 
  /* ####### author */
  if(mssIsValidStr(comHelp->author)){
    list1Cnt=0;
    list1=mssTokByChr(comHelp->author,',',&list1Cnt,1);
    for(j=0; j<list1Cnt; j++){
      mssWriteXmlIndent(1,fpw);
      authorTag=mssInitXmlTag("author",NULL);
      mssAddXmlTagAttributeInt(authorTag,"no", j+1,NULL);
      mssWriteXmlStartTag(authorTag,NULL,fpw);
      mssWriteXmlContent(*(list1+j),NULL,fpw);
      mssWriteXmlEndTag(authorTag,NULL,fpw);
      mssWriteRet(fpw);
      mssFreeXmlTag(authorTag);
    }
    mssFree(*list1);
    mssFree(list1);
  }

  /* ####### example */
  if(mssIsValidStr(comHelp->example)){
    list1Cnt=0;
    list1=mssTokByChr(comHelp->example,',',&list1Cnt,1);
    for(j=0; j<list1Cnt; j++){
      mssWriteXmlIndent(1,fpw);
      exampleTag=mssInitXmlTag("example",NULL);
      mssAddXmlTagAttributeInt(exampleTag,"no", j+1,NULL);
      mssWriteXmlStartTag(exampleTag,NULL,fpw);
      mssWriteXmlContent(*(list1+j),NULL,fpw);
      mssWriteXmlEndTag(exampleTag,NULL,fpw);
      mssWriteRet(fpw);
      mssFreeXmlTag(exampleTag);
    }
    mssFree(*list1);
    mssFree(list1);
  }

  /* ####### bugReport */
  if(mssIsValidStr(comHelp->bugReport)){
    mssWriteXmlTagStr(1,"bugReport",comHelp->bugReport,1,NULL,fpw);
  }

  /* ####### homepage */
  if(mssIsValidStr(comHelp->homepage)){
    mssWriteXmlTagStr(1,"homepage",comHelp->homepage,1,NULL,fpw);
  }

  /* ####### OPTION */
  for(i=0; i<optCnt; i++){
    mssWriteXmlIndent(1,fpw);
    optionTag=mssInitXmlTag("option",NULL);
    mssAddXmlTagAttributeStr(optionTag,"keyword", ((MssOptKEY *)opt[i])->keyWord,NULL);
    mssWriteXmlStartTag(optionTag,NULL,fpw);
    mssWriteRet(fpw);

    switch( ((MssOptKEY *)opt[i])->type ){
      case OSTR:
        optSTR=(MssOptSTR *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"STR"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optSTR->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optSTR->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"minLen"   ,optSTR->minLen ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxLen"   ,optSTR->maxLen ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optSTR->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optSTR->comment,1,NULL,fpw);
        break;

      case OSEL:
        optSEL=(MssOptSEL *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"SEL"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optSEL->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optSEL->def    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optSEL->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optSEL->comment,1,NULL,fpw);

        /* ####### selList,selListTitle */
        if(mssIsValidStr(optSEL->selList)){
          list1Cnt=0;
          list1=mssTokByChr(optSEL->selList,',',&list1Cnt,1);
          list2Cnt=0;
          list2=mssTokByChr(optSEL->selListTitle,',',&list2Cnt,1);
          for(j=0; j<list1Cnt; j++){
            mssWriteXmlIndent(2,fpw);
            xmlTag=mssInitXmlTag("selectList",NULL);
            mssAddXmlTagAttributeInt(xmlTag,"no"     , j+1,NULL);
            mssAddXmlTagAttributeStr(xmlTag,"keyword", *(list1+j),NULL);
            mssWriteXmlStartTag(xmlTag,NULL,fpw);
            if(j<list2Cnt) mssWriteXmlContent(*(list2+j),NULL,fpw);
            mssWriteXmlEndTag(xmlTag,NULL,fpw);
            mssWriteRet(fpw);
            mssFreeXmlTag(xmlTag);
          }
          mssFree(*list1); mssFree(list1);
          mssFree(*list2); mssFree(list2);
        }
        break;


      case OSLS:
        optSLS=(MssOptSLS *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"SLS"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optSLS->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optSLS->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optSLS->maxCnt ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"minLen"   ,optSLS->minLen ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxLen"   ,optSLS->maxLen ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"colFlg"   ,optSLS->colFlg ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optSLS->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optSLS->comment,1,NULL,fpw);
        break;

      case OINT:
        optINT=(MssOptINT *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"INT"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optINT->must   ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"default"  ,optINT->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"min"      ,optINT->min    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"max"      ,optINT->max    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optINT->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optINT->comment,1,NULL,fpw);
        break;

      case OILS:
        optILS=(MssOptILS *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"ILS"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optILS->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optILS->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optILS->maxCnt ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"min"      ,optILS->min    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"max"      ,optILS->max    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optILS->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optILS->comment,1,NULL,fpw);
        break;

      case ORNG:
        optRNG=(MssOptRNG *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"RNG"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optRNG->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optRNG->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optRNG->maxCnt ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"min"      ,optRNG->min    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"max"      ,optRNG->max    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optRNG->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optRNG->comment,1,NULL,fpw);
        break;

      case ODBL:
        optDBL=(MssOptDBL *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"DBL"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optDBL->must   ,1,NULL,fpw);
        mssWriteXmlTagDbl(2,"default"  ,optDBL->def    ,1,NULL,fpw);
        mssWriteXmlTagDbl(2,"min"      ,optDBL->min    ,1,NULL,fpw);
        mssWriteXmlTagDbl(2,"max"      ,optDBL->max    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optDBL->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optDBL->comment,1,NULL,fpw);
        break;

      case ODLS:
        optDLS=(MssOptDLS *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"DLS"          ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optDLS->must   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"default"  ,optDLS->def    ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optDLS->maxCnt ,1,NULL,fpw);
        mssWriteXmlTagDbl(2,"min"      ,optDLS->min    ,1,NULL,fpw);
        mssWriteXmlTagDbl(2,"max"      ,optDLS->max    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optDLS->title  ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optDLS->comment,1,NULL,fpw);
        break;

      case OFLD:
        optFLD=(MssOptFLD *)opt[i];
        mssWriteXmlTagStr(2,"type"           ,"FLD"            ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory"      ,optFLD->must     ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"         ,optFLD->maxCnt   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"inKeyword"      ,optFLD->inKeyWord,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"newFieldNameFlg",optFLD->newFlg   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"          ,optFLD->title    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"        ,optFLD->comment  ,1,NULL,fpw);

        /* ####### fldOptTitle */
        if(mssIsValidStr(optFLD->fldOptSel)){
          list1Cnt=0;
          list1=mssTokByChr(optFLD->fldOptTitle,',',&list1Cnt,1);
          list2Cnt=0;
          list2=mssTokByChr(optFLD->fldOptSel,',',&list2Cnt,1);
          if(list1Cnt>list2Cnt) list1Cnt=list2Cnt;
          for(j=0; j<list1Cnt; j++){
            mssWriteXmlIndent(2,fpw);
            xmlTag=mssInitXmlTag("fieldOption",NULL);
            mssAddXmlTagAttributeInt(xmlTag,"no"     , j+1,NULL);
            mssAddXmlTagAttributeStr(xmlTag,"keyword", *(list2+j),NULL);
            mssWriteXmlStartTag(xmlTag,NULL,fpw);
            mssWriteXmlContent(*(list1+j),NULL,fpw);
            mssWriteXmlEndTag(xmlTag,NULL,fpw);
            mssWriteRet(fpw);
            mssFreeXmlTag(xmlTag);
          }
          mssFree(*list1); mssFree(list1);
          mssFree(*list2); mssFree(list2);
        }
        break;

      case OKEY:
        optKEY=(MssOptKEY *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"KEY"            ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optKEY->must     ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"default"  ,optKEY->def      ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optKEY->maxCnt   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"inKeyword",optKEY->inKeyWord,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optKEY->title    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optKEY->comment  ,1,NULL,fpw);
        break;

      case OINF:
        optINF=(MssOptINF *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"INF"            ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optINF->must     ,1,NULL,fpw);
        mssWriteXmlTagInt(2,"maxCnt"   ,optINF->maxCnt   ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"inout"    ,"in"             ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optINF->title    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optINF->comment  ,1,NULL,fpw);
        break;

      case OOTF:
        optOTF=(MssOptOTF *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"OTF"            ,1,NULL,fpw);
        mssWriteXmlTagFlg(2,"mandatory",optOTF->must     ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"inout"    ,"out"            ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optOTF->title    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optOTF->comment  ,1,NULL,fpw);
        break;

      case OFLG:
        optFLG=(MssOptFLG *)opt[i];
        mssWriteXmlTagStr(2,"type"     ,"FLG"            ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"title"    ,optFLG->title    ,1,NULL,fpw);
        mssWriteXmlTagStr(2,"comment"  ,optFLG->comment  ,1,NULL,fpw);
        break;
    }
    /* </option> */
    mssWriteXmlIndent(1,fpw);
    mssWriteXmlEndTag(optionTag,NULL,fpw);
    mssWriteRet(fpw);
    mssFreeXmlTag(optionTag);
  }
  /* </command> */
  mssWriteXmlEndTag(commandTag,NULL,fpw);
  mssFreeXmlTag(commandTag);
  mssWriteRet(fpw);
}

/**
 * # FUNCTION #
 * ޥɥإץɥȤϤ롣
 * ѥ᡼εˤʲ˼ΥɥȤϤ롣
 *   -h : ʰץإפɽ
 *   -x : XMLɥȤˤɽ
 *   -X : manɥ(troff)ˤɽ
 */
void mssHelpDoc(void *opt[],struct mssComHelp *comHelp, int argc, char **argv)
{

  if( argc>1 ){
    if( 0==strncmp(argv[1],"-h",2) ){
      prnComHlp(opt,comHelp);
      exit(EXIT_FAILURE);
    }
    if( 0==strncmp(argv[1],"-x",2) ){
      prnComXml(opt,comHelp);
      exit(EXIT_FAILURE);
    }
    if( 0==strncmp(argv[1],"-X",2) ){
      prnMan(opt,comHelp);
      exit(EXIT_FAILURE);
    }
  }
}

/**
 * # FUNCTION #
 * optFldiܤιܤ˹ܥץcꤵƤ뤫ɤ֤
 * ex)
 *  "-k %nr"λc=='r'⤷c=='n'λ֤ʳλ֤
 */
int mssIsFldOptOn(MssOptFLD *optFld,int i, char c )
{

  if(optFld==NULL) return(0);
  if(optFld->fldOpt==NULL) return(0);
  if(*(optFld->fldOpt+i)==NULL) return(0);
  if( NULL == strchr(*(optFld->fldOpt+i),c) ) return(0);

  return(1);
}

/**
 * # FUNCTION #
 * ܥץ¤(MssOptKEY)strʲξΤȤƥԡ롣
 */
void mssCpyOptKey(MssOptKEY *to,MssOptKEY *from)
{
  int i;

  to->str=mssStrdup(from->str);
  /**/
  to->diffSame=from->diffSame;
  to->cnt     =from->cnt;

  if(to->cnt==0){
    to->nam   =NULL;
  }else{
    to->nam   =mssMalloc(sizeof(char *)*to->cnt,"cpyOptKey");

    for(i=0; i<to->cnt; i++){
      if( *(from->nam   +i)!=NULL ) *(to->nam   +i)=mssStrdup(*(from->nam   +i));
    }
  }
}

/**
 * # FUNCTION #
 * Ϳ줿(val)ϰϹ¤ΤϰϤˤУ֤
 * ǤʤУ֤
 */
int mssIsInRange(MssOptRNG *optRNG,int val)
{
  int i;

  for(i=0; i<optRNG->cnt; i++){
    if( *(optRNG->from+i) <= val && val<=*(optRNG->to+i) ) return(1);
  }
  return(0);
}

