/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб                                                      */
/*============================================================================*/

#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>
#include <stdarg.h>

#include <xmltreeHelp.h>
struct mssComHelp comHelp={
  "xmltree",      /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/
struct Node {
  char  *element;               /*ʸ*/
  int    emptyTagFlg;
  char **atts;                  /*°ꥹ*/
  int    attCnt;
  struct Node  *parent;
  struct mssHash  *children;
};

typedef struct _XmlState {
  int level;
  int crFlg;
}XmlState;

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern struct mssGlobalVariables mssGV;
extern xmlParserCtxtPtr ctxt;

static struct mssFPW    *fpw; /*ϥե빽¤*/
static iconv_t *icid;   /*iconv Ѵϥɥ*/
static char *inEnc=NULL; /*󥳡ǥ*/
static char *inVer=NULL; /*С*/
static struct Node *currentNode;
static struct Node *tree;

/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* ĥ꡼¤Ǥ°񤭽Ф                                           */
/*----------------------------------------------------------------------------*/
int Level=-1;
void printTree(struct Node *node){
  struct mssHashNode *hnode;
  struct mssXmlTag *xmlTag;
  int i;

  if(node->element !=NULL){
    mssWriteXmlIndent(Level,fpw);
    xmlTag=mssInitXmlTag(node->element,NULL);
    if(node->atts!=NULL){
      for(i=0;;i++){
        if(*(node->atts+2*i+0)==NULL) break;
        if(*(node->atts+2*i+1)==NULL) break;
        mssAddXmlTagAttributeStr(xmlTag,*(node->atts+2*i),
                                        *(node->atts+2*i+1),NULL);
      }
    } 

    if(node->emptyTagFlg){
      mssWriteXmlEmptyTag(xmlTag,icid,fpw);
      mssGV.outCnt++;
      mssWriteRet(fpw);
      return;
    }else{
      mssWriteXmlStartTag(xmlTag,icid,fpw);
      mssGV.outCnt++;
    }
    mssFreeXmlTag(xmlTag);

    if(node->children->cnt!=0){
      mssWriteRet(fpw);
    }
  }

  if(node->children==NULL) return;

  for(i=0; i<node->children->hashVal; i++){
    if( NULL != (hnode=*(node->children->node+i)) ){
      while(hnode!=NULL){
        Level++;
        printTree((struct Node *)(hnode->val.v.a));
        Level--;
        hnode=hnode->next;
      }
    }
  }

  if(node->element !=NULL){
    if(node->children->cnt!=0){
      mssWriteXmlIndent(Level,fpw);
    }

    xmlTag=mssInitXmlTag(node->element,NULL);
    mssWriteXmlEndTag(xmlTag,icid,fpw);
    mssFreeXmlTag(xmlTag);
    mssWriteRet(fpw);
  }
}

void freeTree(struct Node *node){
  struct mssHashNode *hnode;
  int i;

  if(node->children!=NULL){
    if(node->atts!=NULL){
      for(i=0; i<node->attCnt; i++){
        mssFree( *(node->atts+i*2+0) );
        mssFree( *(node->atts+i*2+1) );
      }
      mssFree(node->atts);
    }
    for(i=0; i<node->children->hashVal; i++){
      if( NULL != (hnode=*(node->children->node+i)) ){
        while(hnode!=NULL){
          freeTree((struct Node *)(hnode->val.v.a));
          hnode=hnode->next;
        }
      }
    }
    mssFreeHash(node->children);
  }

  if(node!=NULL) mssFree(node->element);
  mssFree(node);
}

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  mssWriteXmlDeclaration( inVer, inEnc, fpw );
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");


  /*Ϥiconvץ*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1){
      mssShowErrMsg("encoding type error in iconv_open");
      mssEnd(mssErrorNoDefault);
  }
}

void end_doc(XmlState *state){
  printTree(tree);
  freeTree(tree);

  if(icid!=NULL) iconv_close(icid);
}

/*ߤNodeλNode˻ꤵ줿elementСNode֤*/
/*ʤNULL֤                                           */
struct Node *getChildNode(struct Node *cn, char *element){
  struct mssHashNode *node;

  if( cn->element==NULL) return(NULL);
  if( cn->children==NULL) return(NULL);
  node=(struct mssHashNode *) mssHashMember(cn->children, element);

  if( NULL == node){
    return(NULL);
  }else{
    return((struct Node *)node->val.v.a);
  }
}


struct Node *addNode(struct Node *cn, char *element){
  MssValue node;

  /*Ρɤγ*/
  node.v.a=mssCalloc(sizeof(struct Node),"xmltree");

  /*̾,ΡɤΥɥ쥹childrenϿ*/
  mssHashInsert(cn->children, element, node);

  /*ΡɤλҥΡɤ*/
  ((struct Node *)(node.v.a))->children    = mssInitHash(11);
  ((struct Node *)(node.v.a))->element     = mssStrdup(element);
  ((struct Node *)(node.v.a))->emptyTagFlg = 0;
  ((struct Node *)(node.v.a))->parent      = cn;
  ((struct Node *)(node.v.a))->atts        = NULL;
  ((struct Node *)(node.v.a))->attCnt      = 0;

  return(node.v.a);
}

void addAtts(struct Node *node, char **atts){
  int i,j;
  int flg;
  
  if(atts!=NULL){
    i=0;
    while(*(atts+i)!=NULL){
    
      /*¸ߤƤcontinue*/
      flg=0;
      for(j=0; j<node->attCnt; j++){
        if( 0==strcmp(*(atts+i),*(node->atts+j*2)) ){
          flg=1;
          break;
        }
      }
      if(flg){
        i=i+2;
        continue;
      }

      /*ɲϿ*/
      node->atts = mssRealloc(node->atts,
        sizeof(char *)*((node->attCnt+2)*2),"xmltree");
      *(node->atts+node->attCnt*2+0)=mssStrdup(*(atts+i));
      *(node->atts+node->attCnt*2+1)=mssStrdup("");
      *(node->atts+node->attCnt*2+2)=NULL;
      *(node->atts+node->attCnt*2+3)=NULL;
      i=i+2;
      node->attCnt++;
    }
  }
}

/* start */
void start_element(XmlState *state, char *fullname, char **atts){
  struct Node *childNode;

  mssGV.inCnt++;
  if(state->level>MAX_NEST){
    mssShowErrMsg("nest level exceed (max=%d)" ,MAX_NEST);
    mssEnd(mssErrorNoDefault);
  }

  /*ȤλҥΡɤ*/
  childNode=getChildNode(currentNode,fullname);

  /*ȤλҥΡɤ̵ɲä*/
  if( childNode==NULL ){
    childNode=addNode(currentNode,fullname);
  }

  /*°ɲ*/
  addAtts(childNode,atts);

  /*νȤλҥΡɤ򥫥ȥΡɤȤ*/
  currentNode=childNode;

  state->level++;
}

/* end */
void end_element(XmlState *state, char *fullname, char **atts){
  state->level--;
  if(state->level<0){
    mssShowErrMsg("nest level reach to below 0");
    mssEnd(mssErrorNoDefault);
  }
  currentNode=currentNode->parent;
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    NULL, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
};

int main(int argc, char *argv[]){

  XmlState         *state;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*ɸϥץ*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  tree=mssCalloc(sizeof(struct Node),"xmltree");
  tree->children = mssInitHash(11);
  currentNode=tree;

  state=mssCalloc(sizeof(XmlState),"xml2xt");

  if(optINF.set){
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(optINF.str);
  }else{
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt("/dev/stdin");
  }
  if(!ctxt){
    mssShowErrMsg("not xml file\n");
    mssEnd(mssErrorNoDefault);
  }
  ctxt->sax=&SAXFunctions;

  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

  mssFree(inEnc);
  mssFree(inVer);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);       /*ϥեΥ   */
  mssFreeOption(opt);     /*ץΰ賫       */
  mssShowEndMsg();        /*λå           */
  mssEnd(mssExitSuccess); /*λ                     */
  return(0);              /* to avoid warning message*/
}
