/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб                                                      */
/*============================================================================*/

#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>
#include <stdarg.h>

#include <xmltagcntHelp.h>
struct mssComHelp comHelp={
  "xmltagcnt",    /* ޥ̾       */                                      
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */                                    
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */                                    
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};          

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/
/*ͥ*/

struct Attribute {
  char *str;
  int   cnt;
};

struct Node {
  char *element;               /*ʸ*/
  int   cnt;                   /*Ρɤνи*/
  struct Attribute *attribute; /*°ꥹ*/
  int attCnt;                  /*°μ*/
  struct Node  *parent;
  struct mssHash  *children;
};

typedef struct _XmlState {
  int level;
}XmlState;

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern struct mssGlobalVariables mssGV;
extern xmlParserCtxtPtr ctxt;
extern xmlParserCtxtPtr ctxt;

static struct mssFPW    *fpw; /*ϥե빽¤*/
static struct mssHeader *hdo; /*ϥե<head>Ǽ¤*/
static iconv_t *icid;   /*iconv Ѵϥɥ*/
static char *inEnc=NULL; /*󥳡ǥ*/
static char *inVer=NULL; /*С*/
static char currentPath[256];
static struct Node *currentNode;
static struct Node *tree;

/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* ĥ꡼¤Ǥ°ơ֥ǽ񤭽Ф                             */
/*----------------------------------------------------------------------------*/
void printTree(struct Node *node){
  struct mssHashNode *hnode;
  char *pos;
  int i;

  pos=currentPath+strlen(currentPath);

  /*̾ν*/
  if(node->element !=NULL){ /*ȥåץΡɤФ */
    /*ߤΥΡɥѥ򹹿*/
    strcat(currentPath,"/");
    strcat(currentPath,node->element);

    mssWriteXmlContent(currentPath, icid, fpw);
    mssWriteDlm(fpw); 
    mssWriteNull(fpw); 
    mssWriteDlm(fpw); 
    mssWriteInt(node->cnt,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
  }

  /*°ȼäΡɤν*/
  for(i=0; i<node->attCnt; i++){
    mssWriteXmlContent(currentPath, icid, fpw);
    mssWriteDlm(fpw); 

    mssWriteXmlContent((node->attribute+i)->str, icid, fpw);
    mssWriteDlm(fpw); 

    mssWriteInt((node->attribute+i)->cnt,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
  }
  if(node->children==NULL) return;

  for(i=0; i<node->children->hashVal; i++){
    if( NULL != (hnode=*(node->children->node+i)) ){
      while(hnode!=NULL){
        printTree((struct Node *)(hnode->val.v.a));
        hnode=hnode->next;
      }
    }
  }

  /*ߤΥΡɥѥ򹹿*/
  *pos='\0';
}

void freeTree(struct Node *node){
  struct mssHashNode *hnode;
  int i;

  if(node->children!=NULL){
    if(node->attribute!=NULL){
      mssFree(node->attribute);
    }
    for(i=0; i<node->children->hashVal; i++){
      if( NULL != (hnode=*(node->children->node+i)) ){
        while(hnode!=NULL){
          freeTree((struct Node *)(hnode->val.v.a));
          hnode=hnode->next;
        }
      }
    }
    mssFreeHash(node->children);
  }

  if(node!=NULL) mssFree(node->element);
  mssFree(node);
}

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){
  char *fldNam[3]={"element","attribute","count"};
  char *fldNamEnc[3];
  int i;

  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");

  /*ѥ᡼Ѥiconvץ                                   */
  /*xmlޥɤΥѥ᡼ϥǡϥǡencoding     */
  /*ơϥǡΥ󥳡ǥ󥰤ȤʤȤ˺롣*/
  icid=iconv_open("UTF-8","euc-jp");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }
  fldNamEnc[0]=mssEncoding(fldNam[0], icid);
  fldNamEnc[1]=mssEncoding(fldNam[1], icid);
  fldNamEnc[2]=mssEncoding(fldNam[2], icid);

  /*ѥ᡼Ѥiconv*/
  if(icid!=NULL) iconv_close(icid);

  /*Ϥiconvץ*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /*ϥإåκȽ   */
  hdo=mssInitSetHeader(NULL, NULL, inVer, inEnc, MssXtDefVer);

  for(i=0; i<3; i++){
    mssAddFieldsByStr(hdo->flds, mssEncoding(fldNamEnc[i],icid));
  }

  /*xmlTableإåν񤭽Ф*/
  mssWriteHeader(hdo, fpw);

  /* currentPathν */
  currentPath[0]='\0';
}

void end_doc(XmlState *state){
  printTree(tree);
  freeTree(tree);

  if(icid!=NULL) iconv_close(icid);

}

/*ߤNodeλNode˻ꤵ줿elementСNode֤*/
/*ʤNULL֤                                           */
struct Node *getChildNode(struct Node *cn, char *element){
  struct mssHashNode *node;

  if( cn->element ==NULL) return(NULL);
  if( cn->children==NULL) return(NULL);
  node=(struct mssHashNode *) mssHashMember(cn->children, element);

  if( NULL == node){
    return(NULL);
  }else{
    return((struct Node *)node->val.v.a);
  }
}

void addAttribute(struct Node *node, char **atts){
  int i,j;
  int flg;

  if(atts!=NULL){
    i=0;
    while(*(atts+i)!=NULL){

      /*¸ߤƤcountUp+continue*/
      flg=0;
      for(j=0; j<node->attCnt; j++){
        if( 0==strcmp(*(atts+i),(node->attribute+j)->str) ){
          (node->attribute+j)->cnt++;
          flg=1;
          break;
        }
      }
      if(flg){
        i=i+2;
        continue;
      }

      /*ɲϿ*/
      node->attribute = mssRealloc(node->attribute,
        sizeof(struct Attribute)*(node->attCnt+1),"xmltree");
      node->attribute->str=mssStrdup(*(atts+i));
      node->attribute->cnt=1;
      i=i+2;
      node->attCnt++;
    }
  }
}

struct Node *addNode(struct Node *cn, char *element, char **atts){
  MssValue node;

  /*Ρɤγ*/
  node.v.a=mssCalloc(sizeof(struct Node),"xmltree");

  /*̾,ΡɤΥɥ쥹childrenϿ*/
  mssHashInsert(cn->children, element, node);

  /*ΡɤλҥΡɤ*/
  ((struct Node *)(node.v.a))->children = mssInitHash(11);
  ((struct Node *)(node.v.a))->element  = mssStrdup(element);
  ((struct Node *)(node.v.a))->parent   = cn;
  ((struct Node *)(node.v.a))->attribute= NULL;
  ((struct Node *)(node.v.a))->attCnt   = 0;
  ((struct Node *)(node.v.a))->cnt      = 1;

  return(node.v.a);
}

/* start */
void start_element(XmlState *state, char *fullname, char **atts){
  struct Node *childNode;

  mssGV.inCnt++;
  if(state->level>MAX_NEST){
    mssShowErrMsg("nest level exceed (max=%d)" ,MAX_NEST);
    mssEnd(mssErrorNoDefault);
  }

  /*ȤλҥΡɤ*/
  childNode=getChildNode(currentNode,fullname);

  /*ȤλҥΡɤ̵ɲä*/
  if( childNode==NULL ){
    childNode=addNode(currentNode,fullname,atts);
  }

  /*°ɲ*/
  addAttribute(childNode, atts);

  /*νȤλҥΡɤ򥫥ȥΡɤȤ*/
  currentNode=childNode;
  currentNode->cnt++;

  state->level++;
}

/* end */
void end_element(XmlState *state, char *fullname, char **atts){
  state->level--;
  if(state->level<0){
    mssShowErrMsg("nest level reach to below 0");
    mssEnd(mssErrorNoDefault);
  }
  currentNode=currentNode->parent;
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    NULL, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
};

int main(int argc, char *argv[]){

  XmlState         *state;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*ɸϥץ*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  tree=mssCalloc(sizeof(struct Node),"xmltree");
  tree->children = mssInitHash(11);
  currentNode=tree;

  state=mssCalloc(sizeof(XmlState),"xml2xt");

  if(optINF.set){
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(optINF.str);
  }else{
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt("/dev/stdin");
  }
  if(!ctxt){
    mssShowErrMsg("not xml file\n");
    mssEnd(mssErrorNoDefault);
  }
  ctxt->sax=&SAXFunctions;

  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

  if(inEnc!=NULL) mssFree(inEnc);
  if(inVer!=NULL) mssFree(inVer);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν           */
  mssCloseFPW(fpw);       /*ϥեΥ   */
  mssFreeHeader(hdo);     /*ϥإåΰ賫       */
  mssFreeOption(opt);     /*ץΰ賫       */
  mssShowEndMsg();        /*λå           */
  mssEnd(mssExitSuccess); /*λ                     */
  return(0);              /* to avoid warning message*/
}
