/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤXMLtableΥϢδؿ
 * ============================================================================
 * ̾ή
 * 1. mssReadTagǥե뤫ɤ߹ΥStrings˥åȤ
 * 2. mssGetTagɬפʥStrings˥åȤ
 * 3. mssGetTagCont,mssGetTagAtt,mssGetNulTagʤɤƤФ
 * 4. 2ǳݤStrings
 * 5. 2,3,4ν򷫤֤
 * 6. 1ǳݤStrings
 *
 * mssGetTagCont,mssGetTagAtt,mssGetNulTagStringsʸñˤ򸡺ǽ 
 * ߤĤƤ֤ΤǡStrings˥ʣmssGetTag
 * 餫ɬפʥStrings˥åȤƤ
 */

#include <mssInput.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* ############ Хѿ ##############*/
extern struct mssGlobalVariables mssGV;


/** 
 * # FUNCTION # 
 * 3İʸ󤫤鿷ĤʸΥݥ󥿤֤
 * κݡʸΰ褬ݤ롣
 * Tagκʤɤ
 * ex.) bgn="<", str="field", end=">"
 *      ->
 *      "<field>"
 */     
static char *mkStr(char *bgn, char *str, char *end){
  char *tag;
  
  tag=mssMalloc(sizeof(char)*(strlen(bgn)+strlen(str)+strlen(end)+1),"mkStr");
  strcpy(tag,bgn);
  strcat(tag,str);
  strcat(tag,end);
  return(tag);
}

/** 
 * # FUNCTION # 
 * ե(fp)꥿(tag)򸡺Strings˥åȤΥݥ󥿤֤
 * ϥ̵NULL֤
 * ϥꡢλ̵Х顼ɽλ
 * ex.)
 * ե뤬"<xmltable><header>....</header></xmltable>"Ȥȡ
 * strings->str="<header><title>this is title</title></header>"
 */
struct mssStrings *mssReadTag(char *tag, struct mssFPR *fp){
    
  struct mssRec *rec;
  int   len;
  char *bgnTag;
  char *endTag;
  char *tagTmp=NULL;
  struct mssStrings *strings=NULL;

  rec=mssInitRec();

  /*beginend򤽤줾쥻åȤ*/
  bgnTag=mkStr("<" ,tag,"" );
  endTag=mkStr("</",tag,">");

  /*beginθ*/
  while( EOF != (len=mssReadRec(fp, rec)) ){
    if( NULL != (tagTmp=strstr(rec->pnt, bgnTag)) ){
      strings=mssInitStrings();
      mssCatStrings(strings, tagTmp);
      mssCatStrings(strings, "\n");
      break;
    }
  }

  /*beginʤä*/
  if(len==EOF) return(NULL);
  
  /*endθ*/
  while( EOF != (len=mssReadRec(fp, rec)) ){
    if( NULL != (tagTmp=strstr(rec->pnt, endTag)) ){
      mssCatnStrings(strings, rec->pnt, rec->pnt-tagTmp+strlen(endTag));
      mssCatStrings(strings, "\n");
      break;
    }else{
      mssCatStrings(strings, rec->pnt);
      mssCatStrings(strings, "\n");
    }
  }

  /*endʤä*/
  if(len==EOF){
    mssShowErrMsg("there is not the end tag : %s",tag);
    mssEnd(mssErrorNoDefault);
  }

  mssFreeRec(rec);
  mssFree(bgnTag); mssFree(endTag);

  return(strings);
}

/** 
 * # FUNCTION #
 * ʸ(str)꥿(tag)ǰϤޤ줿ʸStrings˥åȤ
 * Υݥ󥿤֤
 * ϥ̵NULL֤
 * ϥꡢλ̵Х顼ɽλ
 * *posˡ줿ϥƬΥݥ󥿤򥻥åȤ롣
 * γؤϹθƤʤΤǡƱ̾ҹ¤ˤʤäƤ
 * ޤưʤ
 * ex.)
 * *str="<header><title>this is title</title><header>"Ȥȡ
 * strings->str="<title>this is title</title>"
 * *posϡꥸʥ*str"<title>...."Ƭ֤åȤ롣
 */
struct mssStrings *mssGetTag(char *tag, char *str, char **pos){

  char *bgnTag;
  char *endTag;
  char *bgnTagTmp;
  char *endTagTmp;
  struct mssStrings *strings;

  /*beginend򤽤줾쥻åȤ*/
  bgnTag=mkStr("<" ,tag,"" );
  endTag=mkStr("</",tag,">");

  /*beginθ*/
  bgnTagTmp=strstr(str, bgnTag);
  if( bgnTagTmp == NULL ){
    return(NULL);
  }

  /*endθ*/
  endTagTmp=strstr(bgnTagTmp, endTag);
  if( endTagTmp == NULL ){
    mssShowErrMsg("there is not the end tag : %s",tag);
    mssEnd(mssErrorNoDefault);
  }

  strings=mssInitStrings();
  mssCatnStrings(strings, bgnTagTmp, endTagTmp-bgnTagTmp+strlen(endTag));

  mssFree(bgnTag); mssFree(endTag);

  *pos=bgnTagTmp;
  return(strings);
}

/** 
 * # FUNCTION #
 * ʸ(str)ǥ򸡺1ʤ0֤
 * ǥ: <numeric/>
 */
int mssGetNullTag(char *str, char *tag){

  char *t;
  int   ret=0;

  /**/
  t=mkStr("<",tag,"/>");

  /*θ*/
  if(NULL != strstr(str, t)) ret=1;

  mssFree(t);
  return(ret);
}

/** 
 * # FUNCTION #
 * ʸ(str)꥿(tag)Ƥ֤
 * ꥿ʤNULL֤ͤ
 * ϥꡢλ̵Х顼ɽλ
 * strƤѤˡ˥ݤơΥɥ쥹֤
 * retIgnoreʤвԤ̵뤹롣
 * γؤϹθƤʤΤǡƱ̾ҹ¤ˤʤäƤ
 * ޤưʤ
 * ex.)
 * str="<title>this is title</title>"
 * tag="title"
 * ="this is title"
 */
char *mssGetTagCont(char *str, char *tag, int retIgnore){

  char *bgnTag;
  char *endTag;
  char *bgnTagTmp=NULL;
  char *endTagTmp=NULL;
  char *retStr=NULL;
  char *retPnt;
  char *conPnt;
  char  tmp;

  if( str == NULL ) return(NULL);

  /*beginend򤽤줾쥻åȤ*/
  bgnTag=mkStr("<" ,tag,"" );
  endTag=mkStr("</",tag,">");

  /*begin,endθ*/
  bgnTagTmp=strstr(str, bgnTag);
  if( bgnTagTmp == NULL ){
    return(NULL);
  }

  endTagTmp=strstr(bgnTagTmp, endTag);
  if( endTagTmp == NULL ){
    mssShowErrMsg("there is not the end tag : %s",tag);
    mssEnd(mssErrorNoDefault);
  }

  while(*bgnTagTmp != '>') bgnTagTmp++;
  bgnTagTmp++;

  tmp=*endTagTmp;
  *endTagTmp='\0';
  if(retIgnore){
    retStr=mssMalloc(sizeof(char)*(strlen(bgnTagTmp)+1),"getTagCont");
    conPnt=bgnTagTmp;
    retPnt=retStr;
    while(conPnt!=endTagTmp){
      if(*conPnt!='\n'){
        *retPnt=*conPnt;
        retPnt++;
      }
      conPnt++;
    }
    *retPnt='\0'; 
  }else{
    retStr=mssStrdup(bgnTagTmp);
  }
  *endTagTmp=tmp;

  mssFree(bgnTag); mssFree(endTag);
  return(retStr);
}

/** 
 * # FUNCTION #
 * ʸ(str)꥿(tag)λ°(att)֤ͤ
 * ϥꡢλ̵Х顼ɽλ
 * strƤѤˡ˥ݤơΥɥ쥹֤
 * °ͤ'"'ǰϤޤƤ뤳Ȥ
 * ex.)
 * str="<field no="1">...</field>"
 * ="1"
 */
char *mssGetTagAtt(char *str, char *tag, char *att){

  char *bgnTag;
  char *bgnTagTmp;
  char *attStr;
  char *retStr=NULL;
  char *pos;
  char buf[256];
  int i;

  /*begin°̾򥻥åȤ*/
  bgnTag=mkStr("<",tag," " );
  attStr=mkStr("" ,att,"=");

  /*beginθ*/
  bgnTagTmp=strstr(str, bgnTag);
  if( bgnTagTmp == NULL ){
    return(NULL);
  }

  /*Ū">"'\0'ˤ롣*/
  pos=bgnTagTmp;
  while(*pos!='>' && *pos!='\0') pos++;
  if(*pos!='>'){
    mssShowErrMsg("not a complete tag : %s",tag);
    mssEnd(mssErrorNoDefault);
  }
  *pos='\0';

  /*°θ*/
  bgnTagTmp=strstr(bgnTagTmp, attStr);
  if( bgnTagTmp == NULL ){
    retStr=NULL;
  }else{

    /*°ͤΥå*/
    while(*bgnTagTmp!='"' && *bgnTagTmp!='\0') bgnTagTmp++;
    if(*bgnTagTmp=='\0'){
      mssShowErrMsg("invalid attribute value : %s",att);
      mssEnd(mssErrorNoDefault);
    }
    bgnTagTmp++;
    for(i=0; *bgnTagTmp!='"' && *bgnTagTmp!='\0' && i<255; i++){
      buf[i]=*bgnTagTmp++;
    }
    if(*bgnTagTmp=='\0' || i>=255){
      mssShowErrMsg("invalid attribute value : %s",att);
      mssEnd(mssErrorNoDefault);
    }
    buf[i]='\0';
    retStr=mssStrdup(buf);
  }

  *pos='>';

  mssFree(bgnTag); mssFree(attStr);
  return(retStr);
}

/** 
 * # FUNCTION #
 * ȥå׹(xml<xmltbl>)ɤ߹
 * ܤXMLȤߤʤܤxmlTableȤߤʤ
 * XMLС󡢥󥳡ǥ󥰤򥻥åȡ
 * xmlTableΥС򥻥åȡ
 */
void mssReadSetTop(struct mssHeader *header, struct mssFPR *fp){
  struct mssRec *rec;
  struct mssStrings *buf;
  int   len;

  rec=mssInitRec();
  buf=mssInitStrings();

  len=mssReadRec(fp, rec);
  /*mssReadRecEOFȤȤϥǡʤȤ*/
  if(len==EOF) {
    mssShowErrMsg("no input data");
    exit(mssErrorNoDefault);
  }

  if( 0!=strncmp(rec->pnt,"<?xml",5) ){
    mssShowErrMsg("not XML data");
    mssEnd(mssErrorNoDefault);
  }else{
    header->xmlver=mssGetTagAtt(rec->pnt, "?xml", "version");
    header->xmlenc=mssGetTagAtt(rec->pnt, "?xml", "encoding");
    len=mssReadRec(fp, rec);
    /*mssReadRecEOFȤȤϥǡʤȤ*/
    if(len==EOF) {
      mssShowErrMsg("no input data");
      exit(mssErrorNoDefault);
    }
  }

  if( 0!=strncmp(rec->pnt+1,"xmltbl ",7) ){
    mssShowErrMsg("not xml table");
    exit(mssErrorNoDefault);
  }
  mssCatStrings(buf, rec->pnt);

  header->version = mssGetTagAtt(buf->str, "xmltbl", "version");

  mssFreeRec(rec);
  mssFreeStrings(buf);  /*20021126ɲ*/
}

/** 
 * # FUNCTION #
 * ǡޤǥåפ롣
 * Ūˤ"<body><![CDATA["μιԤ˥եݥ󥿤ܤ
 * <body>ϰԤ˽񤫤Ƥ뤳Ȥ
 */
void mssSkipToBody(struct mssFPR *fp){
  struct mssRec *rec=NULL;

  if(mssGV.txtFlg) return;

  rec=mssInitRec();

  while(EOF!=mssReadRec(fp, rec)){
    if( 0==strncmp(rec->pnt,MssBeginBodyString,15) ){
      mssFreeRec(rec);
      return;
    }
  }
  mssFreeRec(rec);
  mssShowErrMsg("can't find the end body tag");
  exit(mssErrorNoDefault);
}
