/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤ뽸״Ϣδؿ
 * ============================================================================
 */

#include <mssBase.h>
#include <mssUniq.h>
#include <mssHeader.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

/**
 * Хѿ
 */
extern struct mssGlobalVariables mssGV;

static MssOptKEY  *OptKey;               /*-kѥ᡼*/
static int  FldCnt;                   /*פܿ*/
static char readEnd[2]={0xff,0};      /*ʼ*/
static char fname[MssFileNameMaxLen]; /*ե̾*/

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ֹ(Red Black Tree)
 * ----------------------------------------------------------------------------
 * ʸ: إǡ¤ȥ르ꥺٶΩ,2000,64.
 * p.224 9ܤϸ!!
 * ) if (v == NULL ) return(1) -> ) if (v == NULL ) return(0)
 */

/**
 * # FUNCTION #
 */
static int RBUQhasLeftNode(struct RBUQnode *v)
{
  if(v->left->rank !=0){
    return(1);
  }
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBUQisExternalNode(struct RBUQnode *v)
{
  if(v->rank==0)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBUQisTopNode(struct RBUQnode *v)
{
  if(v->parent->rank==0){
    return(1);
  }
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBUQisLeftNode(struct RBUQnode *v)
{
  if(v==v->parent->left)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static int RBUQisRedNode(struct RBUQnode *v)
{
  if(v==NULL) return(0);
  if(v->rank == v->parent->rank)
    return(1);
  return(0);
}

/**
 * # FUNCTION #
 */
static struct RBUQnode *RBUQfindMax(struct RBUQnode *v)
{
  while(!RBUQisExternalNode(v->right))
    v=v->right;
  return(v);
}

/**
 * # FUNCTION #
 */
static struct RBUQnode *RBUQfind_brother(struct RBUQnode *v)
{
  if(RBUQisLeftNode(v))
    return(v->parent->right);
  return(v->parent->left);
}

/**
 * # FUNCTION #
 */
static struct RBUQnode *RBUQmakeNode(void)
{
  struct RBUQnode *new;
  struct RBUQkey  *key;
  new=(struct RBUQnode *)mssMalloc(sizeof(struct RBUQnode),"RBUQmkNode");
  key=(struct RBUQkey  *)mssMalloc(sizeof(struct RBUQkey ),"RBUQmkNode");
  new->key=key;
  /*new->key.str[0]='\0';*/
  new->key->str=NULL;
  new->rank = 0;
  new->left=new->right=NULL;
  return new;
}

/**
 * # FUNCTION #
 */
static void RBUQfreeKey(struct RBUQkey *key)
{
  mssFree(key->str);
  mssFree(key->fld);
  mssFree(key->bkt);
  mssFree(key);
}

/**
 * # FUNCTION #
 */
static void RBUQfreeNode(struct RBUQnode *v)
{
  if(RBUQisExternalNode(v)){
    mssFree(v->key);
    mssFree(v);
    return;
  }else{
    RBUQfreeKey(v->key);
    mssFree(v);
    return;
  }
}

/**
 * # FUNCTION #
 */
static void RBUQfreeAllNode(struct RBUQnode *v)
{
  if(RBUQisExternalNode(v)){
    mssFree(v->key);
    mssFree(v);
    return;
  }else{
    RBUQfreeAllNode(v->left);
    RBUQfreeAllNode(v->right);
    RBUQfreeNode(v);
    return;
  }
}

/**
 * # FUNCTION #
 */
static int keyCmp(struct mssFldRec *fr, struct RBUQnode *v)
{
  int i;
  int cmp;

  for(i=0; i<OptKey->flds->cnt; i++){
    if( 0 != ( cmp=strcmp( *(fr->pnt+MssFlds2num(OptKey->flds,i)),
                           *(v->key->fld+MssFlds2num(OptKey->flds,i)) )) ){
      return(cmp);
    }
  }
  return(0); /*Ʊ!!*/
}

/**
 * # FUNCTION #
 */
static struct RBUQnode *RBUQmember(struct mssFldRec *fr, struct RBUQnode *v)
{
  struct RBUQnode *vv;

  if(RBUQisExternalNode(v)) return(v);

  if( 0 > keyCmp(fr, v) ){
    vv=RBUQmember(fr,v->left);
  }else if( 0 < keyCmp(fr, v) ){
    vv=RBUQmember(fr,v->right);
  }else{
    return(v);
  }
  return(vv);
}

/**
 * # FUNCTION #
 */
static void RBUQaddExternalNodes(struct RBUQnode *n)
{
  n->left = RBUQmakeNode();
  n->right= RBUQmakeNode();
  n->left->parent =n;
  n->right->parent=n;
}

/**
 * # FUNCTION #
 */
static void RBUQsingleRotate(struct RBUQnode *v)
{
  struct RBUQnode *p, *pp,*ppp;

  p  =v->parent;
  pp =p->parent;
  ppp=pp->parent;

  if(RBUQisLeftNode(pp)){
    ppp->left=p;
  }else{
    ppp->right=p;
  }
  if(RBUQisLeftNode(v)){
    pp->left=p->right;
    pp->left->parent=pp;
    p->right=pp;
    pp->parent=p;
  }else{
    pp->right = p->left;
    pp->right->parent = pp;
    p->left = pp;
    pp->parent = p;
  }
  p->parent=ppp;
}

/**
 * # FUNCTION #
 */
static void RBUQdouble_rotate(struct RBUQnode *v)
{
  struct RBUQnode *p;
  p=v->parent;
  if(RBUQisLeftNode(v)){
    RBUQsingleRotate(v->left);
    RBUQsingleRotate(p);
  }else{
    RBUQsingleRotate(v->right);
    RBUQsingleRotate(p);
  }
}

/**
 * # FUNCTION #
 */
static void RBUQrebalanceOnInsert(struct RBUQnode *v)
{
  struct RBUQnode *w, *p, *pp;
  int p_is_left;
  
  p=v->parent;
  pp=p->parent;
  if(RBUQisTopNode(p)){
    return;
  }
  if(RBUQisRedNode(p)){
    p_is_left=0;   
    if((p_is_left=RBUQisLeftNode(p))){  
      w=pp->right;
    }else{
      w=pp->left;
    }
    if(RBUQisRedNode(w)){   
      (pp->rank)++;
      if(!RBUQisTopNode(pp) && RBUQisRedNode(pp->parent)){
        RBUQrebalanceOnInsert(pp);
      }
    }else{
      if(RBUQisLeftNode(v)){
        if(p_is_left){
          RBUQsingleRotate(v);
        }else{
          RBUQdouble_rotate(v);
        }
      }else{
        if(p_is_left){
          RBUQdouble_rotate(v);
        }else{
          RBUQsingleRotate(v);
        }
      }
    }
  }
}

/**
 * # FUNCTION #
 */
static void RBUQdetermineAB(struct RBUQnode **a, struct RBUQnode **b, struct RBUQnode *v, struct RBUQnode *u)
{
  if(RBUQisLeftNode(v)){
    *a=u->right;
    *b=u->left;
  }else{
    *a=u->left;
    *b=u->right;
  }
}

/**
 * # FUNCTION #
 */
static void RBUQrebalanceOnDelete(struct RBUQnode *v)
{
  struct RBUQnode *p,*u,*a,*b;
  int v_is_left, p_was_red;

  p=v->parent;
  if(v->rank+1 >= p->rank)
    return;
  u=RBUQfind_brother(v);
  RBUQdetermineAB(&a,&b,v,u);
  v_is_left=RBUQisLeftNode(v);
  p_was_red=RBUQisRedNode(p);
  if(RBUQisRedNode(u)){
    if(RBUQisRedNode(a) || RBUQisRedNode(b))
      return;
    RBUQsingleRotate(a);
    RBUQrebalanceOnDelete(v);
  }else{
    if(!RBUQisRedNode(a)){
      if(!RBUQisRedNode(b)){
        (p->rank)--;
        if(!p_was_red)
          RBUQrebalanceOnDelete(p);
      }else{
        RBUQdouble_rotate(b);
        (b->rank)++;
        (p->rank)--;
      }
    }else{
      RBUQsingleRotate(a);
      (u->rank)++;
      (u->rank)--;
    }
  }
}

/**
 * # FUNCTION #
 */
static void RBUQptree(struct RBUQnode *p,int h)
{
  int i,j;

  if(!RBUQisExternalNode(p)){
    RBUQptree(p->left, h+1);
    if(0 == strcmp(p->key->str,readEnd) ){
      for(i=1; i<=h; i++) fprintf(stderr,"    ");
      printf("key='EOF' ");
      /*printf(" bktCnt=%d bkt=",p->key->bktCnt);*/
      for(j=0; j<PWayU; j++){
        if(*(p->key->bkt+j) == 1)
        printf("%d ",j);
      }
      printf("\n");
    }else{
      for(i=1; i<=h; i++) fprintf(stderr,"    ");
      printf("key='");
      for(j=0; j<OptKey->flds->cnt; j++){
        printf("%s ",*(p->key->fld+MssFlds2num(OptKey->flds,j)+1));
      }

      /*printf(" bktCnt=%d bkt=",p->key->bktCnt);*/
      for(j=0; j<PWayU; j++){
        if(*(p->key->bkt+j) == 1)
        printf("%d ",j);
      }
      /*for(j=0; j<p->key->bktCnt; j++){*/
      /*  printf("%d ",*(p->key->bkt+j));*/
      /*}*/
      printf("\n");
    }   
    RBUQptree(p->right,h+1);
  }
}

/**
 * # FUNCTION #
 * RBUQcpKeyδؿǳݤ줿̤η׻
 */
static int RBUQcpKeyMemCnt( struct mssFldRec *fr)
{

  int memCnt=0;

  if(fr->eof==1){ /*EOF*/
    /*ʸȤʼƤ*/
    memCnt+=2*sizeof(char);

    /*ܤΥɥ쥹ʼꤹ*/
    memCnt+=FldCnt*sizeof(char *);

    /*sortUQǤϰʲbktѿѤƤʤmergeRBUQѡ*/
    memCnt+=(sizeof(int)*PWayU);

  }else{

    /*frܤޤ뤴ȥԡ*/
    memCnt+=fr->chrCnt*sizeof(char);

    /*ܤΥɥ쥹׻ˤꥻå*/
    memCnt+=FldCnt*sizeof(char *);

    /*sortUQǤϰʲbktѿѤƤʤmergeRBUQѡ*/
    memCnt+=(sizeof(int)*PWayU);
  }
  return(memCnt);
}

/**
 * # FUNCTION #
 */
static void RBUQcpKey( struct RBUQnode  *v, struct mssFldRec *fr, int bkt)
{
  int i;

  if(fr->eof==1){ /*EOF*/
    /*ʸȤʼƤ*/
    v->key->str = mssMalloc(2*sizeof(char),"RBUQUQtree1");
    memcpy(v->key->str, readEnd, 2);

    /*ܤΥɥ쥹ʼꤹ*/
    v->key->fld = mssMalloc(FldCnt*sizeof(char *),"RBUQUQtree2");
    for(i=0; i<FldCnt; i++){
      *(v->key->fld+i) = v->key->str;
    }

    /*sortUQǤϰʲbktѿѤƤʤmergeRBUQѡ*/
    v->key->bkt    = mssCalloc(sizeof(int)*PWayU, "RBUQtree");
    *(v->key->bkt+bkt) = 1;
    /**v->key->bkt    = bkt;*/
    /*v->key->bktCnt = 1;*/

  }else{

    /*frܤޤ뤴ȥԡ*/
    v->key->str = mssMalloc(fr->chrCnt*sizeof(char),"RBUQUQtree4");
    memcpy(v->key->str, *fr->pnt, fr->chrCnt); 

    /*ܤΥɥ쥹׻ˤꥻå*/
    v->key->fld = mssMalloc(FldCnt*sizeof(char *),"RBUQUQtree5");
    for(i=0; i<FldCnt; i++){
      *(v->key->fld+i) = v->key->str + (*(fr->pnt+i) - *fr->pnt);
    }

    /*sortUQǤϰʲbktѿѤƤʤmergeRBUQѡ*/
    v->key->bkt    = mssCalloc(sizeof(int)*PWayU, "RBUQtree");
    *(v->key->bkt+bkt) = 1;
  }
}

/**
 * # FUNCTION #
 *ΥΡɤFldRec¤ΤΥǡǹ
 */
static void RBUQupdate( struct RBUQnode *v, int bkt)
{
  /*ХåֹХåȥե饰˹*/
  *(v->key->bkt+bkt) = 1;
}

/**
 * # FUNCTION #
 * RBtreeFldRec¤ΤΥǡɲ
 * ˥¸ߤRBUQupdateͤ򹹿
 */
static int RBUQinsert( struct RBUQnode *v, struct mssFldRec *fr, int bkt)
{
  int memCnt=0;

  v = RBUQmember(fr, v);

  /*¸ߤʤɲ*/
  if(RBUQisExternalNode(v)){
    RBUQcpKey(v, fr, bkt);
    memCnt=RBUQcpKeyMemCnt(fr);
    v->rank=1;
    RBUQaddExternalNodes(v);
    RBUQrebalanceOnInsert(v);
    memCnt+=sizeof(struct RBUQnode)*2;
    memCnt+=sizeof(struct RBUQkey )*2;

  /*¸ߤСɤ߹ߥե饰ON*/
  }else{
    RBUQupdate(v, bkt);
  }

  return(memCnt);
}

/**
 * # FUNCTION #
 *ΥΡɤ
 */
static void RBUQdeleteNode(struct RBUQnode *v)
{
  struct RBUQnode *w,*x;

  if(RBUQisExternalNode(v)){
    fprintf(stderr,"Not found such node\n");
    return;
  }
  if(RBUQhasLeftNode(v)){
    w=RBUQfindMax(v->left);
    if(w->parent != v){
      w->parent->right = w->left;
      w->left->parent  = w->parent;
    }
    x=w->left;
    RBUQfreeNode(w->right);
    /*free(w->right->key);*/
    /*free(w->right);*/

    if(RBUQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    if(w->parent != v){
      w->left = v->left;
      w->left->parent = w;
    }
    w->rank = v->rank;
    w->parent = v->parent;
    w->right = v->right;
    w->right->parent=w;
    RBUQfreeNode(v);
    /*free(v->key);*/
    /*free(v);*/
  }else{
    w=v->right;
    if(RBUQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    w->parent=v->parent;
    RBUQfreeNode(v->left);
    RBUQfreeNode(v);
    /*free(v->left->key);*/
    /*free(v->left);*/
    /*free(v->key);*/
    /*free(v);*/
    x=w;
  }

  RBUQrebalanceOnDelete(x);
}

/**
 * # FUNCTION #
 *ΥΡɤ
 *RBtreeͥԤΥΡɥɥ쥹֤
 *νǥΡɤϤʤƤӽФ¦RBUQdeleteNode(node)¹
 */
static struct RBUQnode *RBUQpop(struct RBUQnode *v)
{
  struct RBUQnode *vv;

  if(RBUQisExternalNode(v)){
    return(NULL);
  }else{
    vv=v;
    while(!RBUQisExternalNode(vv)){
      vv=vv->left; /*rightéк硢leftϺǾ*/
    }
    return(vv->parent);
  }
}

/**
 * # FUNCTION #
 * RBtreeĥ꡼Ȥƽ񤭽Ф(ǥХå)
 */
void RBUQprintTree(char *s,struct RBUQnode *pp)
{
  fprintf(stderr,"%s\n",s);
  RBUQptree(pp,0);
}

/**
 * # FUNCTION #
 * ΥΡɤԤȤƽ񤭽Ф
 */
static void RBUQwriteNode( struct RBUQnode *p, struct mssFPW *fpw)
{
  int i;

  /*ǡƥȤν*/
  for(i=0; i<FldCnt-1; i++){
    mssWriteStr(*(p->key->fld+i),fpw); mssWriteDlm(fpw);
  }
  mssWriteStr(*(p->key->fld+i),fpw); mssWriteRet(fpw);
}

/**
 * # FUNCTION #
 * RBtreeƹԤȤƽ񤭽Ф(ǥХå)
 */
static void RBUQwriteAllNode(struct RBUQnode *p, struct mssFPW *fpw)
{
  if(!RBUQisExternalNode(p)){
    RBUQwriteAllNode(p->left,fpw);
    RBUQwriteNode(p,fpw);
    RBUQwriteAllNode(p->right,fpw);
  }
}

/**
 * # FUNCTION #
 * RBtreeΥΰ
 */
static void RBUQfree(struct RBUQnode *v)
{
  RBUQfreeAllNode(v->left);
  mssFree(v->key);
  mssFree(v);
}

/**
 * # FUNCTION #
 * RBnodeν(Ρɺ)
 */
static struct RBUQnode *RBUQinit(struct RBUQnode *rb)
{
  /*ֹڤν*/
  rb               = RBUQmakeNode();
  rb->parent       = rb;
  rb->right        = NULL;
  rb->rank         = 0;
  rb->left         = RBUQmakeNode();
  rb->left->parent = rb;
  return(rb);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ״Ϣؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ե̾μ
 */
static char *getFname(char *prefix, int number)
{
  /*fnameϥХѿ*/
  sprintf(fname,"%s%d",prefix,number);
  return(fname);
}

/**
 * # FUNCTION #
 * mssFldRec¤Τ˰ɤ߹(ʼ)
 */
static void readRBUQkey( struct mssFPR *fp, struct mssFldRec *fr)
{
  int i;

  if(EOF==mssReadFldRec(fp,fr)){
    for(i=0; i<fr->fldCnt; i++)
      *(fr->pnt+i)=readEnd; /*EOFλʼ*/
  }
}

/**
 * # FUNCTION #
 *ƥХåȤκǽιԤRB塼ɤ߹
 *mergeRB,preSortƤӽФ
 *iFromiToޤǤΥեƬԤRB塼
 * ud   : iFile,rb򥻥åȤ
 * iFrom: ϥեֹ
 * iTo  : λեֹ
 */
static void setFirstLineRBUQ( struct mssUnqDat *ud, int iFrom, int iTo)
{
  int bkt;                /*߽ΥХåֹ(0Ϥޤ)*/
  int i;

  /*ץ饤ƥ塼ν*/
  ud->rb=RBUQinit(ud->rb);
  bkt=0;
  for(i=iFrom; i<=iTo; i++){
    ud->fr[bkt]=mssInitFldRec(FldCnt);

    ud->iFile[bkt]=mssOpenFPR(getFname(ud->prefixTxt,i),4);

    /*(Ƭ)ɤ߹*/
    readRBUQkey(ud->iFile[bkt],ud->fr[bkt]);

    /*ֹڤ(ʪŪ˥ԡ)*/
    RBUQinsert(ud->rb->left,ud->fr[bkt],bkt);
    bkt++;
  }
}

/**
 * # FUNCTION #
 * RB塼ѤPWayޡ
 * ¤ѤäƤХå(iCnt)ʻ礷Ƥ
 * ǸΰĤˤʤޤʻϤʤ
 * PWayUĤ꾯ʤʤäȤʻߤ
 */
static void mergeRBUQ(struct mssUnqDat *ud)
{
  int    bkt[PWayU];       /*PwayʻRBtreepopǡΥХåNo*/
  int    bktCnt;           /*ΥХåȿ*/
  struct RBUQnode *node;   /*popˤƼΡɤǼ*/

  struct mssFPW *oFile;       /*ϥեݥ*/

  int    iStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    iEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    oStart;           /*ϥեγֹ(ե̾ΰ)*/
  int    oEnd;             /*ϥեνλֹ(ե̾ΰ)*/
  int    iFrom,iTo;        /*ʻ礹Υեֹ*/
  int    k;
  int    i;

  /*Υ롼פin,outswapΤǡǤϵդ*/
  iStart=ud->iEnd+1;
  iEnd  =ud->iEnd+1;
  oStart=ud->iStart;
  oEnd  =ud->iEnd;

  /*եʻ礹롼 iCntPWayUĤ礭ޤ³*/
  while(1){
    mssSwapInt(&iStart,&oStart);
    mssSwapInt(&iEnd  ,&oEnd  );
    oEnd=oStart;

    /*ϥեPWayUʲʤнλ*/
    if(iEnd-iStart+1 <= PWayU){
      ud->iStart = iStart;
      ud->iEnd   = iEnd;
      break;
    }

    /*PwayĤiFileĤoFile˽񤭽Ф"򷫤֤롼*/
    k=0;
    while(1){
      /*ƥХåȤκǽԤ򥭥塼*/
      iFrom= k   *PWayU+iStart;     /* PWayU=3ǰե뤬
                                          0,1,2,3,4,5,6λ*/
      iTo  =(k+1)*PWayU+iStart-1; /* iFrom: 0 3 6*/
      if(iTo>iEnd) iTo=iEnd;        /* iTo  : 2 5 6*/

      setFirstLineRBUQ(ud, iFrom,iTo);

      /*ϥե륪ץ*/
      oFile=mssOpenFPW(getFname(ud->prefixTxt,oEnd),0,0);

      /*ƥХåȤԤŤɤ߹߽񤭽Ф롼*/
      while(1) {
        node=RBUQpop(ud->rb->left);          /*塼ԼФ*/
        if(strcmp(node->key->str,readEnd)==0)/*readEnd(ʼ)Ф齪λ*/
          break;
        RBUQwriteNode(node,oFile);  /*Խ񤭽Ф*/
        bktCnt=0;                   /*popǼФkeyͤΥХåȿ*/
        for(i=0; i<PWayU; i++){
          if(*(node->key->bkt+i) == 1)
          bkt[bktCnt++]=i;          /*Хåֹ򥻥å*/
        } 
        RBUQdeleteNode(node);              /*ФΡɤκ*/

        /*popХåȤ鿷ɤߤRBtree*/
        for(i=0; i<bktCnt; i++){
          readRBUQkey(ud->iFile[bkt[i]],ud->fr[bkt[i]]);
          RBUQinsert(ud->rb->left,ud->fr[bkt[i]],bkt[i]);
        }
      }

      RBUQfree(ud->rb);                    /*塼γ*/
      for(i=0; i<=iTo-iFrom; i++){          /*ϥեΥ*/
        mssCloseFPR(ud->iFile[i]);
        mssFreeFldRec(ud->fr[i]);
      }
      mssCloseFPW(oFile);                     /*ϥեΥ*/
      if(iTo==iEnd)break;                  /*ǸΥХåȤޤǤнλ*/
      oEnd++;                              /*ϥեֹ楫ȥå*/
      k++;                                 /*ʻȥå*/
    }
    for(i=iStart; i<=iEnd; i++){
      unlink(getFname(ud->prefixTxt,i));      /*ϥեκ*/
    }
  }
}

/**
 * # FUNCTION #
 * פʤsortؿ
 * פʤֹڤ
 * MAXۤե˽񤭽Ф
 */
static void sortUQ( struct mssUnqDat *ud, struct mssFPR *fpr)
{

  struct mssFldRec *fr;    /*ϥե򥭡¤ٴ뤿ΥХåե*/
  int    pid;              /*ץID(ե̾ΰ)*/
  int    oNum;             /*եֹΥȥåѿ*/
  int    memCnt;           /**/

  struct RBUQnode *rb=NULL; /*ֹ*/
  struct mssFPW *fpw;      /*ϰե*/

  fr=mssInitFldRec(FldCnt);/*FldRecν*/
  rb=RBUQinit(rb);          /*RBUQtreeν*/

  /*ե̾Υץեå*/
  pid=getpid();
  if(strlen(ud->tmpDir) > MssFileNameMaxLen - 50 ) {
    mssShowErrMsg("length of path name must be less than %d",MssFileNameMaxLen-50);
    exit(mssErrorNoDefault);
  }
  sprintf(ud->prefixTxt,"%s/xt##%d-PreUnqTxt-",ud->tmpDir,pid);

  memCnt=0; /*ꥫ󥿤Υꥢ*/
  oNum=0;   /*ϥեֹ*/
  while(1){
    /*ǡɤ߹*/
    mssReadFldRec(fpr,fr);
    (*ud->inCnt)++;

    /*ֹڤΥMaxۤ ⤷ ǽԤ򸡽Ф*/
    /*եؽ񤭽Ф*/
    if( memCnt >= MaxMemU || fr->eof==1){
      fpw=mssOpenFPW(getFname(ud->prefixTxt,oNum),0,0);/*ϥե륪ץ*/
      RBUQwriteAllNode(rb->left, fpw);        /*RBtreeƽ*/
      mssCloseFPW(fpw);                          /*ϥեΥ*/
      oNum++;                                     /*ϥեcountUp*/
      RBUQfree(rb);   /*RBUQtreeΰ*/
      if(fr->eof==1){ /*ǽԤǽλ*/
        (*ud->inCnt)--;
        break;
      }
      rb=RBUQinit(rb);    /*RBUQtreeν*/
      memCnt=0;           /*ꥫ󥿤Υꥢ*/
    }

    /*ֹڤ(ʪŪ˥ԡ)򥫥ȥå*/
    memCnt += RBUQinsert(rb->left,fr,1);
  }
  mssFreeFldRec(fr);/*FldRecν*/

  ud->iStart = 0;
  ud->iEnd   = oNum-1;
}

/**
 * # FUNCTION #
 *ɬѤȤʤܴطΥХѿ
 *preUnqrbTreeUQȤΤĤʤΤѿƤ
 */
struct mssUnqDat *mssInitUnqDat(int fldCnt, MssOptKEY *optKey, char *tmpDir, int *inCnt)
{
  struct mssUnqDat *unqDat;
  unqDat=mssMalloc(sizeof(struct mssUnqDat),"initUnqDat");
    
  unqDat->fldCnt  = fldCnt;
  unqDat->optKey  = optKey;
  unqDat->tmpDir  = tmpDir;
  unqDat->inCnt   = inCnt;
    
  /*Хѿ*/
  FldCnt  = unqDat->fldCnt;
  OptKey  = unqDat->optKey;
  
  return(unqDat);
}

/**
 * # FUNCTION #
 * RB塼Ѥڤʬɤ߹
 * ¤ѤäƤХå(ud->iStartud->iEnd)
 * פʤʻ礷Ƥ
 * եθĿϴPWayUʲˤʤäƤ뤳Ȥ
 */
int mssReadWriteUnq(struct mssUnqDat *ud, struct mssFPW *oFile)
{
  struct RBUQnode *node;      /*popˤƼΡɤǼ*/
  int              bkt[PWayU];/*PwayʻRBtreepopǡΥХåNo*/
  int              bktCnt;    /*ΥХåȿ*/
  int i;

  node=RBUQpop(ud->rb->left);           /*塼ԼФ*/
  if(strcmp(node->key->str,readEnd)==0) /*readEnd(ʼ)Ф齪λ*/
    return(EOF);

  /*Խ񤭽Ф*/
  mssWriteFld(node->key->fld,FldCnt,"\n",oFile);

  bktCnt=0;                      /*popǼФkeyͤΥХåȿ*/
  for(i=0; i<PWayU; i++){
    if(*(node->key->bkt+i) == 1)
      bkt[bktCnt++]=i;           /*Хåȥե饰򥻥å*/
  } 
  RBUQdeleteNode(node);          /*ФΡɤκ*/

  /*popХåȤ鿷ɤߤRBtree*/
  for(i=0; i<bktCnt; i++){
    readRBUQkey(ud->iFile[bkt[i]],ud->fr[bkt[i]]);
    RBUQinsert(ud->rb->left,ud->fr[bkt[i]],bkt[i]);
  }
  return(1); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * mssUnqDat¤Τγ
 */
void mssFreeUnqDat(struct mssUnqDat *ud)
{
  int i;

  if(ud->procType==1){
    /*ХåեΤˡϥեϤǽƥ*/
    for(i=0; i<=ud->iEnd-ud->iStart; i++){
      mssCloseFPR(ud->iFile[i]);
      mssFreeFldRec(ud->fr[i]);
    }

    /*եκ*/
    for(i=ud->iStart; i<=ud->iEnd; i++){
      unlink(getFname(ud->prefixTxt,i));
    }

    /*ΰ賫*/
    RBUQfree(ud->rb);
  }
  mssFree(ud);
}

/**
 * # FUNCTION #
 * ֹڤʤ齸סܽפʤPWayޡ
 */
void mssPreUnq( struct mssUnqDat *ud, struct mssFPR *iFile)
{
  /*ʥϥɥ*/
  mssGV.usedTempFileFlg=1;
  mssSetSignalHandler();

  sortUQ(ud,iFile);
  mergeRBUQ(ud);
  setFirstLineRBUQ(ud, ud->iStart,ud->iEnd);
}
