/**
 * # CHAPTER #
 * ============================================================================
 * XMLϢΥإåե
 * ============================================================================
 */

#include <mssOutput.h>
#include <mssBase.h>
#include <libxml/parserInternals.h>

#ifndef __MSSXML_H
#define __MSSXML_H 1

/**
 * # STRUCT #
 * XMLι¤
 */
struct mssXmlTag {
  char *element;     /*̾*/
  char **attributes; /*°̾-°ͥꥹ*/
  int  attCnt;       /*°ο(ΤϤ)*/
};

/**
 * # PROTOTYPE # 
 */
char *			mssEncoding(char *str, iconv_t *icid);
char *			mssNencoding(char *str, int len, iconv_t *icid);
struct mssXmlTag *	mssInitXmlTag(char *element, iconv_t *icid);
struct mssXmlTag *	mssInitXmlTagByOpt(char *str, iconv_t *icid);
void			mssFreeXmlTag(struct mssXmlTag *xmlTag);
void			mssAddXmlTagAttributeStr(struct mssXmlTag *xmlTag, char *name, char *value, iconv_t *icid);
void			mssAddXmlTagAttributeInt(struct mssXmlTag *xmlTag, char *name, int value, iconv_t *icid);
void			mssAddXmlTagAttributeDbl(struct mssXmlTag *xmlTag, char *name, double value, iconv_t *icid);
struct mssXmlTag *	mssOpt2XmlTag(char *str, iconv_t *icid);
char *			mssXmlTag2emptyTag(struct mssXmlTag *xmlTag, iconv_t *icid);
char *			mssXmlTag2startTag(struct mssXmlTag *xmlTag, iconv_t *icid);
char *			mssXmlTag2endTag(struct mssXmlTag *xmlTag, iconv_t *icid);
void 			mssWriteXmlDeclaration( char *ver, char *enc, struct mssFPW *fp );
void			mssWriteXmlStartTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlEndTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlEmptyTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlContent(char *str, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlIndent(int cnt, struct mssFPW *fpw);
void			mssWriteXmlTagStr(int indCnt, char *elemet, char *content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagInt(int indCnt, char *elemet, int content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagDbl(int indCnt, char *elemet, double content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagFlg(int indCnt, char *elemet, int flg, int retFlg, iconv_t *icid, struct mssFPW *fp );

#endif /* _XML_H */

