#!/usr/bin/env bash

################################################################################
# RFM分析のテンプレートファイル
# ver 1.0 : 新規作成 2004/11/09 Y.Hamuro
################################################################################

# 顧客購買履歴データファイルを指定する(ワイルドカードの指定可)
export InDat="./dat.xt"

# 結果データを保存するディレクトリを指定する
export OutDatDir="./rfm_xt"

# HTMLによる結果データを保存するディレクトリを指定する
export OutHtmlDir="./rfm_html"

# InDat上の顧客ID項目名(もしくは顧客IDに相当する項目名)
export CustFldName="顧客"

# InDat上の日付項目名
export DateFldName="日付"

# InDatで利用するレコードの日付選択開始条件(SelPeriodFrom=""にて条件なし)
export SelPeriodFrom=""
#export SelPeriodFrom="20020101"

# InDatで利用するレコードの日付選択終了条件(SelPeriodTo=""にて条件なし)
export SelPeriodTo=""
#export SelPeriodTo="20020630"

# InDat上の金額項目名(Manetaryを計算する項目)
export MoneyFldName="金額"

# Recencyを計算するための基準日(Recency=基準日-最近来店日)
# latestを指定すればInDat上で観測されるもっとも新しい日付
# todayを指定すれば本日
export BaseDate="20021231"
#export BaseDate="latest"
#export BaseDate="today"

# Recencyをいくつのクラスに分割するか
export RecencyCnt="5"

# Frequencyをいくつのクラスに分割するか
export FreqCnt="5"

# Monetaryをいくつのクラスに分割するか
export MonetaryCnt="5"

# Recencyのクラス分割の基準(cnt:件数均等化, rng:範囲均等化, usr:ユーザ指定)
export BucketMethodR="rng"
#export BucketMethodR="rng"

# Frequencyのクラス分割の基準(cnt:件数均等化分割, rng:範囲均等化分割)
export BucketMethodF="usr"
#export BucketMethodF="rng"

# Monetaryのクラス分割の基準(cnt:件数均等化分割, rng:範囲均等化分割)
export BucketMethodM="cnt"
#export BucketMethodM="rng"
#export BucketMethodM="usr"

# BucketMethodR="usr"の時の範囲
export RangeR="
1 120 *
2 60 120
3 30 60
4 10 30
5 * 10
"

# BucketMethodF="usr"の時の範囲
export RangeF="
1 * 2
2 2 4
3 4 8
4 8 12
5 12 *
"

# BucketMethodM="usr"の時の範囲
export RangeM="
1 * 5000
2 5000 10000
3 10000 20000
4 20000 30000
5 30000 *
"
#途中経過の完了メッセージを出力するなら0、そうでなければ1を指定
export mssQuiet=0

#途中経過の完了メッセージを出力するなら0、そうでなければ1を指定
export TmpDir="/tmp"

#html文書のコメント(index.htmlのトップに表示される文書)
export HtmlComment="
<p>サンプルデータを利用しています。
<p>(人工的に生成した購買履歴データ)"

########
# 実行 #
########
# サンプルデータをXMLtableに変換(実際に利用する時は必要ない)
csv2xt -a 店,日付,時間,レシート,顧客,商品,大分類,中分類,小分類,細分類,メーカー,ブランド,仕入単価,単価,数量,金額,仕入金額,粗利金額 -i ./dat.csv -o ./dat.xt

mssRFM.sh

