#!/usr/bin/env bash

################################################################################
# xtrfm
# RFM
# 2.0 ViIo[WVK쐬 2004/11/09 Y.Hamuro
################################################################################

#===============================================================================
#wvbZ[W( -h^ꂽƂɕ\ )
#-------------------------------------------------------------------------------
# -h^ꂽƂɕ\B
# "cat >/dev/stderr <<EOR""EOF"̍s܂ł̃eLXĝ܂܉ʂɕ\
#===============================================================================
version="2.0"

function help {
cat >/dev/stderr <<EOF
---------------------
MUSASHI-SCENARIO
mssRFM.sh version 2.0
---------------------
Tv) RFM
ϐ) ȉ̊ϐݒ肵ɂ̃R}hNB
  InDat		ڋqwf[^t@Cw肷
  OutDatDir	ʃf[^ۑfBNgw肷
  OutHtmlDir	HTMLɂ錋ʃf[^ۑfBNgw肷
  CustFldName	InDaťڋqIDږ(͌ڋqIDɑ鍀ږ)
  DateFldName	InDat̓tږ
  SelPeriodFrom	InDatŗp郌R[h̓tIJn
  SelPeriodTo	InDatŗp郌R[h̓tII
  MoneyFldName	InDat̋zږ(MonetaryvZ鍀)
  DateFldName 	RecencyvZ邽߂̊(Recency=-ŋߗX)
		latestw肷InDatŊϑƂVt
		todayw肷Ζ{
  RecencyCnt	Recency̃NXɕ邩
  FreqCnt	Frequency̃NXɕ邩
  MonetaryCnt	Monetary̃NXɕ邩
  BucketMethodR	RecencỹNX(cnt:ϓ,rng:͈͋ϓ)
  BucketMethodF	FrequencỹNX(cnt:ϓ,rng:͈͋ϓ)
  BucketMethodM	MonetarỹNX(cnt:ϓ,rng:͈͋ϓ)
  RangeR	BucketMethodR="usr"̎̃[Uwɂ͈
  RangeF	BucketMethodF="usr"̎̃[Uwɂ͈
  RangeM	BucketMethodM="usr"̎̃[Uwɂ͈
  mssQuiet	ro߂̊bZ[Wo͂Ȃ0AłȂ1w
  TmpDir	ƃfBNg
  HtmlComment	index.html̃gbvɕ\Rg̓e
EOF
exit 1
}

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#R}hۑ
cmdName="$0"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#-------------------------------------------------------------------------------
# ϐ̃`FbN
#-------------------------------------------------------------------------------
if [ "$1" = "-h" ] ; then
  help
fi

function checkNull {
if eval [ -z \"\$$1\" ] ; then
  echo "#ERROR# $$" \"$0\" \""environment variable [$1] is mandatory"\" >/dev/stderr
  exit 1
fi
}

echo "#MSG# $$" "$cmdName" Checking Environment Variable >/dev/stderr

checkNull InDat
checkNull OutDatDir
checkNull CustFldName
checkNull DateFldName
checkNull MoneyFldName
checkNull DateFldName 
checkNull RecencyCnt
checkNull FreqCnt
checkNull RecencyCnt
checkNull BucketMethodR
checkNull BucketMethodF
checkNull BucketMethodM
checkNull TmpDir

if [ "$BucketMethodR" = "usr" ] ; then
  checkNull RangeR
fi
if [ "$BucketMethodF" = "usr" ] ; then
  checkNull RangeF
fi
if [ "$BucketMethodM" = "usr" ] ; then
  checkNull RangeM
fi

#-------------------------------------------------------------------------------
# eO
#-------------------------------------------------------------------------------
# [Nt@C̃vtBbNX̐ݒ
# $$̓vZXԍ
wf=$TmpDir/xtrfm-$$

# o͐fBNg쐬
mkdir -p $OutDatDir

#gbv
trap endByInt INT QUIT TERM HUP

#-------------------------------------------------------------------------------
# C
#-------------------------------------------------------------------------------
# 1. ̓f[^𕹍A
# 2. Kvȍ(ڋq,t,z)𔲂A
# 3. nulll܂ލs폜
# 4. f[^IA
# 5. ڋqʓʋzv߂B
echo "#MSG# $$" "$cmdName" Creating Basic Data for RFM analysis >/dev/stderr

if [ -z "$SelPeriodFrom" ]  && [ -z "$SelPeriodTo" ] ; then
  xtcat -i "$InDat" |
  xtdelnul -f $CustFldName,$DateFldName,$MoneyFldName |
  xtcut -f $CustFldName,$DateFldName,$MoneyFldName |
  xtagg -k $CustFldName,$DateFldName -f $MoneyFldName -c sum -o $wf-xxbase
else
  if [ -z "$SelPeriodFrom" ] ; then
    SelPeriodFrom="00000000"
  fi
  if [ -z "$SelPeriodTo" ] ; then
    SelPeriodTo="99999999"
  fi
  xtcat -i "$InDat" |
  xtdelnul -f $CustFldName,$DateFldName,$MoneyFldName |
  xtsel -c "\$$DateFldName>$SelPeriodFrom && \$$DateFldName<$SelPeriodTo" |
  xtcut -f $CustFldName,$DateFldName,$MoneyFldName |
  xtagg -k $CustFldName,$DateFldName -f $MoneyFldName -c sum -o $wf-xxbase
fi

#XpxNX߂
echo "#MSG# $$" "$cmdName" Calculating Frequency >/dev/stderr

xtcut -f $CustFldName -i $wf-xxbase |
xtcount -k $CustFldName -a Frequency -o $wf-xxf

if [ "$BucketMethodF" = "usr" ] ; then
  echo "$RangeF" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o  $wf-xxrngF
  xtnrjoin -N -v Frequency%n -m $wf-xxrngF -R rangeFrom,rangeTo -f bucketNo:Fclass -i $wf-xxf -o $wf-xxF
else
  xtbucket -n $FreqCnt -c $BucketMethodF -f Frequency:Fclass -i $wf-xxf -o $wf-xxF -O $wf-xxrngF
fi

#zNX߂
echo "#MSG# $$" "$cmdName" Calculating Monetary >/dev/stderr

xtcut -f $CustFldName,$MoneyFldName -i $wf-xxbase |
xtagg -k $CustFldName -f $MoneyFldName:Monetary -c sum -o $wf-xxm

if [ "$BucketMethodM" = "usr" ] ; then
  echo "$RangeM" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o $wf-xxrngM
  xtnrjoin -N -v Monetary%n -m $wf-xxrngM -R rangeFrom,rangeTo -f bucketNo:Mclass -i $wf-xxm -o $wf-xxM
else
  xtbucket -n $MonetaryCnt -c $BucketMethodM -f Monetary:Mclass -i $wf-xxm -o $wf-xxM -O $wf-xxrngM
fi

#RecencyNX߂
echo "#MSG# $$" "$cmdName" Calculating Recency >/dev/stderr

if [ "$BaseDate" = "today" ] ; then
  BaseDate=$(date +%Y%m%d)
fi
if [ "$BaseDate" = "latest" ] ; then
  BaseDate=$(xtcut -f $DateFldName -i $wf-xxbase | xtagg -f $DateFldName -c max | xt2txt)
fi

xtsetchr -v "$BaseDate" -a today -i $wf-xxbase |
xtcut -f $CustFldName,$DateFldName,today |
xtagg -k $CustFldName -f $DateFldName -c max |
xtcal -c 'day($today,$'$DateFldName')' -a Recency -o $wf-xxr

if [ "$BucketMethodR" = "usr" ] ; then
  echo "$RangeR" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o $wf-xxrngR
  xtnrjoin -N -v Recency%n -m $wf-xxrngR -R rangeFrom,rangeTo -f bucketNo:Rclass -i $wf-xxr -o $wf-xxR
else
  xtbucket -r -n $RecencyCnt -c $BucketMethodR -f Recency:Rclass -i $wf-xxr -o $wf-xxR -O $wf-xxrngR
fi

echo "#MSG# $$" "$cmdName" Output Final Results >/dev/stderr
#O̃t@C
xtjoin -nN -k $CustFldName -m $wf-xxF -f Frequency,Fclass -i $wf-xxR |
xtjoin -nN -k $CustFldName -m $wf-xxM -f Monetary,Mclass |
xtnulto -f Rclass,Fclass,Mclass -v 0 |
xtcut -f $CustFldName,Recency,Frequency,Monetary,Rclass,Fclass,Mclass -o $OutDatDir/dat.xt

#NXʌ\\̍쐬
xtcut -f Rclass,Fclass,Mclass -i $OutDatDir/dat.xt |
xtcount -k Rclass,Fclass,Mclass -a l -o $OutDatDir/RFMcnt.xt

#Recency͈͕\\̍쐬
xtcut -f Rclass,l -i $OutDatDir/RFMcnt.xt |
xtagg -k Rclass -f l -c sum |
xtjoin -k Rclass -m $wf-xxrngR -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Rclass,rangeFrom:Jn͈,rangeTo:I͈,l -o $OutDatDir/RecencyRng.xt


#Frequency͈͕\\̍쐬
xtcut -f Fclass,l -i $OutDatDir/RFMcnt.xt |
xtagg -k Fclass -f l -c sum |
xtjoin -k Fclass -m $wf-xxrngF -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Fclass,rangeFrom:Jn͈,rangeTo:I͈,l -o $OutDatDir/FrequencyRng.xt

#Monetary͈͕\\̍쐬
xtcut -f Mclass,l -i $OutDatDir/RFMcnt.xt |
xtagg -k Mclass -f l -c sum |
xtjoin -k Mclass -m $wf-xxrngM -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Mclass,rangeFrom:Jn͈,rangeTo:I͈,l -o $OutDatDir/MonetaryRng.xt

#====================
# HTMLt@C
#====================
if eval [ ! -z "$OutHtmlDir" ] ; then

echo "#MSG# $$" "$cmdName" Creating HTML documents >/dev/stderr

# o͐fBNg쐬
mkdir -p $OutHtmlDir

# ef[^CSVɕϊ
xt2csv -F -i $OutDatDir/dat.xt -o $OutHtmlDir/dat.csv

xt2csv -F -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/RFMcnt.csv

xt2csv -F -i $OutDatDir/RecencyRng.xt -o $OutHtmlDir/RecencyRng.csv
xt2html -k Rclass -R Jn͈,I͈,l -i $OutDatDir/RecencyRng.xt -o $OutHtmlDir/RecencyRng.html

xt2csv -F -i $OutDatDir/FrequencyRng.xt -o $OutHtmlDir/FrequencyRng.csv
xt2html -k Fclass -R Jn͈,I͈,l -i $OutDatDir/FrequencyRng.xt -o $OutHtmlDir/FrequencyRng.html

xt2csv -F -i $OutDatDir/MonetaryRng.xt -o $OutHtmlDir/MonetaryRng.csv
xt2html -k Mclass -R Jn͈,I͈,l -i $OutDatDir/MonetaryRng.xt -o $OutHtmlDir/MonetaryRng.html

# RFMʐlzOt
xtbar -k Rclass%n -r Fclass%n -c Mclass%n -f l -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/FMRbar.svg --title 'FMʂɌRecency̐lz' --fix
xtbar -k Fclass%n -r Mclass%n -c Rclass%n -f l -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/MRFbar.svg --title 'MRʂɌFrequency̐lz' --fix
xtbar -k Mclass%n -r Rclass%n -c Fclass%n -f l -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/RFMbar.svg --title 'RFʂɌMonetary̐lz' --fix

# R,F,MʐlzOt
xtagg -k Rclass,Fclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Rclass%n -c Fclass%n -f l -o $OutHtmlDir/FRbar.svg --title 'FʂɌRecency̐lz' -H 400 --fix
xtagg -k Rclass,Mclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Rclass%n -c Mclass%n -f l -o $OutHtmlDir/MRbar.svg --title 'MʂɌRecency̐lz' -H 400 --fix
xtagg -k Fclass,Mclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Fclass%n -c Mclass%n -f l -o $OutHtmlDir/MFbar.svg --title 'MʂɌFrequency̐lz' -H 400 --fix
xtagg -k Fclass,Rclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Fclass%n -c Rclass%n -f l -o $OutHtmlDir/RFbar.svg --title 'RʂɌFrequency̐lz' -H 400 --fix
xtagg -k Mclass,Rclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Mclass%n -c Rclass%n -f l -o $OutHtmlDir/RMbar.svg --title 'RʂɌMonetary̐lz' -H 400 --fix
xtagg -k Mclass,Fclass -f l -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Mclass%n -c Fclass%n -f l -o $OutHtmlDir/FMbar.svg --title 'FʂɌMonetary̐lz' -H 400 --fix

# R,F,M̕zOt쐬

# ڋql
CustCnt=`xtcut -f $CustFldName -i $OutDatDir/dat.xt |
xtcount -a ڋql |
xtcut -f ڋql |
xt2txt`

# 쐬t
update=`date`

# index.html
cat >$OutHtmlDir/index.html <<EOF
<html>
<H1>RFM͌</H1>
<p>쐬:${update} (version:$version)
<HR>
${HtmlComment}
<HR>
<H2>{f[^</H2>
<p>
ڋql:<B>${CustCnt}</B>l
<p>RFMNX:<BR>
&nbsp;&nbsp;Recency:<B>${RecencyCnt}</B><BR>
&nbsp;&nbsp;Frequency:<B>${FreqCnt}</B><BR>
&nbsp;&nbsp;Monetary:<B>${MonetaryCnt}</B><BR>

<p>RFMNX:(cnt:ϓ, rng:͈͋ϓ, usr:[Uw)<BR>
&nbsp;&nbsp;Recency:<B>${BucketMethodR}</B><BR>
&nbsp;&nbsp;Frequency:<B>${BucketMethodF}</B><BR>
&nbsp;&nbsp;Monetary:<B>${BucketMethodM}</B><BR>

<H2>RFMNX͈͕\</H2>
&nbsp;&nbsp;<a href="./RecencyRng.html">RecencyNX͈͕̔\</a>(<a href="./RecencyRng.csv">CVS`</a>)<BR>
&nbsp;&nbsp;<a href="./FrequencyRng.html">FrequencyNX͈͕̔\</a>(<a href="./FrequencyRng.csv">CVS`</a>)<BR>
&nbsp;&nbsp;<a href="./MonetaryRng.html">MonetaryNX͈͕̔\</a>(<a href="./MonetaryRng.csv">CVS`</a>)
<p><a href="./dat.csv">ڋqRFMNX\(CSV`)</a>
<H2>RFM̐lz</H2>
<table CELLPADDING=3 BORDER=2>
<TR ALIGN="center">
<TH BGCOLOR="#00FFFF">Recency</TH>
<TH BGCOLOR="#00FFFF">Frequency</TH>
<TH BGCOLOR="#00FFFF">Monetary</TH>
</TR>
<TR ALIGN="center">
<TD><a href="./FMRbar.svg">FM</a></TD>
<TD><a href="./MRFbar.svg">MR</a></TD>
<TD><a href="./RFMbar.svg">RF</a></TD>
</TR>
<TR ALIGN="center">
<TD><a href="./FRbar.svg">F</a><BR><a href="./MRbar.svg">M</a></TD>
<TD><a href="./MFbar.svg">M</a><BR><a href="./RFbar.svg">R</a></TD>
<TD><a href="./RMbar.svg">R</a><BR><a href="./FMbar.svg">F</a></TD>
</TR>
</table>
<p><a href="./RFMcnt.csv">RFMlz\(CSV`)</a>
</html>
EOF

fi

#-------------------------------------------------------------------------------
# ㏈
#-------------------------------------------------------------------------------
# [Nt@C̍폜
rm $wf-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================

