#!/usr/bin/env bash

################################################################################
# xtrfm
# RFMʬ
# 2.0 ʥꥪС󿷵 2004/11/09 Y.Hamuro
################################################################################

#===============================================================================
#إץå( -hͿ줿Ȥɽ )
#-------------------------------------------------------------------------------
# -hͿ줿Ȥɽ롣
# "cat >/dev/stderr <<EOR""EOF"ιԤޤǤΥƥȤΤޤ޲̤ɽ
#===============================================================================
version="2.0"

function help {
cat >/dev/stderr <<EOF
---------------------
MUSASHI-SCENARIO
mssRFM.sh version 2.0
---------------------
) RFMʬ
Ķѿ) ʲδĶѿꤷˤΥޥɤư롣
  InDat		ܵҹǡեꤹ
  OutDatDir	̥ǡ¸ǥ쥯ȥꤹ
  OutHtmlDir	HTMLˤ̥ǡ¸ǥ쥯ȥꤹ
  CustFldName	InDatθܵID̾(⤷ϸܵID̾)
  DateFldName	InDatչ̾
  SelPeriodFrom	InDatѤ쥳ɤ򳫻Ͼ
  SelPeriodTo	InDatѤ쥳ɤλ
  MoneyFldName	InDatζ۹̾(Monetary׻)
  DateFldName 	Recency׻뤿δ(Recency=-ǶŹ)
		latestꤹInDatǴ¬äȤ⿷
		todayꤹ
  RecencyCnt	Recency򤤤ĤΥ饹ʬ䤹뤫
  FreqCnt	Frequency򤤤ĤΥ饹ʬ䤹뤫
  MonetaryCnt	Monetary򤤤ĤΥ饹ʬ䤹뤫
  BucketMethodR	RecencyΥ饹ʬ(cnt:ʬ,rng:ϰ϶ʬ)
  BucketMethodF	FrequencyΥ饹ʬ(cnt:ʬ,rng:ϰ϶ʬ)
  BucketMethodM	MonetaryΥ饹ʬ(cnt:ʬ,rng:ϰ϶ʬ)
  RangeR	BucketMethodR="usr"λΥ桼ˤϰ
  RangeF	BucketMethodF="usr"λΥ桼ˤϰ
  RangeM	BucketMethodM="usr"λΥ桼ˤϰ
  mssQuiet	вδλåϤʤ0Ǥʤ1
  TmpDir	ȥǥ쥯ȥ
  HtmlComment	index.htmlΥȥåפɽ륳Ȥ
EOF
exit 1
}

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ޥ̾¸
cmdName="$0"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#-------------------------------------------------------------------------------
# ĶѿΥå
#-------------------------------------------------------------------------------
if [ "$1" = "-h" ] ; then
  help
fi

function checkNull {
if eval [ -z \"\$$1\" ] ; then
  echo "#ERROR# $$" \"$0\" \""environment variable [$1] is mandatory"\" >/dev/stderr
  exit 1
fi
}

echo "#MSG# $$" "$cmdName" Checking Environment Variable >/dev/stderr

checkNull InDat
checkNull OutDatDir
checkNull CustFldName
checkNull DateFldName
checkNull MoneyFldName
checkNull DateFldName 
checkNull RecencyCnt
checkNull FreqCnt
checkNull RecencyCnt
checkNull BucketMethodR
checkNull BucketMethodF
checkNull BucketMethodM
checkNull TmpDir

if [ "$BucketMethodR" = "usr" ] ; then
  checkNull RangeR
fi
if [ "$BucketMethodF" = "usr" ] ; then
  checkNull RangeF
fi
if [ "$BucketMethodM" = "usr" ] ; then
  checkNull RangeM
fi

#-------------------------------------------------------------------------------
# Ƽ
#-------------------------------------------------------------------------------
# եΥץեå
# $$ϥץֹ
wf=$TmpDir/xtrfm-$$

# ǥ쥯ȥ
mkdir -p $OutDatDir

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#-------------------------------------------------------------------------------
# ᥤ
#-------------------------------------------------------------------------------
# 1. ϥǡʻ礷
# 2. ɬפʹ(ܵ,,)ȴ
# 3. nullͤޤԤ
# 4. ǡ򤷡
# 5. ̶ܵ۹פ롣
echo "#MSG# $$" "$cmdName" Creating Basic Data for RFM analysis >/dev/stderr

if [ -z "$SelPeriodFrom" ]  && [ -z "$SelPeriodTo" ] ; then
  xtcat -i "$InDat" |
  xtdelnul -f $CustFldName,$DateFldName,$MoneyFldName |
  xtcut -f $CustFldName,$DateFldName,$MoneyFldName |
  xtagg -k $CustFldName,$DateFldName -f $MoneyFldName -c sum -o $wf-xxbase
else
  if [ -z "$SelPeriodFrom" ] ; then
    SelPeriodFrom="00000000"
  fi
  if [ -z "$SelPeriodTo" ] ; then
    SelPeriodTo="99999999"
  fi
  xtcat -i "$InDat" |
  xtdelnul -f $CustFldName,$DateFldName,$MoneyFldName |
  xtsel -c "\$$DateFldName>$SelPeriodFrom && \$$DateFldName<$SelPeriodTo" |
  xtcut -f $CustFldName,$DateFldName,$MoneyFldName |
  xtagg -k $CustFldName,$DateFldName -f $MoneyFldName -c sum -o $wf-xxbase
fi

#Ź٥饹
echo "#MSG# $$" "$cmdName" Calculating Frequency >/dev/stderr

xtcut -f $CustFldName -i $wf-xxbase |
xtcount -k $CustFldName -a Frequency -o $wf-xxf

if [ "$BucketMethodF" = "usr" ] ; then
  echo "$RangeF" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o  $wf-xxrngF
  xtnrjoin -N -v Frequency%n -m $wf-xxrngF -R rangeFrom,rangeTo -f bucketNo:Fclass -i $wf-xxf -o $wf-xxF
else
  xtbucket -n $FreqCnt -c $BucketMethodF -f Frequency:Fclass -i $wf-xxf -o $wf-xxF -O $wf-xxrngF
fi

#ۥ饹
echo "#MSG# $$" "$cmdName" Calculating Monetary >/dev/stderr

xtcut -f $CustFldName,$MoneyFldName -i $wf-xxbase |
xtagg -k $CustFldName -f $MoneyFldName:Monetary -c sum -o $wf-xxm

if [ "$BucketMethodM" = "usr" ] ; then
  echo "$RangeM" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o $wf-xxrngM
  xtnrjoin -N -v Monetary%n -m $wf-xxrngM -R rangeFrom,rangeTo -f bucketNo:Mclass -i $wf-xxm -o $wf-xxM
else
  xtbucket -n $MonetaryCnt -c $BucketMethodM -f Monetary:Mclass -i $wf-xxm -o $wf-xxM -O $wf-xxrngM
fi

#Recency饹
echo "#MSG# $$" "$cmdName" Calculating Recency >/dev/stderr

if [ "$BaseDate" = "today" ] ; then
  BaseDate=$(date +%Y%m%d)
fi
if [ "$BaseDate" = "latest" ] ; then
  BaseDate=$(xtcut -f $DateFldName -i $wf-xxbase | xtagg -f $DateFldName -c max | xt2txt)
fi

xtsetchr -v "$BaseDate" -a today -i $wf-xxbase |
xtcut -f $CustFldName,$DateFldName,today |
xtagg -k $CustFldName -f $DateFldName -c max |
xtcal -c 'day($today,$'$DateFldName')' -a Recency -o $wf-xxr

if [ "$BucketMethodR" = "usr" ] ; then
  echo "$RangeR" | grep -v '^$' |
  txt2xt -a bucketNo,rangeFrom,rangeTo -o $wf-xxrngR
  xtnrjoin -N -v Recency%n -m $wf-xxrngR -R rangeFrom,rangeTo -f bucketNo:Rclass -i $wf-xxr -o $wf-xxR
else
  xtbucket -r -n $RecencyCnt -c $BucketMethodR -f Recency:Rclass -i $wf-xxr -o $wf-xxR -O $wf-xxrngR
fi

echo "#MSG# $$" "$cmdName" Output Final Results >/dev/stderr
#ĤΥե
xtjoin -nN -k $CustFldName -m $wf-xxF -f Frequency,Fclass -i $wf-xxR |
xtjoin -nN -k $CustFldName -m $wf-xxM -f Monetary,Mclass |
xtnulto -f Rclass,Fclass,Mclass -v 0 |
xtcut -f $CustFldName,Recency,Frequency,Monetary,Rclass,Fclass,Mclass -o $OutDatDir/dat.xt

#饹̷ɽκ
xtcut -f Rclass,Fclass,Mclass -i $OutDatDir/dat.xt |
xtcount -k Rclass,Fclass,Mclass -a Ϳ -o $OutDatDir/RFMcnt.xt

#Recencyϰɽκ
xtcut -f Rclass,Ϳ -i $OutDatDir/RFMcnt.xt |
xtagg -k Rclass -f Ϳ -c sum |
xtjoin -k Rclass -m $wf-xxrngR -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Rclass,rangeFrom:ϰ,rangeTo:λϰ,Ϳ -o $OutDatDir/RecencyRng.xt


#Frequencyϰɽκ
xtcut -f Fclass,Ϳ -i $OutDatDir/RFMcnt.xt |
xtagg -k Fclass -f Ϳ -c sum |
xtjoin -k Fclass -m $wf-xxrngF -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Fclass,rangeFrom:ϰ,rangeTo:λϰ,Ϳ -o $OutDatDir/FrequencyRng.xt

#Monetaryϰɽκ
xtcut -f Mclass,Ϳ -i $OutDatDir/RFMcnt.xt |
xtagg -k Mclass -f Ϳ -c sum |
xtjoin -k Mclass -m $wf-xxrngM -K bucketNo -f rangeFrom,rangeTo |
xtcut -f Mclass,rangeFrom:ϰ,rangeTo:λϰ,Ϳ -o $OutDatDir/MonetaryRng.xt

#====================
# HTMLե
#====================
if eval [ ! -z "$OutHtmlDir" ] ; then

echo "#MSG# $$" "$cmdName" Creating HTML documents >/dev/stderr

# ǥ쥯ȥ
mkdir -p $OutHtmlDir

# ƼǡCSVѴ
xt2csv -F -i $OutDatDir/dat.xt -o $OutHtmlDir/dat.csv

xt2csv -F -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/RFMcnt.csv

xt2csv -F -i $OutDatDir/RecencyRng.xt -o $OutHtmlDir/RecencyRng.csv
xt2html -k Rclass -R ϰ,λϰ,Ϳ -i $OutDatDir/RecencyRng.xt -o $OutHtmlDir/RecencyRng.html

xt2csv -F -i $OutDatDir/FrequencyRng.xt -o $OutHtmlDir/FrequencyRng.csv
xt2html -k Fclass -R ϰ,λϰ,Ϳ -i $OutDatDir/FrequencyRng.xt -o $OutHtmlDir/FrequencyRng.html

xt2csv -F -i $OutDatDir/MonetaryRng.xt -o $OutHtmlDir/MonetaryRng.csv
xt2html -k Mclass -R ϰ,λϰ,Ϳ -i $OutDatDir/MonetaryRng.xt -o $OutHtmlDir/MonetaryRng.html

# RFM̿Ϳʬۥ
xtbar -k Rclass%n -r Fclass%n -c Mclass%n -f Ϳ -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/FMRbar.svg --title 'FM̤˸RecencyοͿʬ' --fix
xtbar -k Fclass%n -r Mclass%n -c Rclass%n -f Ϳ -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/MRFbar.svg --title 'MR̤˸FrequencyοͿʬ' --fix
xtbar -k Mclass%n -r Rclass%n -c Fclass%n -f Ϳ -i $OutDatDir/RFMcnt.xt -o $OutHtmlDir/RFMbar.svg --title 'RF̤˸MonetaryοͿʬ' --fix

# R,F,M̿Ϳʬۥ
xtagg -k Rclass,Fclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Rclass%n -c Fclass%n -f Ϳ -o $OutHtmlDir/FRbar.svg --title 'F̤˸RecencyοͿʬ' -H 400 --fix
xtagg -k Rclass,Mclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Rclass%n -c Mclass%n -f Ϳ -o $OutHtmlDir/MRbar.svg --title 'M̤˸RecencyοͿʬ' -H 400 --fix
xtagg -k Fclass,Mclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Fclass%n -c Mclass%n -f Ϳ -o $OutHtmlDir/MFbar.svg --title 'M̤˸FrequencyοͿʬ' -H 400 --fix
xtagg -k Fclass,Rclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Fclass%n -c Rclass%n -f Ϳ -o $OutHtmlDir/RFbar.svg --title 'R̤˸FrequencyοͿʬ' -H 400 --fix
xtagg -k Mclass,Rclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Mclass%n -c Rclass%n -f Ϳ -o $OutHtmlDir/RMbar.svg --title 'R̤˸MonetaryοͿʬ' -H 400 --fix
xtagg -k Mclass,Fclass -f Ϳ -c sum -i $OutDatDir/RFMcnt.xt |
xtbar -k Mclass%n -c Fclass%n -f Ϳ -o $OutHtmlDir/FMbar.svg --title 'F̤˸MonetaryοͿʬ' -H 400 --fix

# R,F,Mʬۥպ

# ܵҿͿ
CustCnt=`xtcut -f $CustFldName -i $OutDatDir/dat.xt |
xtcount -a ܵҿͿ |
xtcut -f ܵҿͿ |
xt2txt`

# 
update=`date`

# index.html
cat >$OutHtmlDir/index.html <<EOF
<html>
<H1>RFMʬϷ</H1>
<p>:${update} (version:$version)
<HR>
${HtmlComment}
<HR>
<H2>ܥǡ</H2>
<p>
ܵҿͿ:<B>${CustCnt}</B>
<p>RFM饹ʬ:<BR>
&nbsp;&nbsp;Recency:<B>${RecencyCnt}</B><BR>
&nbsp;&nbsp;Frequency:<B>${FreqCnt}</B><BR>
&nbsp;&nbsp;Monetary:<B>${MonetaryCnt}</B><BR>

<p>RFM饹ʬ:(cnt:, rng:ϰ϶, usr:桼)<BR>
&nbsp;&nbsp;Recency:<B>${BucketMethodR}</B><BR>
&nbsp;&nbsp;Frequency:<B>${BucketMethodF}</B><BR>
&nbsp;&nbsp;Monetary:<B>${BucketMethodM}</B><BR>

<H2>RFM饹ϰɽ</H2>
&nbsp;&nbsp;<a href="./RecencyRng.html">Recency饹ϰɽ</a>(<a href="./RecencyRng.csv">CVS</a>)<BR>
&nbsp;&nbsp;<a href="./FrequencyRng.html">Frequency饹ϰɽ</a>(<a href="./FrequencyRng.csv">CVS</a>)<BR>
&nbsp;&nbsp;<a href="./MonetaryRng.html">Monetary饹ϰɽ</a>(<a href="./MonetaryRng.csv">CVS</a>)
<p><a href="./dat.csv">ܵRFM饹ɽ(CSV)</a>
<H2>RFMοͿʬ</H2>
<table CELLPADDING=3 BORDER=2>
<TR ALIGN="center">
<TH BGCOLOR="#00FFFF">Recency</TH>
<TH BGCOLOR="#00FFFF">Frequency</TH>
<TH BGCOLOR="#00FFFF">Monetary</TH>
</TR>
<TR ALIGN="center">
<TD><a href="./FMRbar.svg">FM</a></TD>
<TD><a href="./MRFbar.svg">MR</a></TD>
<TD><a href="./RFMbar.svg">RF</a></TD>
</TR>
<TR ALIGN="center">
<TD><a href="./FRbar.svg">F</a><BR><a href="./MRbar.svg">M</a></TD>
<TD><a href="./MFbar.svg">M</a><BR><a href="./RFbar.svg">R</a></TD>
<TD><a href="./RMbar.svg">R</a><BR><a href="./FMbar.svg">F</a></TD>
</TR>
</table>
<p><a href="./RFMcnt.csv">RFMͿʬɽ(CSV)</a>
</html>
EOF

fi

#-------------------------------------------------------------------------------
# 
#-------------------------------------------------------------------------------
# եκ
rm $wf-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================

