#!/usr/bin/env bash
#-------------------------------------------------------------------------------
# Installing MUSASHI module
#-------------------------------------------------------------------------------

# Choose Japanese encoding you like to install and remove the comment character.
enc=ja-euc
#enc=ja-sjis
#enc=ja-utf8

# Chage path name that MUSASHI modules will be installed if nesessary.
tmppath=./sample

if [ ! -d "$enc" ] ; then
  echo '## invalid "enc" variable ##'
  exit
fi


# install
function sub {
echo $1
  echo "cp -p ./$enc/$1 $tmppath"
  cp -p ./$enc/$1 $tmppath
  chmod 755 $tmppath/$1
}

for fname in `ls ./$enc/*.sh | grep tmp` ; do
echo $fname
  f=${fname##*/}
  sub $f
done

# end message
echo "completed."

