/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤŪʴؿ
 * 20040129 mktimeؿΥޥʡbug fix
 *          tmpѥͭĶѿѹǤ褦
 * 20040420 AllocInfϢؿľ(reallocбط)
 * 20040428 mssPRand()ݥʬɲ
 * 20040609 mssSort() ȴؿɲ
 * 20041004 mssGV.argvargv[]mssStrdup褦ѹ
 * ============================================================================
 */

#include <musashi/mssBase.h>
#include <musashi/mssConfig.h>
#include <musashi/mssOutput.h>
#include <musashi/random.h>
#include <musashi/qs5.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <dirent.h>
#include <signal.h>
#include <float.h>
#include <limits.h>
#include <math.h>

/* ############ Хѿ ##############*/
struct mssGlobalVariables mssGV;

extern double (*_func[_M])(void);
extern void (*initRND[_M])(long s);

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ʥå
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ۾ｪλΰե
 */
static void delTmpFile()
{
  DIR *dp;
  struct dirent *dir;
  int len;
  char prefix[MssFileNameMaxLen];
  char fname[MssFileNameMaxLen];

  sprintf(prefix,"xt##%d-",(int)getpid());

  len=strlen(prefix);

  if((dp = opendir(mssGV.tmpPath)) == NULL) {
    mssShowErrMsg("can't open directory %s\n", mssGV.tmpPath);
    mssEnd(mssErrorNoDefault);
  }
  while ((dir = readdir(dp)) != NULL) {
    if (dir->d_ino == 0) continue; /*removedեΥå*/
    if(0==strncmp(dir->d_name,prefix,len)){
      /*fprintf(stderr,"%s\n", dir->d_name);*/
      strcpy(fname,mssGV.tmpPath);
      strcat(fname,"/");
      strcat(fname,dir->d_name);
      unlink(fname);
    }
  }
  closedir(dp);
}
 
/**
 * # FUNCTION #
 * ʥˤ륨顼λ
 */
static void sigErrEnd(int sig)
{
  if(sig==2){
    mssShowErrMsg("interrupt by user (CTR^C)");
  }else{
    mssShowErrMsg("end by signal (%d)",sig);
  }
  mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * ʥˤｪλ
 */
static void sigEnd(int sig)
{
  mssShowEndMsg();
  mssEnd(mssExitSuccess);
}

/**
 * # FUNCTION #
 *ʥ­Ͽ(եѤ)
 */
void mssSetSignalHandler()
{
  signal( SIGSEGV, (void (*)())sigErrEnd );
  signal( SIGPIPE, (void (*)())sigEnd );
  signal( SIGKILL, (void (*)())sigErrEnd );
  signal( SIGINT , (void (*)())sigErrEnd );
}

/**
 * # FUNCTION #
 * åФɤȽ
 * ޥɥ饤 -Q ꤷQuiet⡼
 * Ķѿ mssQuiet ͤ1ʤQuiet⡼
 * ¾ξ NoQuiet⡼
 * externѿQuietsetOptionǥåȤ
 * : 1:Quiet⡼, 0:NoQuiet⡼
 */
static int isQuiet()
{
  char *envVal;

  if(mssGV.quiet) return 1;
  envVal=getenv("mssQuiet");
  if(envVal==NULL) return 0;
  if(*envVal=='1') return 1;
  return 0;
}

/**
 * # FUNCTION #
 * Хѿ(mssGV¤)ΥåȤӥʥ­Ͽ
 * ̾ޥɤκǽ˸ƤӽФؿ
 */
void mssInit(int argc, char **argv, struct mssComHelp *comHelp)
{

  char *envStr;
  int sigDigits;
  int i;
  char buf[30];

  /*Хѿν*/
  mssGV.comHelp=comHelp;
  mssGV.inCnt=0;
  mssGV.outCnt=0;
  mssGV.keyNo=0;
  mssGV.keyCnt=0;
  mssGV.keyLine=0;
  mssGV.inFldCnt=0;
  mssGV.quiet=0;
  mssGV.argc=argc;
  mssGV.argv=mssMalloc(sizeof(char *)*argc,"mssInit");
  for(i=0; i<argc; i++){
    *(mssGV.argv+i)=mssStrdup(*(argv+i));
  }
  mssGV.txtFlg=0;
  mssGV.allocDeb=0;
/*  mssGV.allocInf=NULL;*/
  mssGV.allocFreeCnt=0;
  mssGV.allocCnt=0;
  mssGV.writeHeaderFlg=0;
  mssGV.writeFooterFlg=0;
  mssGV.usedTempFileFlg=0;

  if( (envStr=getenv("MssTmpPath")) != NULL ){
    mssGV.tmpPath=mssMalloc(sizeof(char)*(strlen(envStr)+1),"mssInit");
    strcpy(mssGV.tmpPath, envStr);
  }else{
    mssGV.tmpPath=MssTempDir;
  }

  if( (envStr=getenv("MssSigDigits")) != NULL ){
    sigDigits=atoi(envStr);
  }else{
    sigDigits=MssSigDigits;
  }
  /* sprintf(mssGV.sigDigitsForm,"%%.%dg",sigDigits); */
  sprintf(buf,"%%.%dg",sigDigits);
  mssGV.sigDigitsForm=mssStrdup(buf);

  /*ʥϿ*/
  mssSetSignalHandler();
}

/**
 * # FUNCTION #
 * λ˸ƤӽФؿ
 */
void mssEnd(int status)
{
  int i;

  if(mssGV.usedTempFileFlg) delTmpFile();
  signal( SIGSEGV, SIG_IGN );
  signal( SIGPIPE, SIG_IGN );
  signal( SIGKILL, SIG_IGN );
  signal( SIGINT , SIG_IGN );

  for(i=0; i<mssGV.argc; i++){
    mssFree(*(mssGV.argv+i));
  }
  mssFree(mssGV.argv);
  mssFree(mssGV.sigDigitsForm); /* ɲ 2004/10/31 */
  exit(status);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ΰݡϢ
 * ----------------------------------------------------------------------------
 */

/**
 * # DOCUMENT #
 * ΰݡ˴ؤǥХåġλȤ 
 * 1:  "extern struct MssGlobalVariable mssGV;"롣
 * 2: ΰݤȳбطĴ٤֥å
 *    "mssGV.allocDeb=1;"Ȥ롣
 *    ʹߤmssMallocmssFreeθƤӽФƤmssGV.allocInf¤Τ
 *    Ͽ뤳Ȥˤʤ롣
 * 3: ֥åθmssGV.allocDeb=0ᤷϿ򤽤ޤǤȤ롣
 * 4:θmssShowAllocInf()ƤӽФСɤmssMallocɤmssFreeǳ
 * бطꥹȤϤ롣ϤɽΣܤ-1Ǥ
 * бطդʤä(魯)̣롣
 */

/**
 * # FUNCTION #
 * ΰݡξ򥰥Хѿɲä
 */
static void addAllocInf(int func, void *add, int size,char *msg)
{
  int i;

  if(func==0) mssGV.allocFreeCnt--;
  else        mssGV.allocFreeCnt++;

  mssGV.allocInf[mssGV.allocCnt].func=func;
  mssGV.allocInf[mssGV.allocCnt].add =add;
  mssGV.allocInf[mssGV.allocCnt].cnt =mssGV.allocFreeCnt;
  mssGV.allocInf[mssGV.allocCnt].size =size;
  mssGV.allocInf[mssGV.allocCnt].refNo=-1;
  strcpy(mssGV.allocInf[mssGV.allocCnt].msg,msg);

  if(func==0){
    for(i=mssGV.allocCnt; i>=0; i--){
      if( mssGV.allocInf[i].func!=0 && mssGV.allocInf[i].refNo==-1 ){
        if( mssGV.allocInf[i].add==mssGV.allocInf[mssGV.allocCnt].add ){
          mssGV.allocInf[i].refNo=mssGV.allocCnt;
          mssGV.allocInf[mssGV.allocCnt].refNo=i;
          break;
        }
      }
    }
  }

  mssGV.allocCnt++;
}

/**
 * # FUNCTION #
 * mssReallocǥΰ褬ݤ줿Υɥ쥹򸫤ƹ
 */
static void updAllocInf(int func, void *newAdd, void *oldAdd, int size, char *msg){
  int i;
  char buf[256];

  if(newAdd==oldAdd){
/*
    sprintf(buf,"%s--same(%p,%p)",msg,newAdd,oldAdd);
    addAllocInf(func, 0, 0, buf);
*/
    return;
  }

  if(oldAdd==NULL){
    sprintf(buf,"%s--new",msg);
    addAllocInf(func, newAdd, size, buf);
    return;
  }

  for(i=mssGV.allocCnt-1; i>0; i--){
    if( mssGV.allocInf[i].add==oldAdd && mssGV.allocInf[i].func!=0
                                      && mssGV.allocInf[i].refNo==-1 ){
      if(mssGV.allocInf[i].func!=func){
        sprintf(buf,"%s--mismatched (%p,%p:%s)",mssGV.allocInf[i].msg,newAdd,oldAdd,msg);
        strcpy(mssGV.allocInf[i].msg,buf);
      }
      mssGV.allocInf[i].func=func;
      mssGV.allocInf[i].add =newAdd;
      /*addAllocInf(func, 0, 0, msg);*/
      return;
    }
  }
  sprintf(buf,"%s--unmatched (%p,%p)",msg,newAdd,oldAdd);
  addAllocInf(func, newAdd, size, buf);
}

/**
 * # FUNCTION #
 * ΰݡξ򥰥Хѿɲä
 */
void mssAddAllocLabel(char *msg)
{
  if(mssGV.allocDeb){
    mssGV.allocInf[mssGV.allocCnt].func=6;
    mssGV.allocInf[mssGV.allocCnt].add =NULL;
    mssGV.allocInf[mssGV.allocCnt].cnt =0;
    mssGV.allocInf[mssGV.allocCnt].size=0;
    mssGV.allocInf[mssGV.allocCnt].refNo=0;
    strcpy(mssGV.allocInf[mssGV.allocCnt].msg,msg);
    mssGV.allocCnt++;
  }
}

/**
 * # FUNCTION #
 * ΰݡΰɽɽ
 */
void mssShowAllocInf(void)
{
  int i;

/*
  for(i=mssGV.allocCnt-1; i>0; i--){
    if( mssGV.allocInf[i].func==0 && mssGV.allocInf[i].refNo==-1 ){
      for(j=i-1; j>=0; j--){
        if( mssGV.allocInf[i].add==mssGV.allocInf[j].add &&
            mssGV.allocInf[j].refNo==-1 &&
            mssGV.allocInf[j].func!=0   ){
          mssGV.allocInf[i].refNo=j;
          mssGV.allocInf[j].refNo=i;
          break;
        }
      }
    }
  }
*/

  fprintf(stderr,"========================================================\n");
  fprintf(stderr,"ưŪΰγݡбɽ\n");
  fprintf(stderr,"--------------------------------------------------------\n");
  fprintf(stderr,"1: No. (or줿)\n");
  fprintf(stderr,"2: ؿ\n");
  fprintf(stderr,"      0:mssFree\n");
  fprintf(stderr,"      1:mssMalloc\n");
  fprintf(stderr,"      2:mssCalloc\n");
  fprintf(stderr,"      3:mssRealloc\n");
  fprintf(stderr,"      4:mssreallocLim\n");
  fprintf(stderr,"      5:mssStrdup\n");
  fprintf(stderr,"3: ()줿Ƭɥ쥹\n");
  fprintf(stderr,"4: ݤ줿\n");
  fprintf(stderr,"5: -бNo.\n");
  fprintf(stderr,"6: λǤΥݿ(ǽԤ0ΤϤ)\n");
  fprintf(stderr,"       (ǽԤ0Ǥʤв˺줬)\n");
  fprintf(stderr,"7: mssFree,mssStrdupʳˤĤơƤӽФå\n");
  fprintf(stderr,"========================================================\n");
  for(i=0; i<mssGV.allocCnt; i++){
    if( mssGV.allocInf[i].func==6){
      fprintf(stderr,"%3d : Label : %s\n", i, mssGV.allocInf[i].msg );
    }else{
      fprintf(stderr,"%3d : %d %p %d %d %d %s\n",
      i,
      mssGV.allocInf[i].func,
      mssGV.allocInf[i].add ,
      mssGV.allocInf[i].size ,
      mssGV.allocInf[i].refNo,
      mssGV.allocInf[i].cnt ,
      mssGV.allocInf[i].msg );
    }
  }
}

/**
 * # FUNCTION #
 * ΰ賫
 *   ɥ쥹 NULLʤ鲿⤷ʤ
 */
void mssFree(void *add)
{
  if(add!=NULL){
    if(mssGV.allocDeb){
      addAllocInf(0,add,0,"");
/*      mssGV.allocFreeCnt--;*/
    }
    free(add);
    /*add=NULL;*/
  }
}

/**
 * # FUNCTION #
 * callocˤΰ
 */
void *mssCalloc(int size, char *errMsg)
{
  void *p;
  p=calloc(size,1);
  if(p==NULL){
    mssShowErrMsg("memory allocation error in [%s]",errMsg);
    mssEnd(mssErrorNoDefault);
  }
  if(mssGV.allocDeb) {
/*    mssGV.allocFreeCnt++;*/
    addAllocInf(1,p,size,errMsg);
  }
  return(p);
}

/**
 * # FUNCTION #
 * mallocˤΰ
 */
void *mssMalloc(int size, char *errMsg)
{
  void *p;
  p=malloc(size);
  if(p==NULL){
    mssShowErrMsg("memory allocation error in [%s]",errMsg);
    mssEnd(mssErrorNoDefault);
  }
  if(mssGV.allocDeb){
/*    mssGV.allocFreeCnt++;*/
    addAllocInf(2,p,size,errMsg);
  }
  return(p);
}

/**
 * # FUNCTION #
 * reallocˤΰ
 */
void *mssRealloc(void *ptr, int size, char *errMsg)
{
  void *p;
  p=realloc(ptr,size);
  if(p==NULL){
    mssShowErrMsg("memory allocation error in [%s]",errMsg);
    mssEnd(mssErrorNoDefault);
  }
  if(mssGV.allocDeb){
/*    mssGV.allocFreeCnt++;*/
    updAllocInf(3,p,ptr,size,errMsg);
  }
  return(p);
}

/**
 * # FUNCTION #
 * ݤ륵꤬Ǥreallocˤΰ
 */
void *mssReallocLim(void *ptr, int size,int lim, char *errMsg)
{
  void *p;

  if(size>lim){
    mssShowErrMsg("exceed memory limitation of %d byte in [%s]",lim,errMsg);
    mssEnd(mssErrorNoDefault);
  }
  p=realloc(ptr,size);
  if(p==NULL){
    mssShowErrMsg("memory allocation error in [%s]",errMsg);
    mssEnd(mssErrorNoDefault);
  }
  if(mssGV.allocDeb && ptr==NULL) {
/*    mssGV.allocFreeCnt++;*/
    updAllocInf(4,p,ptr,size,errMsg);
  }
  return(p);
}

/**
 * # FUNCTION #
 * strdupˤʸ󥳥ԡ
 */
char *mssStrdup(char *s)
{
  char *S;
  if(s==NULL) return(NULL);
  S=strdup(s);
  if(mssGV.allocDeb) {
/*    mssGV.allocFreeCnt++;*/
    addAllocInf(5,S,strlen(S),"");
  }
  return(S);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * mssStrings¤δϢδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # DOCUMENT #
 * δؿŪϡʸʻ(Concatenate)ʸΰ
 * 뤳Ȥưפ˼¸뤳Ȥˤ롣
 *
 * )
 *   1: struct mssStrings *s;
 *   2: s=mssInitStrings();  mssStrings¤Τν
 *   3: catStrings(s,"abc"); "abc"Ȥʸ򥻥å
 *   4: catStrings(s,"xyz"); "xyz"Ȥʸɲ
 *   5: catStrings(s,"opq"); "opq"Ȥʸɲ
 *   6: freeStrings(s);      mssStrings¤ΰ
 *   嵭5:ܤޤǤνˤơs->str="abcxyzopq", s->cnt=9Ȥʤ롣
 *
 * ʻ礵ʸФƥϡStrListϢδؿȤ
 */

/**
 * # FUNCTION #
 * mssStrings¤Τν
 */
struct mssStrings *mssInitStrings()
{
  struct mssStrings *s;
  s=mssMalloc(sizeof(struct mssStrings),"initStrings");
  s->str=NULL;
  s->cnt=0;
  return(s);
}

/**
 * # FUNCTION #
 * mssStrings¤ΰγ
 */
void mssFreeStrings(struct mssStrings *s)
{
  mssFree(s->str);
  mssFree(s);
}

/**
 * # FUNCTION #
 * mssStrings¤Τʸɲä
 */
void mssCatStrings(struct mssStrings *s, char *str)
{
  int cnt=s->cnt;
  s->cnt += strlen(str);
  s->str=mssRealloc(s->str,sizeof(char)* (s->cnt+1),"catStrings");
  if(cnt==0) strcpy(s->str,str);
  else       strcat(s->str,str);
}

/**
 * # FUNCTION #
 * mssStrings¤Τʸnʸɲä
 */
void mssCatnStrings(struct mssStrings *s, char *str, int n)
{
  int cnt=s->cnt;
  s->cnt += n;
  s->str=mssRealloc(s->str,sizeof(char)* (s->cnt+1),"catnStrings");
  if(cnt==0) strncpy(s->str,str,n);
  else       strncat(s->str,str,n);
  *(s->str+s->cnt)='\0';
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * mssStrList¤δϢδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # DOCUMENT #
 * δؿŪϡĹʸΰ켡ΨŪ˺뤳Ȥˤ롣
 * ŪˤϡʸĤΥΰʻ(Concatenate)
 * ĤʸΰƳʸؤΥ
 * ʸ֥ݥ(ʸΰƬΥХȿ)ˤäƻȤ롣
 * Ǥ0Ϥޤ롣
 *
 * )
 *   1: struct mssStrList *s;
 *   2: s=mssInitStrList();  mssStrList¤Τν
 *   3: mssPutStrList(s,"abc"); "abc"Ȥʸ0˥å
 *   4: mssPutStrList(s,"xyz"); "xyz"Ȥʸ1˥å
 *   5: mssPutStrList(s,"opq"); "opq"Ȥʸ2˥å
 *   6: mssFreeStrList(s);      mssStrList¤ΰ
 *   嵭5:ܤޤǤνˤƵϿ줿ʸϰʲΤ褦mssGetStrListؿ
 *   ˤƻȤǤ롣
 *     mssGetStrList(s,0)=="abc"
 *     mssGetStrList(s,1)=="xyz"
 *     mssGetStrList(s,2)=="opq"
 *   Ǥο s->cntˤƻȤǤ롣嵭Ǥ3
 *   åȤ줿ʸΤʸ s->chrCntǻȤǤ롣嵭Ǥ9
 */

/**
 * # FUNCTION #
 * mssStrList¤Τν
 */
struct mssStrList *mssInitStrList()
{
  struct mssStrList *s;
  s=mssMalloc(sizeof(struct mssStrList),"initStrList");
  s->chrCnt=0;
  s->cnt=0;
  s->str=NULL;
  s->pointer=NULL;
  return(s);
}

/**
 * # FUNCTION #
 * mssStrList¤ΰγ
 */
void mssFreeStrList(struct mssStrList *s)
{
  if(s==NULL)return;
  mssFree(s->str);
  mssFree(s->pointer);
  mssFree(s);
}

/**
 * # FUNCTION #
 * mssStrList¤Τʸɲä
 */
void mssPutStrList(struct mssStrList *s, char *str)
{

  int len;

  /*ԤʸΥԡ*/
  len = strlen(str)+1; /*+1'\0'Τ*/
  s->chrCnt += len;
  s->str=mssRealloc(s->str,sizeof(char)* s->chrCnt,"putStrList");

  strncpy(s->str+s->chrCnt-len,str,len-1); /*ʸΤߤ򥳥ԡ*/
  *(s->str+s->chrCnt-1)='\0';              /*'\0'򥱥ĤˤĤ*/

  /*Ԥʸι(ʸΰƬʸݥ󥿤Ȥ*/
  s->pointer=mssRealloc(s->pointer,sizeof(int)*(s->cnt+1),"putStrList");
  *(s->pointer+s->cnt)=s->chrCnt-len;

  s->cnt++; /*쥳ɿ򥫥ȥå*/
}

/**
 * # FUNCTION #
 * mssStrList¤ΤnܤǤؤΥݥ󥿤֤
 * ꤷֹ椬ǿ礭NULL֤
 */
char *mssGetStrList(struct mssStrList *s,int n)
{
  if( n>=s->cnt ) return(NULL);
  return(s->str+*(s->pointer+n));
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ѿswap
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * intѿswap
 */
void mssSwapInt(int *x, int *y)
{
  int tmp;
  tmp=*x; *x=*y; *y=tmp;
}

/**
 * # FUNCTION #
 * longѿswap
 */
void mssSwapLng(long *x, long *y)
{
  long tmp;
  tmp=*x; *x=*y; *y=tmp;
}

/**
 * # FUNCTION #
 * doubleѿswap
 */
void mssSwapDbl(double *x, double *y)
{
  double tmp;
  tmp=*x; *x=*y; *y=tmp;
}


/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Ѵδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ʸդtime_tͤѴ
 */
time_t mssStrToTime(char *str)
{
  char buf[20];
  time_t caltime;
  struct tm worktm;

  strncpy(buf, str, 4); /*ǽʸ4ʸԡ,źΤǼ*/
  buf[4] = '\0';

  /*04ܤ˶ʸ*/
  worktm.tm_year = atoi(buf) - 1900; /*֤ˤ뤿1900*/

  strncpy(buf, str+4, 2);
  buf[2] = '\0';
  worktm.tm_mon = atoi(buf) - 1;    /*֤ˤ뤿1900*/

  strncpy(buf, str+6, 2);
  buf[2] = '\0';
  worktm.tm_mday = atoi(buf);
  worktm.tm_hour = 0;
  worktm.tm_min = 0;
  worktm.tm_sec = 0;
  worktm.tm_isdst = -1;

  if((caltime = mktime(&worktm)) == -1){ /*mktimeˤ֤Ѵ*/
    return(-1);
  }
  return(caltime);
}

/**
 * # FUNCTION #
 * intͤʸѴ
 */
char *mssItoA(int num)
{
  char buf[100];
  sprintf(buf,"%d",num);
  return(mssStrdup(buf));
}

/**
 * # FUNCTION #
 * doubleͤʸѴ
 * ʲ̵̣ʣϼ롣(ex. 1.560000 -> 1.56, 1.0 -> 1)
 */
char *mssFtoA(double num)
{
/*  int i = 0;*/
  char buf[2048];

  sprintf(buf,mssGV.sigDigitsForm,num);
/*
  sprintf(buf,"%g",num);
  while(buf[i]!='\0') i++;
  while(1) {
    i--;
    if(buf[i]=='.') {buf[i]='\0';break;}
    if(buf[i]=='0') {buf[i]='\0';}
    else        break;
  }
*/
  return(mssStrdup(buf));
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Ϣδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ɤ
 * ɤꤷΥ()֤
 * seed-1ͿȤϡ߻򥷡ɤȤѤ롣
 */
int mssInitRand(int seed)
{
  time_t  long_time;       /*μѤλֹ¤*/                         
  struct tm     *nt;       /*Ʊ*/
  int usedSeed;

  if(seed==-1){
    time(&long_time);
    nt = localtime(&long_time);
    usedSeed=nt->tm_hour*10000+nt->tm_min*100+nt->tm_sec;
  }else{
    usedSeed=seed;
  }
  init_urnd0((long)usedSeed);
  init_irnd(initRND[0],_func[0],(long)usedSeed);
  init_gaussd(initRND[0],_func[0],(long)usedSeed);
  return(usedSeed);
}     

/**
 * # FUNCTION #
 * 0ʾ1ʲμ¿ȯ롣
 */
double mssRand()
{
  return( urnd0() );
}

/**
 * # FUNCTION #
 * Ϳ줿ϰϤ֤ͤ
 * ϰϤΥåϤƤʤΤǡץꥱ¦ǥå뤳ȡ
 */
int mssIRand(int from, int to)
{
  return( irnd(to, from) );
}

/**
 * # FUNCTION #
 * ʬ(ʿm,ɸкs)
 */
double mssNRand(double m, double s)
{
  return( gaussd(m,s) );
}

/**
 * # FUNCTION #
 * ݥʬ(ʿm)
 */
int mssPRand(double m)
{
  int k;
  m=exp(m)*urnd0();
  for(k=0; m>1.0;k++){
    m*=urnd0();
  }
  return( k );
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ʸΤγƼؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ĤʸϢ뤷ʸ֤
 * ȤĤʸˤϰѹäʤ
 * ΰݤ롣
 */
char *mssCatTwoStrings(char *str1, char *str2)
{
  char *str;
  int len;
  int len1=0;
  int len2=0;

  if(str1!=NULL){
    len1=strlen(str1);
  }

  if(str2!=NULL){
    len2=strlen(str2);
  }
  len=len1+len2;

  if(len==0) return(mssStrdup(""));

  str=mssMalloc(sizeof(char)*(len+1),"catTwoStrings");
  *str='\0';
  if(len1!=0) strcat(str,str1);
  if(len2!=0) strcat(str,str2);
  return(str);
}
 
/**
 * # FUNCTION #
 * ̤ʤɤǰϤޤ줿ʸ֥å򥹥åפμΰ֤֤
 * ꤵ줿startChr,endCharʤäꡢ̤бطNULL
 * ֤
 * ̤μϳϳʸȽλʸǻꤹ롣
 * ϳʸȽλʸƱϡͥȤθǤʤΤǡ
 * γʸޤǤ򥹥åפ뤳Ȥˤʤ롣
 * 1)                      2)                    3)
 * abc(aaa*(aaa-ccc))xyz     abc"aaa*"aaa-ccc""xyz   ab(aaa)
 *    ^              ^          ^     ^              ^      ^
 *   str          ֤     str    ֤       str    ֤
 */
char *mssSkipStrBlock(char *str, char startChr, char endChr)
{
  int cnt=0;
  int same=0;

  if(startChr==endChr) same=1;

  while(1) {
    if(*str=='\0'){
      return(NULL);
    }else if(*str==startChr){
      cnt++;
    }else if(*str==endChr){
      cnt--;
    }
    str++;
    if( cnt==0        ) break;
    if( cnt==2 && same) break;
  }
  return(str);
}

/**
 * # FUNCTION #
 * ʸΥȡʬԤʸݥ(char **)֤
 * dup1ȤϡꥸʥʸmssStrdupƤȡʬ
 * ԤΤǥꥸʥʸϰѹʤ
 * ǡdup0(1ʳ)ꤹȡꥸʥʸФƥȡ
 * ʬԤΤǡꥸʥʸѹ롣
 * ȡʬ䤵줿ʸοϰcntݥ󥿤Ǽ줿
 * ѿ˥åȤ롣
 *
 * ʤdup1ȤƤδؿѤƥȡʬ䤷硢
 * ˳ݤ줿ʸΰˤϡʸݥ󥿤κǽ
 * (ɥ쥹)Τ߳Ф褤
 *  -> ѹ2004/10/28ƤǤʤФʤʤ
 * )
 *   char **s;
 *   int cnt;
 *   s=mssTokByChr("abc,efg,hij", ',', &cnt, 1);
 *   Free(*s);
 *
 *    *(s+0)=="abc"
 *        *(s+1)=="efg"
 *        *(s+2)=="hij"
 *           cnt==3;
 */
char **mssTokByChr(char *string, char tok, int *cnt, int dup)
{
  char *orgStr;
  char *str;
  char *pos;
  char **list=NULL;
  int i;

  *cnt=0;
  if(dup) str=mssStrdup(string);
  else    str=string;
  orgStr=str;

  pos=str;
  while(1){
    if(*str==tok || *str=='\0'){
      list=mssRealloc(list,sizeof(char *)*(*cnt+1),"tokByChr");
      *(list+*cnt)=pos;
      (*cnt)++;
      pos=str+1;
      if(*str=='\0') break;
      *str='\0';
    }
    str++;
  }

  /* dupλ꤬listγǤstrdup ɲ 2004/10/28 */
  if(dup){
    for(i=0; i<*cnt; i++){
      *(list+i)=mssStrdup(*(list+i));
    }
    mssFree(orgStr);
  }

  return(list);
}

/**
 * # FUNCTION #
 * ʸ󤫤ɤå롣
 * ʸȤϡNULL⤷ĹʸΤȡ
 */
int mssIsValidStr(char *str)
{
  if(str==NULL) return(0);
  if(*str=='\0') return(0);
  return(1);
}

/**
 * # FUNCTION #
 * mssSortʸӥ롼
 */
static int cmpStrUp(const void **s1,const void **s2)
{
  return (strcmp(*(char **)s1,*(char **)s2));
}

/**
 * # FUNCTION #
 * mssSortʸ߽ӥ롼
 */
static int cmpStrDown(const void **s1,const void **s2)
{
  return (strcmp(*(char **)s1,*(char **)s2) * (-1) );
}

/**
 * # FUNCTION #
 * mssSortѿ;ӥ롼
 */
static int cmpNumUp(const void **s1,const void **s2)
{
  double n1,n2;

  if(MssIsNull(*(char **)s1)) n1=-DBL_MAX;
  else                        n1=atof(*s1);
  if(MssIsNull(*(char **)s2)) n2=-DBL_MAX;
  else                        n2=atof(*s2);
  if(n1 > n2){
    return(1);
  }else if(n1 < n2){
    return(-1);
  }else{
    return(0);
  }
}

/**
 * # FUNCTION #
 * mssSortѿ͹߽ӥ롼
 */
static int cmpNumDown(const void **s1,const void **s2)
{
  double n1,n2;

  if(MssIsNull(*(char **)s1)) n1=-DBL_MAX;
  else                        n1=atof(*s1);
  if(MssIsNull(*(char **)s2)) n2=-DBL_MAX;
  else                        n2=atof(*s2);
  if(n1 > n2){
    return(-1);
  }else if(n1 < n2){
    return(1);
  }else{
    return(0);
  }
}

/**
 * # FUNCTION #
 * ʸǡΥ(ͤȤƥȤ뤳Ȥǽ)
 * flagǻꤹͤ
 *     0:ʸ
 *     1:ʸ߽
 *     2:͹߽
 *     3:;
 */
void mssSort(char **data, int cnt, int flag){
  switch(flag){
  case 0:
    qsort5((char *)data, cnt, sizeof(char *), (int (*))cmpStrUp);
    break;
  case 1:
    qsort5((char *)data, cnt, sizeof(char *), (int (*))cmpStrDown);
    break;
  case 2:
    qsort5((char *)data, cnt, sizeof(char *), (int (*))cmpNumUp);
    break;
  case 3:
    qsort5((char *)data, cnt, sizeof(char *), (int (*))cmpNumDown);
    break;
  }
}


/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * åνϴϢδؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ޥɥ饤񤭽Ф
 * argv˲ԤޤޤƤХڡѴƽϤ
 */
static void printCmdLine(struct mssFPW *fp)
{
  int i,j,len;
  char *str;


  mssWriteStr("\"",fp);
  for(i=0; i<mssGV.argc; i++){
    len=strlen(*(mssGV.argv+i));
    str=mssMalloc(sizeof(char)*(len+1),"printCmdLine");
    for(j=0; j<len; j++){
      if('\n'!=*(*(mssGV.argv+i)+j)){
        *(str+j)=*(*(mssGV.argv+i)+j);
      }else{
        *(str+j)=' ';
      }
    }
    *(str+j)='\0';
    mssWriteStr(str,fp);
    mssFree(str);

    if(i!=mssGV.argc-1){
      mssWriteStr(" ",fp);
    }else{
      mssWriteStr("\"",fp);
    }
  }
} 

/**
 * # FUNCTION #
 * ϥå
 * ) #START# 2996 2003/04/11 21:56:37 "xtcut -f customer -i dat.xt"
 *   #START#³ơץֹ,,,ޥɥ饤
 */
void mssShowStartMsg()
{
  struct mssFPW *fp;

  if(!isQuiet()){
    fp=mssOpenFPW((char *)1,0,0); /*ɸ२顼ϥץ*/
    mssWriteStr("#START# ",fp);
    mssWriteInt(getpid(),fp);
    mssWriteStr(" ",fp);
    mssWriteDate(fp,1);
    mssWriteStr(" ",fp);
    mssWriteTime(fp,1);
    mssWriteStr(" ",fp);
    printCmdLine(fp);
    mssWriteRet(fp);
    mssCloseFPW(fp);
  }
}

/**
 * # FUNCTION #
 * ｪλå
 * )
 *   #END# 2999 2003/04/11 21:59:21 "xtcut -f customer -i xxcc.xt" in=25 out=25
 *   #END#³ơץֹ,,,ޥɥ饤,Ϸ,Ϸ
 */
void mssShowEndMsg()
{
  struct mssFPW *fp;

  if(!isQuiet()){
    fp=mssOpenFPW((char *)1,0,0); /*ɸ२顼ϥץ*/
    mssWriteStr("#END# ",fp);
    mssWriteInt(getpid(),fp);
    mssWriteStr(" ",fp);
    mssWriteDate(fp,1);
    mssWriteStr(" ",fp);
    mssWriteTime(fp,1);
    mssWriteStr(" ",fp);
    printCmdLine(fp);
    mssWriteStr(" in="  ,fp);
    mssWriteInt(mssGV.inCnt  ,fp);
    mssWriteStr(" out=",fp);
    mssWriteInt(mssGV.outCnt ,fp);
    mssWriteRet(fp);
    mssCloseFPW(fp);
  }
}

/**
 * # FUNCTION #
 * 顼λå
 * å˴ޤޤԤ"_"Ѵ롣
 * ) #ERROR# 2996 "xtcut" "option -f is mandatory"
 *   #ERROR#³,ץֹ,ޥɥ饤,顼å
 */
void mssShowErrMsg(char *msg, ...)
{
  char tmp[1024];
  va_list args;
  struct mssFPW *fp;
  int i;

  if(isQuiet()) return;

  va_start(args,msg);
  vsprintf(tmp,msg,args);

  /*Ԥ_Ѵ*/
  for(i=0;;i++){
    if(tmp[i]=='\0') break;
    if(tmp[i]=='\n') tmp[i]='_';
  }

  fp=mssOpenFPW((char *)1,0,0); /*ɸ२顼ϥץ*/
  mssWriteStr("#ERROR# ",fp);
  mssWriteInt(getpid(),fp);
  mssWriteStr(" ",fp);
  printCmdLine(fp);
  mssWriteStr(" \"",fp);
  mssWriteStr(tmp,fp);
  mssWriteStr("\"",fp);
  mssWriteRet(fp);
  mssCloseFPW(fp);
  va_end(args);
}

/**
 * # FUNCTION #
 * ñʤå
 *   #MSG#³,ץֹ,å
 */
void mssShowMsg(char *msg, ...)
{
  char tmp[1024];
  va_list args;
  struct mssFPW *fp;
  int i;

  if(isQuiet()) return;

  va_start(args,msg);
  vsprintf(tmp,msg,args);

  /*Ԥ_Ѵ*/
  for(i=0;;i++){
    if(tmp[i]=='\0') break;
    if(tmp[i]=='\n') tmp[i]='_';
  }

  fp=mssOpenFPW((char *)1,0,0); /*ɸ२顼ϥץ*/
  mssWriteStr("#MSG# ",fp);
  mssWriteInt(getpid(),fp);
  mssWriteStr(" \"",fp);
  mssWriteStr(tmp,fp);
  mssWriteStr("\"",fp);
  mssWriteRet(fp);
  mssCloseFPW(fp);
  va_end(args);
}
