/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤ뤽¾إåե
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssValue.h>
#include <musashi/mssHeader.h>

#ifndef __MSSMISC_H
#define __MSSMISC_H 1

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ֹ(Red Black Tree)
 * ----------------------------------------------------------------------------
 */

/**
 * # STRUCT #
 * ֹڤΥΡɤѤ륭¤
 */
struct mssRBkey {
  MssValue v; /*Υ羮ˤäƥץ饤ƥޤ*/
  void *add;  /*ѥɥ쥹*/
};
  
/**
 * # STRUCT #
 * ֹڤΥΡɹ¤
 */
struct mssRBnode {
  struct mssRBkey  *key;
  struct mssRBnode *parent, *left, *right;
  int    rank;
};

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ϰϥǥå
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ϰϽͤȾĥΡɤ˳Ǽ(ꥹȹ¤)
 */
struct RangeNode {
  MssValue v;   /* Ρɤ */
  char **recLT; /* v꾮ĥ쥳ɽ(range->rec)*/
  char **recLE; /* vʲĥ쥳ɽ(range->rec)*/
  char **recIN; /* ΥΡɤͤΤޤ쥳ɽ(range->rec)*/
  char **recGE; /* vʾĥ쥳ɽ(range->rec)*/
  char **recGT; /* v礭ĥ쥳ɽ(range->rec)*/
  int  cntLT;   /* ʲ嵭ѿϿ줿(range->rec)*/
  int  cntLE;
  int  cntIN;
  int  cntGE;
  int  cntGT;
  struct RangeNode *next;
  int procLTGE; /*joinեѡnodeLT,GEstackȿǥե饰*/
  int procLEGT; /*joinեѡnodeLE,GTstackȿǥե饰*/
};

/**
 * # FUNCTION #
 * ޥϰϡJOINͤǼ
 */
struct Range {
  MssValue st;
  int      stEq;
  MssValue ed;
  int      edEq;
  char *rec;
};

/**
 * # FUNCTION #
 * ޥ(-kιܤͤƱ)RangeǼ
 */
struct RangeTbl {
  struct Range **range;
  int cnt;
};

/**
 * # FUNCTION #
 * ϰϥǥå
 */
struct RangeIndex {
  struct RangeTbl *tbl;
  struct RangeNode *list;
  int nsFlg; /*ϰ(1)ʸϰ(0)*/
};

/**
 * # PROTOTYPE # 
 */

struct mssRBnode *	mssRBinit(int keyType);
void 			mssRBfree(struct mssRBnode *v);
void 			mssRBshowTree(char *s,struct mssRBnode *pp);
int 			mssRBdelete(struct mssRBnode *v, MssValue value);
int 			mssRBinsert(struct mssRBnode *v,MssValue value,void *add);
struct mssRBnode *	mssRBinsertAdd( struct mssRBnode *v, MssValue value, void *add);
struct mssRBnode *      mssRBfindMax(struct mssRBnode *v);
struct mssRBnode *      mssRBfindMin(struct mssRBnode *v);

struct mssRBnode *	mssRBmember(struct mssRBnode *n, MssValue value);
int			mssRBisExternalNode(struct mssRBnode *v);

struct RangeIndex *	mssSetRangeIndexFrk(struct mssFldRecKey *frkM, struct mssFields *flds, int stFldNo, int edFldNo, int nsFlg, int stEQflg, int edEQflg);

void 			mssShowRangeIndex(struct RangeIndex *rIndex);
void 			mssFreeRangeIndex(struct RangeIndex *rIndex);
void			mssProcLTGE(struct mssRBnode *rb, struct RangeNode *node);
void			mssProcLEGT(struct mssRBnode *rb, struct RangeNode *node);


#endif
