/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤXMLtableǡϴϢΥإåե
 * ============================================================================
 */

#include <stdio.h>
#include <zlib.h>

#include <musashi/mssHeader.h>
#include <musashi/mssConfig.h>
#include <musashi/mssOutput.h>
#include <musashi/mssOption.h>


#ifndef __MSSINPUT_H
#define __MSSINPUT_H 1

/**
 * # DEFINE #
 * ޡȤԤݤˡĤޤǤΥեƱʻ礵뤫
 */
#define PWayS 25

/**
 * # DEFINE #
 * ʬ䥽ȤǤΥǡɤ߹ߥХåեξ
 * ͡⤷MssMaxLineSortΤ줫ͤãȤΥǡ
 * ʬ䥽ȤˤĤΥХåȤȤʤ롣
 */
#define MaxMemS 2048000

/**
 * # DEFINE #
 * ʬ䥽ȤǤΥǡɤ߹߹Կξ
 * ͡⤷MssMaxMemSortΤ줫ͤãȤΥǡ
 * ʬ䥽ȤˤĤΥХåȤȤʤ롣
 */
#define MaxLineS 50000

/**
 * # DEFINE #
 * ѥפΥХåե
 */
#define PipeSize 4096

/**
 * # DEFINE #
 * 󥰥ХåեΰĤΥ塼Υ֥å
 */
#define ReadCnt 4

/**
 * # DEFINE #
 * FRM¤Τˤݥ󥿥ХåեΥ̾
 */
#define MaxPntSize 2048000

/**
 * # STRUCT #
 * ȡʥȥĥ꡼Υǡ¤
 *
 *                 (1)
 *          +-------+--------+
 *          |                |
 *         (2)              (3)
 *    +-----+------+     +---+--+
 *    |            |     |      |
 *   (4)          (5)   (6)    (7)
 *  +--+--+     +--+--+
 *  |     |     |     |
 * (8)   (9)  (10)  (11)
 * ƥΡTTnode¤ΤĥĤ
 * Ρֹ(4)ˤĤƤߤȡ
 * node->parent   (2)
 * node->brother  (5)Ȥʤ롣
 * node->key TTkey¤ΤؤΥݥ󥿤Ǽºݤʸ򼨤ȹͤФ褤
 * node->key->strºݤʸؤΥݥ󥿤򼨤
 * node->key->bktϤstrʸPwayޡȤʬ䤵줿Хåֹ
 *                                                          (եֹ)
 */
struct TTnode {
  int num;           /*Ρֹ*/
  struct TTkey {
    char   *str;     /*ʸ*/
    int     bkt;     /*ʬ䥽ȤˤХåֹ*/
  } *key;
  struct TTnode *parent;  /*ƥΡ*/
  struct TTnode *brother; /*Ρ*/
};

/**
 * # STRUCT #
 * ѤΥǡ¤
 * ȤΥ르ꥺϡˤʣˤʤäƤ롣
 * ʣθϡͤս祽Ȥ̾ʸȤƱץ
 * äƤȤˤʤ롣
 * ͵ս祽ȤǤƤνˤơӤñ̤ǹԤäƤ뤿
 * ɤ߹ߤTNtreeǤϹܤڤäƽƤ롣
 * ǡ̾ʸȤξϡǽ˥ǡɤ߹ݤˡܤ򥭡
 * ¤ٴ롣뤳ȤˤäơνǤϹܤڤ뤳Ȥʤ
 * Ǥ롣Ӥϡñ̤ƬʸӤ򤹤Ф褤
 * Υ르ꥺΰ㤤ˤäơ̾ʸȤϤʤ®ˤʤ롣
 * 500Υ٥ޡˤơ1.3ܤι®¸ǤƤ롣
 * ξԤΥȤ͵ս祽Ȥˤ碌뤳ȤǤ뤬ȡ
 * ץब˥ץˤʤˡ٤ʤ롣
 * ̾ѤˤƤϡñʸȤΨŪ¿ͽ¬
 * ΤǡץΥץ뤵ꡢ®
 */
struct mssSortDat {
  struct TTnode  *tt;               /*ȡʥȥĥ꡼(ץ饤ƥ塼)*/
  struct mssFPR  *iFile[PWayS];     /*ϥեݥ*/
  struct mssRec  *rec[PWayS];       /*ϥեɤ߹ߥХåե*/
  struct mssFldRec *fr[PWayS];        /*ͤս祽ȤǤɤ߹ߥХåե*/
  char            prefix[MssFileNameMaxLen]; /*ե̾prefix*/
  int             iStart;           /*ϥեֹ*/
  int             iEnd;             /*λϥեֹ*/
  int             bktCnt;           /*ХåȤο(iEnd-iStart+1)*/
  struct mssFields *flds;           /*ȹ*/
  int             fldCnt;           /*ǡܿ*/
  int             recCnt;           /*ǡΥ쥳ɿ*/
  int             conv[MssFieldMaxCnt];/*:ȹܽ :infileιֹ*/
  int             cmpRevNum;        /*Ȥˤ륭Ӥ*/
                                    /* 0:ñƬʸӤǹԤ*/
                                    /* 1:͡սθӤԤ*/
                                    /* ɲ(2004/08/03) */
};

/**
 * # STRUCT #
 * ϥХåեι¤(󥰥Хåե)
 *
 * Хåե                  ĤΥ塼(ɤ߹ñ)
 * fp->que -----+---------------+       
 *              |MssRecordMaxLen|    / +------------+
 *              +---------------+   /  |PipeSize    |0
 *             0|fp->queSize    |  /   +------------+
 *              |               | /    |            |1
 *              +---------------+/     +------------+
 *             1|               |      |     :      |
 *              |               |      |     :      |
 *              +---------------+\     |     :      |
 *              |       :       | \    |     :      |
 *              |       :       |  \   +------------+
 *              |       :       |   \  |            |ReadCnt
 *              +---------------+    \ +------------+
 *              |               |
 *    fp->queCnt|               |
 *              +---------------+
 */
struct mssFPR {
  char *fName;  /*ե̾ؤΥݥ(NULL:ɸ)*/
  char *curPnt; /*ߤɤ߹ߥݥ*/
  char *buf;    /*󥰥Хåեǡ*/
  int   queCnt; /*queueο 2߾ǤʤФʤʤ*/
  int   queSize;/*queΥ=queCnt*PipeSize(׻ǵΤ٤Τ)*/
  int   enq;    /*ɤߤХåեֹ*/
  int   deq;    /*ͭʥХåեγֹ*/
  int   full;   /*Хåեfullե饰*/
  int   last;   /*eofޤɤ߹ߤԤäե饰*/
  int   recCnt; /*ޤǤɤ߹쥳ɤΥ*/
  int   chrCnt; /*ޤǤɤ߹ʸΥ*/

  int   zflg;   /*̥ե(1)̾ե(0)?*/
  gzFile zfd;   /*̥ե*/
  FILE *fp;     /*̾ե*/

  int   sort;   /*̾ե(0)ȥե(1)? reopenFPRsortǥå*/
  struct mssSortDat *sd; /*ȥե륪֥*/
  char *readPnt;         /*ǡɤ߹ߥݥ*/
};

/**
 * # STRUCT #
 * ɤ߹߹¤
 * ܤˤʬϤʤʤ
 */
struct mssRec {
  char *pnt;    /*ԤƬؤΥݥ*/
  int   chrCnt; /*ɤߤʸ*/
  int   eof;    /*եɤڤä˥åȤ*/
};

/**
 * # STRUCT #
 * ܤˤȡʬȤʤäñɤ߹߹¤
 */
struct mssFldRec {
  char **pnt;   /*ƹܤؤΥݥ*/
  int fldCnt;   /*ܿ(initFldRec˥åȤ)*/
  int   chrCnt; /*ɤߤʸ*/
  int   eof;
};

/**
 * # STRUCT #
 * ܤˤȡʬȤʤäñɤ߹߹¤
 * ֥졼ԤȤѤ롣
 */
struct mssFldRecDbl {
  char **pnt[2]; /*ƹԳƹܤؤΥݥ*/
  int new;       /*0 or 1: pnt[new]Ǹ߹Ԥιܤ򤵤*/
  int old;       /*0 or 1: pnt[old]Ԥιܤ򤵤*/
  int firstRead; /*ǽΰԤΥ֥졼ˤΤ㳰뤿Υե饰*/
  int eof;       /*եɤڤä˥åȤ*/
  int newChrCnt; /*ɤߤʸ(new)*/
  int oldChrCnt; /*ɤߤʸ(old)*/
  int fldCnt;    /*ܿ(initFRD˥åȤ)*/
};

/**
 * # STRUCT #
 * ܤˤȡʬȤʤänñɤ߹߹¤
 * nͤFPRΥХåե礭⤷MaxPntSizeǷޤ롣
 */
struct mssFldRecMax {
  char **pnt;      /*ƹԳƹܤؤΥݥ
                    (*(pnt+fldCnt*ֹ)+ֹ)ǹֹιֹ򤵤*/
  int    fldCnt;   /*ܿ(initFldRec˥åȤ)*/
  int    chrCnt;   /*ɤߤʸ*/
  int    eof;      /*եɤڤä˥åȤ*/
  int    recCnt;   /*ɤ߹Կ*/
  int    recMax;   /*MaxPntSize׻롢ɤ߹߹Կξ*/
};

/**
 * # STRUCT #
 * ܤˤȡʬȤʤäñɤ߹߹¤
 */
struct mssFldRecKey {
  char **pnt;       /*ñ̤ιܥݥ*/
  int    fldCnt;    /*ܿ(initFRK˥åȤ)*/
  int    chrCnt;    /*ɤߤʸ*/
  int    eof;       /*եɤڤä˥åȤ*/
  int    keyRecCnt; /*ߤΥ˴ޤޤԿ*/
  int    keyNo;     /*ߤֹ̤*/

  char **frPnt;     /*ܹԤǼݥ*/
  int firstRead;    /*ǽΰԤΥ֥졼ˤΤ㳰뤿Υե饰*/
  int    alcRecCnt; /*pntΰݤ줿Կ*/
  int    recPnt;    /*pntɤ߹(ֹ)*/
  MssOptKEY *optKey;   /**/
  int     byFile;   /*ե˽Ϥ줿ɤΥե饰*/
  char   fName[MssFileNameMaxLen]; /*ե̾*/
  struct mssFPW *fpw;  /*Ѥե*/
  struct mssFPR *fpr;/*Ѥե*/
  struct mssFldRec *fr;/*ե뤫ñ̤ɤ߹ि*/
  int    curRecNo;  /*߽ιֹ*/
};

/**
 * # STRUCT #
 * ե륹ơι¤
 */
struct mssFileInfo {
  int   maxCnt;    /* 0:ǡɤ߹ n:nԤޤ*/
  char *fName;     /*ե̾*/
  int   totalSize; /*-tλtotalSize==bodySize*/
  int   readEnd;   /*ǽԤޤɤ߹ɤ*/
  int   bodySize;  /*ǡ*/
  int   fldCnt;    /*ܿ*/
  int   recCnt;    /*쥳ɿ*/
};

/**
 * # PROTOTYPE # 
 */
struct mssFileInfo * 	mssGetFileInfo(char *fName, int recMax);
struct mssRec *		mssInitRec(void);
void        		mssFreeRec(struct mssRec *rec);
int         		mssReadRec(struct mssFPR *fp, struct mssRec *rec);
struct mssFldRec *	mssInitFldRec(int fldCnt);
void           		mssFreeFldRec(struct mssFldRec* fr);
int            		mssReadFldRec(struct mssFPR *fp, struct mssFldRec *fr);
int 			mssReadRandFldRec(struct mssFPR *fp, struct mssFldRec *fr, int recNo, int datTop, int recLen);
struct mssFldRecDbl *	mssInitFRD(int fldCnt);
void              	mssFreeFRD(struct mssFldRecDbl *frd);
int               	mssReadFRD(struct mssFPR *fp, struct mssFldRecDbl *frd);
int               	mssKeyBreak(struct mssFldRecDbl *frd, MssOptKEY *optKey);
struct mssFldRecMax *	mssInitFRM(int fldCnt);
void 			mssFreeFRM(struct mssFldRecMax *frm);
int 			mssReadFRM(struct mssFPR *fp, struct mssFldRecMax *frm);
struct mssFldRecKey *	mssInitFRK(int fldCnt,MssOptKEY *optKey,char *path);
void              	mssFreeFRK(struct mssFldRecKey *frk);
int               	mssReadFRK(struct mssFPR *fp, struct mssFldRecKey *frk);
int			mssReadFldRecFRK(struct mssFldRecKey *frk);
void			mssSeekTopFRK(struct mssFldRecKey *frk);
int 			mssGetFldCntOnData(struct mssFPR *fp);
void 			mssSeekTopFPR(struct mssFPR *fp);
struct mssFPR *		mssOpenFPR(char *fileName, int bufCnt);
struct mssFPR *		mssReopenFPRsort(struct mssFPR *inFile, int queCnt, struct mssFields *flds, int fldCnt, char *tmpPath);
void			mssCloseFPR(struct mssFPR *fp);
struct mssFPR *		mssOpenFPU(char *fileName, int queCnt);
void        		mssCloseFPU(struct mssFPR *fp);
#endif /* _INPUT_H */
