/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤϥåϢΥإåե
 * ============================================================================
 */

#include <musashi/mssHeader.h>
#include <musashi/mssValue.h>

#ifndef __MSSHASH_H
#define __MSSHASH_H 1

/**
 * # STRUCT #
 * ܥϥåͤ빽¤
 * -Ԥchar **pntؤΥݥ󥿤ϥåơ֥˼
 *
 * [0] [1] [2] [3] ...[HashValFld-1]->HashValFld˽äHashValFldĤ
 *                                                            ϥå
 * hn         ->rec : [0]
 * hn->next*1 ->rec : [0][1][2][3] ---->˳ƥ쥳ɤƬܥɥ쥹
 * hn->next*2 ->rec : [0]
 *       :
 * hn->next*n ->rec : [0][1]
 *
 * ƥϥåΥХåȤhn->nextHashNodeFldΥꥹȹ¤ȤꡢƱhash
 * ĥϢ뤵Ƥ롣
 * ex) hn : A,  hn->next : Z,  hn->next->next : 001ʤ
 * ꥹȽühn->rec==NULLǸʬƤ롣
 * ޤǤǡƱhashͤĥꥹȲ줿HashNodeFld¤ΤϡĤΥ
 * бƤ뤳Ȥˤʤ롣
 * ˡƱ쥭ͤä쥳ɤʣ¸ߤǽ롣
 * hn->recreallocưŪΰݤˤΥ쥳ɤƬ
 * Υɥ쥹򥻥åȤƤ롣hn->recCntˤϤη¸롣
 */
struct mssHashNodeFld {
  char ***rec;
  int     recCnt;
  struct mssHashNodeFld *next;
  int     endFlg; /*joinǻȤhashSearchFld줿˥åȤ롣
                    traNullǧouterJoinǡΥե饰ΩäƤʤ
                    쥳ɤ񤭽ФȤˤʤ롣*/
};

/**
 * # STRUCT #
 * ܥϥåι¤
 */
struct mssHashFld {
  int hashVal;
  struct mssHashNodeFld **node;
  struct mssFields *flds;
  int fldCnt;
  int keyCnt; /*ͤढä==̣ΤHashNodeFldο
                hashInsertFldǥȥåפ롣*/
  int endCnt; /*hashSearchFld٤˥ȥåפѿ
                joinǡޥEndȽꤵ뤿
                endCnt==keyCntƥ줿ȤȤߤʤ*/
};

/**
 * # STRUCT #
 * ѥϥåͤ빽¤
 */
struct mssHashNode {
  char  *str;
  MssValue  val;
  struct mssHashNode *last;
  struct mssHashNode *next;
  struct mssHashNode **top;
};

/**
 * # STRUCT #
 * ѥϥå幽¤
 */
struct mssHash {
  int hashVal;
  int cnt;                 /*줿ͤο*/
  struct mssHashNode **node; /*줿ͤؤΥݥ*/
};

/**
 * # PROTOTYPE # 
 */
struct mssHashFld *	mssInitHashFld( int size, struct mssFields *flds);
void			mssFreeHashFld(struct mssHashFld *hash);
void			mssHashInsertFld(struct mssHashFld *hash, char **str);
struct mssHashNodeFld *	mssHashMemberFld(struct mssHashFld *hash,char **str, struct mssFields *flds);
void			mssShowHashFld(struct mssHashFld *hash, int fldCnt);
struct mssHash *	mssInitHash(int size);
void			mssFreeHash(struct mssHash *hash);
struct mssHashNode *	mssHashInsert(struct mssHash *hash, char *str, MssValue val);
struct mssHashNode *	mssHashInsertAdd(struct mssHash *hash, char *str, MssValue val);
struct mssHashNode *	mssHashDeleteNode(struct mssHash *hash, struct mssHashNode *node);
void			mssHashDelete(struct mssHash *hash, char *str);
struct mssHashNode *	mssHashMember(struct mssHash *hash, char *str);
char *			mssHashMemberAdd(struct mssHash *hash, char *str);
MssValue		mssHashMemberVal(struct mssHash *hash, char *str);
void			mssShowHash(struct mssHash *hash);

#endif
