/**
 * # CHAPTER #
 * ============================================================================
 * xtcalѤ׻˴ؤإåե
 * 20040121 sys/types.hɲ(ĻΤŦfor FreeBSD49)
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssValue.h>
#include <musashi/mssHeader.h>
#include <sys/types.h>
#include <regex.h>

#ifndef __MSSCAL_H
#define __MSSCAL_H

/**
 * # DEFINE #
 *ĤδؿȤ롢κ
 */
#define MaxCalArg 128  /*ĤδؿȤ롢κ*/

/**
 * # STRUCT #
 * ؿ黻Ҥΰ
 */
struct Arg {
  MssValue      val[MssFieldMaxCnt];/*(ʣΤϹܥ磻ɥ)*/
  int        valCnt;             /*ͤθĿ*/
  char         *str;             /**/
  int           datType;         /*η(N,S,X)*/
  int           type;            /*Υ(NODE,LEAF(CONST, FIELD)*/
  struct mssCal   *node;         /*ؿ黻Ҥʤ顢ΥΡ*/
  struct mssFields *flds;        /*type==FIELDʤСι*/
  MssValue         constant;        /*type=CONSTʤС*/
};

/**
 * # STRUCT #
 *ؿγƼ
 */
struct Func {
  char name[32];                 /*ؿ̾*/
  int  type;                     /*ؿ,黻Ҥμ 0:ؿ n:n黻*/
  int  priority;                 /*黻Ҥͥ*/
  int  argType[MaxCalArg];       /*η(N,S,X)*/
  int  retType;                  /*ͤη(N,S,X)*/
  unsigned char procType;        /*Ѳǽ*/
  MssValue (*pnt)(struct mssCal *cal); /* ؿΥɥ쥹*/

  /*ʲϾ嵭ѿ׻Ƶ*/
  int  argCnt;                   /*ο(ɬפʿ)*/
  int  argMul;                   /*Ѱޤफɤ*/
  int  mulBcnt;                  /*Ѱξ˲İ뤫*/
  int  mulAcnt;                  /*Ѱξθ˲İ뤫*/
                                 /*{S,S,M,N,N,N}: mulBcnt=1, mulAcnt=3*/
};                               /*   ~~~                             */

/**
 * # STRUCT #
 * ׻¤
 */
struct mssCal {
  struct Func *func;          /* ؿ*/
  int         argCnt;         /* ο*/
  struct Arg  arg[MaxCalArg]; /* */
  int         retType;        /* ΥΡɤͥ*/
  struct mssCal *parent;      /* ƥΡ*/
  regex_t *regex;             /* ɽȤؿξ硢Υѥ*/
};

/**
 * # PROTOTYPE # 
 */
void		mssCalReadFuncIsFldRec(struct mssCal *cal,struct mssFldRec *fr);
void		mssCalReadFuncIsFRK(struct mssCal *cal,struct mssFldRecKey *frk);
void		mssCalReadFuncIsFRD(struct mssCal *cal,struct mssFldRecDbl *frd);
struct mssCal *	mssCalCompile(char *str, struct mssHeader *hd);
void		mssCalShowTree(struct mssCal *cal,int level);
MssValue	mssCalculate(struct mssCal *cal, char **pnt);
void		mssCalFree(struct mssCal *cal);

#endif /*_CAL_H*/
