
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "参照ファイル項目の自然結合"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define TKYT "入力データ上の突き合わせる項目名リスト"
#define TKYC "ここで指定した入力データの項目と-Kで指定された参照データの項目が同じ行の項目結合が行われる"

/*-K*/
#define MKYT "参照データ上の突き合わせる項目名rリスト"
#define MKYC "ここで指定した参照データの項目と-kで指定された入力データの項目が同じ行の項目結合が行われる"

/*-m*/
#define MSTT "参照ファイル名"
#define MSTC "参照ファイル名を指定する"

/*-f*/
#define FLDT "結合項目名リスト"
#define FLDC "結合する参照ファイル上の項目名リスト"
#define FLDF NULL

/*-n*/
#define TNLT "未結合入力データ出力"
#define TNLC "参照データにない入力データをNULL値として出力するフラグ"

/*-N*/
#define MNLT "未結合参照データ出力"
#define MNLC "入力データにない参照データをNULL値として出力するフラグ"

/*-H*/
#define HAST "強制hash結合"
#define HASC "このオプションにより強制的にhash結合を行う。"

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "-kで指定した入力ファイルの項目値と-Kで指定した参照ファイルの項目値を比較し、同じ値を持つ参照ファイルの項目を自然結合する。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtnjoin -k 顧客 -m ref.xt -f 生年月日,性別 -i dat.xt -o rsl.xt\n\
xtnjoin -k 顧客 -m ref.xt -f 生年月日,性別 -nN -i dat.xt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtjoin,xtproduct,xtcommon"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
