/**
 * # CHAPTER #
 * ============================================================================
 * BONSAIǥѥĴ٤ݤpriority queueϢؿ
 * Red-Black Treeˤץ饤ƥ塼μ
 * ڽӽCˤ륢르ꥺȥǡ¤׾Ʋ,1999. 
 * ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <musashi/mssBase.h>
#include <priorityQueue.h>

static void PQfreeNode(struct PQnode *v){
  mssFree(v);
}

void PQptree(struct PQnode *p,int h) {
  int i;

  if(!PQisExternalNode(p)){
    PQptree(p->right, h+1);
    for(i=1; i<=h; i++) printf("    ");
    printf("%1.4f '",p->key.reg.objVal);
    prnstrUSI(p->key.reg.str);
    printf("'(%d)\n",p->rank);
    if(( p->parent->left != p ) && (p->parent->right != p)){
      printf("(%f ",p->key.reg.objVal);
      prnstrUSI(p->key.reg.str);
      printf(")");
    }
    PQptree(p->left,h+1);
  }
}

void PQprintTree(char *s,struct PQnode *pp) {
  printf("%s\n",s);
  PQptree(pp,0);
}

void PQcpKey(struct PQkey *to, struct PQkey *from){

  cpReg(&to->reg, &from->reg);
  to->upperBound = from->upperBound;
}

int PQhasLeftNode(struct PQnode *v) {
  if(v->left->rank !=0){
    return(1);
  }
  return(0);
}

int PQisExternalNode(struct PQnode *v) {
  if(v->rank==0)
    return(1);
  return(0);
}

int PQisTopNode(struct PQnode *v) {
  if(v->parent->rank==0){
    return(1);
  }
  return(0);
}

int PQisLeftNode(struct PQnode *v){
  if(v==v->parent->left)
    return(1);
  return(0);
}

int PQisRedNode(struct PQnode *v) {
  if(v==NULL) return(0);
  if(v->rank == v->parent->rank)
    return(1);
  return(0);
}

struct PQnode *PQfindMax(struct PQnode *v) {
  while(!PQisExternalNode(v->right))
    v=v->right;
  return(v);
}

struct PQnode *PQfind_brother(struct PQnode *v) {
  if(PQisLeftNode(v))
    return(v->parent->right);
  return(v->parent->left);
}

struct PQnode *PQmakeNode(void) {
  struct PQnode *new;
  new=mssCalloc(sizeof(struct PQnode),"PQmakeNode");
  if(new==NULL)fprintf(stderr,"memory allocation error in PQ\n");
  new->rank = 0;
  new->left=new->right=NULL;
  return new;
}

/*queueɤ֤0:Ǥʤ 1:*/
int PQisEmpty(struct PQnode *v) {

  if(PQisExternalNode(v)) return(1);
  else                    return(0);
}

struct PQnode *PQworstMember(struct PQnode *v){

  struct PQnode *vv;

  if(PQisExternalNode(v)){
    return(v);
  }else{
    vv=v;
    while(!PQisExternalNode(vv)){
      vv=vv->right; /*rightéк硢leftϺǾ*/
    }
    return(vv->parent);
  }
}

struct PQnode *PQmember(struct PQkey *key, struct PQnode *v) {
  struct PQnode *vv;

  if(PQisExternalNode(v)) return(v);

  /*ץ饤ƥ(splitting rule)㤤*/
  if(key->reg.objVal < v->key.reg.objVal){
    vv=PQmember(key,v->left);
  }else if(key->reg.objVal >v->key.reg.objVal ){
    vv=PQmember(key,v->right);

  /*ץ饤ƥƱȤѥĹĹ*/
  }else if( strlenUSI(key->reg.str) > strlenUSI(v->key.reg.str) ){
    vv=PQmember(key,v->left);
  }else if( strlenUSI(key->reg.str) < strlenUSI(v->key.reg.str) ){
    vv=PQmember(key,v->right);

  /* bgnRngФο */
  }else if( key->reg.bgnRng!=0 && v->key.reg.bgnRng==0 ){
      vv=PQmember(key,v->left);
  }else if( key->reg.bgnRng==0 && v->key.reg.bgnRng!=0 ){
      vv=PQmember(key,v->right);
  }else if((key->reg.bgnRng!=0 && v->key.reg.bgnRng!=0)&&
           (key->reg.bgnRng    <  v->key.reg.bgnRng)   ){
      vv=PQmember(key,v->left);
  }else if((key->reg.bgnRng!=0 && v->key.reg.bgnRng!=0)&&
           (key->reg.bgnRng    >  v->key.reg.bgnRng)   ){
      vv=PQmember(key,v->right);

  /* endRngФο */
  }else if( key->reg.endRng!=0 && v->key.reg.endRng==0 ){
      vv=PQmember(key,v->left);
  }else if( key->reg.endRng==0 && v->key.reg.endRng!=0 ){
      vv=PQmember(key,v->right);
  }else if((key->reg.endRng!=0 && v->key.reg.endRng!=0)&&
           (key->reg.endRng    <  v->key.reg.endRng)   ){
      vv=PQmember(key,v->left);
  }else if((key->reg.endRng!=0 && v->key.reg.endRng!=0)&&
           (key->reg.endRng    >  v->key.reg.endRng)   ){
      vv=PQmember(key,v->right);

  /* substring  subsequence Ǥsubstringξ */
  }else if( key->reg.type==0 && v->key.reg.type==1 ){
    vv=PQmember(key,v->left);
  }else if( key->reg.type==1 && v->key.reg.type==0 ){
    vv=PQmember(key,v->right);

  /*嵭ξ郎Ʊϥե٥åȽ*/
  }else if( 0 > strcmpUSI(key->reg.str, v->key.reg.str) ){
    vv=PQmember(key,v->left);
  }else if( 0 < strcmpUSI(key->reg.str, v->key.reg.str) ){
    vv=PQmember(key,v->right);

  /* 嵭ξ郎Ʊʤ顢ƱСäȤ */
  }else{
    return(v);
  }
  return(vv);
}

void PQaddExternalNodes(struct PQnode *n)
{
  n->left = PQmakeNode();
  n->right=PQmakeNode();
  n->left->parent=n;
  n->right->parent=n;
}

void PQsingleRotate(struct PQnode *v) {
  struct PQnode *p, *pp,*ppp;

  p  =v->parent;
  pp =p->parent;
  ppp=pp->parent;

  if(PQisLeftNode(pp)){
    ppp->left=p;
  }else{
    ppp->right=p;
  }
  if(PQisLeftNode(v)){
    pp->left=p->right;
    pp->left->parent=pp;
    p->right=pp;
    pp->parent=p;
  }else{
    pp->right = p->left;
    pp->right->parent = pp;
    p->left = pp;
    pp->parent = p;
  }
  p->parent=ppp;
}

void PQdouble_rotate(struct PQnode *v) {
  struct PQnode *p;
  p=v->parent;
  if(PQisLeftNode(v)){
    PQsingleRotate(v->left);
    PQsingleRotate(p);
  }else{
    PQsingleRotate(v->right);
    PQsingleRotate(p);
  }
}

void PQrebalanceOnInsert(struct PQnode *v) {
  struct PQnode *w, *p, *pp;
  int p_is_left;
  
  p=v->parent;
  pp=p->parent;
  if(PQisTopNode(p)){
    return;
  }
  if(PQisRedNode(p)){
    p_is_left=0;   
    if((p_is_left=PQisLeftNode(p))){  
      w=pp->right;
    }else{
      w=pp->left;
    }
    if(PQisRedNode(w)){   
      (pp->rank)++;
      if(!PQisTopNode(pp) && PQisRedNode(pp->parent)){
        PQrebalanceOnInsert(pp);
      }
    }else{
      if(PQisLeftNode(v)){
        if(p_is_left){
          PQsingleRotate(v);
        }else{
          PQdouble_rotate(v);
        }
      }else{
        if(p_is_left){
          PQdouble_rotate(v);
        }else{
          PQsingleRotate(v);
        }
      }
    }
  }
}

void PQinsert(struct PQkey *key,struct PQnode *v) {
  v = PQmember(key,v);
  if(PQisExternalNode(v)){
    PQcpKey(&v->key, key);
    v->rank=1;
    PQaddExternalNodes(v);
    PQrebalanceOnInsert(v);
  }else{
    printf("Cannot : %f",key->reg.objVal);
    prnstrUSI(key->reg.str);
    printf("\n");
  }
}


void PQdetermineAB(struct PQnode **a,
              struct PQnode **b,
              struct PQnode *v,
              struct PQnode *u) {
  if(PQisLeftNode(v)){
    *a=u->right;
    *b=u->left;
  }else{
    *a=u->left;
    *b=u->right;
  }
}


void PQrebalanceOnDelete(struct PQnode *v) {
  struct PQnode *p,*u,*a,*b,*PQfind_brother();
  int v_is_left, p_was_red;

  p=v->parent;
  if(v->rank+1 >= p->rank)
    return;
  u=PQfind_brother(v);
  PQdetermineAB(&a,&b,v,u);
  v_is_left=PQisLeftNode(v);
  p_was_red=PQisRedNode(p);
  if(PQisRedNode(u)){
    if(PQisRedNode(a) || PQisRedNode(b))
      return;
    PQsingleRotate(a);
    PQrebalanceOnDelete(v);
  }else{
    if(!PQisRedNode(a)){
      if(!PQisRedNode(b)){
        (p->rank)--;
        if(!p_was_red)
          PQrebalanceOnDelete(p);
      }else{
        PQdouble_rotate(b);
        (b->rank)++;
        (p->rank)--;
      }
    }else{
      PQsingleRotate(a);
      (u->rank)++;
      (u->rank)--;
    }
  }
}

void PQdelete(struct PQkey *key,struct PQnode *v) {
  struct PQnode *w,*x;
  v=PQmember(key,v);
  if(PQisExternalNode(v)){
    printf("Not found in the tree: %f",key->reg.objVal);
    prnstrUSI(key->reg.str);
    printf("\n");
    return;
  }
  if(PQhasLeftNode(v)){
    w=PQfindMax(v->left);
    if(w->parent != v){
      w->parent->right = w->left;
      w->left->parent  = w->parent;
    }
    x=w->left;
    PQfreeNode(w->right);

    if(PQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    if(w->parent != v){
      w->left = v->left;
      w->left->parent = w;
    }
    w->rank = v->rank;
    w->parent = v->parent;
    w->right = v->right;
    w->right->parent=w;
    PQfreeNode(v);
  }else{
    w=v->right;
    if(PQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    w->parent=v->parent;
    PQfreeNode(v->left);
    PQfreeNode(v);
    x=w;
  }
  PQrebalanceOnDelete(x);
}

void PQdeleteNode(struct PQnode *v) {
  struct PQnode *w,*x;

  if(PQisExternalNode(v)){
    fprintf(stderr,"Not found such node\n");
    return;
  }
  if(PQhasLeftNode(v)){
    w=PQfindMax(v->left);
    if(w->parent != v){
      w->parent->right = w->left;
      w->left->parent  = w->parent;
    }
    x=w->left;
    PQfreeNode(w->right);

    if(PQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    if(w->parent != v){
      w->left = v->left;
      w->left->parent = w;
    }
    w->rank = v->rank;
    w->parent = v->parent;
    w->right = v->right;
    w->right->parent=w;
    PQfreeNode(v);
  }else{
    w=v->right;
    if(PQisLeftNode(v)){
      v->parent->left=w;
    }else{
      v->parent->right=w;
    }
    w->parent=v->parent;
    PQfreeNode(v->left);
    PQfreeNode(v);
    x=w;
  }

  PQrebalanceOnDelete(x);
}

void PQpop(struct Regexp *reg,double *upperBound, struct PQnode *v){

  struct PQnode *vv;

  if(PQisExternalNode(v)){
    *reg->str=0;
    *upperBound=0;
  }else{
    vv=v;
    while(!PQisExternalNode(vv)){
      vv=vv->left; /*rightéк硢leftϺǾ*/
    }
    cpReg(reg,&vv->parent->key.reg);
    *upperBound = vv->parent->key.upperBound;
    PQdeleteNode(vv->parent);
  }
}

/*============================================================================*/
/*PQtreeΥΰ                                                      */
/*============================================================================*/
static void PQfreeAllNode(struct PQnode *v){
  if(PQisExternalNode(v)){
    PQfreeNode(v);
    return;
  }else{
    PQfreeAllNode(v->left);
    PQfreeAllNode(v->right);
    PQfreeNode(v);
    return;
  }
}

void PQfree(struct PQnode *v){
  PQfreeAllNode(v->left);
  PQfreeNode(v);
}
