/**
 * # CHAPTER #
 * ============================================================================
 * ʬϢؿ
 * ============================================================================
 */

#include <musashi.h>
#include <condition.h>

/* ############ Хѿ ##############*/
extern int ClassSize; /*饹Υ*/

/**
 * # FUNCTION #
 * ʬﹽ¤(CndCnt)¤Τν
 */
void iniCndCnt( struct CndCnt *cnt, struct Cost *cost){
  int i;
  for(i=0; i<ClassSize; i++){
    cnt->uCnt[i]=0;
    cnt->mCnt[i]=0;
    cnt->nCnt[i]=0;
    cnt->tCnt[i]=0;
    cnt->uuCnt[i]=0;
    cnt->mmCnt[i]=0;
    cnt->uShrRN[i]=0;
    cnt->mShrRN[i]=0;
    cnt->tShrRN[i]=0;
    cnt->uShrRC[i]=0;
    cnt->mShrRC[i]=0;
    cnt->tShrRC[i]=0;
  }
  cnt->mRatio    =0;
  cnt->mCount    =0;
  cnt->uCount    =0;
  cnt->nCount    =0;
  cnt->utCnt     =0;
  cnt->utCnt     =0;
  cnt->mtCnt     =0;
  cnt->mtCnt     =0;
  cnt->total     =0;
  cnt->splitBefor=0;
  cnt->splitAfter=0;
  cnt->cost      =cost;

  cnt->uShr=cnt->uShrRC;
  cnt->mShr=cnt->mShrRC;
  cnt->tShr=cnt->tShrRC;
}

/**
 * # FUNCTION #
 * ʬﹽ¤(CndCnt)¤Τɽ
 */
void prnCndCnt( struct CndCnt *cnt){
  int i;

  printf("      ");
  for(i=0; i<ClassSize; i++) printf("                  CLS%d",i);
  printf("      TOTAL\n");

  printf("  match");
  for(i=0; i<ClassSize; i++) printf("%6.1f(%6.1f+%6.1f) ",cnt->mmCnt[i],cnt->mCnt[i],cnt->nCnt[i]);
  printf("  %6.1f\n",cnt->mtCnt);

  printf("unmatch");
  for(i=0; i<ClassSize; i++) printf("%6.1f(%6.1f+%6.1f) ",cnt->uuCnt[i],cnt->uCnt[i],cnt->nCnt[i]);
  printf("  %6.1f\n",cnt->utCnt);

  printf("  TOTAL");
  for(i=0; i<ClassSize; i++) printf("%6.1f                ",cnt->tCnt[i]);
  printf("  %6.1f\n",cnt->total);


  printf("---- share -----------------------\n");
  printf("\nshare          match");
  for(i=0; i<ClassSize; i++) printf(" %g",*(cnt->mShr+i));
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",*(cnt->uShr+i));

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrRN[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrRN[i]);

  printf("\nReal Number    match");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->mShrRC[i]);
  printf("\n             unmatch");
  for(i=0; i<ClassSize; i++) printf(" %g",cnt->uShrRC[i]);

  printf("splitBefor=%f\n",cnt->splitBefor);
  printf("splitAfter=%f\n",cnt->splitAfter);
}

/**
 * # FUNCTION #
 * ʬﹽ¤(CndCnt)¤ΤΥԡ
 */
void cpyCndCnt(struct CndCnt *cntTo, struct CndCnt *cntFrom){
  int i;
  for(i=0; i<ClassSize; i++){
    cntTo->uCnt[i]=cntFrom->uCnt[i];
    cntTo->mCnt[i]=cntFrom->mCnt[i];
    cntTo->nCnt[i]=cntFrom->nCnt[i];
    cntTo->uuCnt[i]=cntFrom->uuCnt[i];
    cntTo->mmCnt[i]=cntFrom->mmCnt[i];
    cntTo->tCnt[i]=cntFrom->tCnt[i];
    cntTo->uShrRN[i]=cntFrom->uShrRN[i];
    cntTo->mShrRN[i]=cntFrom->mShrRN[i];
    cntTo->tShrRN[i]=cntFrom->tShrRN[i];
    cntTo->uShrRC[i]=cntFrom->uShrRC[i];
    cntTo->mShrRC[i]=cntFrom->mShrRC[i];
    cntTo->tShrRC[i]=cntFrom->tShrRC[i];
  }
  cntTo->mRatio    =cntFrom->mRatio;
  cntTo->mCount    =cntFrom->mCount;
  cntTo->uCount    =cntFrom->uCount;
  cntTo->nCount    =cntFrom->nCount;
  cntTo->utCnt     =cntFrom->utCnt;
  cntTo->utShr     =cntFrom->utShr;
  cntTo->mtShr     =cntFrom->mtShr;
  cntTo->mtCnt     =cntFrom->mtCnt;
  cntTo->total     =cntFrom->total;
  cntTo->splitBefor=cntFrom->splitBefor;
  cntTo->splitAfter=cntFrom->splitAfter;
  cntTo->cost      =cntFrom->cost;
  
  cntTo->uShr      =cntTo->uShrRC;
  cntTo->mShr      =cntTo->mShrRC;
  cntTo->tShr      =cntTo->tShrRC;
}

/**
 * # FUNCTION #
 * giniη׻
 */
static void gini(struct CndCnt *cnt){
  double mGini=1;    /*   match gini */
  double uGini=1;    /* unmatch gini */
  double tGini=1;    /* total   gini */
  int i;

  for(i=0; i<ClassSize; i++){
    mGini -= *(cnt->mShr+i) * *(cnt->mShr+i);
    uGini -= *(cnt->uShr+i) * *(cnt->uShr+i);
    tGini -= *(cnt->tShr+i) * *(cnt->tShr+i);
  }
  cnt->splitBefor = tGini;
  cnt->splitAfter = cnt->mtShr*mGini + cnt->utShr*uGini;
}

/**
 * # FUNCTION #
 * splitting criteria η׻
 */
void calCndCntSplit( struct CndCnt *cnt){
  gini(cnt);
}

/**
 * # FUNCTION #
 * CndCnt¤ΤdominantClassη
 */
int dominantClass(struct CndCnt *cnt){
  double domClassShr;
  int    domClass;
  int    i;

  domClassShr=*(cnt->tShr+0);
  domClass=0;
  for(i=1; i<ClassSize; i++){
    if( domClassShr < *(cnt->tShr+i)){
      domClassShr = *(cnt->tShr+i);
      domClass    = i;
    }
  }
  return(domClass);
}

/**
 * # FUNCTION #
 * 任ͤǤ任
 */
static double divDef(double d1, double d2, double def){
  if(d2==0) return(def);
  return(d1/d2);
}

/**
 * # FUNCTION #
 * CndCnt ¤Τηפ
 * uCnt[],mCnt[],nCnt[]餵ޤޤѿͤ׻
 */
void calCndCnt( struct CndCnt *cnt){
  int i;
  double uCost=0;
  double mCost=0;
  double tCost=0;
  double total=0;
  double mTotal=0;

  /*ΥΡɤΥ饹̥ȡη׻(NULLͤϽ)*/
  for(i=0; i<ClassSize; i++){
    cnt->tCnt[i] = cnt->mCnt[i] + cnt->uCnt[i];
    total+=cnt->tCnt[i];
    mTotal+=cnt->mCnt[i];
  }
  cnt->mRatio=mTotal/total;

  /*NULLͤη(nCnt[])ȿǤ*/
  for(i=0; i<ClassSize; i++){
    if(cnt->tCnt[i]!=0){
      cnt->mmCnt[i]=(cnt->mCnt[i]/cnt->tCnt[i])*cnt->nCnt[i];
      cnt->uuCnt[i]=(cnt->uCnt[i]/cnt->tCnt[i])*cnt->nCnt[i];
    }else{
      cnt->mmCnt[i]=0;
      cnt->uuCnt[i]=0;
    }
  }

  /*Υ*/
  for(i=0; i<ClassSize; i++){
    cnt->mmCnt[i]+=cnt->mCnt[i];
    cnt->uuCnt[i]+=cnt->uCnt[i];
  }

  /*ι*/
  cnt->mtCnt =0;
  cnt->utCnt =0;
  cnt->total=0;
  for(i=0; i<ClassSize; i++){
    cnt->tCnt[i] = cnt->mCnt[i] + cnt->uCnt[i] + cnt->nCnt[i];
    cnt->mtCnt += cnt->mmCnt[i];
    cnt->utCnt += cnt->uuCnt[i];
    cnt->total += cnt->tCnt[i];
  }


  /*ޥåޥåη׻*/
  cnt->mtShr = divDef((double)cnt->mtCnt, (double)cnt->total, 0);
  cnt->utShr = divDef((double)cnt->utCnt, (double)cnt->total, 0);

  /*-------------------------------------------------*/
  /*ޥåޥå̳ƥ饹иΨη׻         */
  /*-------------------------------------------------*/

  /*-------------------------------------------------*/
  /*                                       */
  /*-------------------------------------------------*/
  for(i=0; i<ClassSize; i++){
    cnt->uShrRN[i]=divDef( cnt->uuCnt[i],cnt->utCnt,0 );
    cnt->mShrRN[i]=divDef( cnt->mmCnt[i],cnt->mtCnt,0 );
    cnt->tShrRN[i]=divDef( cnt->tCnt[i] ,cnt->total,0 );
  }

  /*-------------------------------------------------*/
  /*Ȥˤ륷η׻                         */
  /*xShrC=C(j)*xShr(j)/SUMi(C(i)*xShr(i))            */
  /* C(j)=SUMi(cost(j,i))                            */
  /* cost(j,i)Ȥϥ饹jiͽ¬ȤΥ   */
  /*-------------------------------------------------*/
  /*SUMi(C(i)*xShr(i))η׻*/
  for(i=0; i<ClassSize; i++){
    uCost+=cnt->cost->actTtl[i]*cnt->uShrRN[i];
    mCost+=cnt->cost->actTtl[i]*cnt->mShrRN[i];
    tCost+=cnt->cost->actTtl[i]*cnt->tShrRN[i];
  }

  /*xShrC=C(j)*xShr(j)/xCost η׻*/
  for(i=0; i<ClassSize; i++){
    cnt->uShrRC[i]
      =divDef(cnt->cost->actTtl[i]*cnt->uShrRN[i], uCost, cnt->uShrRN[i]);
    cnt->mShrRC[i]
      =divDef(cnt->cost->actTtl[i]*cnt->mShrRN[i], mCost, cnt->mShrRN[i]);
    cnt->tShrRC[i]
      =divDef(cnt->cost->actTtl[i]*cnt->tShrRN[i], tCost, cnt->tShrRN[i]);
  }
}

/**
 * # FUNCTION #
 * 롼(Ρ)ˤclassͽ¬Ȥ
 */
double calCndCntCost(struct CndCnt *cnt, struct Cost *cost, int class){

  double totalCost=0;
  int i;

  for(i=0; i<ClassSize; i++){
    if(i!=class) totalCost+=cost->tbl[i][class]*cnt->tCnt[i];
  }
  return(totalCost);
}
