/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 :  2003/11/01 A.Fujimoto                                       */
/* 1.1 : autoconf,automakeб 2003/11/03 Y.Hamuro                            */
/* 1.2 : encodingб 2003/11/15 Y.Hamuro                                     */
/*============================================================================*/

#include <stdio.h>
#include <signal.h>
#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <iconv.h>
#include <pmmldtcls.h>

#define U 0	/* ̤ */
#define N 1	/*  */
#define S 2	/* ʸ */

struct mssComHelp comHelp={
  "pmmldtcls",    /* ޥ̾       */
  "1.2",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

static iconv_t *icidUX; /* iconv UTF-8 -> XMLtable Encoding Ѵϥɥ*/
static iconv_t *icidXU; /* iconv XMLtable Encoding -> UTF-8 Ѵϥɥ*/

/* PMML TreeΥΡɤι¤ */
struct PmNode{
  char *score;			/* scoreǼ */
  char *calFormula;		/* ʸǳǼ */
  struct mssCal **cal;          /* calFormulaɾmssCal¤Τset*/
                                /* surrogateξʣμˤʤ */
                                /* ߥ͡ȤNULLåȤƤ */
  int depth;			/* ΥΡɤο */
  struct PmNode *parent;	/* ƥΡɤؤΥݥ */
  struct PmNode *children;	/* ǽλҤɤؤΥݥ */
  struct PmNode *next;		/* ()ΥΡɤؤΥݥ */
};

/* defaultͤꤹ뤿ι¤(ܤοȤꤵ) */
struct DefaultValue{
  char *fldName;		/* ̾ */
  int   fldType;		/* ܥ(N or S) */
  char *value;			/* defaultͤǼ */
  int  null;                    /* ǥեͤʤϣ˥å*/
};

/**
 * XPath Υƥ(Хѿ)
 */
xmlXPathContextPtr XpathContext;

/**
 * Хѿ XpathContext Ͽ
 */
static void setXpathContext(xmlDocPtr doc){
  XpathContext=xmlXPathNewContext(doc);
}

/**
 * Хѿ XpathContext ΰ賫
 */
static void freeXpathContext(void){
  xmlXPathFreeContext(XpathContext);
}

/**
 * ȥΡ(node)顢XPATH(path)˥ޥå
 * Ρɤ򸡺ΥΡɥݥ󥿤֤
 * ޥåΡɤʤNULL֤
 */
static xmlNodePtr nextNodeByXPath(
  xmlNodePtr node,  /* ȥΡ */
  xmlChar *path){   /* XPath */

  xmlNodePtr next;

  xmlXPathObjectPtr result;

  /* XPathƥȤ˥ȥΡɤ */
  XpathContext->node=node;

  /* path˥ޥåΡɤθ */
  result  = xmlXPathEvalExpression(path, XpathContext);

  /* ޥåΡɤʤänext=NULL˥å */
  if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
    next = NULL;

  /* ޥåΡɤСΡɥꥹȤ0ǤФ*/
  }else{
    next = xmlXPathNodeSetItem(result->nodesetval, 0);
  }
  return(next);
}

/**
 * 饹̾(°̾)PMMLMiningFieldǤ(XMLtableencodig)
 * ʤNULL֤
 *   ex) <MiningField name="whatIdo" usageType="predicted"/>
 */
static char *getClassName(xmlDocPtr doc){
  char *className=NULL;
  xmlNodePtr node;

  node = nextNodeByXPath(xmlDocGetRootElement(doc),
                         "/PMML/TreeModel/MiningSchema/MiningField");

  while(node){
    if(xmlStrcmp(node->name,"MiningField")==0){
      if(xmlStrcmp("predicted",xmlGetProp(node,"usageType"))==0){
        /* 饹̾򥳥ԡ */
        className=mssEncoding(xmlGetProp(node,"name"),icidUX);
        break;
      }
    }
    node=node->next;
  }
  return(className);
}

/**
 * PMMLDataDictionaryĴ١̾(fldName)η֤
 * ͡ۿ:N,ʸ:S, ̾ʤor̤ξ:U
 * fieldUTF-8ǻꤹ롣
 */
static int getFieldType(xmlDocPtr doc, char *field){
  int type=U;
  xmlNodePtr node;

  node = nextNodeByXPath(xmlDocGetRootElement(doc),
                         "/PMML/DataDictionary/DataField");

  while(node){
    if(xmlStrcmp(node->name,"DataField")==0){
      if(xmlStrcmp(field,xmlGetProp(node,"name"))==0){
        if(xmlStrcmp("continuous",xmlGetProp(node,"optype"))==0){
          type=N;
          break;
        }else if(xmlStrcmp("categorical",xmlGetProp(node,"optype"))==0){
          type=S;
          break;
        }
      }
    }
    node=node->next;
  }
  return(type);
}

/**
 * XMLtableɤ߹ߡ°Υǥեͤꤷ֤
 *   °ξ硧Ԥʿ
 *   ʸ°ξ硧Ǥи¿ʸ
 *   ԤNULLξNULLͤ򥻥åȤ
 */
static struct DefaultValue *getDefaultValue(
  xmlDocPtr doc,         /* PMML document */	
  struct mssHeader *hdi, /* XMLtable Υإå¤ */
  struct mssFPR *fpr){   /* XMLtable ΥǡХåե */

  struct DefaultValue *defaultValue; /* ƹܤΥǥեͤǼ빽¤ */
  struct mssFldRec *fr;              /* -ԥХåե¤                */
  double *sum;                       /* °ͤ­٤ΰѿ   */
  int    *cnt;                       /* °(nullǤʤ)ιԿ       */
  struct mssHash **hash;             /* ʸ°ͤǼhash     */
  struct mssHashNode *hn;            /* 嵭hashΥΡɤ򼨤ѿ       */
  MssValue v;                        /* ʸ°(nullǤʤ)ιԿ     */
  struct mssHashNode *maxHn;         /* Ǥ¿hashNode               */
  int maxCnt;                        /* ¿                             */
  int i,j;
  char *encStr;

  /* ܿΥǥեΰ() */
  defaultValue=mssCalloc(sizeof(struct DefaultValue)*
                         (hdi->flds->cnt+1),"getDefaultValue");

  /* defaultValueΥߥ͡(fldName==NULL) */
  (defaultValue+hdi->flds->cnt)->fldName=NULL;

  /* ̾ȥפ򥻥å */
  for(i=0;i< hdi->flds->cnt;i++){

    /* ̾Υå */
    (defaultValue+i)->fldName=mssStrdup(MssFlds2name(hdi->flds,i));

    /* PMMLꡢιܤΥפ򥻥å */
    encStr=mssEncoding((defaultValue+i)->fldName,icidXU);
    (defaultValue+i)->fldType
       =getFieldType(doc,encStr);
    mssFree(encStr);
  }

  /*FldRec¤Τν*/ 
  fr=mssInitFldRec(hdi->flds->cnt);

  /* ǡƬԤ˰ư */
  mssSeekTopFPR(fpr);

  /* ͷѰѿΰ(ܿʬ) */
  sum=mssCalloc(sizeof(double)*hdi->flds->cnt,"defaultValue");
  cnt=mssCalloc(sizeof(int   )*hdi->flds->cnt,"defaultValue");

  hash=mssCalloc(sizeof(struct mssHash *)*hdi->flds->cnt,"defaultValue");
  for(i=0;i< hdi->flds->cnt;i++){
    *(hash+i)=mssInitHash(101); /* hash¤Τν */
  }
  mssVinit(&v,INT);      /* (=0) */

  /* ܤ٥defaultͷν */
  while(EOF!=mssReadFldRec(fpr,fr)){

    /* ܿLoop */
    for(i=0;i< hdi->flds->cnt;i++){

      /* ܥ׸ */
      switch((defaultValue+i)->fldType){
      case N:                             /* ͷξ */
        if(!MssIsNull(*(fr->pnt+i))){
          (*(sum+i))+=atof(*(fr->pnt+i));
          (*(cnt+i))++;
        }
        break;

      case S:                             /* ʸ󷿤ξ */
        if(!MssIsNull(*(fr->pnt+i))){
          /* ܤ(ʸ)ϥåɽϿ                      */
          /* ϥåɽˤʤСΡɤɲäΥΡɤ֤*/
          /* ϥåɽˤСΥΡɤ֤                        */
          hn=mssHashInsertAdd(*(hash+i),*(fr->pnt+i),v);

          /* 򥤥󥯥Ȥ */
          hn->val.v.i++;
        }
        break;
      }
    }
  }

  /* ǥեͤꤹ */
  for(i=0;i< hdi->flds->cnt;i++){

    switch((defaultValue+i)->fldType){
    /* ͷξ */
    case N:                                  /* ͷξ */
      /* ʿͤǥեͤȤϿ(ʸȤ) */
      /* ƤιԤNULLξnullե饰򤿤Ƥ         */
      if(*(cnt+i)!=0){
        (defaultValue+i)->value=mssFtoA((*(sum+i))/(double)(*(cnt+i)));
      }else{
        (defaultValue+i)->value=mssStrdup(MssNullStr);
      }
      break;

      case S:                             /* ʸ󷿤ξ */
      /* Ǥ¿ʸܤͤhashNodeõ */
      maxCnt=0;
      maxHn =NULL;
      for(j=0; j<(*(hash+i))->hashVal; j++){
        if( NULL != (hn=*((*(hash+i))->node+j)) ){
          while(hn!=NULL){
            if(hn->val.v.i > maxCnt){
              maxCnt=hn->val.v.i;
              maxHn =hn;
            }
            hn=hn->next;
          }
        }
      }

      /* Ǥ¿ʸܤͤǥեͤȤѤ */
      /* ƤιԤNULLξ(maxCnt==0)nullե饰򤿤Ƥ */
      if(maxCnt!=0){
        (defaultValue+i)->value=mssStrdup(maxHn->str);
      }else{
        (defaultValue+i)->value=mssStrdup(MssNullStr);
      }
    }
  } 
 
  mssFreeFldRec(fr);
  return(defaultValue);
}

/**
 * ǥեͤɽ (for debug)
 * ڽϥץ
 * field[0]: name=temperature, value=58.333333, null=0
 * field[1]: name=humidity, value=68.333333, null=0
 * field[2]: name=windy, value=false, null=0
 * field[3]: name=outlook, value=rain, null=0
 */
void showDefaultValue(struct DefaultValue *defaultValue){
  int i;

  if(defaultValue==NULL) return;

  /* ߥ͡fldNameNULL */
  for(i=0;(defaultValue+i)->fldName!=NULL;i++){
    printf("field[%d]: type=%d, name=%s, value=%s\n",i,
                                    (defaultValue+i)->fldType,
                                    (defaultValue+i)->fldName,
                                    (defaultValue+i)->value);
  }
}

/**
 * ǥեΰ賫
 */
static void freeDefaultValue(struct DefaultValue *defaultValue){
  int i;

  if(defaultValue==NULL) return;

  /* ߥ͡fldNameNULL */
  for(i=0;(defaultValue+i)->fldName!=NULL;i++){
    mssFree((defaultValue+i)->fldName);
    mssFree((defaultValue+i)->value);
  }
}

/**
 * ̾calFormulacat
 * ̾"$(̾)"Τ褦ˡ̤Ǥ
 * ̤ʤС̾"-""+"ʤɤα黻ҵ椬ˡ̾
 * ΰȤƤǤϤʤ黻ҤȤɾƤޤᡣ
 */
void catFieldName(struct mssStrings *calFormula, char *fldName){
  mssCatStrings(calFormula,"$(");
  mssCatStrings(calFormula,fldName);
  mssCatStrings(calFormula,")");
}

/**
 * compoundPredicateα黻Ҥcat롣
 * ξϤʤˤ⤷ʤ
 *   operatorNULLξ(compoundPredicateǤʤ)
 *   compoundPredicateκǽμǤ
 */
static void catOperator(
  struct mssStrings *calFormula,
  char *operator){

  /* operatorNULLϡcompoundPredicateǤʤȤ */
  if(operator==NULL) return;

  /* compoundPredicateκǽμλoperatorɬפʤΤreturn */
  if(calFormula->str==NULL) return;
  if(*(calFormula->str+calFormula->cnt-1)=='(') return;

  /* conpoundPredicate黻(and,or,xor,surrogate) */
  /* mssCalǤα黻ҤѴcat                     */
        if(strcmp(operator,"and")==0){
    mssCatStrings(calFormula," && ");
  }else if(strcmp(operator,"or" )==0){
    mssCatStrings(calFormula," || ");
  }else if(strcmp(operator,"xor")==0){
    mssCatStrings(calFormula," <> ");

  /* surrogateξϡ"\n"ǶڤꡢmssCal˥ѥ뤹 */
  /* Ʒ׻̡ɾǼ                              */
  }else if(strcmp(operator,"surrogate")==0){
    mssCatStrings(calFormula,")\n(");

  /* 嵭ʳoperatorꤵƤХ顼λ */
  }else{
    mssShowErrMsg("unknown booleanOperator in ConpoundPredicate");
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * simplePredicateɾʸ󼰤Ȥɲä롣
 * operatorconpoundPredicateξ˻ꤵ졢ʳξNULL
 */
static void catSimplePredicate(
  struct mssStrings *calFormula, /* simplePredicateɲä */
  xmlNodePtr node,
  xmlDocPtr doc){

  char *fldName;		/* ̾Ǽptr */
  int   fldType;		/* ܤΥ */

  /* ̾Υå */
  fldName = mssStrdup(xmlGetProp(node,"field"));

  /* Τμ̤Ǥ */
  mssCatStrings(calFormula,"(");

  /* isMissing: isNull()ؿѴ */
  if(xmlStrcmp("isMissing",xmlGetProp(node,"operator"))==0){
    mssCatStrings(calFormula,"isNull(");
    catFieldName(calFormula,fldName);
    mssCatStrings(calFormula,")");
  }

  /* isNotMissing: not(isNull())Ѵ */
  else if(xmlStrcmp("isNotMissing",xmlGetProp(node,"operator"))==0){
    mssCatStrings(calFormula,"not(isNull(");
    catFieldName(calFormula,fldName);
    mssCatStrings(calFormula,"))");

  /* ʲmissingValueϢʳμ */
  /* "$̾ operator Value")    */
  } else {
    /* ̾cat */
    catFieldName(calFormula,fldName);

    /* ܤΥפ */
    fldType = getFieldType(doc,fldName);

    /* equal:ͤ==,ʸ-eq */
    if(xmlStrcmp("equal",xmlGetProp(node,"operator"))==0) {
      if(fldType==N) mssCatStrings(calFormula," == " );
      else           mssCatStrings(calFormula," -eq ");
    }

    /* notEqual:ͤ<>,ʸ-ne */
    else if(xmlStrcmp("notEqual",xmlGetProp(node,"operator"))==0){
      if(fldType==N) mssCatStrings(calFormula," <> " );
      else           mssCatStrings(calFormula," -ne ");
    }

    /* lessThan:ͤ<,ʸ-lt */
    else if(xmlStrcmp("lessThan",xmlGetProp(node,"operator"))==0){
      if(fldType==N) mssCatStrings(calFormula," < "  );
      else           mssCatStrings(calFormula," -lt ");
    }

    /* lessOrEqual:ͤ<=,ʸ-le */
    else if(xmlStrcmp("lessOrEqual",xmlGetProp(node,"operator"))==0){
      if(fldType==N) mssCatStrings(calFormula," <= " );
      else           mssCatStrings(calFormula," -le ");
    }

    /* greaterThan:ͤ>,ʸ-gt */
    else if(xmlStrcmp("greaterThan",xmlGetProp(node,"operator"))==0){
      if(fldType==N) mssCatStrings(calFormula," > "  );
      else           mssCatStrings(calFormula," -gt ");
    }

    /* greaterOrEqual:ͤ>=,ʸ-ge */
    else if(xmlStrcmp("greaterOrEqual",xmlGetProp(node,"operator"))==0){
      if(fldType==N) mssCatStrings(calFormula," >= " );
      else           mssCatStrings(calFormula," -ge ");
    }

    /* ʸܤӤξϡ(value)ϥ֥륯ĤǤ */
    /* ͹ܤӤξϡ(value)ϤΤޤ޽           */
    /*   ex) $(outlook) -eq "sunny"                              */
    /*       $(temperature) > 50                                 */
    if(fldType==S) mssCatStrings(calFormula,"\"");
    mssCatStrings(calFormula,xmlGetProp(node,"value"));
    if(fldType==S) mssCatStrings(calFormula,"\"");
  }

  /* Τμ̤Ǥ */
  mssCatStrings(calFormula,")");

  /* ΰ賫 */
  mssFree(fldName);
}

/**
 * simpleSetPredicateʸ(<Array>)ɾʸ󼰤Ȥɲä롣
 * ex)
 * <Array>sunny rain</Array> -> "sunny,rain"
 */
static void catArray(
  struct mssStrings *calFormula, /* Arrayɲä */
  xmlNodePtr node,
  xmlDocPtr doc){

  xmlNodePtr arrayNode; /* "Array" */
  xmlChar    *arrayStr; /* "Array"Ǥ */
  xmlChar    *tokElement;

  /* nodeʲArrayΡɤ򸡺 */
  arrayNode = nextNodeByXPath(node,"./Array");
  if(arrayNode==NULL){
    mssShowErrMsg("threre is no array under the node: %s",
                                                     xmlGetNodePath(node));
    mssEnd(mssErrorNoDefault);
  }

  /* Arrayͤ򥻥åȤ
     <Array>sunny rain</Array> -> "sunny rain" */
  arrayStr=xmlNodeListGetString(doc,arrayNode->xmlChildrenNode,1);

  /* ȡڤФcalFormula˥޶ڤǥåȤ */
  tokElement=strtok(arrayStr," ");
  while(tokElement!=NULL){
    mssCatStrings(calFormula,",");
    mssCatStrings(calFormula,tokElement);
    tokElement=strtok(NULL,"\n");
  }

  xmlFree(arrayStr);
}

/**
 * simpleSetPredicateɾʸ󼰤Ȥɲä롣
 * operatorconpoundPredicateξ˻ꤵ졢ʳξNULL
 */
static void catSimpleSetPredicate(
  struct mssStrings *calFormula, /* simplePredicateɲä */
  xmlNodePtr node,
  xmlDocPtr doc){

  char *fldName;		/* ̾Ǽptr */

  /* ̾Υå */
  fldName = mssStrdup(xmlGetProp(node,"field"));

  /* Τμ̤Ǥ */
  mssCatStrings(calFormula,"(");

  /* isIn: Not Supported(衢isNotؿбͽ) */
  if(xmlStrcmp("isIn",xmlGetProp(node,"booleanOperator"))==0){
    mssCatStrings(calFormula,"isIn(");
    catFieldName(calFormula,fldName);
    catArray(calFormula,node,doc);
    mssCatStrings(calFormula,")");

  /* isNotIn: Not Supported(衢not(isNot)ؿбͽ) */
  }else if(xmlStrcmp("isNotIn",xmlGetProp(node,"booleanOperator"))==0){
    mssCatStrings(calFormula,"not(isIn(");
    catFieldName(calFormula,fldName);
    catArray(calFormula,node,doc);
    mssCatStrings(calFormula,"))");
  }

  /* Τμ̤Ǥ */
  mssCatStrings(calFormula,")");

  /* ΰ賫 */
  mssFree(fldName);
}

/**
 * <True/>"(1==1)"ιȤϿ롣
 * operatorconpoundPredicateξ˻ꤵ졢ʳξNULL
 */
static void catTruePredicate(struct mssStrings *calFormula){
  mssCatStrings(calFormula, "(1==1)");
}

/**
 * <False/>"(1==2)"ιȤϿ롣
 */
static void catFalsePredicate(struct mssStrings *calFormula){
  mssCatStrings(calFormula, "(1==2)");
}

/**
 * nodeλҤˤƺǽ˽иPredicateΡɤ֤
 * PredicateΡɤʤХ顼λ
 */
xmlNodePtr getFirstPredicateNode(xmlNodePtr node){
  xmlNodePtr result;
  result=nextNodeByXPath(node,
                       "child::True               | \
                        child::False              | \
                        child::SimplePredicate    | \
                        child::SimpleSetPredicate | \
                        child::CompoundPredicate" );

  /* PredicateʤХ顼λ */
  if(!result){
    mssShowErrMsg("threre is no predicate under the Node: %s",
                                                     xmlGetNodePath(node));
    mssEnd(mssErrorNoDefault);
  }
  return(result);
}

/**
 * nodeμηΡ(followin-sibling)Ǻǽ˽иPredicateΡɤ֤
 * PredicateΡɤʤNULL֤
 */
xmlNodePtr getNextPredicateNode(xmlNodePtr node){
  xmlNodePtr result;
  result=nextNodeByXPath(node,
                       "following-sibling::True               | \
                        following-sibling::False              | \
                        following-sibling::SimplePredicate    | \
                        following-sibling::SimpleSetPredicate | \
                        following-sibling::CompoundPredicate" );
  return(result);
}

static void catCompoundPredicate(
  struct mssStrings *calFormula, /* compoundPredicateɲä */
  xmlNodePtr node,
  xmlDocPtr doc,
  char *operator){               /* compoundPredicateξα黻 */

  while(node){
    /* for debug */
    /* printf("path=%s\n",xmlGetNodePath(node)); */

    /* compoundPredicateξ硢ƵŪ˥ΡɤɾϿ */
    if(xmlStrcmp(node->name,"CompoundPredicate")==0){
      mssCatStrings(calFormula,"("); /* ̤Ǥ */
      catCompoundPredicate(calFormula,getFirstPredicateNode(node),doc,
                                        xmlGetProp(node,"booleanOperator"));
      mssCatStrings(calFormula,")"); /* ̤Ǥ */

    /* compoundPredicateʳξ */
    }else{
      /* ɬפǤcompoundPredicateα黻ҤĤ */
      catOperator(calFormula, operator);

      /* TrueñΤξ硢"1==1"Ȥ */
      if(xmlStrcmp(node->name,"True")==0){
        catTruePredicate(calFormula);
      }

      /* FalseñΤξ硢"1==2"Ȥ */
      else if(xmlStrcmp(node->name,"False")==0){
        catFalsePredicate(calFormula);
      }

      /* simplePredicateξ硢ɾϿ */
      else if(xmlStrcmp(node->name,"SimplePredicate")==0){
        catSimplePredicate(calFormula,node,doc);
      }

      /* simpleSetPredicateξ硢ɾϿ */
      else if(xmlStrcmp(node->name,"SimpleSetPredicate")==0){
        catSimpleSetPredicate(calFormula,node,doc);
      }
    }

    /* ηPredicate˰ư */
    node=getNextPredicateNode(node);
  }
}

/**
 * Predicateʸ󼰤Ѵʸ֤
 */
static char *getPredicate(xmlNodePtr node,xmlDocPtr doc){
  struct mssStrings *calFormula; /* predicateʸ󼰤ǳǼ */
  char *retStr;                  /* ǽŪ֤ʸ */
  xmlNodePtr firstPredicateNode; /* "Node"ǲκǽPredicateΡ */

  /* Stringsν */
  calFormula=mssInitStrings();

  /* ǽPredicate */
  firstPredicateNode=getFirstPredicateNode(node);

  /* Predicateʸ(calFormula)ȤϿ */
  catCompoundPredicate(calFormula,firstPredicateNode,doc,NULL);

  /* calFormulaʸФΥɥ쥹֤ */
  retStr=mssEncoding(calFormula->str,icidUX);
  mssFreeStrings(calFormula);
  return(retStr);
}

/**
 * PMML Tree
 *              pmParent
 *               /
 *              / parent
 *             /
 *          pmNode (depth, score, predicate, scoreDist)
 *           //       \            \
 * children // parent  \ parent     \ parent
 *         //           \            \
 *      pmNext -----> pmNext -----> pmNext -----> NULL(勵ߥ͡)
 *       //\    next   //\    next   //\
 *      //  \         //  \         //  \
 */
static struct PmNode *makeTree(
  xmlDocPtr doc,
  xmlNodePtr node,
  struct PmNode *pmParent){

  xmlNodePtr next;             /* PMMLɥȤnode򤿤뤿ptr */
  struct PmNode *pmNode=NULL;  /* ϿPmNode */
  struct PmNode **pmNext=NULL; /* children or nextΡɤ򤿤뤿ptr */

  /* PMML Tree ΰݡ */
  pmNode = mssCalloc(sizeof(struct PmNode),"makeTree");

  /* ΡɤοϿ */
  if(pmParent==NULL) pmNode->depth = 0;
  else               pmNode->depth = pmParent->depth+1;

  /* (饹ܤ)Ͽ */
  pmNode->score = mssEncoding(xmlGetProp(node,"score"),icidUX);

  /* Predicate(Ｐ)mssCalʸ󼰤ȤϿ */
  pmNode->calFormula = getPredicate(node,doc);

  /* ScoreDistribution Ͽ (not yet)*/
  /*pmNode->scoreDist = getScoreDist();*/

  /* ȥΡɤοƥΡɤϿ */
  pmNode->parent = pmParent;

  /* γؤNodeƷΡɤϿ */
  next=node->children;
  pmNext=&pmNode->children;
  while(next!=NULL){
    if(xmlStrcmp(next->name,"Node")==0){
      *pmNext=makeTree(doc,next,pmNode);
      pmNext=&((*pmNext)->next);
    }
    next=next->next;
  }
  *pmNext=NULL; /* ΡɤΥߥ͡ */
  return(pmNode);
}

/**
 * calFormulamssCal¤˥ѥ뤷åȤ롣
 * calFormulasurrogateξʣμ¸ߤ뤿ᡢ줾줴Ȥ
 * mssCal׻֤ۤ
 */
struct mssCal **getCalList(char *calFormula, struct mssHeader *hdi){
  struct mssCal **cal=NULL; /* mssCal */
  int cnt=0;                /* ֹ */
  char *dupCalFormula;      /* ꥸʥcatFormulaΥԡ */
  char *formula;            /* ȡʬѰѿ */

  /* ꥸʥѹʤ˥ԡѤ */
  dupCalFormula=mssStrdup(calFormula);
 
  /* surrogateθơ\nǥȡʬ䤹 */
  /* surrogateǤʤХȡοϣǤ */
  formula=strtok(dupCalFormula,"\n");
  while(formula!=NULL){
    /* ΰ */
    cal=mssRealloc(cal,sizeof(struct mssCal *)*(cnt+2),"getCalList");

    /* ׻ɾ */
    *(cal+cnt)=mssCalCompile(formula,hdi);
    cnt++;
    formula=strtok(NULL,"\n");
  }

  /* ߥ͡ɲ */
  *(cal+cnt)=NULL;

  mssFree(dupCalFormula);

  return(cal);
}

/**
 * PMML treeƵŪʸǤμ(calFormula)mssCal˥ѥ뤹롣
 */
static void setCal(struct PmNode *node, struct mssHeader *hdi){

  /*Ρɤ򤿤äƤ*/
  while(node!=NULL){
    /*ȥåץΡɤϲɽʤ*/
    if(node->depth!=-1){
      node->cal=getCalList(node->calFormula, hdi);
    }
    /*ҥΡɤкƵƽ*/
    if(node->children!=NULL) setCal(node->children,hdi);

    /*ηΡɤ*/
    node=node->next;
  }
}

/**
 * PMML Treeɽ(for debug)
 *   calFlg=1 mssCalɽ calFlg=0ɽ
 * ڽϥץ
 * rsl=will play, surFlg=0, depth=0
 *   +- form=1
 *  rsl=will play, surFlg=0, depth=1
 *    +- form=$(outlook) -eq "sunny"
 *    rsl=will play, surFlg=0, depth=2
 *      +- form=$(temperature) < 90 && $(temperature) > 50
 *      rsl=will play, surFlg=0, depth=3
 *        +- form=$(humidity) < 80
 *      rsl=no play, surFlg=0, depth=3
 *        +- form=$(humidity) >= 80
 *    rsl=no play, surFlg=0, depth=2
 *      +- form=$(temperature) >= 90 || $(temperature) <= 50
 *  rsl=may play, surFlg=0, depth=1
 *    +- form=$(outlook) -eq "overcast" || $(outlook) -eq "rain"
 *    rsl=may play, surFlg=0, depth=2
 *      +- form=$(temperature) > 60 && $(temperature) < 100 && $(outlook) -eq "overcast" && $(humidity) < 70 && $(windy) -eq "false"
 *    rsl=no play, surFlg=0, depth=2
 *      +- form=$(outlook) -eq "rain" && $(humidity) < 70
 */
static void showTree(struct PmNode *node, int calFlg){
  int i;
  struct mssCal **cal;

  /*Ρɤ򤿤äƤ*/
  while(node!=NULL){
    /*ȥåץΡɤϲɽʤ*/
    if(node->depth!=-1){
      for(i=0; i<node->depth; i++) printf("  "); /*ǥ*/
      printf("score=%s, depth=%d\n", node->score,node->depth);
      for(i=0; i<node->depth; i++) printf("  "); /*ǥ*/
      printf("  +- form=%s\n",node->calFormula);
      if(calFlg){
        cal=node->cal;
        while(*cal!=NULL){
          mssCalShowTree(*cal,0);
          cal++;
        }
      }
    }
    /*ҥΡɤкƵƽ*/
    if(node->children!=NULL) showTree(node->children, calFlg);

    /*ηΡɤ*/
    node=node->next;
  }
}

/**
 * pmTreeΰγ
 */
static void freePmTree(struct PmNode *node){
  struct mssCal **cal;
  struct PmNode *next;

  /*Ρɤ򤿤äƤ*/
  while(node!=NULL){
    /*ȥåץΡɤϲɽʤ*/
    if(node->depth!=-1){

      mssFree(node->score);
      mssFree(node->calFormula);

      /* mssCalΰγ */
      cal=node->cal;
      while(*cal!=NULL){
        mssCalFree(*cal);
        cal++;
      }
      mssFree(node->cal);
    }
    /*ҥΡɤкƵƽ*/
    if(node->children!=NULL){
      freePmTree(node->children);
    }

    /*ߥΡɤηΡɤ*/
    next=node->next;
    mssFree(node);
    node=next;
  }
}
   
struct mssFldRec *complement(
  struct mssFldRec *fr,
  struct DefaultValue *defaultValue){

  struct mssFldRec *nulfr; /* 䴰ѹԥХåե¤ */
  int i;

  nulfr=mssInitFldRec(fr->fldCnt);
  nulfr->chrCnt=fr->chrCnt;
  nulfr->eof=fr->eof;

  for(i=0;i<nulfr->fldCnt;i++){
    /* nullädefault֤ͤ */
    if(MssIsNull(*(fr->pnt+i))){
      *(nulfr->pnt+i)=(defaultValue+i)->value;
      //nulfr->chrCnt=nulfr->chrCnt-strlen(*(fr->pnt+i))+strlen(dStr[i].value);
      //nulCnt++;
    }else{
      *(nulfr->pnt+i)=*(fr->pnt+i);   
    }
  }

  return(nulfr);
}


/**
 * PMM treeȤͿ줿ǡ(fr)Υ饹ͽ¬
 */
static char *predict(
  struct PmNode *node,                /* PMMLtree           */
  struct mssFldRec *fr,               /* ͽ¬оݥǡ     */
  struct DefaultValue *defaultValue){ /* NULL䴰ѥǡ */

  MssValue rsl;             /* ׻           */
  struct mssCal **cal;      /* ׻         */
  struct mssFldRec *compfr; /* NULL䴰ǡ */

  /* ׻¹ */
  cal=node->cal;
  while(*cal!=NULL){     /* surrogateξʣ롼,¾ϣ */
    rsl = mssCalculate(*cal, fr->pnt);
    if(!rsl.nul) break;  /* ̤NULLǤʤbreak */
    cal++;
  }

  /* predicateǤȽԲ(NULL)ξNULLͤ䴰ƺٻߤ */
  if(rsl.nul==1){
    /* NULLͤǥեͤ䴰 */
    compfr=complement(fr,defaultValue);

    /* ١׻¹ */
    cal=node->cal;
    while(*cal!=NULL){
      rsl = mssCalculate(*cal, compfr->pnt);
      if(!rsl.nul) break;  /* ̤NULLǤʤbreak */
      cal++;
    }
  }

  /* 䴰ƤȽԲ(NULL)ξNULL(*)֤ */
  if(rsl.nul==1){
    return("*");
  }

  if(rsl.v.d==1){	       /* Ƚ̤1(˥ޥå)ä */
    if(node->children==NULL){  /* leafǤ */
      return(node->score);
    }else{
      node=node->children;
    }
  }else{		       /* ʳ(0:˥ޥå)ä */
    if(node->next==NULL){      /* ηΡɥ롼ˤפʤä */
      return(node->parent->score);
    }else{
      node=node->next;
    }
  }

  /* Ƶƽ */
  return(predict(node,fr,defaultValue));
}

/**
 * ǥߥʸ"_"Ѵ(ʸΰݤ)ptr֤
 */
char *repDelim(char *str){
  char *repStr; /* Ѵ줿ʸΰ */
  char *pos;    /* repStr */

  repStr=mssStrdup(str);

  pos=repStr;
  while(*pos!='\0'){
    if(*pos==MssFieldDelim || *pos=='\n'){
      *pos='_';
    }
    pos++;
  }
  return(repStr);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* xtե                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* PMMLե                                                           */
/*----------------------------------------------------------------------------*/
  MssOptINF optPML={
    OINF,   /* ץ󥿥                                             */
    "p",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    PMLT,   /* ΥץΥȥ(Helpɽ)                         */
    PMLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̾                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* ץ󥿥                                             */
    "a",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե(ʸ)                                           */
    1,      /* ޤǶڤǿκ                             */
    1,      /* ǤʸĹκǾ                                     */
    MssFieldMaxLen,/* ǤʸĹκ                              */
    0,      /* 1:Ǥ˥Ǥ,0:Բ  ex) aaaa:xxxxx            */
    FNMT,   /* ΥץΥȥ(Helpɽ)                         */
    FNMC    /* ΥץΥ(Helpɽ)                         */
  }; 

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={ 
    OOTF,   /* ץ󥿥                                             */ 
    "o",    /* (ʣʸԲ)                                   */ 
    0,      /* 0:ץ, 1:ɬ                                         */ 
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={ 
    OFLG,   /* ץ󥿥                                             */ 
    "z",    /* (ʣʸԲ)                                   */ 
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */ 
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optINF,&optPML,&optFNM,&optOTF,&optZIP,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssFPR    *fpr; 	/* ϥե빽¤                */
  struct mssFPR    *fpr2;	/* ׻ϥե빽¤	     */
  struct mssFPW    *fpw; 	/* ϥե빽¤                */
  struct mssHeader *hdi; 	/* ϥե<head>Ǽ¤*/
  struct mssHeader *hdo; 	/* ϥե<head>Ǽ¤*/
  struct mssFldRec *fr; 	/* -ԥХåե¤             */

  xmlDocPtr	doc;		/* XML DocumentΥݥ            */
  xmlNodePtr	top;		/* XML NodeΥȥåץݥ          */
  xmlNodePtr	cur;		/* XML NodeΥȥݥ        */
  char		*className;	/* ɲä륯饹ι̾            */
  int           classType;      /* 饹(°)Υ          */
  struct	PmNode *pmTop; 	/* ĥ꡼Υ롼ȥΡ        */
  char *rslStr;                 /* ׻ 			     */
  char *encStr;                 /* encodingѰѿ   	     */

  struct DefaultValue *defaultValue;    /* ͤNULLͤλѤǥե */
/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν         */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                           */
  mssSetOption(opt,argc,argv);       /* ޥɥץ         */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ             */
  fpr2=mssOpenFPR(optINF.str,4);     /* ׻ϥե륪ץ       */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                 */
  mssSkipToBody(fpr2);		     /* ׻ѹ¤Τϥإåskip     */

  /* UTF-8 -> XMLtableEncodingѴiconvץ */
  icidUX=iconv_open(hdi->xmlenc,"UTF-8");
  if((int)icidUX==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* XMLtable -> UTF-8EncodingѴiconvץ */
  icidXU=iconv_open("UTF-8",hdi->xmlenc);
  if((int)icidXU==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* PMMLեperse(xmlDoc¤ΤؤΥå) */
  doc = xmlParseFile(optPML.str);
  if(doc == NULL) {
    mssShowErrMsg("It seems that %s is not a xml data.",optPML.str);
    mssEnd(mssErrorNoDefault);
  }

  /* XPathΥƥ(Хѿ:XpathContext)ꤹ */
  setXpathContext(doc);

  /* PMML TreeΥ롼ȥΡɤ */
  top = xmlDocGetRootElement(doc);
  if(top==NULL){                
    xmlFreeDoc(doc);              
    mssShowErrMsg("PMML document is empty");
    mssEnd(mssErrorNoDefault);
  }      

  /* 饹(°)ι̾γ */
  className=getClassName(doc);
  if(className==NULL){
    mssShowErrMsg("cannot find class field in PMML file");
    mssEnd(mssErrorNoDefault);
  }

  /* 饹(°)Υפγ */
  /* ƥ°ǤʤФʤʤ */
  encStr=mssEncoding(className, icidXU);
  classType=getFieldType(doc,encStr);
  if(classType!=S){
    mssShowErrMsg("type of class field must be categorical in PMML file");
    mssEnd(mssErrorNoDefault);
  }
  mssFree(encStr);

  /* for debug */
  /* printf("className=%s %d\n",className,classType); */

  /* ȥΡɤ"/PMML/TreeModel/Node" */
  cur = nextNodeByXPath(top,"/PMML/TreeModel/Node");
  if(cur==NULL){
    mssShowErrMsg("cannot find Node element in PMML file");
    mssEnd(mssErrorNoDefault);
  }

  /* PMMLNode(ĥ꡼)顢Ѥ(pmTree) */
  pmTop=makeTree(doc,cur, NULL);

  /* pmTreeƵŪʸ(calFormula)mssCal˥ѥ뤹롣*/
  setCal(pmTop, hdi);

  /* for debug ǴʰɽǾܺɽ */
  /* showTree(pmTop,0); */

  /* NULLͤͽ¬ΤγƹܤΥǥեͤμ */
  defaultValue=getDefaultValue(doc,hdi,fpr);

  /* for debug */
  /* showDefaultValue(defaultValue); */

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
/*ϥإåν(ȥΥ )*/ 
  hdo=mssInitCpyHeader(hdi);
 
  /*ϥإåܤɲ*/ 
  mssAddFieldsByFields(hdo->flds,hdi->flds);
  
  /*̾ɲ*/ 
  if(optFNM.set){
    mssAddFieldsByStrList(hdo->flds,optFNM.strList,optFNM.cnt);
  }else{
    mssAddFieldsByStr(hdo->flds,className);
  }

  /*ɸϥץ+إåν*/ 
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); 
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*FldRec¤Τν*/ 
  fr=mssInitFldRec(hdi->flds->cnt);  

  /* ǡƬԤ˰ư */
  mssSeekTopFPR(fpr);
 
  while(EOF!=mssReadFldRec(fpr,fr)){
    /* Ϸȥå */
    mssGV.inCnt++; 

    /* ͽ¬¹ */
    rslStr=predict(pmTop,fr,defaultValue);

    /* ǥߥʸޤޤƤѴ */
    rslStr=repDelim(rslStr);
   
    /* ϥǡԽ񤭽Ф */ 
    mssWriteFld(fr->pnt, fr->fldCnt, MssFieldDelimStr, fpw);
  
    /* ׻̽ */ 
    mssWriteStr(rslStr,fpw); 
    mssWriteRet(fpw); 

    /* ΰ賫 */
    mssFree(rslStr);

    /* Ϸȥå */
    mssGV.outCnt++; 
  }

  mssFreeFldRec(fr);  
  freePmTree(pmTop);
  if(icidUX!=NULL) iconv_close(icidUX);  /* icidΥ*/
  if(icidXU!=NULL) iconv_close(icidXU);  /* icidΥ*/

/*----------------------------------------------------------------------------*/
/* եå&λ                                                      */
/*----------------------------------------------------------------------------*/
  freeXpathContext();              /* XPathƥȤΰ賫 */
  freeDefaultValue(defaultValue);  /* ǥեΰγ */
  xmlFreeDoc(doc);        /* PMMLեΰ賫     */
  mssWriteFooter(fpw);    /* եåν             */ 
  mssCloseFPR(fpr);       /* ϥեΥ     */
  mssCloseFPR(fpr2);      /* ϥեΥ     */
  mssCloseFPW(fpw);       /* ϥեΥ     */  
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeHeader(hdo);     /* ϥإåΰ賫         */ 
  mssFreeOption(opt);     /* ץΰγ       */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
