//  ץǤ
//  ղ Ver.4 
//  '2000/10/03
//
typedef unsigned long **matrix;
typedef double **dmatrix;
typedef char **cmatrix;

matrix mat(unsigned long m,unsigned long n)
{
	unsigned long i;
	matrix x;

	x=(unsigned long **)malloc(sizeof(void *)*(m+1));
	if(x==NULL)
		return NULL;
	for(i=0;i<m;i++){
		x[i]=(unsigned long *)malloc(sizeof(unsigned long)*n);
		if(x[i]==NULL){
			while(--i>=0)
				free(x[i]);
		free(x);
		return NULL;
		}
	}
	x[m]=NULL;
	return x;
}

dmatrix dmat(unsigned long m,unsigned long n)
{
	unsigned long i;
	dmatrix x;

	x=(double **)malloc(sizeof(void *)*(m+1));
	if(x==NULL)
		return NULL;
	for(i=0;i<m;i++){
		x[i]=(double *)malloc(sizeof(double)*n);
		if(x[i]==NULL){
			while(--i>=0)
				free(x[i]);
		free(x);
		return NULL;
		}
	}
	x[m]=NULL;
	return x;
}

cmatrix cmat(unsigned long m,unsigned long n)
{
	unsigned long i;
	cmatrix x;

	x=(char **)malloc(sizeof(void *)*(m+1));
	if(x==NULL)
		return NULL;
	for(i=0;i<m;i++){
		x[i]=(char *)malloc(sizeof(char)*n);
		if(x[i]==NULL){
			while(--i>=0)
				free(x[i]);
		free(x);
		return NULL;
		}
	}
	x[m]=NULL;
	return x;
}

void delmat(matrix x)
{
	matrix a;

	a=x;
	while(*a!=NULL)
		free(*a++);
	free(x);
}


void delcmat(cmatrix x)
{
	cmatrix a;

	a=x;
	while(*a!=NULL)
		free(*a++);
	free(x);
}

void dispmat(matrix a,unsigned long x,unsigned long y)
{
	unsigned long i,j;

	for(i=0;i<x;i++){
		for(j=0;j<y;j++){
			printf("%lu ",a[i][j]);
		}
		printf("\n");
	}
	printf("\n");
}

void dispcmat(cmatrix a,unsigned long x,unsigned long y)
{
	unsigned long i,j;

	for(i=0;i<x;i++){
		for(j=0;j<y;j++){
			printf("%d ",a[i][j]);
		}
		printf("\n");
	}
	printf("\n");
}

void fdispcmat(cmatrix a,unsigned long x,unsigned long y,FILE *fp)
{
	unsigned long i,j;

	for(i=0;i<x;i++){
		for(j=0;j<y;j++){
			fprintf(fp,"%d ",a[i][j]);
		}
		fprintf(fp,"\n");
	}
	fprintf(fp,"\n");
}
