// Original Source Code Copyrighted by Akihiro Inokuchi in 1999.
// Modified and Extended to Introduce PMML Interface,and the
// Extented Part Copyright by Yuki Mitsunaga and Takashi Washio in 2004
//  ΥץबᥤǤ
//
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xmlmemory.h>
#include <libxml/tree.h>
#include <musashi.h>
#include <pmmlagmHelp.h>

struct mssComHelp comHelp={
  "agm",          /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};
extern struct mssGlobalVariables mssGV;



#define trie_size 1000000
#define entries_size 100000
#define Transaction_num 10000
#define ESFG 20 /*expected size of maximal frequent graphs*/
char g_type;/*type=1 => directed,type=2 => undirected*/
unsigned long ntypenum;
char ltypenum,encoding[40],copyright[256],modelname[256]="",description[256]="",wfp[256];

#include "matgen.c"
#include "gauss.c"
#include "defstruct.c"
#include "readdata2.c"
#include "apriori4.c"
#include "treesize.c"
#include "disppatn1_2.c"

unsigned long trie_pos;
unsigned long transaction_num=Transaction_num;

cmatrix Adj1,Adj2,Space,Tramat,Dummy0;

struct graph transaction[Transaction_num];
struct trie_node trie[trie_size];

int main(int argc, char *argv[])
{
	unsigned long size=200;
	double sup;
	char filename[256],opf[256];


/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptDBL optSUP={
    ODBL,   /* ץ󥿥                                             */
    "S",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    30,     /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    100,    /*                                                        */
    SUPT,   /* ΥץΥȥ(Helpɽ)                         */
    SUPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե̾                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽ϥե                                                           */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOPF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̾                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optGRD={
    OSTR,   /* ץ󥿥                                             */
    "G",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "",     /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    256,      /* ʸκĹ                                               */
    GRDT,   /* ΥץΥȥ(Helpɽ)                         */
    GRDC    /* ΥץΥ(Helpɽ)                         */
  };

  
/*------------------------------------------------------------------------------*/
/* copyright                                                                  */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCPR={
    OSTR,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "",     /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    256,      /* ʸκĹ                                              */
    CPRT,   /* ΥץΥȥ(Helpɽ)                         */
    CPRC    /* ΥץΥ(Helpɽ)                         */
  }; 

/*------------------------------------------------------------------------------*/
/* եѥ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optWFP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir,/* ǥե(ѹ:hamuro 2004/08/21)                        */
    1,      /* ʸκǾĹ                                               */
    256,      /* ʸκĹ                                              */
    WFPT,   /* ΥץΥȥ(Helpɽ)                         */
    WFPC    /* ΥץΥ(Helpɽ)                         */
  };                                                               

     
void *opt[]={&optSUP,&optINF,&optOPF,&optGRD,&optCPR,&optWFP, NULL};


	Adj1=cmat(size,size);
	Adj2=cmat(size,size);
	Space=cmat(size,size);
	Tramat=cmat(size,size);
	Dummy0=cmat(120,120);

  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  mssGV.usedTempFileFlg=1;
  mssGV.tmpPath=mssStrdup(optWFP.str);

  if(optINF.set == 0){
    strcpy(filename,"/dev/stdin");
  }
  else{
    strcpy(filename,optINF.str);
  }
  if(optOPF.set == 0){
    strcpy(opf,"/dev/stdout");
  }
  else{
    strcpy(opf,optOPF.str);
  }
  
  strcpy(wfp,optWFP.str);
	
	sup=optSUP.val/100;
	strcpy(copyright,optCPR.str);

	readdata2(filename);

	if(optCPR.set == 1){
	  strcpy(copyright,optCPR.str);
	}
	if(optGRD.set ==1){
	  strcpy(description,optGRD.str);
	}

	apriori4(sup,1);
	treesize();

	disppatn1_2(opf);

	decode2(Adj1,trie[127].item);

	/*printf("END");*/
	mssShowMsg("AGM END");


  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
	return 0;
}
