/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 :  2004/06/08                                                  */
/* 1.1 : ĶˤɸξʤХ 2004/10/09                  */
/* 1.2 : yvCnt,xvCntηѹ(BSDǤΥХ),꡼ 2004/10/27     */
/* 1.3 : ꡼ 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include "mssSVG.h"

#include <xtlineHelp.h>
struct mssComHelp comHelp={
  "xtline",        /* ޥ̾       */
  "1.3",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

#define COLMAX 20 /* ʬξ */
#define ROWMAX 20 /* ʬξ */

extern struct mssGlobalVariables mssGV;

extern double LineUnit;
extern iconv_t *icid;   /*iconv Ѵϥɥ*/

static double CurYplus;
static double CurYminus;
static int rSet=0;
static int cSet=0;
static int eSet=0;

static char *Color[]={
"fuchsia",
"blue",
"orange",
"green",
"silver",
"salmon",
"royalblue",
"lavender",
"navy",
"yellow",
"cyan",
"darkmagenta",
"tomato",
"teal",
"purple",
"deepskyblue",
"paleturquoise",
"palegreen",
"mediumslateblue",
"red"};

double OPT_WIDTH;
double OPT_HEIGHT;
char  *OPT_TITLE;

struct Scale {
  double min;
  double max;
  double unit;
  int    splitCnt;
  int    posSplitCnt;
  int    negSplitCnt;
};

/* ι¤
               width
        +------------------+
        | +--------------+ |
        | |title         | |
        | +--------------+ |
height  | |+---+         | |
        | ||col| val     | |
        | |+---+         | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | +--------------+ |
        +------------------+
        margin
*/
struct ExNote {
  char  *id;                /* id (exNote) */
  struct SVGcoord   *co;    /* ΰ */
  struct SVGrect    *bg;    /* ΰΥХå饦 */
  struct SVGstring  *title; /* title */
  void   **col;   /* 顼ܥå */
  struct SVGstring **val;   /* 顼б */
  int    cnt;              /* ºݤɽο */
  double margin;           /* ; */
};

/* դι¤
                     width
        +----------------------------------------------------------+
        | +---+------+-------------------------------------------| |
height  | |YT |YV    |                                           | |
        | |   |      |   +----+                                  | |
        | |   | Ymark+---|    |----------------------------------| |
        | |   |      |   +----+     +----+            scale line | |
        | |   |      |   |    |     |    |                       | |
        | |   |      +---|    |-----+----+-----------------------| |
        | |   |      |   |    |     |    |                       | |
        | |   |      |   |    |     +----+                       | |
        | |   |      +---+----+-----|    |-----------------------| |
        | |   |      |   |    |     |    |                       | |
        | |   |      |   |    |     |    |                       | |
        | +---+------+-+-+----+--+--+----+---+---------+---------| |
        | |          |XV                              Xmark      | |
        | |          +-------------------------------------------+ |
        | |          |XT                                         | |
        | +----------+-------------------------------------------+ |
        +----------------------------------------------------------+
        margin
*/
struct LineChart {
  char  *id;             /* id (g#-#) */
  struct SVGcoord   *co; /* ΰ */
  struct SVGrect    *bg; /* ΰΥХå饦 */

  struct SVGstring  *xt; /* X title */
  struct SVGstring  *yt; /* Y title */
  struct SVGstring **xv; /* X value */
  struct SVGstring **yv; /* Y value */
  struct SVGline    *xa; /* X axis */
  struct SVGline    *ya; /* Y axis */
  struct SVGline   **xm; /* X mark */
  struct SVGline   **ym; /* Y mark */
  struct SVGline   **ys; /* scale line */

  struct SVGcoord   *g;  /* ΰ */

  int    xvCnt;          /* Xͤο */
  int    yvCnt;          /* Yͤο */

  double margin;         /* ; */
  int ratio;             /* 楰դɤ */
  char vhFlg;            /* (v:,h:) */

  double unit;           /* -fͤñ̤Υԥ */
  double origin;         /* yɸ */
  double dotSize;        /* ɥåȥ(ham)*/
};

/* ƥʤι¤
                     width
        +----------------------------------------------------------+
        | +------------------------------------------------------+ |
        | |Title (tWD*tHT)                                       | |
        | +-------------+---------------------------------+------+ |
height  | |             |CT     (CTWD*CTHT)               |      | |
        | |             +----------------+----------------+      | |
        | |             |CV   (CVWD*CVHT)|                |      | |
        | +------+------+----------------+----------------+------+ |
        | |RT    |RV    |                |                |EX    | |
        | |      |      | ΰ |                |      | |
        | |RTHT* |RVHT* | G(0,0)         | G(1,0)         |EXWD* | |
        | |  RTWD|  RVWD|                |                |  EXHT| |
        | |      +------+----------------+----------------+      | |
        | |      |      |                |                |      | |
        | |      |      |                |                |      | |
        | |      |      | G(0,1)         | G(i,j)         |      | |
        | |      |      |                |                |      | |
        | +------+------+----------------+----------------+------+ |
        +----------------------------------------------------------+
        margin
*/
struct Container {
  char  *id;               /* id (root) */
  struct SVGcoord   *co;   /* ΰ */
  struct SVGrect    *bg;   /* ΰΥХå饦(margin) */

  struct SVGstring *title; /* ȥ */
  struct SVGstring *ct;    /*  title */
  struct SVGstring *rt;    /*  title */
  struct SVGstring **cv;   /*  value */
  struct SVGstring **rv;   /*  value */

  struct LineChart   *line[COLMAX][ROWMAX];
  struct ExNote     *exNote;

  int cvCnt;             /*  */
  int rvCnt;             /* Կ */
  int fix;               /* ΰX:Y=3:2˸ꤹ뤫ɤ */
  double margin;         /* ; */
  double pWidth;         /* rootWindowʪŪ */
  double pHeight;        /* rootWindowʪŪʹ⤵ */
};

struct KeyInfo {
  struct mssFields *rFld;
  struct mssFields *cFld;
  struct mssFields *kFld;
  struct mssFields *eFld;
  struct mssFields *fFld;
  struct mssHash *rHash;
  struct mssHash *cHash;
  struct mssHash *kHash;
  struct mssHash *eHash;
  char **rAdd;
  char **cAdd;
  char **kAdd;
  char **eAdd;
  struct Scale *scale[COLMAX][ROWMAX];

  int rKB,cKB,kKB,eKB;
};

void setKeyBreakInfo(struct KeyInfo *keyInfo, struct mssFldRecDbl *frd){
  int fn;
  char **newPnt;
  char **oldPnt;

  /**/
  keyInfo->rKB=0;
  keyInfo->cKB=0;
  keyInfo->kKB=0;
  keyInfo->eKB=0;

  /*ǽԤλϥ֥졼*/
  if(frd->firstRead){
    frd->firstRead=0;
    return;
  }

  /*ǽԤλϥ֥졼*/
  if(frd->eof == 1){
    keyInfo->rKB=1;
    keyInfo->cKB=1;
    keyInfo->kKB=1;
    keyInfo->eKB=1;
    return;
  }

  newPnt=frd->pnt[frd->new];
  oldPnt=frd->pnt[frd->old];

  /* -r */
  if(rSet){
    fn=MssFlds2num(keyInfo->rFld,0);
    if( 0 != strcmp(*(newPnt+fn),*(oldPnt+fn)) ){
      keyInfo->rKB=1;
      keyInfo->cKB=1;
      keyInfo->kKB=1;
      keyInfo->eKB=1;
      return;
    }else{
      keyInfo->rKB=0;
    }
  }

  /* -c */
  if(cSet){
    fn=MssFlds2num(keyInfo->cFld,0);
    if( 0 != strcmp(*(newPnt+fn),*(oldPnt+fn)) ){
      keyInfo->cKB=1;
      keyInfo->kKB=1;
      keyInfo->eKB=1;
      return;
    }else{
      keyInfo->cKB=0;
    }
  }

  /* -k */
  fn=MssFlds2num(keyInfo->kFld,0);
  if( 0 != strcmp(*(newPnt+fn),*(oldPnt+fn)) ){
    keyInfo->kKB=1;
    keyInfo->eKB=1;
    return;
  }else{
    keyInfo->kKB=0;
  }

  /* -e */
  if(eSet){
    fn=MssFlds2num(keyInfo->eFld,0);
    if( 0 != strcmp(*(newPnt+fn),*(oldPnt+fn)) ){
      keyInfo->eKB=1;
      return;
    }else{
      keyInfo->eKB=0;
    }
  }
  return;
}

char **setKeyVal(char **list, struct mssHash *hash,char *val){
  struct mssHashNode *node;
  MssValue v;
  mssVinit(&v,INT); /* ¤ؤǽֹǼ */

  node=mssHashInsert(hash,val,v);
  if(node!=NULL){
    list=mssRealloc(list,sizeof(char *) * hash->cnt,"setKeyVal");
    *(list+hash->cnt-1) = node->str;
  }
  return(list);
}

void sortHashAdd(struct mssHash *hash,char **add, int cnt,MssOptFLD *optFld){
  int flag;
  int i;
  struct mssHashNode *node;

  if(mssIsFldOptOn(optFld,0,'n')){
    if(mssIsFldOptOn(optFld,0,'r')) flag=3;
    else                            flag=2; 
  }else{
    if(mssIsFldOptOn(optFld,0,'r')) flag=1;
    else                            flag=0; 
  }

  mssSort(add, cnt, flag);

  for(i=0; i<cnt; i++){
    node=mssHashMember(hash,*(add+i));
    if(node!=NULL){
      node->val.v.i=i;
    }
  }
}

struct Scale *setScale(double min, double max, int splitCnt){
  double unit;
  double limit;
  double unitA;
  double unitB;
  struct Scale *scale;
  struct Scale *posScale;
  struct Scale *negScale;

  scale=malloc(sizeof(struct Scale));
  scale->splitCnt = splitCnt;

  /*-------------------------------------------------*/
  /* min,maxȤ⤷ξĴ           */
  /*-------------------------------------------------*/
  if(min>0 && max>0) min=0;
  if(min<0 && max<0) max=0;

  /*-------------------------------------------------*/
  /* ʬ(posSplitCnt,negSplitCnt) */
  /*-------------------------------------------------*/
  scale->posSplitCnt = (int)floor((max/(max+min*(-1)))*(double)splitCnt+0.5);
  scale->negSplitCnt = splitCnt - scale->posSplitCnt;

  /* Ĵ */
  if( min <0 && scale->negSplitCnt<=0 ){
    scale->posSplitCnt--;
    scale->negSplitCnt++;
  }
  if( max >0 && scale->posSplitCnt<=0 ){
    scale->posSplitCnt++;
    scale->negSplitCnt--;
  }

  /*-------------------------------------------------*/
  /* ñ(unit)                              */
  /*-------------------------------------------------*/

  /* min,maxʤ顢줾̡˥*/
  if( min < 0 && max > 0 ){
    posScale=setScale(0,max,scale->posSplitCnt);
    negScale=setScale(min,0,scale->negSplitCnt);
    if(posScale->unit > negScale->unit) scale->unit=posScale->unit;
    else                                scale->unit=negScale->unit;
    free(posScale);
    free(negScale);

  /* min,maxΤ줫0ξñ̤*/
  }else{
 
    /* 10ʿɽʤΤǡǤξʤñ̤ꤹ롣
       ޤñ̤˴Ťͤκͤ1.2ܤۤʤunitA
       ۤunitBѤ롣   ) unit  unitA unitB
                                         3456  4000  3500 
                                         0.23  0.3   0.23 */
    unit=(max-min)/(double)splitCnt;
    unitA = pow(10,floor(log10(unit)));
    unitB = unitA/10;
    unitA = unitA * ceil(unit/unitA);
    unitB = unitB * ceil(unit/unitB);
    if( max == 0 ) limit=min*(-1.2);
    else           limit=max*( 1.2);
    if(unitA*(double)splitCnt <= limit) scale->unit=unitA;
    else                                scale->unit=unitB;
  }

  /*-------------------------------------------------*/
  /* Ǿ(min,max)                     */
  /*-------------------------------------------------*/
  scale->max=scale->unit * scale->posSplitCnt;
  scale->min=scale->unit * scale->negSplitCnt * (-1);

/*
printf("min=%g max=%g splitCnt=%d\n",min,max,splitCnt);
printf("SplitCnt(pos,neg)=(%d,%d)\n",scale->posSplitCnt,scale->negSplitCnt);
printf("unit=%g min=%g max=%g\n\n",scale->unit,scale->min,scale->max);
*/

  return(scale);
}

void drawShapes(double x, double y, double w, int eNum, int swidth, struct mssFPW *fpw) {
  /********** 20 Shapes **********/ 
  /***** Shape 0 -- square *****/
  if(eNum == 0) {
    struct SVGsq *sq;
    sq=initSVGsq(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGsq(sq, fpw);
    freeSVGsq(sq);
  }
  
  /***** Shape 1 -- circle *****/
  else if(eNum == 1) { 
  struct SVGcircle *circle;
    circle=initSVGcircle(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGcircle(circle, fpw);
    freeSVGcircle(circle);
  }

  /***** Shape 2 --  rectangle *****/
  else if(eNum == 2) {
    struct SVGv_rect *v_rect; 
    v_rect=initSVGv_rect(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGv_rect(v_rect, fpw);
    freeSVGv_rect(v_rect);
  }

  /***** Shape 3 -- funnel *****/
  else if(eNum == 3) {
    struct SVGfun *fun; 
    fun=initSVGfun(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGfun(fun, fpw);
    freeSVGfun(fun);
  }

  /***** Shape 4 --  ellipse *****/
  else if(eNum == 4) {
    struct SVGell *ell;
    ell=initSVGell(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGell(ell, fpw);
    freeSVGell(ell);
  }
  
  /***** Shape 5 -- i *****/
  else if(eNum == 5) {
    struct SVGi *i;
    i=initSVGi(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGi(i, fpw);
    freeSVGi(i);
  }

  /***** Shape 6 -- diamond *****/
  else if(eNum == 6) {
    struct SVGdia *dia; 
    dia=initSVGdia(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGdia(dia, fpw);
    freeSVGdia(dia);
  }

  /***** Shape 7 -- triangle *****/
  else if(eNum == 7) { 
  struct SVGtri *tri;
    tri=initSVGtri(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGtri(tri, fpw);
    freeSVGtri(tri);
  }

  /***** Shape 8 -- cross *****/
  else if(eNum == 8) {
    struct SVGcross *cross;
    cross=initSVGcross(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGcross(cross, fpw);
    freeSVGcross(cross);
  }
  
  /***** Shape 9 -- hexagon *****/
  else if(eNum == 9) { 
    struct SVGhex *hex;
    hex=initSVGhex(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGhex(hex, fpw);
    freeSVGhex(hex);
  }

  /***** Shape 10 -- crown *****/
  else if(eNum == 10) { 
    struct SVGcrown *crown;
    crown=initSVGcrown(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGcrown(crown, fpw);
    freeSVGcrown(crown);
  }

  /***** Shape 11 -- u *****/
  else if(eNum == 11) {
    struct SVGu *u;
    u=initSVGu(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGu(u, fpw);
    freeSVGu(u);
  }

  /***** Shape 12 -- star *****/
  else if(eNum == 12) {
  struct SVGstar *star;
    star=initSVGstar(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGstar(star, fpw);
    freeSVGstar(star);
  }
  
  /***** Shape 13 -- arrow  *****/
  else if(eNum == 13) { 
    struct SVGarrow *arrow;
    arrow=initSVGarrow(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGarrow(arrow, fpw);
    freeSVGarrow(arrow);
  }

  /***** Shape 14 -- fugo *****/
  else if(eNum == 14) {
    struct SVGfugo *fugo; 
    fugo=initSVGfugo(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGfugo(fugo, fpw);
    freeSVGfugo(fugo);
  }

  /***** Shape 15 -- tree *****/
  else if(eNum == 15) {
    struct SVGtree *tree; 
    tree=initSVGtree(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGtree(tree, fpw);
    freeSVGtree(tree);
  }

  /***** Shape 16 --  house *****/
  else if(eNum == 16) {
    struct SVGhouse *house;
    house=initSVGhouse(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGhouse(house, fpw);
    freeSVGhouse(house);
  }
  
  /***** Shape 17 -- male *****/
  else if(eNum == 17) {
    struct SVGmale *male; 
    male=initSVGmale(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGmale(male, fpw);
    freeSVGmale(male);
  }

  /***** Shape 18 -- cone *****/
  else if(eNum == 18) {
    struct SVGcone *cone; 
    cone=initSVGcone(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGcone(cone, fpw);
    freeSVGcone(cone);
  }

  /***** Shape 19 -- watch *****/
  else  {
    struct SVGwatch *watch; 
    watch=initSVGwatch(x, y, w, w, swidth, Color[eNum], NULL);
    writeSVGwatch(watch, fpw);
    freeSVGwatch(watch);
  }
}
/*************** End of Dawing Shapes ***************/
/* ι¤
          TX     WD
        +-|----------------+
    TY----+------TW------+ |
        | |title        TH |
        | +--------------+ |
    HT  | |+---+ CW*CH   | |
        | ||col| val     | |
        | |+---+  VW*VH  | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | |              | |
        | +--------------+ |
        +------------------+
        MARGIN
*/
struct ExNote *setExNote(double X, double Y, double W, double H, char *title,
  struct KeyInfo *keyInfo){

  struct ExNote *exNote;
  double FontUnit;
  double x,y,w,h;
  char *s;
  char buf[20];
  int i;
  double WD      = W;   /*ΰ*/
  double HT      = H;   /*ΰι⤵(ƤΨǷޤ)*/
  double MARGIN  = 15;  /*;*/

  double TWD;          /*ȥ*/
  double THT;          /*ȥι⤵*/
  double TFS    = 12;  /*ȥΥեȥ*/

  double CWD;          /*color boxͤι⤵*/
  double CHT;          /*color boxͤ  */

  double VWD;          /* val ͤ*/
  double VHT;          /* val ͤι⤵*/
  double VFS    = 10;  /* val Υեȥ*/

  double CVM;          /* col  valδ֤ */
  double LNM;          /* LINE֤Υޡ */

  double GWD;           /*ΰ*/
  double GHT;           /*ΰι⤵*/

  /* եñ̤η(FontUnit) */
  /* եȤw,hθƸ̩˷٤*/
  if(WD>HT) FontUnit=HT/100;
  else      FontUnit=WD/100;

  /*----------------------------*/
  /* Ǥȹ⤵Ĵ */
  /*----------------------------*/
  GWD = W;
  GHT = H;

  LNM = H*0.01;
  THT = TFS*FontUnit;
  VHT = VFS*FontUnit;
  CHT = VFS*FontUnit;
  if(keyInfo->eHash->cnt * (VHT+LNM) > GHT-THT){
    VHT=(GHT-THT)/(double) keyInfo->eHash->cnt - LNM;
    CHT=VHT;
  }
 
  CVM = W*0.05;
  TWD = GWD;
  CWD = CHT*1.5;
  VWD = GWD-CWD-CVM-MARGIN;

  exNote=mssCalloc(sizeof(struct ExNote),"setExNote");

  exNote->cnt=keyInfo->eHash->cnt;
  exNote->col=mssCalloc(sizeof(void *)*exNote->cnt,"setExNote");
  exNote->val=mssCalloc(sizeof(struct ExNote)*exNote->cnt,"setExNote");

  /*----------------------------*/
  /* ɸ                       */
  /*----------------------------*/
  exNote->co=initSVGcoord(X,Y,W,H);

  /*----------------------------*/
  /* ȥ                   */
  /*----------------------------*/
  x=X; y=Y; w=TWD; h=THT;
  s=MssFlds2name(keyInfo->eFld,0);
  exNote->title=initSVGstring(x,y,w,h,0,1,"middle","exnote",s);

  /*----------------------------*/
  /* color box                  */
  /*----------------------------*/
  for(i=0; i<exNote->cnt; i++){
    x=X+MARGIN; y=Y+MARGIN+THT+(double)i*(CHT+LNM); w=CWD*0.5;
// h=CHT;
    s=*(keyInfo->eAdd+i);
    sprintf(buf,"exCol-%d",i);

    if      (i==0)  *(exNote->col+i) = initSVGsq(x,y,w,w,0,Color[i],buf);
    else if (i==1)  *(exNote->col+i) = initSVGcircle(x,y,w,w,0,Color[i],buf);
    else if (i==2)  *(exNote->col+i) = initSVGv_rect(x,y,w,w,0,Color[i],buf);
    else if (i==3)  *(exNote->col+i) = initSVGfun(x,y,w,w,0,Color[i],buf);
    else if (i==4)  *(exNote->col+i) = initSVGell(x,y,w,w,0,Color[i],buf);
    else if (i==5)  *(exNote->col+i) = initSVGi(x,y,w,w,0,Color[i],buf);
    else if (i==6)  *(exNote->col+i) = initSVGdia(x,y,w,w,0,Color[i],buf);
    else if (i==7)  *(exNote->col+i) = initSVGtri(x,y,w,w,0,Color[i],buf);
    else if (i==8)  *(exNote->col+i) = initSVGcross(x,y,w,w,0,Color[i],buf);
    else if (i==9)  *(exNote->col+i) = initSVGhex(x,y,w,w,0,Color[i],buf);
    else if (i==10) *(exNote->col+i) = initSVGcrown(x,y,w,w,0,Color[i],buf);
    else if (i==11) *(exNote->col+i) = initSVGu(x,y,w,w,0,Color[i],buf);
    else if (i==12) *(exNote->col+i) = initSVGstar(x,y,w,w,0,Color[i],buf);
    else if (i==13) *(exNote->col+i) = initSVGarrow(x,y,w,w,0,Color[i],buf);
    else if (i==14) *(exNote->col+i) = initSVGfugo(x,y,w,w,0,Color[i],buf);
    else if (i==15) *(exNote->col+i) = initSVGtree(x,y,w,w,0,Color[i],buf);
    else if (i==16) *(exNote->col+i) = initSVGhouse(x,y,w,w,0,Color[i],buf);
    else if (i==17) *(exNote->col+i) = initSVGmale(x,y,w,w,0,Color[i],buf);
    else if (i==18) *(exNote->col+i) = initSVGcone(x,y,w,w,0,Color[i],buf);
    else            *(exNote->col+i) = initSVGwatch(x,y,w,w,0,Color[i],buf);
  }

  /*----------------------------*/
  /* val                        */
  /*----------------------------*/
  for(i=0; i<exNote->cnt; i++){
    x=X+MARGIN+CWD+CVM; y=Y+MARGIN+THT+(double)i*(VHT+LNM); w=VWD; h=VHT;
    s=*(keyInfo->eAdd+i);
    sprintf(buf,"exVal-%d",i);
    *(exNote->val+i)=initSVGstring(x,y,w,h,0,0,"start",buf,s);
  }

  /*----------------------------*/
  /* Хå饦ΰ       */
  /*----------------------------*/
  x=X; y=Y; w=WD; h=HT;
  sprintf(buf,"ex-bg");
  exNote->bg=initSVGrect(x,y,w,h,1,"none",buf);

  return(exNote);
}

void freeExNote(struct ExNote *exNote){
  int i;

  if(exNote==NULL) return;

  freeSVGcoord(exNote->co);
  freeSVGstring(exNote->title);
  freeSVGrect(exNote->bg);

  if(exNote->col!=NULL){
    for(i=0; i<exNote->cnt; i++){
      freeSVGrect(*(exNote->col+i));
    }
    mssFree(exNote->col);
  }
  if(exNote->val!=NULL){
    for(i=0; i<exNote->cnt; i++){
      freeSVGstring(*(exNote->val+i));
    }
    mssFree(exNote->val);
  }
  mssFree(exNote);
}

void writeExNote( struct ExNote *ex, struct mssFPW *fpw ){
  int i;
  /* ΰ */
  writeSVGrect(ex->bg,fpw);

  /* ȥ */
  writeSVGstring(ex->title,fpw);

  for(i=0; i<ex->cnt; i++){
    if      (i==0)  writeSVGsq(*(ex->col+i),fpw);
    else if (i==1)  writeSVGcircle(*(ex->col+i),fpw);
    else if (i==2)  writeSVGv_rect(*(ex->col+i),fpw);
    else if (i==3)  writeSVGfun(*(ex->col+i),fpw);
    else if (i==4)  writeSVGell(*(ex->col+i),fpw);
    else if (i==5)  writeSVGi(*(ex->col+i),fpw);
    else if (i==6)  writeSVGdia(*(ex->col+i),fpw);
    else if (i==7)  writeSVGtri(*(ex->col+i),fpw);
    else if (i==8)  writeSVGcross(*(ex->col+i),fpw);
    else if (i==9)  writeSVGhex(*(ex->col+i),fpw);
    else if (i==10) writeSVGcrown(*(ex->col+i),fpw);
    else if (i==11) writeSVGu(*(ex->col+i),fpw);
    else if (i==12) writeSVGstar(*(ex->col+i),fpw);
    else if (i==13) writeSVGarrow(*(ex->col+i),fpw);
    else if (i==14) writeSVGfugo(*(ex->col+i),fpw);
    else if (i==15) writeSVGtree(*(ex->col+i),fpw);
    else if (i==16) writeSVGhouse(*(ex->col+i),fpw);
    else if (i==17) writeSVGmale(*(ex->col+i),fpw);
    else if (i==18) writeSVGcone(*(ex->col+i),fpw);
    else            writeSVGwatch(*(ex->col+i),fpw);
  }

  for(i=0; i<ex->cnt; i++){
    writeSVGstring(*(ex->val+i),fpw);
  }
}

/**
 *                     WD
 *      +-----------------------------------------------------------+
 *    ----+---+-------+-------------------------------------------+ |
 *      | |YTHT|YVWD  |                                           | |
 *    G | | *  | *    |   +----+                                  | |
 *    H | |YTWD|YVHT  +---|    |----------------------------------| |
 *    T | |    |      |   +----+     +----+            scale line | |
 * HT   | |    |      |   |    |     |    |                       | |
 *      | |    | Ymark+---|    |-----+----+-----------------------| |
 *      | |    |      |   |    |     |    |                       | |
 *      | |    |      |   |    |     +----+                       | |
 *      | |    |      +---+----+-----|    |-----------------------| |
 *      | |    |      |   |    |     |    |                       | |
 *      | |    |      |   |    |     |    |                       | |
 *    ----+----+------+-+-+----+--+--+----+---+---------+---------| |
 *      | |           |XVWD*XVHT                       Xmark      | |
 *      | |           +-------------------------------------------+ |
 *      | |           |XTWD*XVHT                                  | |
 *      | +-----------+-------------------------------------------+ |
 *      +-------------|-------------------------------------------|-+
 *      MARGIN        |                GWD                        |
 */
struct LineChart *setLineChart(
  int cNo,
  int rNo,
  double X, double Y, double W, double H,
  struct KeyInfo *keyInfo){

  struct LineChart *line;
  double x,y,w,h;
  double x1,y1,x2,y2;
  char *s;
  int i;
  double unit,min;
  char buf[20];
  double FontUnit;

  /*ȹ⤵*/
  double WD      = W;   /*ΰ*/
  double HT      = H;   /*ΰι⤵(ƤΨǷޤ)*/
  double MARGIN  = H*0.05; /*;*/

  double XTWD;          /*XΥȥ*/
  double XTHT;          /*XΥȥι⤵*/
  double XTFS    = 7;   /*YȥΥեȥ*/

  double YTWD;          /*YΥȥ*/
  double YTHT;          /*YΥȥι⤵*/
  double YTFS    = 7;   /*YȥΥեȥ*/

  double XVWD;          /*Xͤ*/
  double XVHT;          /*Xͤι⤵*/
  double XVFS    = 6;   /*YȥΥեȥ*/

  double YVWD;          /*Yͤι⤵*/
  double YVHT;          /*Yͤ ????????? */
  double YVFS    = 6;   /*YȥΥեȥ*/

  double GWD;           /*ΰ*/
  double GHT;           /*ΰι⤵*/

  double DOTU    = 3;   /*ɥåȤΥ(ham)*/

  /* եñ̤η(FontUnit) */
  /* եȤw,hθƸ̩˷٤*/
  if(WD>HT) FontUnit=HT/100;
  else      FontUnit=WD/100;

  /*----------------------------*/
  /* Ǥȹ⤵Ĵ */
  /*----------------------------*/
  XTHT = XTFS*FontUnit;
  YTHT = YTFS*FontUnit;
  XVHT = XVFS*FontUnit;
  YVWD = YVFS*FontUnit*4;

  XTWD = WD-YTHT-YVWD-MARGIN*2;
  YTWD = HT-XTHT-XVHT-MARGIN*2;
  XVWD = XTWD/keyInfo->kHash->cnt;
  YVHT = YVFS*FontUnit;

  GWD  = WD-YTHT-YVWD-MARGIN*2;
  GHT  = HT-XTHT-XVHT-MARGIN*2;

  line=mssCalloc(sizeof(struct LineChart),"setLineChart");

  /*----------------------------*/
  /* id                         */
  /*----------------------------*/
  sprintf(buf,"g%d-%d",cNo,rNo);
  line->id=mssStrdup(buf);

  /*----------------------------*/
  /* Xȥ                */
  /*----------------------------*/
  x=X+MARGIN+YTHT+YVWD; y=Y+MARGIN+GHT+XVHT; w=XTWD; h=XTHT;
  s=MssFlds2name(keyInfo->kFld,0);
  sprintf(buf,"g%d-%d-xt",cNo,rNo);
  line->xt=initSVGstring(x,y,w,h,0,0,"middle",buf,s);

  /*----------------------------*/
  /* Yȥ                */
  /*----------------------------*/
  x=X+MARGIN; y=Y+MARGIN; w=YTWD; h=YTHT;
  s=MssFlds2name(keyInfo->fFld,0);
  sprintf(buf,"g%d-%d-yt",cNo,rNo);
  line->yt=initSVGstring(x,y,w,h,1,0,"middle",buf,s);

  /*----------------------------*/
  /* X                      */
  /*----------------------------*/
  line->xvCnt=keyInfo->kHash->cnt;
  line->xv=mssMalloc(sizeof(struct SVGstring *)*keyInfo->kHash->cnt,"setLine");
  for(i=0; i<line->xvCnt; i++){
    x=X+MARGIN+YTHT+YVWD+(double)(double)i*XVWD; y=Y+MARGIN+GHT; w=XVWD; h=XVHT;
    s=*(keyInfo->kAdd+i);
    sprintf(buf,"g%d-%d-xv%d",cNo,rNo,i);
    *(line->xv+i)=initSVGstring(x,y,w,h,0,0,"middle",buf,s);
  }

  /*----------------------------*/
  /* Y                      */
  /*----------------------------*/
  line->yvCnt=keyInfo->scale[cNo][rNo]->splitCnt+1;
  line->yv=mssMalloc(sizeof(struct SVGstring *)*line->yvCnt,"setLine");
  unit=keyInfo->scale[cNo][rNo]->unit;
  min =keyInfo->scale[cNo][rNo]->min;
  for(i=0; i<line->yvCnt; i++){
    x=X+MARGIN+YTHT;
    y=Y+MARGIN+GHT-(double)i*GHT/(double)(line->yvCnt-1)-YVFS*FontUnit/2;
    w=YVWD-YVWD*0.1; h=YVHT;
    s=mssFtoA(min+unit*i);
    sprintf(buf,"g%d-%d-yv%d",cNo,rNo,i);
    *(line->yv+i)=initSVGstring(x,y,w,h,0,0,"end",buf,s);
    mssFree(s); /* ɲ 2004/10/31 */
  }

  /*----------------------------*/
  /* ΰ                   */
  /*----------------------------*/
  x=X; y=Y; w=WD; h=HT;
  line->co=initSVGcoord(x,y,w,h);

  /*----------------------------*/
  /* ΰ                 */
  /*----------------------------*/
  x=X+MARGIN+YTHT+YVWD; y=Y+MARGIN; w=GWD; h=GHT;
  line->g=initSVGcoord(x,y,w,h);

  /*----------------------------*/
  /*  -f ñ̤ԥ */
  /*----------------------------*/
  line->unit = GHT / (keyInfo->scale[cNo][rNo]->max -
                     keyInfo->scale[cNo][rNo]->min );

  /*----------------------------*/
  /*  Yɸ               */
  /*----------------------------*/
  line->origin=line->g->y + line->g->h *
             ((double)keyInfo->scale[cNo][rNo]->posSplitCnt / 
              (double)keyInfo->scale[cNo][rNo]->splitCnt    );

  /*----------------------------*/
  /* X                        */
  /*----------------------------*/
  x1=line->g->x;           y1=line->origin;
  x2=line->g->x+line->g->w; y2=y1;
  sprintf(buf,"g%d-%d-xa",cNo,rNo);
  line->xa=initSVGline(x1,y1,x2,y2,1,"black",NULL,buf);

  /*----------------------------*/
  /* Y                        */
  /*----------------------------*/
  x1=line->g->x; y1=line->g->y;
  x2=x1;        y2=line->g->y+line->g->h;
  sprintf(buf,"g%d-%d-ya",cNo,rNo);
  line->ya=initSVGline(x1,y1,x2,y2,1,"black",NULL,buf);

  /*----------------------------*/
  /* Xޡ                  */
  /*----------------------------*/
  line->xm=mssMalloc(sizeof(struct SVGline *)*line->xvCnt,"setLine");
  for(i=0; i<line->xvCnt; i++){
    x1 = X+MARGIN+YTHT+YVWD+(double)(i+1)*XVWD; x2=x1;
    y1=line->g->y+line->g->h - line->g->h*0.01;
    y2=line->g->y+line->g->h + line->g->h*0.01;
    s=*(keyInfo->kAdd+i);
    sprintf(buf,"g%d-%d-xm%d",cNo,rNo,i);
    *(line->xm+i)=initSVGline(x1,y1,x2,y2,1,"black",NULL,buf);
  }

  /*----------------------------*/
  /* Yޡ                  */
  /*----------------------------*/
  line->ym=mssMalloc(sizeof(struct SVGline *)*line->yvCnt,"setline");
  for(i=0; i<line->yvCnt; i++){
    x1=line->g->x - line->g->w*0.01;
    x2=line->g->x + line->g->w*0.01;
    y1 = Y+MARGIN+GHT-(double)i*GHT/(double)(line->yvCnt-1); y2=y1;
    s=*(keyInfo->kAdd+i);
    sprintf(buf,"g%d-%d-ym%d",cNo,rNo,i);
    *(line->ym+i)=initSVGline(x1,y1,x2,y2,1,"black",NULL,buf);
  }

  /*----------------------------*/
  /* Y                */
  /*----------------------------*/
  line->ys=mssMalloc(sizeof(struct SVGline *)*line->yvCnt,"setLine");
  for(i=0; i<line->yvCnt; i++){
    x1=line->g->x; x2=line->g->x + line->g->w;
    y1 = Y+MARGIN+GHT-(double)i*GHT/(double)(line->yvCnt-1); y2=y1;
    s=*(keyInfo->kAdd+i);
    sprintf(buf,"g%d-%d-ys%d",cNo,rNo,i);
    *(line->ys+i)=initSVGline(x1,y1,x2,y2,0.5,"black","1,2",buf);
  }


  /*----------------------------*/
  /* Хå饦ΰ       */
  /*----------------------------*/
  x=X; y=Y; w=WD; h=HT;
  sprintf(buf,"g%d-%d-bg",cNo,rNo);
  line->bg=initSVGrect(x,y,w,h,1,"none",buf);

  /*;Υå*/
  line->margin=MARGIN;

  /*ɥåȥΥå(ham)*/
  line->dotSize=FontUnit*DOTU;
  return(line);
}

void freeLineChart(struct LineChart *line){
  int i;

  if(line==NULL) return;

  mssFree(line->id);
  freeSVGstring(line->xt);
  freeSVGstring(line->yt);
  freeSVGcoord(line->co);
  freeSVGcoord(line->g);
  freeSVGline(line->xa);
  freeSVGline(line->ya);
  freeSVGrect(line->bg);

  for(i=0; i<line->yvCnt; i++){
    freeSVGstring(*(line->yv+i));
    freeSVGline(*(line->ys+i));
    freeSVGline(*(line->ym+i));
  }
  mssFree(line->yv);
  mssFree(line->ys);
  mssFree(line->ym);
  for(i=0; i<line->xvCnt; i++){
    freeSVGstring(*(line->xv+i));
    freeSVGline(*(line->xm+i));
  }
  mssFree(line->xv);
  mssFree(line->xm);

  mssFree(line);

}


/**
 * =============================================================================
 * 롼ȥƥʤ
 *      |            WD(PWD)                                       |
 * -----+----------------------------------------------------------+
 *      | +------------------------------------------------------+ |
 *      | |Title (TWD*THT)                                       | |
 * HT   | +-------------+---------------------------------+------+ |
 *(PHT) | |             |CT     (CTWD*CTHT)               |      | |
 *      | |             +----------------+----------------+      | |
 *      | |             |CV   (CVWD*CVHT)|                |      | |
 *    ----+------+------+----------------+----------------+------+ |
 *      | |RT    |RV    |                |                |EX    | |
 *      | |      |      | ΰ |                |      | |
 *      | |RTHT* |RVHT* | G(0,0)         | G(1,0)         |EXWD* | |
 *     G| |  RTWD|  RVWD|                |                |  EXHT| |
 *     H| |      +------+----------------+----------------+      | |
 *     T| |      |      |                |                |      | |
 *      | |      |      |                |                |      | |
 *      | |      |      | G(0,1)         | G(i,j)         |      | |
 *      | |      |      |                |                |      | |
 *    ----+------+------+----------------+----------------+------+ |
 * -----+---------------|----------------------------------------|-+
 *      MARGIN          |                GWD                     |
 *
 *  WD=GWD+RVHT+RTHT+MARGIN*2
 *  HT=GHT+CVHT+CTHT+MARGIN*2
 * =============================================================================
 * եȥñ
 * 롼ȥƥʤΥ˹碌ơեȥϷ
 * 롼ȥƥʤx,yǾͤ100ǳä
 * ǥեȤǤ1600*1200ʤΤ FontUnit=1600/10=16
 * վɽʸ[Ū礭]*FontUnitˤ
 * ǽŪʥեȥޤ
 * Ū礭ϡƼ롼(setContainerʤ)ˤƤ롣
 * ѿsetContainerؿ롣
 */
struct Container *setContainer(
  char *title,  /* ȥ(NULLʤɽΰݤʤ */
  int cvCnt,    /* Xͤο(-x ꤵƤʤȤ1) */
  int rvCnt,    /* Yͤο(-y ꤵƤʤȤ1) */
  int fix,      /* ɽΰX:Y=3:2˸ꤹ뤫ɤ */
  int exFlg,    /* ɽ뤫ɤ */
  struct KeyInfo *keyInfo){

  struct Container *con;
  double x,y,w,h;
  char *s;
  char *id;
  int i,j;
  char buf[20];
  double FontUnit;

  /**/
  double PWD     = OPT_WIDTH;     /*ʪŪ*/
  double PHT     = OPT_HEIGHT;    /*ʪŪʹ⤵*/
  double MARGIN  = 20;      /*;*/

  double GWD     = 0;       /*ΰ(ham)*/
  double GHT     = 0;       /*ΰι⤵(ham)*/

  double TWD;               /*ȥ*/
  double THT;               /*ȥι⤵*/
  double TFS     = 6;       /*ȥΥեȥ*/

  double CTWD;              /*󥿥ȥ*/
  double CTHT;              /*󥿥ȥι⤵*/
  double CTFS    = 4;       /*󥿥ȥΥեȥ*/

  double RTWD;              /*ԥȥ*/
  double RTHT;              /*ԥȥι⤵*/
  double RTFS    = 4;       /*ԥȥΥեȥ*/

  double CVWD;              /*ͤ*/
  double CVHT;              /*ͤι⤵*/
  double CVFS    = 3;       /*ͤΥեȥ*/

  double RVWD;              /*ͤ*/
  double RVHT;              /*ͤι⤵*/
  double RVFS    = 3;       /*ͤΥեȥ*/

  double EXWD    = 0;       /**/
  double EXHT    = 0;       /*ι⤵*/

  /*----------------------------*/
  /* Ǥȹ⤵Ĵ */
  /*----------------------------*/

  /* եñ̤η(FontUnit) */
  /* եȤw,hθƸ̩˷٤*/
  if(PWD>PHT) FontUnit=PHT/100;
  else        FontUnit=PWD/100;

  /* Ƽեȥ顢⤵ꤹ */
  if(title==NULL) THT = 0;
  else            THT = TFS*FontUnit;

  if(cSet==1) { CTHT=CTFS*FontUnit; CVHT=CVFS*FontUnit; }
  else        { CTHT=0            ; CVHT=0            ; }

  if(rSet==1) { RTHT=RTFS*FontUnit; RVHT=RVFS*FontUnit; }
  else        { RTHT=0            ; RVHT=0            ; }

  /*  */
  if(exFlg==0) EXWD=0;
  else         EXWD=PWD/5;

  /* ¾ȹ⤵׻ */
  if(fix) {
    if( (double)cvCnt > (double)rvCnt*(PWD/PHT) ){
      GHT=PHT-CTHT-CVHT-THT -MARGIN*2;
      GWD=(GHT/(double)rvCnt) * (PWD/PHT) * (double)cvCnt;
    }else{
      GWD=PWD-RTHT-RVHT-EXWD-MARGIN*2;
      GHT=(GWD/(double)cvCnt) * (PHT/PWD) * (double)rvCnt;
    }
  }else{
    GWD=PWD-RTHT-RVHT-EXWD-MARGIN*2;
    GHT=PHT-CTHT-CVHT-THT -MARGIN*2;
  }

  PWD=GWD+RTHT+RVHT+EXWD+MARGIN*2;
  PHT=GHT+CTHT+CVHT+THT +MARGIN*2;

  TWD=RTHT+RVHT+GWD+EXWD;
  CTWD=GWD;
  RTWD=GHT;
  CVWD=GWD/(double)cvCnt;
  RVWD=GHT/(double)rvCnt;
  EXHT=GHT;

  con=mssCalloc(sizeof(struct Container),"setContainer");

  /* id */
  con->id=mssStrdup("root");

  /* ΰ */
  x=0; y=0; w=PWD; h=PHT;
  con->co=initSVGcoord(x,y,w,h);

  /*X,YͤθĿå*/
  con->cvCnt=cvCnt;
  con->rvCnt=rvCnt;

  /*Ψե饰*/
  con->fix=fix;

  /*ʪŪΤȹ⤵*/
  con->pWidth  = PWD;
  con->pHeight = PHT;

  /* ñ*/
  LineUnit=con->co->w/con->pWidth;


  /*----------------------------*/
  /* ȥ                   */
  /*----------------------------*/
  if(title==NULL){
    con->title=NULL;
  }else{
    x=MARGIN; y=MARGIN; w=TWD; h=THT;
    s=title;
    id="title";
    con->title=initSVGstring(x,y,w,h,0,0,"middle",id,title);
  }

  /*----------------------------*/
  /* 󥿥ȥ                 */
  /*----------------------------*/
  if(cSet){
    x=MARGIN+RTHT+RVHT; y=MARGIN+THT; w=CTWD; h=CTHT;
    s=MssFlds2name(keyInfo->cFld,0);
    id="ct";
    con->ct=initSVGstring(x,y,w,h,0,1,"middle",id,s);
  }else{
    con->ct=NULL;
  }

  /*----------------------------*/
  /* ԥȥ                 */
  /*----------------------------*/
  if(rSet){
    x=MARGIN; y=MARGIN+THT+CTHT+CVHT; w=RTWD; h=RTHT;
    s=MssFlds2name(keyInfo->rFld,0);
    id="rt";
    con->rt=initSVGstring(x,y,w,h,1,1,"middle",id,s);
  }else{
    con->rt=NULL;
  }

  /*----------------------------*/
  /*                        */
  /*----------------------------*/
  if(cSet){
    con->cv=mssMalloc(sizeof(struct SVGstring *)*cvCnt,"setCon");
    for(i=0; i<cvCnt; i++){
      x=MARGIN+RTHT+RVHT+(double)i*CVWD; y=MARGIN+THT+CTHT; w=CVWD; h=CVHT;
      s=*(keyInfo->cAdd+i);
      sprintf(buf,"cv%d",i);
      *(con->cv+i)=initSVGstring(x,y,w,h,0,1,"middle",buf,s);
    }
  }else{
    con->cv=NULL;
  }

  /*----------------------------*/
  /*                        */
  /*----------------------------*/
  if(rSet){
    con->rv=mssMalloc(sizeof(struct SVGstring)*rvCnt,"setCon");
    for(i=0; i<rvCnt; i++){
      x=MARGIN+RTHT; y=MARGIN+THT+CTHT+CVHT+(double)i*RVWD; w=RVWD; h=RVHT;
      s=*(keyInfo->rAdd+i);
      sprintf(buf,"rv%d",i);
      *(con->rv+i)=initSVGstring(x,y,w,h,1,1,"middle",buf,s);
    }
  }else{
    con->rv=NULL;
  }

  /*----------------------------*/
  /* ΰ                   */
  /*----------------------------*/
  if(exFlg!=0){
    x=MARGIN+RTHT+RVHT+CTWD; y=MARGIN+THT+CTHT+CVHT; w=EXWD; h=EXHT;
    s=MssFlds2name(keyInfo->eFld,0);
    con->exNote=setExNote(x,y,w,h,s,keyInfo);
  }else{
    con->exNote=NULL;
  }

  /*----------------------------*/
  /* ΰ                 */
  /*----------------------------*/
  for(i=0; i<cvCnt; i++){
    for(j=0; j<rvCnt; j++){
      x=MARGIN    +RTHT+RVHT+(double)i*CVWD;
      y=MARGIN+THT+CTHT+CVHT+(double)j*RVWD;
      w=CVWD; h=RVWD;
      con->line[i][j]=setLineChart(i,j,x,y,w,h,keyInfo);
    }
  }

  return(con);
}

void freeContainer(struct Container *con){
  int i,j;

  if(con==NULL) return;

  mssFree(con->id);
  freeSVGcoord(con->co);
  freeSVGstring(con->title);
  freeSVGstring(con->ct);
  freeSVGstring(con->rt);
  if(con->cv!=NULL){
    for(i=0; i<con->cvCnt ; i++) freeSVGstring(*(con->cv+i));
    mssFree(con->cv);
  }
  if(con->rv!=NULL){
    for(i=0; i<con->rvCnt ; i++) freeSVGstring(*(con->rv+i));
    mssFree(con->rv);
  }
  freeExNote(con->exNote);
  for(i=0; i<con->cvCnt ; i++){
    for(j=0; j<con->rvCnt ; j++){
      freeLineChart(con->line[i][j]);
    }
  }
  mssFree(con);
}



void showContainer( struct Container *con ){
  int i;

  printf("===============Container Data\n");
  showSVGstring(con->title);
  showSVGstring(con->ct   );
  showSVGstring(con->rt   );

  for(i=0; i<con->cvCnt-1; i++){
    showSVGstring(*(con->cv+i) );
  }
  for(i=0; i<con->rvCnt-1; i++){
    showSVGstring(*(con->rv+i) );
  }

  printf("fix   : %d\n",con->fix);
  printf("pWidth : %g\n",con->pWidth);
  printf("pHeight: %g\n",con->pHeight);
}


void writeLineChartContainer( struct LineChart *line, struct mssFPW *fpw ){

  struct mssXmlTag *gTag; /* g*/
  int i;

  gTag=mssInitXmlTag("g",NULL);
  mssAddXmlTagAttributeStr(gTag,"id", line->id, NULL);

  /* <g> */
  mssWriteXmlStartTag(gTag,NULL,fpw);
  mssWriteRet(fpw);

  /* Хå饦 */
  writeSVGrect(line->bg,fpw);

  /* X&ȥ */
  writeSVGstring(line->xt,fpw);
  writeSVGline(line->xa,fpw);

  /* Y&ȥ */
  writeSVGstring(line->yt,fpw);
  writeSVGline(line->ya,fpw);

  /* X&ޡ */
  for(i=0; i<line->xvCnt; i++){
    if(line->xv!=NULL) writeSVGstring(*(line->xv+i),fpw);
    if(line->xm!=NULL) writeSVGline(*(line->xm+i),fpw);
  }

  /* Y&ޡ&*/
  for(i=0; i<line->yvCnt; i++){
    if(line->yv!=NULL) writeSVGstring(*(line->yv+i),fpw);
    if(line->ym!=NULL) writeSVGline(*(line->ym+i),fpw);
    if(line->ys!=NULL) writeSVGline(*(line->ys+i),fpw);
  }



  /* </g> */
  mssWriteXmlEndTag(gTag,NULL,fpw);

  mssFreeXmlTag(gTag);
}

void writeContainer( struct Container *con, struct mssFPW *fpw ){
  int i,j;

  /* ȥ */
  writeSVGstring(con->title,fpw);

  if(cSet){
    /* 󥿥ȥ */
    writeSVGstring(con->ct,fpw);

    /*  */
    for(i=0; i<con->cvCnt; i++){
      writeSVGstring(*(con->cv+i),fpw);
    }
  }

  if(rSet){
    /* ԥȥ */
    writeSVGstring(con->rt,fpw);

    /*  */
    for(i=0; i<con->rvCnt; i++){
      writeSVGstring(*(con->rv+i),fpw);
    }
  }

  /*  */
  for(i=0; i<con->cvCnt; i++){
    for(j=0; j<con->rvCnt; j++){
      writeLineChartContainer( con->line[i][j], fpw );
    }
  }

  /*  */
  if(eSet){
    writeExNote(con->exNote, fpw);
  }
}


/* դι¤
 *                              +-----------------------+
 *                              |                       |
 *                              |   +----+              |
 *                              +---|    |--------------|
 *                 CurYplus     |   +----+              |
 *                              |   |    |              |
 *                              +---|    |--------------|
 *                              |   |    |              |
 *                              |   |    |     +----+   |
 *                              +---|    |-----|    |---|
 *                              |   |    |     |    |   |
 *                              |   |    |     |    |   |
 *                 line->origin +-+-+----+--+--+----+--+|
 *                              |              |    |   |
 *                 CurYminus    |              +----+   |
 *                              +-----------------------|
 *                                  |    |
 *                                  |   *(line->w+kNum)
 *                                 *(line->x+kNum)
 *
 *  -f ñ̤ԥ
 *    line->unit = line->g->h / (scale->max - scale->min)
 */
void writeChart(struct Container *con,
  int cNum, int rNum, int eNum,
  int kNumO, int kNumN, double fValO, double fValN,
  struct KeyInfo *keyInfo, struct mssFPW *fpw){
  struct LineChart *line;
  struct SVGline *drawline;

  double x,y,w,h,x1,y1,x2,y2;
  char buf[30];
  int swidth = 0; /* border width */

  line=con->line[cNum][rNum];


  //w = con->pWidth*0.04;
  w = line->dotSize; //(ham)
  x = (*(line->xm+kNumO))->c2.x2 - (line->g->w/(double)line->xvCnt)*0.5 -w*0.5;

  if(fValO>=0) {
    h = fValO*line->unit;
    y = line->origin-h-w*0.5;
  }else{
    h = (-1)*(fValO*line->unit);
    y = line->origin+h-w*0.5;
  }

drawShapes(x, y, w, eNum, swidth, fpw);

//fprintf(stderr,"knum=%d,%d, %d\n",kNumN,kNumO,keyInfo->kHash->cnt-1 );
//fprintf(stderr,"comp=%d,%d\n", 1==(kNumN-kNumO), kNumN!=(keyInfo->kHash->cnt-1));
  if( 1==(kNumN-kNumO) && kNumO!=(keyInfo->kHash->cnt-1) ){
    x1=x;           y1=y;
    x2 =   (*(line->xm+kNumN))->c2.x2 - (line->g->w / line->xvCnt)*0.5 -w*0.5;
    if(fValN>=0) {
      h = fValN*line->unit;
      y2 = line->origin-h-w*0.5;
    }else{
      h = (-1)*(fValO*line->unit);
      y2= line->origin+h-w*0.5;
    }


    sprintf(buf,"line%d-%d-%d",cNum,rNum,kNumO);
    drawline=initSVGline(x1+w*0.5,y1+w*0.5,x2+w*0.5,y2+w*0.5,1,Color[eNum],NULL,buf);
    writeSVGline(drawline,fpw);
    freeSVGline(drawline);
  }
}

int main(int argc, char *argv[]){
/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptFLD optKEY={
    OFLD,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n,r",  /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    KEYT,   /* ΥץΥȥ(Helpɽ)                         */
    KEYC,   /* ΥץΥ(Helpɽ)                         */
    KEYF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* (Ѥ߾夲ʬ)                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEXP={
    OFLD,   /* ץ󥿥                                             */
    "e",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n,r",  /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    EXPT,   /* ΥץΥȥ(Helpɽ)                         */
    EXPC,   /* ΥץΥ(Helpɽ)                         */
    EXPF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ʬ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCOL={
    OFLD,   /* ץ󥿥                                             */
    "c",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    COLT,   /* ΥץΥȥ(Helpɽ)                         */
    COLC,   /* ΥץΥ(Helpɽ)                         */
    COLF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ʬ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optROW={
    OFLD,   /* ץ󥿥                                             */
    "r",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n,r",  /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    ROWT,   /* ΥץΥȥ(Helpɽ)                         */
    ROWC,   /* ΥץΥ(Helpɽ)                         */
    ROWF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ͹                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ɽ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optWID={
    OINT,   /* ץ󥿥                                             */
    "W",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    640,    /* ǥե(ͤȤƻ)                                   */
    320,    /* Ǿ                                                       */
    1600,   /*                                                        */
    WIDT,   /* ΥץΥȥ(Helpɽ)                         */
    WIDC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ɽ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optHIT={
    OINT,   /* ץ󥿥                                             */
    "H",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    480,    /* ǥե(ͤȤƻ)                                   */
    240,    /* Ǿ                                                       */
    1200,   /*                                                        */
    HITT,   /* ΥץΥȥ(Helpɽ)                         */
    HITC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*//* -r,-cꤹȤդΥꤹե饰                    *//*----------------------------------------------------------------------------*/  MssOptFLG optFIX={
    OFLG,   /* ץ󥿥                                             */
    "fix",  /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    FIXT,   /* ΥץΥȥ(Helpɽ)                         */
    FIXC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*//* -r,-cꤹȤġΥդ礭WID:HIT˸ꤹե饰         *//*----------------------------------------------------------------------------*/  MssOptFLG optADJ={
    OFLG,   /* ץ󥿥                                             */
    "adjust",  /* (ʣʸԲ)                                */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ADJT,   /* ΥץΥȥ(Helpɽ)                         */
    ADJC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ȥ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTIT={
    OSTR,   /* ץ󥿥                                             */
    "title",/* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "",     /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    256,    /* ʸκĹ                                   */
    TITT,   /* ΥץΥȥ(Helpɽ)                         */
    TITC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optEXP,&optCOL,&optROW,&optFLD,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,
               &optWID,&optHIT,&optFIX,&optADJ,&optTIT,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr; /*ϥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFldRec    *fr;  /*-ԥХåե¤             */
  struct mssFldRecDbl *frd; /*-ԥХåե¤             */
  struct mssFields    *sf;  /*ȹܹ¤     */

  struct KeyInfo *keyInfo;
  double maxAL;
  double minAL;
  double accValplus;
  double accValminus;
  int i,j;
  struct Container *con;

  int cvCnt;
  int rvCnt;
  int exFlg;
  char *cStr, *rStr, *kStr,*kStrN,*kStrO,*eStr,*fStr,*fStrN,*fStrO;
  int   cNum,  rNum,  kNumO, kNumN, eNum;
  double fVal;
  double fValN,fValO;
  double maxCR[COLMAX][ROWMAX];
  double minCR[COLMAX][ROWMAX];

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */

  if(optCOL.set) cSet=1;
  if(optROW.set) rSet=1;
  if(optEXP.set) eSet=1;

           mssSetOptFld(&optKEY, hdi); /* -k  */
           mssSetOptFld(&optFLD, hdi); /* -f  */
  if(eSet) mssSetOptFld(&optEXP, hdi); /* -c  */
  if(cSet) mssSetOptFld(&optCOL, hdi); /* -x  */
  if(rSet) mssSetOptFld(&optROW, hdi); /* -r  */

  /*ȹܤκ*/
  sf=mssInitFields();
  if(rSet) mssAddFieldsByFields(sf,optROW.flds); /* -r  */
  if(cSet) mssAddFieldsByFields(sf,optCOL.flds); /* -c  */
  if(eSet) mssAddFieldsByFields(sf,optEXP.flds); /* -e  */
           mssAddFieldsByFields(sf,optKEY.flds); /* -k  */

  mssSetFieldsSortPriority(sf);         /* ֹͥϿˤդ   */

  keyInfo=mssCalloc(sizeof(struct KeyInfo),"keyInfo");
           keyInfo->kFld=optKEY.flds;
           keyInfo->fFld=optFLD.flds;
  if(rSet) keyInfo->rFld=optROW.flds;
  if(cSet) keyInfo->cFld=optCOL.flds;
  if(eSet) keyInfo->eFld=optEXP.flds;

  keyInfo->kHash=mssInitHash(101);
  keyInfo->rHash=mssInitHash(101);
  keyInfo->cHash=mssInitHash(101);
  keyInfo->eHash=mssInitHash(101);

  if(!eSet) exFlg=0;
  else      exFlg=1;
 
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

  if(hdi->xmlenc!=NULL){
    icid=iconv_open("UTF-8",hdi->xmlenc);
  }else{
    icid=NULL;
  }

  OPT_WIDTH  = optWID.val;
  OPT_HEIGHT = optHIT.val;
  if(optTIT.set) OPT_TITLE    = optTIT.str;
  else           OPT_TITLE    = hdi->title;

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*ȺѤߥեȤƥץ*/
  fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*-------------------------------------*/
  /* ܤ                        */
  /* Ƽͤμ,̾ΤhashϿ */
  /*-------------------------------------*/
  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){

    /* -kͤhashϿ */
    kStr=*(fr->pnt+MssFlds2num(keyInfo->kFld,0));
    if(!MssIsNull(kStr))
      keyInfo->kAdd=setKeyVal(keyInfo->kAdd,keyInfo->kHash,kStr);

    /* -rͤhashϿ */
    if(rSet){
      rStr=*(fr->pnt+MssFlds2num(keyInfo->rFld,0));
      if(!MssIsNull(rStr))
        keyInfo->rAdd=setKeyVal(keyInfo->rAdd,keyInfo->rHash,rStr);
    }

    /* -cͤhashϿ */
    if(cSet){
      cStr=*(fr->pnt+MssFlds2num(keyInfo->cFld,0));
      if(!MssIsNull(cStr))
        keyInfo->cAdd=setKeyVal(keyInfo->cAdd,keyInfo->cHash,cStr);
    }

    /* -eͤhashϿ */
    if(eSet){
      eStr=*(fr->pnt+MssFlds2num(keyInfo->eFld,0));
      if(!MssIsNull(eStr))
        keyInfo->eAdd=setKeyVal(keyInfo->eAdd,keyInfo->eHash,eStr);
    }

    mssGV.inCnt++;
  }
  mssFreeFldRec(fr);

  /* r,c,eꤵƤʤϥߡ(*)ϿƤ*/
  if(!rSet) keyInfo->rAdd=setKeyVal(keyInfo->rAdd,keyInfo->rHash,"DUMMY *");
  if(!cSet) keyInfo->cAdd=setKeyVal(keyInfo->cAdd,keyInfo->cHash,"DUMMY *");
  if(!eSet) keyInfo->eAdd=setKeyVal(keyInfo->eAdd,keyInfo->eHash,"DUMMY *");

/*
printf("-----------------------------------\n");
for(i=0; i<keyInfo->rHash->cnt; i++){
printf("r[%d]=%s\n",i,*(keyInfo->rAdd+i));
}
for(i=0; i<keyInfo->cHash->cnt; i++){
printf("c[%d]=%s\n",i,*(keyInfo->cAdd+i));
}
for(i=0; i<keyInfo->kHash->cnt; i++){
printf("k[%d]=%s\n",i,*(keyInfo->kAdd+i));
}
for(i=0; i<keyInfo->eHash->cnt; i++){
printf("e[%d]=%s\n",i,*(keyInfo->eAdd+i));
}
*/
  /*--------------------------------------------------*/
  /* hashϿ줿ͤ¤ؤֹϿ */
  /*--------------------------------------------------*/
  sortHashAdd(keyInfo->kHash, keyInfo->kAdd, keyInfo->kHash->cnt, &optKEY);
  sortHashAdd(keyInfo->rHash, keyInfo->rAdd, keyInfo->rHash->cnt, &optROW);
  sortHashAdd(keyInfo->cHash, keyInfo->cAdd, keyInfo->cHash->cnt, &optCOL);
  sortHashAdd(keyInfo->eHash, keyInfo->eAdd, keyInfo->eHash->cnt, &optEXP);

  /*-------------------------*/
  /* 2ܤ             */
  /* -f κǾͺ       */
  /* -c -r ̤˵        */
  /*-------------------------*/
  mssSeekTopFPR(fpr);
  frd=mssInitFRD(hdi->flds->cnt);
  maxAL=-DBL_MAX;
  minAL= DBL_MAX;
  for(i=0; i<COLMAX; i++){
    for(j=0; j<ROWMAX; j++){
      maxCR[i][j]=-DBL_MAX;
      minCR[i][j]= DBL_MAX;
    }
  }

  accValplus = 0;
  accValminus= 0;
  while( EOF != mssReadFRD(fpr,frd) ){

    setKeyBreakInfo(keyInfo, frd);

    if(keyInfo->kKB){
      if(cSet) cStr=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->cFld,0));
      else     cStr="DUMMY *";
      if(rSet) rStr=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->rFld,0));
      else     rStr="DUMMY *";

      if(MssIsNull(cStr)) continue;
      if(MssIsNull(rStr)) continue;
 
      cNum=mssHashMember(keyInfo->cHash,cStr)->val.v.i;
      rNum=mssHashMember(keyInfo->rHash,rStr)->val.v.i;

      if(cNum<COLMAX && rNum<ROWMAX){
        if(maxCR[cNum][rNum] < accValplus)  maxCR[cNum][rNum] = accValplus;
        if(minCR[cNum][rNum] > accValminus) minCR[cNum][rNum] = accValminus;

        if(maxAL<accValplus)  maxAL=accValplus;
        if(minAL>accValminus) minAL=accValminus;
      }
      accValplus =0;
      accValminus=0;
    }

    /* -f ͤ */
    fStr = *(frd->pnt[frd->new]+MssFlds2num(optFLD.flds,0));
    if(MssIsNull(fStr)) continue;

    fVal = atof(fStr);
    if(fVal>=0) accValplus += fVal;
    else        accValminus+= fVal;

  }
  mssFreeFRD(frd);

  for(i=0; i<keyInfo->cHash->cnt; i++){
    for(j=0; j<keyInfo->rHash->cnt; j++){
      if(maxCR[i][j]==-DBL_MAX){
        maxCR[i][j]=0;
        minCR[i][j]=0;
      }
    }
  }
  for(i=0; i<keyInfo->cHash->cnt; i++){
    for(j=0; j<keyInfo->rHash->cnt; j++){
      /* -c,-r̤˰ۤʤ륹ꤹ */
      if(!optFIX.set){
        if(maxCR[i][j]!=-DBL_MAX){
          if(maxCR[i][j]>0 && minCR[i][j]>0){
            keyInfo->scale[i][j]=setScale(0, maxCR[i][j], 5);
          }else if(maxCR[i][j]<0 && minCR[i][j]<0){
            keyInfo->scale[i][j]=setScale(minCR[i][j], 0, 5);
          }else{
            keyInfo->scale[i][j]=setScale(minCR[i][j], maxCR[i][j], 5);
          }
        }else{
          keyInfo->scale[i][j]=NULL;
        }
      /* -c,-rͤ˴طʤƱꤹ */
      }else{
        keyInfo->scale[i][j]=setScale(minAL, maxAL, 5);
      }
    }
  }


/*
printf("-----------------------------------\n");
for(i=0; i<keyInfo->rHash->cnt; i++){
printf("r[%d]=%s\n",i,*(keyInfo->rAdd+i));
}
for(i=0; i<keyInfo->cHash->cnt; i++){
printf("c[%d]=%s\n",i,*(keyInfo->cAdd+i));
}
for(i=0; i<keyInfo->kHash->cnt; i++){
printf("k[%d]=%s\n",i,*(keyInfo->kAdd+i));
}
for(i=0; i<keyInfo->eHash->cnt; i++){
printf("e[%d]=%s\n",i,*(keyInfo->eAdd+i));
}
printf("-----------------------------------\n");
*/

  /*-------------------------------------*/
  /* ƥʤ                      */
  /*-------------------------------------*/
  cvCnt=keyInfo->cHash->cnt;
  rvCnt=keyInfo->rHash->cnt;
  con=setContainer( OPT_TITLE, cvCnt, rvCnt, optADJ.set, exFlg, keyInfo);

  //showContainer( con );

  /*-------------------------------------*/
  /*                           */
  /*-------------------------------------*/
  //con->exNote=setExNote("abc",keyInfo);

  /*-------------------------------------*/
  /* եƥʤ                */
  /*-------------------------------------*/

  /*-------------------------------------*/
  /* Output XML data                     */
  /*-------------------------------------*/

  /* XML declareration : <?xml version="1.0" encoding="UTF-8"?> */
  mssWriteXmlDeclaration(MssXmlDefVer,"UTF-8",fpw);

  /* output svg start tag :
               <svg width="xxx" height="xxx" viewBox="x x x x" .... > */
  writeSVGstartTag(con->pWidth,con->pHeight,con->co->w,con->co->h,fpw);

  /*-------------------------------------*/
  /* Output line chart                    */
  /*-------------------------------------*/
  mssSeekTopFPR(fpr);
  frd=mssInitFRD(hdi->flds->cnt);
//fprintf(stderr,"xxxxxxxxxxxxxxxx\n");

  CurYplus =con->line[0][0]->origin;
  CurYminus=con->line[0][0]->origin;
  while( EOF != mssReadFRD(fpr,frd) ){

    if(frd->eof) break;

    if(frd->firstRead){
      frd->firstRead=0;
      continue;
    }
    if(cSet) cStr=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->cFld,0));
    else     cStr="DUMMY *";
    if(rSet) rStr=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->rFld,0));
    else     rStr="DUMMY *";
    if(eSet) eStr=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->eFld,0));
    else     eStr="DUMMY *";

             kStrO=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->kFld,0));
             kStrN=*(frd->pnt[frd->new]+MssFlds2num(keyInfo->kFld,0));

             fStrO=*(frd->pnt[frd->old]+MssFlds2num(keyInfo->fFld,0));
             fStrN=*(frd->pnt[frd->new]+MssFlds2num(keyInfo->fFld,0));

    if(MssIsNull(fStrO)) continue;
    if(MssIsNull(kStrO)) continue;
    if(MssIsNull(cStr)) continue;
    if(MssIsNull(rStr)) continue;
    if(MssIsNull(eStr)) continue;

    cNum=mssHashMember(keyInfo->cHash,cStr)->val.v.i;
    rNum=mssHashMember(keyInfo->rHash,rStr)->val.v.i;
    eNum=mssHashMember(keyInfo->eHash,eStr)->val.v.i;
    kNumO=mssHashMember(keyInfo->kHash,kStrO)->val.v.i;
    kNumN=mssHashMember(keyInfo->kHash,kStrN)->val.v.i;
    fValO=atof(fStrO);
    fValN=atof(fStrN);

    setKeyBreakInfo(keyInfo, frd);
    if(keyInfo->kKB){
      CurYplus =con->line[cNum][rNum]->origin;
      CurYminus=con->line[cNum][rNum]->origin;
//fprintf(stderr,"keyBreak\n");
    }

    /*̾Ԥν*/
//fprintf(stderr,"xxx %s,%s : %g,%g\n",kStrO,kStrN,fValO,fValN);
    writeChart(con, cNum, rNum, eNum, kNumO, kNumN, fValO, fValN,keyInfo,fpw);

  }
  mssFreeFRD(frd);

  /*TOPƥʽ*/
  writeContainer(con, fpw);

  /*output SVG end tag : </svg> */
  writeSVGendTag(fpw);

  if(icid!=NULL) iconv_close(icid);

  /* ɲ 2004/10/31 */
  freeContainer(con);

  for(i=0; i<keyInfo->cHash->cnt; i++){
    for(j=0; j<keyInfo->rHash->cnt; j++){
      mssFree(keyInfo->scale[i][j]);
    }
  }
  mssFreeHash(keyInfo->rHash);
  mssFreeHash(keyInfo->cHash);
  mssFreeHash(keyInfo->kHash);
  mssFreeHash(keyInfo->eHash);
  mssFree(keyInfo->rAdd);
  mssFree(keyInfo->cAdd);
  mssFree(keyInfo->kAdd);
  mssFree(keyInfo->eAdd);
  mssFree(keyInfo);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());                */
//  mssWriteFooter(fpw);    /* եåν             */
  mssCloseFPR(fpr);       /* ϥեΥ     */
  mssCloseFPW(fpw);       /* ϥեΥ     */
  mssFreeFields(sf);      /* ȹܹ¤Τΰ賫 */
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
