/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/06/20                                           */
/* 1.1 : ͤǥȤĥǡưԶн(API) 2003/08/07     */
/* 1.2 : -nȼäǡ̵եηǤΥ顼 2004/10/20          */
/* 1.3 : եηǤΥ顼 2004/10/25                              */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtjoinHelp.h>
struct mssComHelp comHelp={
  "xtjoin",       /* ޥ̾       */
  "1.3",          /* С       */
  HELPT,          /* ޥɥȥ */ 
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--Хѿ*/
static int fcT;       /*ȥιܿ*/
static int fcM;       /*ޥιܿ*/
static int statT;     /*readFRK(Tra)Υơ*/
static int statM;     /*readFRK(Mst)Υơ*/
static struct mssFPW *op;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTFLD;

/**
 * # FUNCTION #
 * ɤ߹ޤƤTraMstΥͤӤ
 */
int keyCmp(
  struct mssFldRecDbl *frdT,
  struct mssFldRec    *frM){
  int cmp;
  int i;
  int fnT;
  int fnM;

  if(frdT->eof)  return(1);  /*T>M*/
  if(statM==EOF) return(-1); /*T<M*/

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp(*(frdT->pnt[frdT->new]+fnT),*(frM ->pnt+fnM));
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

/**
 * # FUNCTION #
 * ޥܤȤstrcntĤǤ񤭽Ф
 * βԤϤ롣
 */
void writeMstFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
    mssWriteDlm(op);
  } 
  mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
  mssWriteRet(op);
} 

/**
 * # FUNCTION #
 * ޥܤȤơcntĤNULLͤȤƽ񤭽Ф
 * βԤϤ롣
 */
void writeMstNul(int cnt){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteNull(op); mssWriteDlm(op);
  } 
  mssWriteNull(op); mssWriteRet(op);
} 

/**
 * # FUNCTION #
 * ȥ󥶥ܤȤstrcntĤǤ񤭽Ф
 * ϥڡϤ롣
 */
void writeTraFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt; i++){
    mssWriteStr(*(str+i),op);
    mssWriteDlm(op);
  } 
} 

/**
 * # FUNCTION #
 * ȥ󥶥󥭡ܤͤ˥ޥܤ¸ߤʤȤ
 * ȥ󥶥Υܤϡޥι(str)򻲾ȤʤϤ
 * ¾Υȥ󥶥ܤNULLͤϤ롣
 */
void writeTraByMst(char **str){
  int kv;
  int i;
  for(i=0; i<fcT; i++){
    kv=*(OPTTKY->fldNo2optNo+i);
    if(kv!=-1){
      mssWriteStr(*(str+MssFlds2num(OPTMKY->flds,kv)),op);
      mssWriteDlm(op);
    }else{
      mssWriteNull(op); mssWriteDlm(op);
    }
  }
}

void writeTM(struct mssFldRecDbl *frdT,struct mssFldRec *frM){

  /*ޥEOFλ*/
  if(frM==NULL){
    writeTraFld(frdT->fldCnt,frdT->pnt[frdT->new]);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*ȥ餬EOFλ*/
  }else if(frdT==NULL){
    writeTraByMst(frM->pnt);
    writeMstFld(OPTFLD->flds->cnt,frM->pnt);
    mssGV.outCnt++;

  /*ȥ顢ޥξ*/
  }else{
    writeTraFld(frdT->fldCnt,frdT->pnt[frdT->new]);
    writeMstFld(OPTFLD->flds->cnt,frM->pnt);
    mssGV.outCnt++;
  }
}

void writeNulMstHash(struct mssHashFld *hash){
  struct mssHashNodeFld *node;
  int i,j;

  for(i=0; i<hash->hashVal; i++){ /*hashͤ򸫤*/
    node=*(hash->node+i);
    while(node != NULL){          /*hashͤiΥΡɤƸ*/
      if(!node->endFlg){          /*ΥΡɤ⸡Ƥʤ*/
        for(j=0; j<node->recCnt; j++){
          writeTraByMst(*(node->rec+j));
          writeMstFld(OPTFLD->flds->cnt,*(node->rec+j));
          mssGV.outCnt++;
        }
      }
      node=node->next;
    }
  }
}

void writeTMhash(struct mssFldRec *frT,struct mssHashNodeFld *hn){

  /*ޥNULLλ*/
  if(hn==NULL){
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*ȥ顢ޥξ*/
  }else{
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstFld(OPTFLD->flds->cnt,*hn->rec);
    mssGV.outCnt++;
  }
}

/*============================================================================*/
/* version 1.00 2000/07/07  hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    TKYT,   /* ΥץΥȥ(Helpɽ)                         */
    TKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ȥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* ץ󥿥                                             */
    "K",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    MKYT,   /* ΥץΥȥ(Helpɽ)                         */
    MKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ȥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* ץ󥿥                                             */
    "m",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    MSTT,   /* ΥץΥȥ(Helpɽ)                         */
    MSTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ޥouterJoin                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLG optMNL={
    OFLG,   /* ץ󥿥                                             */
    "N",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    MNLT,   /* ΥץΥȥ(Helpɽ)                         */
    MNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* outerJoin                                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTNL={
    OFLG,   /* ץ󥿥                                             */
    "n",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TNLT,   /* ΥץΥȥ(Helpɽ)                         */
    TNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥåJoin                                                           */
/*----------------------------------------------------------------------------*/
  MssOptINT optHAS={
    OINT,   /* ץ󥿥                                             */
    "H",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1001,   /* ǥե(ͤȤƻ)                                   */
    11,     /* Ǿ                                                       */
    100001, /*                                                        */
    HAST,   /* ΥץΥȥ(Helpɽ)                         */
    HASC    /* ΥץΥ(Helpɽ)                         */
  };        

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optMKY,&optMST,&optFLD,&optMNL,&optTNL,&optHAS,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdM; /*ȥե<head>Ǽ¤*/
  struct mssHeader    *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fprT;/*ϥե빽¤                */
  struct mssFPR       *fprM;/*ȥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFields    *sfT; /*ȹܹ¤                  */
  struct mssFields    *sfM; /*ȹܹ¤                  */
  int sortedT;              /*Ⱥѥå                */
  int sortedM;              /*Ⱥѥå                */

  /*hash joinˤ*/
  struct mssFldRec    *frT =NULL;
  struct mssFldRecMax *frmM=NULL;

  /*key break joinˤ*/
  struct mssFldRecDbl *frdT=NULL;
  struct mssFldRec    *frM =NULL;

  struct mssFileInfo  *fi=NULL; /*ޥΥե*/

  struct mssHashFld     *hash;
  struct mssHashNodeFld *hn;


  /*ޥԤǤ񤤤Ȥon -tnullñʤ륭֥졼ʬ*/
  int mstw;

  int mstIsSmall;
  int procType;
  int kc;
  int i;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  
  /*-KꤵƤʤ-k򥳥ԡ*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }
  
  fprT=mssOpenFPR(optINF.str,4);    /*ե륪ץ*/
  fprM=mssOpenFPR(optMST.str,128);  /*ޥե륪ץ*/
  hdT=mssReadHeader(fprT);          /*̾ɤ߹*/
  hdM=mssReadHeader(fprM);          /*̾ɤ߹*/
  
  mssSetOptKey(&optTKY, hdT);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptKey(&optMKY, hdM);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optFLD, hdM);       /* ץܤإåܤ˴ϢŤ*/
  
  /*traȹܤκ*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfT);        /* ֹͥϿˤդ   */
  sortedT=mssChkSorted(sfT,hdT);        /* ȺѤå                 */
  
  /*mstȹܤκ*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfM);        /* ֹͥϿˤդ   */
  sortedM=mssChkSorted(sfM,hdM);        /* ȺѤå                 */
  
  /*hashǤʤаԤ¤˥ޥξ*/
  if(!optHAS.set){
    fi=mssGetFileInfo(optMST.str,10000);
  
  /*hashʤԥޥξ*/
  }else{
    fi=mssGetFileInfo(optMST.str,0);
  }

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
/* Tra礭Ȥǹͤ*/
/* TraSrt MstSrt MstSmall */
/* ̵     ̵      hash                (1)*/
/* ̵     ̵      Tsrt+Msrt + keyBreak(2)*/
/* ̵           hash                (1)*/
/* ̵           Tsrt      + keyBreak(3)*/
/*      ̵      Msrt      + keyBreak(4)*/
/*      ̵      Msrt      + keyBreak(4)*/
/*                        keyBreak(5)*/
/*                        keyBreak(5)*/

  /*ޥɤΥå*/
  if(!fi->readEnd){  /*ǸޤɤڤäƤʤ*/
    mstIsSmall=0;
  }else{             /*¾ϡsmallǤȽ*/
    mstIsSmall=1;
  }
  mssFree(fi);

  /*פη*/
  if(sortedT==1){
    if(sortedM==1){
      if(mstIsSmall) procType=5;
      else           procType=5;
    }else{
      if(mstIsSmall) procType=4;
      else           procType=4;
    }
  }else{
    if(sortedM==1){
      if(mstIsSmall) procType=1;
      else           procType=3;
    }else{
      if(mstIsSmall) procType=1;
      else           procType=2;
    }
  }

  /*hashλϡŪtype1*/
  if(optHAS.set) procType=1;

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdT);

  /*ϥإåܤɲ*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*̾ɲä*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  if(procType==2 || procType==3){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*Хѿå*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTFLD=&optFLD;
  op=fpw;

  /*hash join*/
  if(procType==1){

    /*ϥåơ֥κ*/
    frmM =mssInitFRM(fcM);
    mssReadFRM(fprM,frmM);

    /*ɤ߹ǤϤʤΤeofե饰äƤϤ*/
    if(!frmM->eof) {
      mssShowErrMsg("internal error in xtjoin by hash");
      mssEnd(mssErrorNoDefault);
    }
    hash=mssInitHashFld(optHAS.val,optMKY.flds);
    for(i=0; i<frmM->recCnt; i++){
      mssHashInsertFld(hash, frmM->pnt+i*frmM->fldCnt);
    }
/*mssShowHashFld(hash, frmM->fldCnt);*/

    frT =mssInitFldRec(fcT);
    while(1){
      statT=mssReadFldRec(fprT,frT);

      /*Tra Endλ*/
      if(statT==EOF){
        if(optMNL.set) writeNulMstHash(hash);
        break;
      }

      mssGV.inCnt++;

      /*TraΥͤMstˤ뤫ɤ*/
      hn=mssHashMemberFld(hash, frT->pnt, optTKY.flds);
      if(hn==NULL && !optTNL.set) continue;

      /*񤭽Ф*/
      writeTMhash(frT,hn);
    }

    mssFreeFRM(frmM);
    mssFreeFldRec(frT);
    mssFreeHashFld(hash);

  }else{

    frdT=mssInitFRD(fcT);
    frM =mssInitFldRec(fcM);
    if(sortedT!=1){
      fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
    }
    if(sortedM!=1){
      fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
    }

    /*ȥɤ߹*/
    statT=mssReadFRD(fprT,frdT);

    /*ޥɤ߹*/
    statM=mssReadFldRec(fprM,frM); mstw=0;
    while(1){

      /*Tra,MstξEndλ*/
      if(statT==EOF && statM==EOF) break;

      /*TraEndλ*/
      if(frdT->eof==1){
        if(statM==EOF) break;
        if(!optMNL.set) break;
      }

      /*MstEndλ*/
      if(statM==EOF){
        if(!optTNL.set) break;
      }

      kc=keyCmp(frdT,frM);
      if(kc == 1){       /*T>M*/
        if(optMNL.set && mstw==0) writeTM(NULL,frM);
        statM=mssReadFldRec(fprM,frM); mstw=0;
      }else if(kc ==-1){ /*T<M*/
        if(optTNL.set) writeTM(frdT,NULL);
        statT=mssReadFRD(fprT,frdT);
        mssGV.inCnt++;
      }else{             /*T==M*/
        writeTM(frdT,frM);
        mstw=1;
        statT=mssReadFRD(fprT,frdT);
        mssGV.inCnt++;
      }
    }
    mssFreeFRD(frdT);
    mssFreeFldRec(frM);
  }

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν              */
  mssCloseFPR(fprT);      /*ϥեΥ      */
  mssCloseFPR(fprM);      /*ϥեΥ      */
  mssCloseFPW(fpw);       /*ϥեΥ      */
  mssFreeFields(sfT);     /*ȹܹ¤Τΰ賫  */
  mssFreeFields(sfM);     /*ȹܹ¤Τΰ賫  */
  mssFreeHeader(hdT);     /*ϥإåΰ賫          */
  mssFreeHeader(hdM);     /*ϥإåΰ賫          */
  mssFreeHeader(hdo);     /*ϥإåΰ賫          */
  mssFreeOption(opt);     /*ץΰ賫          */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
