/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : (2004/08/13)                                                 */
/* 1.1 : ꡼(2004/10/31)                                         */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2gmlHelp.h>
struct mssComHelp comHelp={
  "xt2gml",       /* ޥ̾       */
  "1.1",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */                                      
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */                                      
  HELPH           /* ۡڡ     */
};
    
extern struct mssGlobalVariables mssGV;

/**
 * # FUNCTION #
 * ɤ߹ޤƤΡɤȥåեΥͤӤ
 */
int keyCmp(
  struct mssFldRecDbl *frdN,
  struct mssFldRecDbl *frdE,
  struct mssFields    *fldsN,
  struct mssFields    *fldsE){
  int cmp;
  int i;
  int fnN;
  int fnE;
  
  for(i=0; i<fldsN->cnt; i++){
    fnN=MssFlds2num(fldsN,i);
    fnE=MssFlds2num(fldsE,i);
    cmp = strcmp(*(frdN->pnt[frdN->old]+fnN),
                 *(frdE->pnt[frdE->new]+fnE));
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

/**
 * # FUNCTION #
 * VertexǤν
 * Vertex򼨤(-v)ϥåϿ򤫤
 */
struct mssHash *writeVertex(
  struct mssFldRecDbl *frdN,
  struct mssFPR       *fprN,
  MssOptKEY           *optNKY,
  MssOptFLD           *optNID,
  MssOptFLD           *optNAT,
  MssOptFLG           *optWOT,
  struct mssFPW       *fpw){

  int dimention;
  struct mssXmlTag *vTag; /* Vertex*/
  struct mssXmlTag *lTag; /* VertexLabel*/
  char *fldVal;
  int i;
  int nulFlg;
  struct mssHash *hash;
  MssValue v; /* hashϿ */
  char buf[MssRecordMaxLen];
  struct mssHashNode *hn;

  if(!optWOT->set) dimention=optNID->cnt+optNAT->cnt;
  else             dimention=            optNAT->cnt;

  hash=mssInitHash(101); /* hash¤Τν */
  mssVinit(&v,INT);         /* vertexID */
  v.v.i=1;                  /*vertexID1Ϥޤ*/

  while(1){
    mssReadFRD(fprN,frdN);

    /* ΡIDΥϥåϿ (nullͤޤǤϿʤ) */
    nulFlg=0;
    buf[0]='\0';
    for(i=0; i<optNID->cnt; i++){
      fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNID->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(buf,fldVal);
    }
    /* ܤ(ʸ)ϥåɽϿ       */
    /* ϥåɽˤʤСΡɤɲä */
    if(!nulFlg){
      hn=mssHashInsert(hash,buf,v);
      if(hn==NULL){
        mssShowErrMsg("-n fields must be unique");
        mssEnd(mssErrorNoDefault);
      }
    }else{
      continue;
    }
 
    /* <Vertex vertexID="1" dimention="2"> */
    vTag=mssInitXmlTag("Vertex",NULL);
    mssAddXmlTagAttributeInt(vTag,"vertexId" , hn->val.v.i , NULL);
    mssAddXmlTagAttributeInt(vTag,"dimention", dimention, NULL);
    mssWriteXmlStartTag(vTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    if(!optWOT->set){
      for(i=0; i<optNID->flds->cnt; i++){
        /* <VertexLabel field="year" value="2004"> */
        fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNID->flds,i));
        lTag=mssInitXmlTag("VertexLabel",NULL);
        mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optNID->flds,i),NULL);
        mssAddXmlTagAttributeStr(lTag,"value", fldVal     , NULL);
        mssWriteXmlEmptyTag(lTag,NULL,fpw);
        mssWriteRet(fpw); mssGV.outCnt++;
        mssFreeXmlTag(lTag);
      }
    }

    for(i=0; i<optNAT->flds->cnt; i++){
      /* <VertexLabel field="year" value="2004"> */
      fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNAT->flds,i));
      lTag=mssInitXmlTag("Vertex",NULL);
      mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optNAT->flds,i), NULL);
      mssAddXmlTagAttributeStr(lTag,"value", fldVal     , NULL);
      mssWriteXmlEmptyTag(lTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(lTag);
    }

    /* </Vertex> */
    mssWriteXmlEndTag(vTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(vTag);

    if(mssKeyBreak(frdN, optNKY)) break;

    if(frdN->eof) break;

    v.v.i++;
  }

  return(hash);
}

/**
 * # FUNCTION #
 * EdgeǤν
 */
void writeEdge(
  struct mssFldRecDbl *frdE,
  struct mssFPR       *fprE,
  struct mssHash      *hash,
  MssOptKEY           *optEKY,
  MssOptFLD           *optEBG,
  MssOptFLD           *optEED,
  MssOptFLD           *optDIR,
  MssOptFLG           *optDFG,
  MssOptFLD           *optEAT,
  struct mssFPW       *fpw){

  int dimention=optEAT->flds->cnt;
  struct mssXmlTag *eTag; /* Edge*/
  struct mssXmlTag *lTag; /* EdgeLabel*/
  char *fldVal;
  int i;
  int nulFlg;
  char bufB[MssRecordMaxLen];
  char bufE[MssRecordMaxLen];
  struct mssHashNode *hn;
  int bNo=0,eNo=0;
  char *dir;

  while(1){
    mssReadFRD(fprE,frdE);

    /* -bܤͤ (nullͤޤǤФʤˤ⤷ʤ) */
    nulFlg=0;
    bufB[0]='\0';
    for(i=0; i<optEBG->cnt; i++){
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEBG->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(bufB,fldVal);
    }
    if(nulFlg) continue;

    /* -eܤͤ (nullͤޤǤФʤˤ⤷ʤ) */
    nulFlg=0;
    bufE[0]='\0';
    for(i=0; i<optEED->cnt; i++){
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEED->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(bufE,fldVal);
    }
    if(nulFlg) continue;

    /* -eܤͤhashɽ䤤碌Ρֹ */
    hn=mssHashMember(hash,bufB);
    if(hn!=NULL) {
      bNo=hn->val.v.i;
    }else{
      mssShowErrMsg("internal error in referencing a hash");
      mssEnd(mssErrorNoDefault);
    }

    /* -bܤͤhashɽ䤤碌Ρֹ */
    hn=mssHashMember(hash,bufE);
    if(hn!=NULL) {
      eNo=hn->val.v.i;
    }else{
      mssShowErrMsg("internal error in referencing a hash");
      mssEnd(mssErrorNoDefault);
    }

    /* direction(-Dܤ͡-Dir) */
    if(optDFG->set){
      dir="directed";
    }else{
      if(optDIR->set){
        fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optDIR->flds,0));
        if(MssIsNull(fldVal) || *fldVal=='0') {
          dir="undirected";
        }else{
          dir="directed";
        }
      }else{
        dir="undirected";
      }
    }

    /* <Edge edgeID="1" edgeType="undirected" dimention="2"
                        bgnVertexId="1" endVertexId="2" > */
    eTag=mssInitXmlTag("Edge",NULL);
    mssAddXmlTagAttributeStr(eTag,"edgeType" ,dir , NULL);
    mssAddXmlTagAttributeInt(eTag,"dimention", dimention, NULL);
    mssAddXmlTagAttributeInt(eTag,"bgnVertexId", bNo, NULL);
    mssAddXmlTagAttributeInt(eTag,"endVertexId", eNo, NULL);
    mssWriteXmlStartTag(eTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    for(i=0; i<optEAT->flds->cnt; i++){
      /* <EdgeLabel field="att1" value="xxx"> */
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEAT->flds,i));
      lTag=mssInitXmlTag("EdgeLabel",NULL);
      mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optEAT->flds,i), NULL);
      mssAddXmlTagAttributeStr(lTag,"value", fldVal, NULL);
      mssWriteXmlEmptyTag(lTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(lTag);
    }

    /* </Edge> */
    mssWriteXmlEndTag(eTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(eTag);

    if(mssKeyBreak(frdE, optEKY)) break;

    if(frdE->eof) break;
  }
}


int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ΡɥեΥե                                             */
/*----------------------------------------------------------------------------*/
  MssOptKEY optNKY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    NKYT,   /* ΥץΥȥ(Helpɽ)                         */
    NKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* åեΥե                                             */
/*----------------------------------------------------------------------------*/
  MssOptKEY optEKY={
    OKEY,   /* ץ󥿥                                             */
    "K",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "I",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    EKYT,   /* ΥץΥȥ(Helpɽ)                         */
    EKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ΡID                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNID={
    OFLD,   /* ץ󥿥                                             */
    "v",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    NIDT,   /* ΥץΥȥ(Helpɽ)                         */
    NIDC,   /* ΥץΥ(Helpɽ)                         */
    NIDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* Ρ°                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNAT={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    NATT,   /* ΥץΥȥ(Helpɽ)                         */
    NATC,   /* ΥץΥ(Helpɽ)                         */
    NATF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* åγϥΡɹ                                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEBG={
    OFLD,   /* ץ󥿥                                             */
    "b",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "I",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    EBGT,   /* ΥץΥȥ(Helpɽ)                         */
    EBGC,   /* ΥץΥ(Helpɽ)                         */
    EBGF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* åγϥΡɹ                                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEED={
    OFLD,   /* ץ󥿥                                             */
    "e",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "I",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    EEDT,   /* ΥץΥȥ(Helpɽ)                         */
    EEDC,   /* ΥץΥ(Helpɽ)                         */
    EEDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* å°                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEAT={
    OFLD,   /* ץ󥿥                                             */
    "F",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "I",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    EATT,   /* ΥץΥȥ(Helpɽ)                         */
    EATC,   /* ΥץΥ(Helpɽ)                         */
    EATF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* Ρɥե                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optNIF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    NIFT,   /* ΥץΥȥ(Helpɽ)                         */
    NIFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* åե                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optEIF={
    OINF,   /* ץ󥿥                                             */
    "I",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    EIFT,   /* ΥץΥȥ(Helpɽ)                         */
    EIFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* directed/undirectedե饰                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLD optDIR={
    OFLD,   /* ץ󥿥                                             */
    "d",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "I",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    DIRT,   /* ΥץΥȥ(Helpɽ)                         */
    DIRC,   /* ΥץΥ(Helpɽ)                         */
    DIRF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* directedե饰                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optDFG={
    OFLG,   /* ץ󥿥                                             */
    "D",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    DFGT,   /* ΥץΥȥ(Helpɽ)                         */
    DFGC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* -n ιܤgraphLabel˴ޤʤե饰                                      */
/*----------------------------------------------------------------------------*/
  MssOptFLG optWOT={
    OFLG,   /* ץ󥿥                                             */
    "w",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    WOTT,   /* ΥץΥȥ(Helpɽ)                         */
    WOTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ԡ饤                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCPY={
    OSTR,   /* ץ󥿥                                             */
    "cr",   /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "musashi.sourceforge.jp", /* ǥե                                 */
    1,      /* ʸκǾĹ                                               */
    250,    /* ʸκĹ                                   */
    CPYT,   /* ΥץΥȥ(Helpɽ)                         */
    CPYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* description                                                                */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDSC={
    OSTR,   /* ץ󥿥                                             */
    "desc",   /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "xt2gml", /* ǥե                                                */
    1,      /* ʸκǾĹ                                               */
    250,    /* ʸκĹ                                   */
    DSCT,   /* ΥץΥȥ(Helpɽ)                         */
    DSCC    /* ΥץΥ(Helpɽ)                         */
  };


/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optNKY,&optEKY,&optNID,&optNAT,&optEBG,&optEED,&optEAT,
               &optNIF,&optEIF,&optOTF,&optDIR,&optDFG,&optWOT,&optTXT,
               &optTMP,&optCPY,&optDSC,NULL};
    
/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader *hdN; /*Ρɥե<head>Ǽ¤*/
  struct mssHeader *hdE; /*åե<head>Ǽ¤*/

  struct mssFPR    *fprN; /*Ρɥե빽¤*/
  struct mssFPR    *fprE; /*åե빽¤*/
  struct mssFPW    *fpw; /*ϥե빽¤*/
  struct mssFldRec *fr;  /*-ԥХåե¤*/
  struct mssFldRecDbl *frdN;  /*-ԥХåե¤*/
  struct mssFldRecDbl *frdE;  /*-ԥХåե¤*/
  struct mssFields *sfN; /*ȹܹ¤*/
  struct mssFields *sfE; /*ȹܹ¤*/
  int sortedN;           /*Ⱥѥå*/
  int sortedE;           /*Ⱥѥå*/

  struct mssHash *hash=NULL;     /* ΡIDͤǼhash */

  struct mssHash **hashNID=NULL;  /* -nܤͤǼhash */
  struct mssHash **hashNAT=NULL;  /* -bܤͤǼhash */
  struct mssHash **hashEAT=NULL;  /* -eܤͤǼhash */
  struct mssHash *hs;             /* ׻hash */
  struct mssHashNode *hn;

  MssValue v; /* hashϿѥߡ */
  char *fldVal;
  int i,j;
  int kc;
  int gNo;
  struct mssXmlTag *rTag; /* root(graphML)*/
  struct mssXmlTag *hTag; /* header*/
  struct mssXmlTag *dTag; /* DataDictionary*/
  struct mssXmlTag *dfTag; /* DataField*/
  struct mssXmlTag *gTag; /* graph*/
  struct mssXmlTag *gdTag; /* GraphData*/
  struct mssXmlTag *tag; /* */
  int    nf;
  int    numFlg;

/*------------------------------------------------------------------------------
ѥ᡼
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  /*-KꤵƤʤ-k򥳥ԡ*/
  if(!optEKY.set){
    mssCpyOptKey(&optEKY,&optNKY);
  }

  fprN=mssOpenFPR(optNIF.str,4);       /* Ρɥե륪ץ       */
  fprE=mssOpenFPR(optEIF.str,4);       /* åե륪ץ       */
  hdN=mssReadHeader(fprN);             /* Ρɥեإåɤ߹ */
  hdE=mssReadHeader(fprE);             /* åեإåɤ߹ */

  mssSetOptKey(&optNKY, hdN); /* -k */
  mssSetOptFld(&optNID, hdN); /* -n */
  mssSetOptFld(&optNAT, hdN); /* -f */
  mssSetOptKey(&optEKY, hdE); /* -K */
  mssSetOptFld(&optEBG, hdE); /* -b */
  mssSetOptFld(&optEED, hdE);        /* -e ܤإåܤ˴ϢŤ */
  mssSetOptFld(&optDIR, hdE);        /* -d ܤإåܤ˴ϢŤ */
  mssSetOptFld(&optEAT, hdE);        /* -F ܤإåܤ˴ϢŤ */

  /*ΡɤΥȹܤκ*/
  sfN=mssInitFields();
  mssAddFieldsByFields(sfN,optNKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfN);        /* ֹͥϿˤդ   */
  sortedN=mssChkSorted(sfN,hdN);        /* ȺѤå                 */

  /*åΥȹܤκ*/
  sfE=mssInitFields();
  mssAddFieldsByFields(sfE,optEKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfE);        /* ֹͥϿˤդ   */
  sortedE=mssChkSorted(sfE,hdE);        /* ȺѤå                 */


/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  if(!sortedN){
    fprN=mssReopenFPRsort(fprN,4,sfN,hdN->flds->cnt,optTMP.str);
  }
  if(!sortedE){
    fprE=mssReopenFPRsort(fprE,4,sfE,hdE->flds->cnt,optTMP.str);
  }

  /* ΡIDܤ٥󤷡ϥå˳ǼIDֹդ*/
  /* Ρ°ܤ٥󤷡ϥå˳Ǽ*/

  /* ΡIDϢ */
  hashNID=mssCalloc(sizeof(struct mssHash *)*optNID.flds->cnt,"main");
  for(i=0;i<optNID.flds->cnt;i++){
    *(hashNID+i)=mssInitHash(101); /* hash¤Τν */
  }

  /* Ρ°Ϣ */
  hashNAT=mssCalloc(sizeof(struct mssHash *)*optNAT.flds->cnt,"main");
  for(i=0;i<optNAT.flds->cnt;i++){
    *(hashNAT+i)=mssInitHash(101); /* hash¤Τν */
  }

  /* Ρɥե򥹥 */
  fr=mssInitFldRec(hdN->flds->cnt);
  mssVinit(&v,INT);         /* hashϿѥߡ */
  while(EOF!=mssReadFldRec(fprN,fr)){

    /* ΡID (nullͤϿʤ) */
    for(i=0;i<optNID.flds->cnt;i++){
      fldVal=*(fr->pnt + MssFlds2num(optNID.flds,i));
      if(!MssIsNull(fldVal)) {
        mssHashInsert(*(hashNID+i),fldVal,v); /* vϥߡ */
      }
    }
 
    /* Ρ° (nullͤϿ)*/
    for(i=0;i<optNAT.flds->cnt;i++){
      numFlg=mssIsFldOptOn(&optNAT,i,'n');
      if(!numFlg){ /* numericܤϥå*/
        fldVal=*(fr->pnt + MssFlds2num(optNAT.flds,i));
        mssHashInsert(*(hashNAT+i),fldVal,v); /* vϥߡ */
      }
    }
  }
  mssFreeFldRec(fr);


  /* å°Ϣ */
  hashEAT=mssCalloc(sizeof(struct mssHash *)*optEAT.flds->cnt,"main");
  for(i=0;i<optEAT.flds->cnt;i++){
    *(hashEAT+i)=mssInitHash(101); /* hash¤Τν */
  }

  /* åե򥹥 */
  fr=mssInitFldRec(hdE->flds->cnt);
  while(EOF!=mssReadFldRec(fprE,fr)){
    /* å°(nullͤϿ) */
    for(i=0;i<optEAT.flds->cnt;i++){
      numFlg=mssIsFldOptOn(&optNAT,i,'n');
      if(!numFlg){ /* numericܤϥå*/
        fldVal=*(fr->pnt + MssFlds2num(optEAT.flds,i));
        mssHashInsert(*(hashEAT+i),fldVal,v); /* vϥߡ */
      }
    }
  }
  mssFreeFldRec(fr);


/*----------------------------------------------------------------------------*/
/* XMLإå & graphMLإå                                          */
/*----------------------------------------------------------------------------*/
  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,0,0);

  /*xmlإåν񤭽Ф*/
  mssWriteXmlDeclaration(MssXmlDefVer,MssXmlDefEnc,fpw);
  mssGV.outCnt++;

  /* <GraphML version="0.1"> */
  rTag=mssInitXmlTag("GraphML",NULL);
  mssAddXmlTagAttributeStr(rTag,"version", "0.1", NULL);
  mssWriteXmlStartTag(rTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /* <Header copyright="xxx" description="xxxxx"/> */
  hTag=mssInitXmlTag("Header",NULL);
  mssAddXmlTagAttributeStr(hTag,"copyright", optCPY.str, NULL);
  mssAddXmlTagAttributeStr(hTag,"description", optDSC.str, NULL);
  mssWriteXmlStartTag(hTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /*   <DataDictionary numberOfFields="xxxxx"> */
  if(!optWOT.set) nf=optNID.cnt+optNAT.cnt+optEAT.cnt;
  else            nf=           optNAT.cnt+optEAT.cnt;
  dTag=mssInitXmlTag("DataDictionary",NULL);
  mssAddXmlTagAttributeInt(dTag,"numberOfFields",nf,NULL);
  mssWriteXmlStartTag(dTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /*     <DataField name="xxx" optype="xxxxx"> */
  /*       <Value value="xxx"/> */
  /*     </DataField> */

  /* -v */
  if(!optWOT.set){
    for(i=0; i<optNID.cnt; i++){
      dfTag=mssInitXmlTag("DataField",NULL);
      mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optNID.flds,i),NULL);
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      hs=*(hashNID+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(dfTag);
    }
  }

  /* -f */
  for(i=0; i<optNAT.cnt; i++){
    numFlg=mssIsFldOptOn(&optNAT,i,'n');
    dfTag=mssInitXmlTag("DataField",NULL);
    mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optNAT.flds,i),NULL);
    if(numFlg){
      mssAddXmlTagAttributeStr(dfTag,"optype","numerical",NULL);
      mssWriteXmlEmptyTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }else{
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;

      hs=*(hashNAT+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }
    mssFreeXmlTag(dfTag);
  }

  /* -F */
  for(i=0; i<optEAT.cnt; i++){
    numFlg=mssIsFldOptOn(&optEAT,i,'n');
    dfTag=mssInitXmlTag("DataField",NULL);
    mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optEAT.flds,i),NULL);
    if(numFlg){
      mssAddXmlTagAttributeStr(dfTag,"optype","numerical",NULL);
      mssWriteXmlEmptyTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }else{
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;

      hs=*(hashEAT+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }
    mssFreeXmlTag(dfTag);
  }


  /*   </DataDictionary> */
  mssWriteXmlEndTag(dTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(dTag);

  /* </Header> */
  mssWriteXmlEndTag(hTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(hTag);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /* <GraphData> */
  gdTag=mssInitXmlTag("GraphData",NULL);
  mssWriteXmlStartTag(gdTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /* <Graph graphID="xx"> */

  mssSeekTopFPR(fprN);
  mssSeekTopFPR(fprE);

  frdN=mssInitFRD(hdN->flds->cnt);
  frdE=mssInitFRD(hdE->flds->cnt);

  mssReadFRD(fprN,frdN);
  mssReadFRD(fprE,frdE);
  frdN->firstRead=0;
  frdE->firstRead=0;
  gNo=1;
  while(1){

    /* Ρɥե뤬End */
    if(frdN->eof) break;

    /* <Graph graphID="1"> */
    gTag=mssInitXmlTag("Graph",NULL);
    mssAddXmlTagAttributeInt(gTag,"graphId", gNo, NULL);
    mssWriteXmlStartTag(gTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    /* Ρɤν񤭽Ф */
    hash=writeVertex(frdN,fprN,&optNKY,&optNID,&optNAT,&optWOT,fpw);

BgnLoop:
    /* åե뤬End */
    if(frdE->eof) goto EndLoop;

    kc=keyCmp(frdN,frdE,optNKY.flds,optEKY.flds);
    if(kc>0){        /*T>M*/
      /* åե򥹥å*/
      while(kc>0){
        mssReadFRD(fprE,frdE);
        kc=keyCmp(frdN,frdE,optNKY.flds,optEKY.flds);
        if(frdE->eof)break;
      }
      goto BgnLoop;
    }else if(kc<0) { /*T<M*/
      goto EndLoop;
    }else{           /*T==M*/
      writeEdge(frdE,fprE,hash,&optEKY,&optEBG,&optEED,&optDIR,&optDFG,&optEAT,fpw);
    }
EndLoop:

    mssFreeHash(hash);

    /* </Graph> */
    mssWriteXmlEndTag(gTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(gTag);
    gNo++;
  }

  /* </GraphData> */
  mssWriteXmlEndTag(gdTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(gdTag);

  /* </GraphML> */
  mssWriteXmlEndTag(rTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(rTag);


  /* free */
  if(hashNID!=NULL){
    for(i=0;i<optNID.flds->cnt;i++){
      mssFreeHash(*(hashNID+i)); /* hash¤Τν */
    }
    mssFree(hashNID);
  }
  if(hashNAT!=NULL){
    for(i=0;i<optNAT.flds->cnt;i++){
      mssFreeHash(*(hashNAT+i)); /* hash¤Τν */
    }
    mssFree(hashNAT);
  }
  if(hashEAT!=NULL){
    for(i=0;i<optEAT.flds->cnt;i++){
      mssFreeHash(*(hashEAT+i)); /* hash¤Τν */
    }
    mssFree(hashEAT);
  }

  mssFreeFRD(frdN);
  mssFreeFRD(frdE);


/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fprN);       /*ϥեΥ*/
  mssCloseFPR(fprE);       /*ϥեΥ*/
  mssCloseFPW(fpw);        /*ϥեΥ*/
  mssFreeFields(sfN);      /* ȹܹ¤Τΰ賫(ɲ2004/10/31) */
  mssFreeFields(sfE);      /* ȹܹ¤Τΰ賫(ɲ2004/10/31) */
  mssFreeHeader(hdN);      /*ϥإåΰ賫*/
  mssFreeHeader(hdE);      /*ϥإåΰ賫*/
  mssFreeOption(opt);      /*ץΰ賫*/
  mssShowEndMsg();         /*λå*/
  mssEnd(mssExitSuccess);  /*λ*/
  return(0); /* to avoid warning message*/
}
