/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤMssValue˴ؤؿ
 *
 * Change log
 * 2004/02/14 : ͱ黻ϰϥ顼Υåɲ(finite)
 * 2004/08/02 : mssVcmpmssVcmpOpeѹ+mssVcmpؿɲ
 * ============================================================================
 * NULLФ黻NULL
 */


#include <musashi/mssValue.h>
#include <musashi/mssBase.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <regex.h>
#include <math.h>
#include <errno.h>
#include <limits.h>
#include <float.h>


/**
 * # FUNCTION #
 * MssValueν
 * MssValue򣰥ꥢΥǡפ򥻥åȤ롣
 */
void mssVinit(MssValue *v, enum vType vType)
{
  v->vType=vType;
  mssVclear(v);
} 

/**
 * # FUNCTION #
 * MssValueΣꥢ
 */
void mssVclear(MssValue *v)
{
  v->nul=0;
  v->v.d=0; /*Ǥ⥵礭(double)ǽ*/
} 

/**
 * # FUNCTION #
 * MssValueη˱ǾͤǤΥꥢ
 * INT:INT_MIN
 * DBL:-DBL_MAX
 * ¾η:NULL򥻥å
 */
void mssVclearMin(MssValue *v)
{
  v->nul=0;
  switch(v->vType){
    case INT: v->v.i= INT_MIN; break;
    case DBL: v->v.d=-DBL_MAX; break;
    default : MssVnull(*v);    break;
  }
}
  
/**
 * # FUNCTION #
 * MssValueη˱ͤǤΥꥢ
 * INT:INT_MAX
 * DBL:DBL_MAX
 * ¾η:NULL򥻥å
 */
void mssVclearMax(MssValue *v)
{
  v->nul=0;
  switch(v->vType){
    case INT: v->v.i= INT_MAX; break;
    case DBL: v->v.d= DBL_MAX; break;
    default : MssVnull(*v);    break;
  }
}
 
/**
 * # FUNCTION #
 * intMssValueINTѴ
 */
MssValue mssVint2i(int i)
{
  MssValue v;

  mssVinit(&v,INT);
  v.v.i=i;
  return(v);
}

/**
 * # FUNCTION #
 *intMssValueDBLѴ
 */
MssValue mssVint2d(int i)
{
  MssValue v;

  mssVinit(&v,DBL);
  v.v.d=(double)i;
  return(v);
}

/**
 * # FUNCTION #
 * intMssValueSTRѴ
 * MssValueSTR˿ʸΰݤ롣
 */
MssValue mssVint2s(int i)
{
  MssValue v;

  mssVinit(&v,STR);
  v.v.s=mssItoA(i);
  return(v);
}

/**
 * # FUNCTION #
 * doubleMssValueINTѴ
 */
MssValue mssVdbl2i(double d)
{
  MssValue v;

  mssVinit(&v,INT);
  v.v.i=(int)d;
  return(v);
}

/**
 * # FUNCTION #
 * doubleMssValueDBLѴ
 */
MssValue mssVdbl2d(double d)
{
  MssValue v;

  mssVinit(&v,DBL);
  v.v.d=d;
  return(v);
}

/**
 * # FUNCTION #
 * doubleMssValueSTRѴ
 * MssValueSTR˿ʸΰݤ롣
 */
MssValue mssVdbl2s(double d)
{
  MssValue v;

  mssVinit(&v,STR);
  v.v.s=mssFtoA(d);
  return(v);
}

/**
 * # FUNCTION #
 * ʸ(char *)MssValueINTѴ
 * ʸƬ"*"(NULL)λϡMssValueNULL˥åȤ롣
 * ѴˤatoiؿѤƤ롣
 */
MssValue mssVstr2i(char *str)
{
  MssValue v;

  mssVinit(&v,INT);

  if(MssIsNull(str)){
    MssVnull(v);
  }else{
    v.v.i=atoi(str);
  }
  return(v);
}

/**
 * # FUNCTION #
 * ʸ(char *)MssValueDBLѴ
 * ʸƬ"*"(NULL)λϡMssValueNULL˥åȤ롣
 * ѴˤatofؿѤƤ롣
 */
MssValue mssVstr2d(char *str)
{
  MssValue v;

  mssVinit(&v,DBL);

  if(MssIsNull(str)){
    MssVnull(v);
  }else{
    v.v.d=atof(str);
  }
  return(v);
}

/**
 * # FUNCTION #
 * ʸ(char *)MssValueSTRѴ
 * ʸƬ"*"(NULL)λϡMssValueNULL˥åȤ롣
 * ʸΰ򥳥ԡ뤳ȤϤʤ
 * ʤñ˰strΥɥ쥹򥻥åȤ
 */
MssValue mssVstr2s(char *str)
{
  MssValue v;

  mssVinit(&v,STR);

  if(MssIsNull(str)){
    MssVnull(v);
  }else{
    v.v.s=str;
  }
  return(v);
}

/**
 * # FUNCTION #
 * ηʤΡ顼åλ
 */
static void errorInvalidType(char *msg)
{
  mssShowErrMsg("internal error: invalid type of value is assigned: %s",msg);
  mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * MssValueINTMssValueDBLѴ
 */
MssValue mssVi2d(MssValue v)
{

  if(v.vType!=INT) errorInvalidType("mssVi2d");

  v.vType=DBL;

  if(!v.nul){
    v.v.d=(double)v.v.i;
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueINTMssValueSTRѴ
 */
MssValue mssVi2s(MssValue v)
{

  if(v.vType!=INT) errorInvalidType("mssVi2s");

  v.vType=STR;

  if(!v.nul){
    v.v.s=mssItoA(v.v.i);
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueDBLMssValueINTѴ
 */
MssValue mssVd2i(MssValue v)
{

  if(v.vType!=DBL) errorInvalidType("mssVd2i");

  v.vType=INT;

  if(!v.nul){
    v.v.i=(int)v.v.d;
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueDBLMssValueSTRѴ
 * MssValueSTR˿ʸΰݤ롣
 */
MssValue mssVd2s(MssValue v)
{

  if(v.vType!=DBL) errorInvalidType("mssVd2s");

  v.vType=STR;

  if(!v.nul){
    v.v.s=mssFtoA(v.v.d);
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueSTRMssValueINTѴ
 * Ϳ줿MssValueSTRʸΰϳʤ
 * ѴˤatoiؿѤƤ롣
 */
MssValue mssVs2i(MssValue v)
{

  if(v.vType!=STR) errorInvalidType("mssVs2i");

  v.vType=INT;

  if(!v.nul){
    v.v.i=atoi(v.v.s);
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueSTRMssValueDBLѴ
 * Ϳ줿MssValueSTRʸΰϳʤ
 * ѴˤatofؿѤƤ롣
 */
MssValue mssVs2d(MssValue v)
{

  if(v.vType!=STR) errorInvalidType("mssVs2d");

  v.vType=DBL;

  if(!v.nul){
    v.v.d=atof(v.v.s);
  }
  return(v);
}

/**
 * # FUNCTION #
 * ĤΰηۤΡ顼åλ
 */
static void errorDiffType(char *msg)
{
    mssShowErrMsg("internal error: operation with different types of values");
    mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * MssValue­
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ĤMssValue(v1,v2)ηפʤХ顼Ϥ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVadd(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    v1.nul=0;
    switch(v1.vType){
      case INT: v1.v.i += v2.v.i; break;
      case DBL: v1.v.d += v2.v.d;
                if(finite(v1.v.d)==0) MssVnull(v1);
                break;
      default : errorInvalidType("mssVadd");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * MssValueΰ
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ĤMssValue(v1,v2)ηפʤХ顼Ϥ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVsub(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    v1.nul=0;
    switch(v1.vType){
      case INT: v1.v.i -= v2.v.i; break;
      case DBL: v1.v.d -= v2.v.d; break;
      default : errorInvalidType("mssVadd");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * MssValueΤ
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ĤMssValue(v1,v2)ηפʤХ顼Ϥ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVmul(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    v1.nul=0;
    switch(v1.vType){
      case INT: v1.v.i *= v2.v.i; break;
      case DBL: v1.v.d *= v2.v.d;
                if(finite(v1.v.d)==0) MssVnull(v1);
                break;
      default : errorInvalidType("mssVadd");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * MssValueγ껻
 * MssValueDBLФƤΤѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ĤMssValue(v1,v2)ηפʤХ顼Ϥ롣
 * ֤ͤηϡηƱ(DBL)
 * v2ξNULL֤ͤ
 */
MssValue mssVdiv(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    v1.nul=0;
    switch(v1.vType){
      case DBL:
        if(v2.v.d==0) MssVnull(v1);
        else          v1.v.d /= v2.v.d;
        break;
      default : errorInvalidType("mssVadd");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * MssValueξ;
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ĤMssValue(v1,v2)ηפʤХ顼Ϥ롣
 * ֤ͤηϡηƱ
 * v2ξNULL֤ͤ
 * INTξ"%"黻ҤȤDBLξfmodؿѤƤ롣
 * ex. 5 % 2 = 1, 5.2 % 1.2 = 0.3
 */
MssValue mssVmod(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    v1.nul=0;
    switch(v1.vType){
      case INT:
        if(v2.v.i==0) MssVnull(v1);
        else          v1.v.i %= v2.v.i;
        break;
      case DBL:
        if(v2.v.d==0) MssVnull(v1);
        else          v1.v.d=fmod(v1.v.d,v2.v.d);
        break;
      default : errorInvalidType("mssVadd");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * MssValueʿ
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡη˴ؤ餺DBL
 * v2οξNULL֤ͤ
 */
MssValue mssVsqrt(MssValue v)
{

  if(!v.nul){
    switch(v.vType){
      case INT:
        if(v.v.i<0) MssVnull(v);
        else        v.v.d=sqrt((double)v.v.i);
        break;
      case DBL:
        if(v.v.d<0) MssVnull(v);
        else        v.v.d=sqrt(v.v.d);
        break;
      default : errorInvalidType("mssVsqrt");
    }
  }
  v.vType=DBL;
  return(v);
}

/**
 * # FUNCTION #
 * MssValueΥȥå
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVcntUp(MssValue v)
{

  if(!v.nul){
    switch(v.vType){
      case INT: v.v.i++; break;
      case DBL: v.v.d++; break;
      default : errorInvalidType("mssVcntUp");
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * MssValueΥȥ
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVcntDown(MssValue v)
{

  if(!v.nul){
    switch(v.vType){
      case INT: v.v.i--; break;
      case DBL: v.v.d--; break;
      default : errorInvalidType("mssVcntUp");
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * ĤMssValuev1,v2Ǿ֤ͤ
 * ĤMssValueƱv1֤
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVmin(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    switch(v1.vType){
    case DBL:
      if(v1.v.d>v2.v.d) v1=v2;
      break;
    case INT:
      if(v1.v.i>v2.v.i) v1=v2;
      break;
    default : errorInvalidType("mssVcntUp");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * ĤMssValuev1,v2礭֤ͤ
 * ĤMssValueƱv1֤
 * MssValueINTDBLФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡηƱ
 */
MssValue mssVmax(MssValue v1, MssValue v2)
{

  if(v1.nul || v2.nul){
    MssVnull(v1);
  }else{
    if(v1.vType!=v2.vType) errorDiffType("mssVadd");

    switch(v1.vType){
    case DBL:
      if(v1.v.d<v2.v.d) v1=v2;
      break;
    case INT:
      if(v1.v.i<v2.v.i) v1=v2;
      break;
    default : errorInvalidType("mssVcntUp");
    }
  }
  return(v1);
}

/**
 * # FUNCTION #
 * ĤMssValuea,bӱ黻
 * "a ope b"ɾʤ1ʤ飰֤
 * a,b줫NULLʤ-1֤
 * MssValueINT,DBL,STRФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡint
 */
int mssVcmpOpe(MssValue a, enum OpeType ope, MssValue b)
{
  double d=0;
  int  flag=0;

  if(a.nul || b.nul) return(-1);

  switch(a.vType){
    /*Double ------- -DBL0 0 +DBL0 ++++++++ */
    case DBL:
    d=a.v.d-b.v.d;
    switch(ope){
      case OPE_LT: if(d<-DBL0)           flag=1; break;
      case OPE_LE: if(d< DBL0)           flag=1; break;
      case OPE_GT: if(d> DBL0)           flag=1; break;
      case OPE_GE: if(d>-DBL0)           flag=1; break;
      case OPE_EQ: if(d>=-DBL0&&d<=DBL0) flag=1; break;
      case OPE_NE: if(d< -DBL0||d >DBL0) flag=1; break;
    }
    break;

    /*INT*/
    case INT:
    switch(ope){
      case OPE_LT: if(a.v.i <b.v.i) flag=1; break;
      case OPE_LE: if(a.v.i<=b.v.i) flag=1; break;
      case OPE_GT: if(a.v.i >b.v.i) flag=1; break;
      case OPE_GE: if(a.v.i>=b.v.i) flag=1; break;
      case OPE_EQ: if(a.v.i==b.v.i) flag=1; break;
      case OPE_NE: if(a.v.i!=b.v.i) flag=1; break;
    }
    break;

    /*STR*/
    case STR:
    switch(ope){
      case OPE_LT: if(0> strcmp(a.v.s,b.v.s)) flag=1; break;
      case OPE_LE: if(0>=strcmp(a.v.s,b.v.s)) flag=1; break;
      case OPE_GT: if(0< strcmp(a.v.s,b.v.s)) flag=1; break;
      case OPE_GE: if(0<=strcmp(a.v.s,b.v.s)) flag=1; break;
      case OPE_EQ: if(0==strcmp(a.v.s,b.v.s)) flag=1; break;
      case OPE_NE: if(0!=strcmp(a.v.s,b.v.s)) flag=1; break;
    }
    break;

    default : errorInvalidType("mssVcmpOpe");
    break;
  }
  return(flag);
} 


/**
 * # FUNCTION #
 * ĤMssValuea,bӱ黻
 * "a > b"ʤ+1a<bʤ-1a=bʤ0֤
 * a,b줫NULLʤ9֤
 * MssValueINT,DBL,STRФѲǽǡ¾ηꤵХ顼
 * åɽλ롣
 * ֤ͤηϡint
 */
int mssVcmp(MssValue a, MssValue b)
{
  double d=0;
  int  flag=0;

  if(a.nul || b.nul) return(9);

  switch(a.vType){
    /*Double ------- -DBL0 0 +DBL0 ++++++++ */
    case DBL:
    d=a.v.d-b.v.d;
         if(d<-DBL0) flag=-1;
    else if(d> DBL0) flag=1;
    else             flag=0;
    break;

    /*INT*/
    case INT:
         if(a.v.i<b.v.i) flag=-1;
    else if(a.v.i>b.v.i) flag=1;
    else                 flag=0;
    break;

    /*STR*/
    case STR:
    flag=strcmp(a.v.s,b.v.s);
         if(flag<0) flag=-1;
    else if(flag>0) flag=1;
    else            flag=0;
    break;

    /*ADD*/
    case ADD:
         if(a.v.a<b.v.a) flag=-1;
    else if(a.v.a>b.v.a) flag=1;
    else                 flag=0;
    break;

    default : errorInvalidType("mssVcmp");
    break;
  }
  return(flag);
} 

/**
 * # FUNCTION #
 * MssValueν
 * MssValueηưŪȽǤŬڤ˽Ϥ롣
 */
void mssVwrite(MssValue v, struct mssFPW *fp)
{
  if(v.nul){
    mssWriteNull(fp);
  }else{
    switch(v.vType){
      case INT: mssWriteInt(v.v.i,fp); break;
      case DBL: mssWriteDbl(v.v.d,fp); break;
      case STR: mssWriteStr(v.v.s,fp); break;
      case ADD: mssWriteInt((int)v.v.a,fp); break;
      case USI: mssWriteInt(v.v.usi,fp); break;
    }
  }
}

/**
 * # FUNCTION #
 * MssValueINTν
 */
void mssVwriteInt(MssValue v, struct mssFPW *fp)
{

  if(v.nul){
    mssWriteNull(fp);
  }else{
    mssWriteInt(v.v.i,fp);
  }
}

/**
 * # FUNCTION #
 * MssValueDBLν
 */
void mssVwriteDbl(MssValue v, struct mssFPW *fp)
{

  if(v.nul){
    mssWriteNull(fp);
  }else{
    mssWriteDbl(v.v.d,fp);
  }
}

/**
 * # FUNCTION #
 * MssValueSTRν
 */
void mssVwriteStr(MssValue v, struct mssFPW *fp)
{

  if(v.nul){
    mssWriteNull(fp);
  }else{
    mssWriteStr(v.v.s,fp);
  }
}

