/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤPMMLϢδؿ
 *
 * ¿δؿǰΥȤη줷Ƥ롣
 * ̾  [ɬ | optional] (ꥹ) | CDATA
 * [ɬ]ȥȤƤNULLξErrorλ롣
 *   CDATAξϼͳҤ̣롣
 *   (ꥹ)ξϡΰĤꤵƤʤХ顼λ롣
 * [optional]ȥȤƤNULLξ°ȤƲϤʤ
 *   ʤ[*]ĤǤϥǥեȤ̣Ƥ롣
 * ============================================================================
 */
#include <stdarg.h>
#include <string.h>
#include <musashi/mssOutput.h>
#include <musashi/mssHeader.h>
#include <musashi/mssXml.h>
#include <musashi/mssPMML.h>

/**
 * Хѿ
 */
struct mssPMMLvariables mssPV;

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * PMML̴ؿ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * PMMLϤΤν
 */
void mssPMMLinit(){
  mssPV.indentLevel=0;
  mssPV.outRetCnt=0;
}

/**
 * # FUNCTION #
 * ǥȤν
 * 桼ꤷХѿmssPMML.indentLevelˤäƥǥޤ
 */
void mssPMMLindent(struct mssFPW *fpw){
  int i;
  for(i=0; i<mssPV.indentLevel; i++){
    mssWriteStr("  ",fpw);
  }
}

/**
 * # FUNCTION #
 * °륨ƥƥξˤäƤ뤫å롣
 * ʸ(ܤΰ)ΰꥹ(Ĥʹߤΰ)ˤʤ
 * 顼λ
 */
void checkOneInListAttribute(char *attName, char *elementName, char *att, ...){
  va_list args;
  char *s;
  int stat=0;
  int msgLen=0;
  char *msg;
  char *msg0="attribute %s of %s tag must be one in {";

  va_start(args,att);
  while(1){
    s=va_arg(args, char *);
    if(s==NULL) break;
    msgLen+=strlen(s)+1; /* comma */
    if(0==strcmp(att,s)){
      return;
    }
  }
  va_end(args);

  if(stat==0){
    msgLen+=strlen(msg0)+2; /* }\0 Σʸʬɲ*/
    msg=mssMalloc(sizeof(char)*msgLen,"checkMustOne");
    *msg='\0';
    strcat(msg,msg0);
    va_start(args,att);
    while(1){
      s=va_arg(args, char *);
      if(s==NULL) break;
      strcat(msg,s);
      strcat(msg,",");
    }
    va_end(args);
    strcat(msg,"}");
    mssShowErrMsg(msg,attName,elementName);
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * # FUNCTION #
 * °ե饰(0 or 1)Ǥ뤫å롣
 * 0⤷1ǤʤХ顼λ
 */
void checkIsFlagAttribute(char *attName, char *elementName, int *attInt){
  if(attInt==NULL)return;
  if(*attInt!=0 && *attInt!=0){
    mssShowErrMsg("attribute %s of %s tag must be 0 or 1",attName,elementName);
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * # FUNCTION #
 * ɬܤ°ꤵƤ뤫ɤå롣
 * ʸ(att)NULLξ硢顼λ
 */
void checkMandatoryAttribute(char *attName, char *elementName,void *att){

  if(att==NULL){
    mssShowErrMsg("Internal Error: %s attribute is mandatory in %s tag",attName,elementName);
    mssEnd(mssErrorNoDefault);
  }

}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * General Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * Extension γϥν
 * ex) <Extension extender="MUSASHI" name="optype" value="pattern">
 */
void mssPMMLextensionStart( char *extender, char *name, char *value, int   emptyFlg, struct mssFPW *fpw)
{
  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="Extension";
  tag=mssInitXmlTag(eleNam,NULL);

  /* extender° (Optional)*/
  attNam="extender";
  attStr= extender;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* name° (Optional)*/
  attNam="name";
  attStr= name;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* value° (Optional)*/
  attNam="value";
  attStr= value;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  if(emptyFlg){
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlEmptyTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
    mssPV.indentLevel--;
  }else{
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlStartTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
  }

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Extension νλν
 * ex) </Extension>
 */
void mssPMMLextensionEnd(struct mssFPW *fpw)
{
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="Extension";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}


/**
 * # FUNCTION #
 * Array(ʸ) Ǥν
 * ex) <Array n="3" type="string">a aa aaa</Array>
 */
void mssPMMLarrayStr(int *n, char **str, struct mssFPW *fpw){

  struct mssXmlTag *tag;
  int i;

  char *eleNam;
  char *attNam;
  char *attStr;
  int  *attInt;

  eleNam="Array";
  tag=mssInitXmlTag(eleNam,NULL);

  /* n° (Optional)*/
  attNam="n";
  attInt= n;
  if(n!=NULL){
    mssAddXmlTagAttributeInt(tag,attNam,*attInt,NULL);
  }

  /* type° (Optional)*/
  attNam="type";
  attStr="string";
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  for(i=0; i<*n; i++){
    mssWriteXmlContent(*(str+i),NULL,fpw);
    if(i!=*n-1) mssWriteXmlContent(" ",NULL,fpw);
  }
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * False ζν
 * ex) <True/>
 */
void mssPMMLfalseEmpty(struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;

  eleNam="False";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * True ζν
 * ex) <True/>
 */
void mssPMMLtrueEmpty(struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;

  eleNam="True";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}


/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * PMML Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * PMML γϥν
 * ex) <PMML version="2.0">
 */
void mssPMMLpmmlStart(
  char *version,
  struct mssFPW *fpw){
  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="PMML";
  tag=mssInitXmlTag(eleNam,NULL);

  /* version° (ɬ)*/
  attNam="version";
  attStr= version;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr, "2.0",NULL);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * PMML νλν
 * ex) </PMML>
 */
void mssPMMLpmmlEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="PMML";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Header Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * Header γϥν
 * ex) <Header copyright="MUSASHI" description="customer loyalty">
 */
void mssPMMLheaderStart(
  char *copyright,
  char *description,
  struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="Header";
  tag=mssInitXmlTag(eleNam,NULL);

  /* copyright° (ɬ)*/
  attNam="copyright";
  attStr= copyright;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* description° (Optional)*/
  attNam="description";
  attStr= description;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Header νλν
 * ex) </Header>
 */
void mssPMMLheaderEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="Header";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Application ζν
 * ex) <Application name="xtclassify" version="1.1"/>
 */
void mssPMMLapplicationEmpty(
  char *name,
  char *version,
  struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="Application";
  tag=mssInitXmlTag(eleNam,NULL);

  /* name° (ɬ)*/
  attNam="name";
  attStr= name;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* version° (Optional)*/
  attNam="version";
  attStr= version;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Timestamp ν
 * ex) <Timestamp>10 JUN 2003 13:16:15</Timestamp>
 */
void mssPMMLtimestamp(struct mssFPW *fpw){
  char *mon[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  time_t  long_time;
  struct tm     *nt;
  char msg[100];
  struct mssXmlTag *tag;

  time(&long_time);
  nt = localtime(&long_time);

  sprintf(msg, "%d %s %04d %02d:%02d:%02d",
          nt->tm_mday,
          mon[nt->tm_mon],
          nt->tm_year + 1900,
          nt->tm_hour,
          nt->tm_min,
          nt->tm_sec);

  tag=mssInitXmlTag("Timestamp",NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteXmlContent(msg,NULL,fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Data Dictionary Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * DataDictionary γϥν
 * ex) <DataDictionary numberOfFields="5">
 */
void mssPMMLdataDictionaryStart(int *numberOfFields, struct mssFPW *fpw)
{
  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  int  *attInt;

  eleNam="DataDictionary";
  tag=mssInitXmlTag(eleNam,NULL);

  /* numberOfFields° (ɬ)*/
  attNam="numberOfFields";
  attInt= numberOfFields;
  checkMandatoryAttribute(attNam, eleNam, attInt);
  mssAddXmlTagAttributeInt(tag,attNam,*attInt,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * DataDictionary νλν
 * ex) </PMML>
 */
void mssPMMLdataDictionaryEnd(struct mssFPW *fpw)
{
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="DataDictionary";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * DataField γϥν
 * ex) <DataField name="" optype="continuous">
 */
void mssPMMLdataFieldStart(char *name, char *displayName, char *optype, char *taxonomy, int  *isCyclic, int emptyFlg, struct mssFPW *fpw)
{
  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;
  int  *attInt;

  eleNam="DataField";
  tag=mssInitXmlTag(eleNam,NULL);

  /* name° (ɬ)*/
  attNam="name";
  attStr= name;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* displayName° (Optional)*/
  attNam="displayName";
  attStr= displayName;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* optype° (ɬ)*/
  attNam="optype";
  attStr= optype;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr,
                          "categorical", "ordinal", "continuous",NULL);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* taxonomy° (Optional)*/
  attNam="taxonomy";
  attStr= taxonomy;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* isCyclic° (Optional)*/
  attNam="isCyclic";
  attInt= isCyclic;
  if(attInt!=NULL){
    checkIsFlagAttribute(attNam, eleNam, attInt);
    mssAddXmlTagAttributeInt(tag,attNam,*attInt,NULL);
  }

  /* 񤭽Ф*/
  if(emptyFlg){
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlEmptyTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
    mssPV.indentLevel--;
  }else{
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlStartTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
  }

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * DataField νλν
 * ex) </DataField>
 */
void mssPMMLdataFieldEnd(struct mssFPW *fpw)
{
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="DataField";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Value γϥν
 * ex) <Value value="*" property="missing">
 */
void mssPMMLvalueStart( char *value, char *displayValue, char *property, int   emptyFlg, struct mssFPW *fpw)
{
  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="Value";
  tag=mssInitXmlTag(eleNam,NULL);

  /* value° (ɬ)*/
  attNam="value";
  attStr= value;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* displayValue° (Optional)*/
  attNam="displayValue";
  attStr= displayValue;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* property° (Optional)*/
  attNam="property";
  attStr= property;
  if(attStr!=NULL){
    checkOneInListAttribute(attNam, eleNam, attStr,
                            "valid", "invalid", "missing",NULL);
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  if(emptyFlg){
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlEmptyTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
    mssPV.indentLevel--;
  }else{
    mssPV.indentLevel++;
    mssWriteXmlStartTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
  }

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Value νλν
 * ex) </Value>
 */
void mssPMMLvalueEnd(struct mssFPW *fpw)
{
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="Value";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Mining Schema Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * Mining Schema γϥν
 * ex) <MiningSchema>
 */
void mssPMMLminingSchemaStart(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="MiningSchema";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}   
    
/**
 * # FUNCTION #
 * Mining Schema νλν
 * ex) </MiningSchema>
 */
void mssPMMLminingSchemaEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="MiningSchema";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * MiningField γϥν
 * ex) <MiningField name="" usageType="predicted"/>
 * )
 * char *name:                    ̾        [ɬ]     CDATA
 * char *usageType:               ѥ    [Optional] ("active",
 *                                                          "predicted",
 *                                                          "supplimentary")
 * char *outliers:                ۾ͤΰ  [optional] ("asIs",
                                                            "asMissingValues",
                                                            "asExtremeValues")
 * double *lowValue:              ۾ͤϰ(Ǿ) [optional] CDATA
 * double *highValue:             ۾ͤϰ() [optional] CDATA
 * char *missingValueReplacement: NULLͤѴ [optional] CDATA
 * char *missingValueTreatment:   NULLͤΰ [optional] ("asIs,asMean",
 *                                                         "asMode",
 *                                                         "asMedian",
 *                                                         "asValue")
 * int empty: 1:Ȥƽ 0:ϥȤƽ
 */
void mssPMMLminingFieldStart(char *name, char *usageType, char *outliers, double *lowValue, double *highValue, char *missingValueReplacement, char *missingValueTreatment, int emptyFlg, struct mssFPW *fpw)
{

  struct mssXmlTag *tag;

  char   *eleNam;
  char   *attNam;
  char   *attStr;
  double *attDbl;

  eleNam="MiningField";
  tag=mssInitXmlTag(eleNam,NULL);

  /* name° (ɬ)*/
  attNam="name";
  attStr= name;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* usageType° (Optional)*/
  attNam="usageType";
  attStr= usageType;
  if(attStr!=NULL){
    checkOneInListAttribute(attNam, eleNam, attStr,
                            "active", "predicted", "supplementary",NULL);
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* outliers° (Optional)*/
  attNam="outliers";
  attStr= outliers;
  if(attStr!=NULL){
    checkOneInListAttribute(attNam, eleNam, attStr,
                            "asIs", "asMissingValues", "asExtremeValues",NULL);
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* lowValue° (Optional)*/
  attNam="lowValue";
  attDbl= lowValue;
  if(attDbl!=NULL){
    mssAddXmlTagAttributeDbl(tag,attNam,*attDbl,NULL);
  }

  /* highValue° (Optional)*/
  attNam="highValue";
  attDbl= highValue;
  if(attDbl!=NULL){
    mssAddXmlTagAttributeDbl(tag,attNam,*attDbl,NULL);
  }

  /* missingValueReplacement° (Optional)*/
  attNam="missingValueReplacement";
  attStr= missingValueReplacement;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* missingValueTreatment° (Optional)*/
  attNam="missingValueTreatment";
  attStr= missingValueTreatment;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  if(emptyFlg){
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlEmptyTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
    mssPV.indentLevel--;
  }else{
    mssPV.indentLevel++;
    mssPMMLindent(fpw);
    mssWriteXmlStartTag(tag,NULL,fpw);
    mssWriteRet(fpw); mssPV.outRetCnt++;
  }

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Mining Field νλν
 * ex) </MiningField>
 */
void mssPMMLminingFieldEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="MiningField";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}


/**
 * # FUNCTION #
 * MiningField ȤơmssFieldsϿ줿ʣܤˤĤƽ
 */
void mssPMMLminingFields(struct mssFields *fld, char *usageType, char *outliers, double *lowValue, double *highValue, char *missingValueReplacement, char *missingValueTreatment, struct mssFPW *fpw)
{
  int i;

  for(i=0; i<fld->cnt; i++){
    mssPMMLminingFieldStart(MssFlds2name(fld,i), usageType, outliers,
                            lowValue, highValue, missingValueReplacement,
                            missingValueTreatment, 1, fpw);
  }
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * Trees Ϣ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * Tree γϥν
 * ex) <TreeModel modelName="" functionName="classification">
 * )
 * char *modelName:           ǥ̾        [optional] CDATA
 * char *functionName:        MINING-FUNCTION [ɬ]     ("associationRules",
 *                                                        "sequnces",
 *                                                        "classification",
 *                                                        "regression",
 *                                                        "clustering")
 * char *algorithmName:       르ꥺ̾  [optional] CDATA
 * char *splitCharacteristic: Ρʬˡ  [optional] ("binarySplit",
 *                                                        "multiSplit"[*])
 */
void mssPMMLtreeModelStart(
  char *modelName,
  char *functionName,
  char *algorithmName,
  char *splitCharacteristic,
  struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="TreeModel";
  tag=mssInitXmlTag(eleNam,NULL);

  /* modelName° (Optional)*/
  attNam="modelName";
  attStr= modelName;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* functionName° (ɬ)*/
  attNam="functionName";
  attStr= functionName;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr,
                          "associationRules", "sequences", "classification",
                          "regression","clustering",NULL);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* algorithmName° (Optional)*/
  attNam="algorithmName";
  attStr= algorithmName;
  if(attStr!=NULL){
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* splitCharacteristic° (Optional)*/
  attNam="splitCharacteristic";
  attStr= splitCharacteristic;
  if(attStr!=NULL){
    checkOneInListAttribute(attNam, eleNam, attStr,
                            "binarySplit", "multiSplit",NULL);
    mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);
  }

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}


/**
 * # FUNCTION #
 * Tree νλν
 * ex) </TreeModel>
 */
void mssPMMLtreeModelEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="TreeModel";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Node γϥν
 * ex) <Node score="will play" recordCount="14">
 * )
 * char *score:           °           [ɬ]     CDATA
 * int  *recordCount:     ΥΡɤ° [Optional] CDATA
 */
void mssPMMLnodeStart( char *score, double *recordCount, struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;
  double *attDbl;

  eleNam="Node";
  tag=mssInitXmlTag(eleNam,NULL);

  /* score° (ɬ)*/
  attNam="score";
  attStr= score;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* recordCount° (Optional)*/
  attNam="recordCount";
  attDbl= recordCount;
  if(attDbl!=NULL){
    mssAddXmlTagAttributeDbl(tag,attNam,*attDbl,NULL);
  }

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * Node νλν
 * ex) </TreeModel>
 */
void mssPMMLnodeEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="Node";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * SimplePredicate() ζν
 * ex) <SimplePredicate field="" operator="lessThan",value=10.5/>
 */
void mssPMMLsimplePredicateNumEmpty(char *field,char *operator, double *value, struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;
  double *attDbl;

  eleNam="SimplePredicate";
  tag=mssInitXmlTag(eleNam,NULL);

  /* field° (ɬ)*/
  attNam="field";
  attStr= field;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* operator° (ɬ)*/
  attNam="operator";
  attStr= operator;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr, "equal",
                                                  "notEqual",
                                                  "lessThan",
                                                  "lessOrEqual",
                                                  "greaterThan",
                                                  "greaterOrEqual");
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* value° (ɬ)*/
  attNam="value";
  attDbl= value;
  checkMandatoryAttribute(attNam, eleNam, attDbl);
  mssAddXmlTagAttributeDbl(tag,attNam,*attDbl,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * SimplePredicate(ʸ) ζν
 * ex) <SimplePredicate field="ŷ" operator="equal",value=""/>
 */
void mssPMMLsimplePredicateStrEmpty(char *field,char *operator, char *value, struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="SimplePredicate";
  tag=mssInitXmlTag(eleNam,NULL);

  /* field° (ɬ)*/
  attNam="field";
  attStr= field;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* operator° (ɬ)*/
  attNam="operator";
  attStr= operator;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr, "equal",
                                                  "notEqual",
                                                  "lessThan",
                                                  "lessOrEqual",
                                                  "greaterThan",
                                                  "greaterOrEqual");
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* value° (ɬ)*/
  attNam="value";
  attStr= value;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * SimpleSetPredicate γϥν
 * ex) <SimpleSetPredicate field="ŷ" booleanOperator="isIn">
 */
void mssPMMLsimpleSetPredicateStart(char *field,char *booleanOperator, struct mssFPW *fpw){

  struct mssXmlTag *tag;

  char *eleNam;
  char *attNam;
  char *attStr;

  eleNam="SimpleSetPredicate";
  tag=mssInitXmlTag(eleNam,NULL);

  /* field° (ɬ)*/
  attNam="field";
  attStr= field;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* booleanOperator° (ɬ)*/
  attNam="booleanOperator";
  attStr= booleanOperator;
  checkMandatoryAttribute(attNam, eleNam, attStr);
  checkOneInListAttribute(attNam, eleNam, attStr, "isIn", "isNotIn");
  mssAddXmlTagAttributeStr(tag,attNam,attStr,NULL);

  /* 񤭽Ф*/
  mssPV.indentLevel++;
  mssPMMLindent(fpw);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;

  mssFreeXmlTag(tag);
}

/**
 * # FUNCTION #
 * SimpleSetPredicate νλν
 * ex) </SimpleSetPredicate>
 */
void mssPMMLsimpleSetPredicateEnd(struct mssFPW *fpw){
  struct mssXmlTag *tag;
  char *eleNam;

  eleNam="SimpleSetPredicate";
  tag=mssInitXmlTag(eleNam,NULL);

  /* 񤭽Ф*/
  mssPMMLindent(fpw);
  mssWriteXmlEndTag(tag,NULL,fpw);
  mssWriteRet(fpw); mssPV.outRetCnt++;
  mssPV.indentLevel--;

  mssFreeXmlTag(tag);
}



