/**
 * # CHAPTER #
 * ============================================================================
 * XMLtableΥإå򰷤ؿ
 * 2002/08/07 mssSetOptKey: numFlg,revFlg򥯥ꥢɲ
 * 2004/01/15 mssFields(sf)ƱܤİʾȤƤХ顼λ
 * 2004/08/09 mssFreeHeader NULLǥ꥿
 * ============================================================================
 */

#include <musashi/mssHeader.h>
#include <musashi/mssXml.h>
#include <musashi/mssXtTag.h>
#include <musashi/qs5.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fnmatch.h>

/* ############ Хѿ ##############*/
/*ƥȥե饰*/
extern struct mssGlobalVariables mssGV;

/**
 * # SECTION #
 *----------------------------------------------------------------------------- 
 * mssFldInfo¤Τιֹ̾桢ɥ쥹ʤɤѴ
 *----------------------------------------------------------------------------- 
 */

/**
 * # DOCUMENT #
 * ǤδؿreadHeaderؿˤHeader¤Τ򥻥åȤѲǽȤʤ롣
 */

/**
 * # FUNCTION #
 * mssFldInfo¤Τΰݡ
 */
struct mssFldInfo *mssInitFldInfo()
{
  struct mssFldInfo *fi;

  fi=mssMalloc(sizeof(struct mssFldInfo),"initFldInfo");

  fi->num=0;
  fi->name=NULL;
  fi->priority=0;
  fi->revFlg=0;
  fi->numFlg=0;
  fi->length=0;
  fi->comment=NULL;

  return(fi);
}

/**
 * # FUNCTION #
 * mssFldInfo¤Τΰ賫
 */
void mssFreeFldInfo( struct mssFldInfo *fi)
{

  if(fi!=NULL){
    mssFree(fi->name);
    mssFree(fi->comment);
  }
  mssFree(fi);
}

/**
 * # FUNCTION #
 * mssFldInfoν(ǥХå)
 */
void mssShowFldInfo(struct mssFldInfo *fi)
{
  printf("\tnum=%d name=%s priority=%d revFlg=%d numFlg=%d comment=%s\n",
       fi->num, fi->name, fi->priority, fi->revFlg, fi->numFlg, fi->comment);
}

/**
 * # FUNCTION #
 * numǻꤵ줿ֹιܤmssFields¤ΤmssFldInfo¤(flds->fi)
 * õĤФΥݥ󥿤֤
 * ĤʤХ顼ɽƽλ롣
 * ǻꤵnumǤιֹǡϤޤ롣
 */
struct mssFldInfo *mssFldNum2Add(struct mssFields *flds, int num)
{
  int i;

  for(i=0; i<flds->cnt; i++){
    if( num==MssFlds2num(flds,i) ){
      return( *(flds->fi+i) );
    }
  }
  mssShowErrMsg("internal error field number not found : [%d]",num);
  mssEnd(mssErrorNoDefault);
  return(NULL); /*ѥٹ򤱤뤿*/
}

/**
 * # FUNCTION #
 * nameǻꤵ줿̾ιܤmssFields¤ΤmssFldInfo¤(flds->fi)
 * õĤФΥݥ󥿤֤
 * ĤʤХ顼ɽƽλ롣
 */
struct mssFldInfo *mssFldNam2Add(struct mssFields *flds, char *name)
{
  int i;

  for(i=0; i<flds->cnt; i++){
    if( 0==strcmp(MssFlds2name(flds,i), name) ){
      return( *(flds->fi+i) );
    }
  }
  mssShowErrMsg("field name or number not found : [%s]",name);
  mssEnd(mssErrorNoDefault);
  return(NULL); /*ѥٹ򤱤뤿*/
}

/**
 * # FUNCTION #
 * nameǻꤵ줿磻ɥ(*,?ʤ)ޤ̾mssFields¤Τ
 * mssFldInfo¤(flds->fi)õޥåݥƤ֤
 * ĤޥåʤХ顼ɽƽλ롣
 */
struct mssFldInfo **mssFldGlbNam2Add(struct mssFields *flds, char *name)
{
  int i;
  int cnt=0;
  struct mssFldInfo **fiList=NULL;

  for(i=0; i<flds->cnt; i++){

    /*̾Υ磻ɥɥޥå*/
    if( 0==fnmatch(name,(*(flds->fi+i))->name,0) ){

      /*ΰ*/
      fiList = mssRealloc(fiList,sizeof(struct mssFldInfo *)*(cnt+1),
        "FldGlbNam2Add");
      *(fiList+cnt) = *(flds->fi+i);
      cnt++;
    }
  }
  if( cnt == 0 ) {
    mssShowErrMsg("field name not found : [%s]",name);
    mssEnd(mssErrorNoDefault);
  }

  /*üNULLɲ*/
  fiList = mssRealloc(fiList,sizeof(struct mssFldInfo *)*(cnt+1),"fldRegN2A");
  *(fiList+cnt) = NULL;

  return(fiList);
}

/**
 * # FUNCTION #
 * nameǻꤵ줿̾ιܤmssFields¤ΤmssFldInfo¤(flds->fi)
 * õĤФιֹ֤
 * ĤʤХ顼ɽƽλ롣
 * ) ֹȤϡXMLtable<field no="1">Ǥno°ͤ飱
 */
int mssFldNam2Num(struct mssFields *flds, char *name)
{
  int i;
  int namLen;

  namLen=strlen(name);
  for(i=0; i<flds->cnt; i++){
    if( 0==strcmp((*(flds->fi+i))->name, name) ){
      return( (*(flds->fi+i))->num );
    }
  }
  mssShowErrMsg("field name or number not found : [%s]",name);
  mssEnd(mssErrorNoDefault);
  return(0); /*Ȥꤢ*/
}

/**
 * # FUNCTION #
 * numǻꤵ줿ֹmssFields¤ΤmssFldInfo¤(flds->fi)
 * õֹ֤ͥͤ
 * ꤨʤֹ椬ꤵ줿Ȥϡ顼ɽƽλ롣
 * 1) ֹȤϡXMLtable<field no="1">Ǥno°ͤ飱
 * 2) ֹͥȤϡXMLtable<sort priority="1">Ǥpriority
 *      °ͤΤȡ
 */
int mssFldNum2SrtPri(struct mssFields *flds, int num)
{
  int i;

  if( num<0 || num>flds->cnt-1 ) {
    mssShowErrMsg("Internal Error: field number not found : [%d]",num);
    mssEnd(mssErrorNoDefault);
  }

  for(i=0; i<flds->cnt; i++){
    if( (*(flds->fi+i))->num == num ){
      return( (*(flds->fi+i))->priority );
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * numǻꤵ줿ֹmssFields¤ΤmssFldInfo¤(flds->fi)
 * õιܤս祽Ȥλ꤬УǤʤУ֤
 * ꤨʤֹ椬ꤵ줿Ȥϡ顼ɽƽλ롣
 * 1) ֹȤϡXMLtable<field no="1">Ǥno°ͤ飱
 * 2) ս祽ȻȤϡXMLtable<reverse/>ǤΤȡ
 */
int mssFldNum2SrtRev(struct mssFields *flds, int num)
{
  int i;

  if( num<0 || num>flds->cnt-1 ) {
    mssShowErrMsg("Internal Error: field number not found : [%d]",num);
    mssEnd(mssErrorNoDefault);
  }

  for(i=0; i<flds->cnt; i++){
    if( (*(flds->fi+i))->num == num ){
      return( (*(flds->fi+i))->revFlg );
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * numǻꤵ줿ֹmssFields¤ΤmssFldInfo¤(flds->fi)
 * õιܤͥȤλ꤬УǤʤУ֤
 * ꤨʤֹ椬ꤵ줿Ȥϡ顼ɽƽλ롣
 * 1) ֹȤϡXMLtable<field no="1">Ǥno°ͤ飱
 * 2) ͥȻȤϡXMLtable<numeric/>ǤΤȡ
 */
int mssFldNum2SrtNum(struct mssFields *flds, int num)
{
  int i;

  if( num<0 || num>flds->cnt-1 ) {
    mssShowErrMsg("Internal Error: field number not found : [%d]",num);
    mssEnd(mssErrorNoDefault);
  }

  for(i=0; i<flds->cnt; i++){
    if( (*(flds->fi+i))->num == num ){
      return( (*(flds->fi+i))->numFlg );
    }
  }
  return(0);
}

/**
 * # SECTION #
 *----------------------------------------------------------------------------- 
 * mssHeader¤Τ򰷤ؿ
 *----------------------------------------------------------------------------- 
 */

/**
 * # FUNCTION #
 * إå¤Τΰ賫
 */
void mssFreeHeader(struct mssHeader *hd)
{
  if(hd==NULL) return;
  mssFree(hd->title  );
  mssFree(hd->comment);
  mssFreeFields(hd->flds);
  mssFree(hd->xmlver);
  mssFree(hd->xmlenc);
  mssFree(hd);
}

/**
 * # FUNCTION #
 * ȥ(title)ȥ(comment)ˤHeader¤Τ
 * Ԥ
 */
struct mssHeader *mssInitHeader(char *title, char *comment)
{

  struct mssHeader *hd;

  hd=mssMalloc( sizeof(struct mssHeader),"initHeader" );

  hd->title  = mssStrdup(title);
  hd->comment= mssStrdup(comment);
  hd->xmlver = mssStrdup(MssXmlDefVer);
  hd->xmlenc = mssStrdup(MssXmlDefEnc);
  hd->version= MssXtDefVer;
  hd->flds   = mssInitFields();
  hd->recCnt = -1;

  return(hd);
}

/**
 * # FUNCTION #
 * mssHeader¤Τoldǻꤷ¸Υإå(ܾϽ)
 * ԡ롣
 * ԡϡtitle,comment,xmlver,xmlencǡ¾Ͻ롣
 * version MssXtDefVerǽ롣
 * ԡκݤmssStrdupѤΤǡ
 * ¸Υإå(ʸ)ݥ󥿤Ƕͭ뤳ȤϤʤ
 */
struct mssHeader *mssInitCpyHeader(struct mssHeader *old)
{
  struct mssHeader *hd;

  hd=mssMalloc( sizeof(struct mssHeader),"initCpyHeader" );

  if(NULL!=old->title)   hd->title  = mssStrdup(old->title);
  else                   hd->title  = NULL;

  if(NULL!=old->comment) hd->comment= mssStrdup(old->comment);
  else                   hd->comment= NULL;

  if(NULL!=old->xmlver)  hd->xmlver = mssStrdup(old->xmlver);
  else                   hd->xmlver = NULL;
  
  if(NULL!=old->xmlenc)  hd->xmlenc = mssStrdup(old->xmlenc);
  else                   hd->xmlenc = NULL;

  hd->version = MssXtDefVer;
  hd->flds    = mssInitFields();
  hd->recCnt  = -1;

  return(hd);
}

/**
 * # FUNCTION #
 * mssHeader¤Τǻꤷʸǥإåꤹ롣
 * ꤹϡtitle,comment,xmlver,xmlenc,versionǡ¾Ͻ롣
 * κݤmssStrdupѤΤǡ
 * ʸݥ󥿤Ƕͭ뤳ȤϤʤ
 */
struct mssHeader *mssInitSetHeader( char *title, char *comment, char *xmlver, char *xmlenc, int version)
{
  struct mssHeader *hd;

  hd=mssMalloc( sizeof(struct mssHeader),"initCpyHeader" );

  if(NULL!=title)   hd->title  = mssStrdup(title);
  else              hd->title  = NULL;

  if(NULL!=comment) hd->comment= mssStrdup(comment);
  else              hd->comment= NULL;

  if(NULL!=xmlver)  hd->xmlver = mssStrdup(xmlver);
  else              hd->xmlver = NULL;
  
  if(NULL!=xmlenc)  hd->xmlenc = mssStrdup(xmlenc);
  else              hd->xmlenc = NULL;

  hd->version= version;

  hd->flds    = mssInitFields();
  hd->recCnt = -1;

  return(hd);
}

/**
 * # FUNCTION #
 * mssHeader¤ΤΥ쥳ɿ(recCnt)򥻥åȤ롣
 */
void mssSetHeaderRecCnt(struct mssHeader *hd, int recCnt)
{
  hd->recCnt=recCnt;
}

/**
 * # SECTION #
 *----------------------------------------------------------------------------- 
 * mssFields,mssFldInfo¤Τ򰷤ؿ
 *----------------------------------------------------------------------------- 
 */

/**
 * # FUNCTION #
 * mssFields¤Τν
 */
struct mssFields *mssInitFields()
{
  struct mssFields *flds;
  flds=mssMalloc(sizeof(struct mssFields),"initFields");
  flds->fi=NULL;
  flds->cnt=0;
  return(flds);
}

/**
 * # FUNCTION #
 * mssFields¤Τΰ賫
 */
void mssFreeFields(struct mssFields *flds)
{
  int i;
  if(flds!=NULL){
    for(i=0; i<flds->cnt; i++){
      mssFreeFldInfo(*(flds->fi+i));
    }
    mssFree(flds->fi);
  }
  mssFree(flds);
}

/**
 * # FUNCTION #
 * إåܾν(ǥХå)
 */
void mssShowFields(struct mssFields *flds)
{
  int i;
  for(i=0; i<flds->cnt; i++){
    printf("fld[%d]:",i);
    mssShowFldInfo(*(flds->fi+i));
  }
}


/**
 * # FUNCTION #
 * mssUpdateSortPriorityؿѤ륽ȤӴؿ
 */
static int cmpUpdHeader(const void **a, const void **b)
{
  if((int)*a > (int)*b) return(1);
  else                  return(-1);
}

/**
 * # FUNCTION #
 * mssFields¤ΤΥȾ򸡺ǤʤȾ롣
 * δؿȤ
 *   ϥǡΰΥإåܾ򿷤إåܾȤƺ
 *   Υpriorityʤʤǽ롣㤨Сϥǡ
 *   a,b,c,dΣĤιܤäȤơȤprioritya,b,cνǤä
 *   (a=1,b=2,c=3)ʤa,b,cǥȤƤȤ롣
 *   λa,c,dΣܤ򿷤ܤȤȴȤȤpriority
 *   ʤʤ롣aǤϥȤƤ뤬cǤϥȤƤʤ
 *   ǡδؿϡapriority1ΤޤޤǡcΥpriority
 *   õ롣
 */
void mssUpdateFieldsSortPriority(struct mssFields *flds)
{
  int list[MssFieldMaxCnt];
  int listCnt;
  int i;
  int until;

  if(mssGV.txtFlg) return;

  /*ȤƤܤpriorityֹlist˥å*/
  listCnt=0;
  for(i=0; i<flds->cnt; i++){
    if((*(flds->fi+i))->priority != 0){
      list[listCnt++]=(*(flds->fi+i))->priority;
    }
  }

  /*list¤Ѥơpriorityֹ椬orʣƤսuntil*/
  /*list[]=1,2,3,5 λ3ޤǤOKʹߤ䡣until=3 */
  /*list[]=1,2,2,3 λǽ2ޤǤOKʹߤϽʣuntil=2 */
  until=0;
  if(listCnt!=0){
/*
    qsort(list,listCnt,sizeof(int),
               (int (*)(const void *,const void *))cmpUpdHeader);
*/
    qsort5(list,listCnt,sizeof(int), (int (*))cmpUpdHeader);

    for(i=0; i<listCnt; i++){
      if((i+1)!=list[i]) break;
    }
    until=i;
  }

  /*(until)priorityä*/
  for(i=0; i<flds->cnt; i++){
    if((*(flds->fi+i))->priority > until){
      (*(flds->fi+i))->priority = 0;
      (*(flds->fi+i))->revFlg   = 0;
      (*(flds->fi+i))->numFlg   = 0;
    }
  }
}

/**
 * # FUNCTION #
 * mssFldInfo¤ΤΥȾ(priority,revFlg,numFlg)򥻥åȤ롣
 */
void mssSetFldInfoSort(struct mssFldInfo *fi, int prioriy, int revFlg,int numFlg)
{
  fi->priority = prioriy;
  fi->revFlg   = revFlg;
  fi->numFlg   = numFlg;
}

/**
 * # FUNCTION #
 * fldsΥȾ򥯥ꥢ롣
 */
void mssClearFieldsSort(struct mssFields *flds)
{
  int i;

  if(mssGV.txtFlg) return;

  for(i=0; i<flds->cnt; i++){
    mssSetFldInfoSort(*(flds->fi+i),0,0,0);
  }
}

/**
 * # FUNCTION #
 * fldsΥȾöꥢsfȾ򥳥ԡ롣
 */
void mssSetFieldsSort(struct mssFields *flds, struct mssFields *sortFlds)
{
  int i;
  int no;

  /*öfldsƤΥȾ򥯥ꥢ*/
  mssClearFieldsSort(flds);

  for(i=0; i<sortFlds->cnt; i++){
    no = MssFlds2num(sortFlds,i);
    MssFlds2priority(flds,no)= i+1;
    MssFlds2revFlg(flds,no)  = MssFlds2revFlg(sortFlds,i);
    MssFlds2numFlg(flds,no)  = MssFlds2numFlg(sortFlds,i);
  }
}

/**
 * # FUNCTION #
 * flds˴ޤޤܤˤĤơϿ줿֤˥ֹͥդ롣
 */
void mssSetFieldsSortPriority(struct mssFields *flds)
{
  int i;

  for(i=0; i<flds->cnt; i++){
    MssFlds2priority(flds,i)= i+1;
  }
}

/**
 * # FUNCTION #
 * mssFldInfo¤ΤιĹ(lenght)򥻥åȤ롣
 * ξϡĹܤˤ˥åȤ롣
 */
void mssSetFldInfoLength(struct mssFldInfo *fi, int length)
{
  fi->length = length;
}

/**
 * # FUNCTION #
 * mssFldInfo¤ΤιֹnumˤäƥåȤ롣
 * ǡǤ1ϤޤֹŪˤϣϤޤֹ档
 * ǤǤϡnumˤֹȤͿ뤳ȡ
 */
void mssSetFldInfoNum(struct mssFldInfo *fi, int num)
{
  fi->num      = num;
}

/**
 * # FUNCTION #
 * mssFldInfo¤Τι̾name ˤäƥåȤ롣
 */
void mssSetFldInfoName(struct mssFldInfo *fi, char *name)
{
  fi->name     = mssStrdup(name);
}

/**
 * # FUNCTION #
 * mssFldInfo¤ΤΥȤcommentˤäƥåȤ롣
 */
void mssSetFldInfoComment(struct mssFldInfo *fi, char *comment)
{
  fi->comment = mssStrdup(comment);
}

/**
 * # FUNCTION #
 * mssFields¤ΤFldInfo¤Τnum(ֹ)ˡ0ϤޤϢ֤˥å
 * 롣
 */
void mssSetFieldsSequenceNum(struct mssFields *flds)
{
  int i;

  for(i=0; i<flds->cnt; i++){
    MssFlds2num(flds,i)=i;
  }
}

/**
 * # FUNCTION #
 * mssFields¤ΤˡʸȤƻꤵ줿̾ɲä롣
 * Ⱦʤɤϥꥢ롣
 */
void mssAddFieldsByStr(struct mssFields *flds, char *str)
{
  flds->fi=mssRealloc(flds->fi,sizeof(struct mssFldInfo *)*(flds->cnt+1),
                        "AddFieldsByStr");
  *(flds->fi+flds->cnt) = mssInitFldInfo();

  mssSetFldInfoNum(*(flds->fi+flds->cnt),flds->cnt);
  mssSetFldInfoName(*(flds->fi+flds->cnt),str);
  mssSetFldInfoSort(*(flds->fi+flds->cnt),0,0,0);
  mssSetFldInfoLength(*(flds->fi+flds->cnt),0);
  mssSetFldInfoComment(*(flds->fi+flds->cnt),NULL);

  flds->cnt++;
}

/**
 * # FUNCTION #
 * mssFields¤ΤˡʸꥹȤȤƻꤵ줿̾ɲä롣
 * Ⱦʤɤϥꥢ롣
 */
void mssAddFieldsByStrList(struct mssFields *flds, char **str, int cnt)
{
  int i;

  for(i=0; i<cnt; i++){
    mssAddFieldsByStr(flds,*(str+i));
  }
}

/**
 * # FUNCTION #
 * mssFields¤Τˡꤵ줿mssFldInfoɲä롣
 */
void mssAddFieldsByFldInfo(struct mssFields *flds, struct mssFldInfo *fi)
{
  struct mssFldInfo *ofi;

  flds->fi=mssRealloc(flds->fi,sizeof(struct mssFldInfo *)*(flds->cnt+1),
                      "AddFldInfo");
  *(flds->fi+flds->cnt) = mssInitFldInfo();
  ofi=*(flds->fi+flds->cnt);

  mssSetFldInfoNum(ofi,fi->num);
  mssSetFldInfoName(ofi,fi->name);
  mssSetFldInfoSort(ofi,fi->priority,fi->revFlg,fi->numFlg);
  mssSetFldInfoLength(ofi,fi->length);
  mssSetFldInfoComment(ofi,fi->comment);

  flds->cnt++;
}

/**
 * # FUNCTION #
 * mssFields¤fldsˡꤵ줿ʣmssFldInfo¤fiɲä롣
 * fiκǸǤNULLǤʤФʤʤ
 * 㤨mssFldGlbNam2AddǼʣmssFldInfoꥹȤϺǸǤNULL
 * ǽäƤΤǡΤޤѤǤ롣
 */
void mssAddFieldsByFldInfoList(struct mssFields *flds, struct mssFldInfo **fi)
{
  int i;

  for(i=0;;i++){
    if( *(fi+i) == NULL ) break;
    mssAddFieldsByFldInfo(flds, *(fi+i));
  }
}

/**
 * # FUNCTION #
 * mssFields¤Τˡꤵ줿mssFields¤ΤƤmssFldInfoɲä롣
 * ֹ桢̾ȾʤƤΤޤɲåԡ롣
 */
void mssAddFieldsByFields(struct mssFields *flds, struct mssFields *addFlds)
{
  int i;

  for(i=0; i<addFlds->cnt; i++){
    mssAddFieldsByFldInfo(flds, *(addFlds->fi+i));
  }
}

/**
 * # FUNCTION #
 * mssFields¤Τˡץǻꤵ줿mssFields¤Τȥإå
 * mssFields¤ΤȤɲä롣λץǻꤵƤܤϡ
 * ̾ɲäǤʤܤϥإåιܤɲä롣
 */
void mssAddHeadOrOptFields(struct mssFields *flds, struct mssHeader *hd, MssOptFLD *optFld)
{
  int i;
  int num;

  for(i=0; i<hd->flds->cnt; i++){
    mssAddFieldsByFldInfo(flds, *(hd->flds->fi+i));

    /*ץǻꤵʤä*/
    num=*(optFld->fldNo2optNo+i);
    if(*(optFld->fldNo2optNo+i)!=-1){
      mssSetFldInfoNum(*(flds->fi+flds->cnt-1), i);
      mssSetFldInfoName(*(flds->fi+flds->cnt-1), *(optFld->newNam+num));
      mssSetFldInfoSort(*(flds->fi+flds->cnt-1),0,0,0);
      mssSetFldInfoLength(*(flds->fi+flds->cnt-1),0);
      mssSetFldInfoComment(*(flds->fi+flds->cnt-1), NULL);
    }
  }
}

/**
 * # SECTION #
 *----------------------------------------------------------------------------- 
 * mssHeader¤Τϴؿ
 *----------------------------------------------------------------------------- 
 */

/**
 * # FUNCTION #
 * ϥեι̾å
 */
static void chkInfFldName(struct mssHeader *hd, struct mssFPR *fp )
{
  char *fName;
  int i,j;

  /*ե̾å*/
  if(fp->fName==NULL) fName="stdin";
  else                fName=fp->fName;

  /*̾NULLå*/
  for(i=0; i<hd->flds->cnt; i++){
    if(NULL==(*(hd->flds->fi+i))->name){
      mssShowErrMsg("name of %dth field is null in %s",i+1,fName);
      mssEnd(mssErrorNoDefault);
    }
  }

  /*̾ʣå*/
  for(i=0; i<hd->flds->cnt-1; i++){
    for(j=i+1; j<hd->flds->cnt; j++){
      if(0==strcmp((*(hd->flds->fi+i))->name,(*(hd->flds->fi+j))->name)){
        mssShowErrMsg("same field names in %s: %s",fName,(*(hd->flds->fi+j))->name);
        mssEnd(mssErrorNoDefault);
      }
    }
  }
}

/**
 * # FUNCTION #
 * ϥեι̾å
 */
static void chkOtfFldName(struct mssHeader *hd, struct mssFPW *fp )
{
  char *fName;
  int i,j;

  /*ե̾å*/
  if(fp->fName==NULL)           fName="stdout";
  else if(fp->fName==(char *)1) fName="stderr";
  else                          fName=fp->fName;

  /*̾NULLå*/
  for(i=0; i<hd->flds->cnt; i++){
    if(NULL==(*(hd->flds->fi+i))->name){
      mssShowErrMsg("name of %dth field is null in %s",i+1,fName);
      mssEnd(mssErrorNoDefault);
    }
  }

  /*̾ʣå*/
  for(i=0; i<hd->flds->cnt-1; i++){
    for(j=i+1; j<hd->flds->cnt; j++){
      if(0==strcmp((*(hd->flds->fi+i))->name,(*(hd->flds->fi+j))->name)){
        mssShowErrMsg("same field names in %s: %s",fName,(*(hd->flds->fi+j))->name);
        mssEnd(mssErrorNoDefault);
      }
    }
  }
}


/**
 * # FUNCTION #
 * mssFldInfo¤ξإåȤƽ񤭽Ф
 */
void mssWriteFldInfo( struct mssFldInfo *fi, int version, struct mssFPW *fp)
{
  struct mssXmlTag *fieldTag;
  struct mssXmlTag *sortTag;
  struct mssXmlTag *revTag;
  struct mssXmlTag *numTag;
  char *str;

  switch(version){
  /*XMLtable version 1.0*/
  case 10:
    /* <field no="1"> */
    fieldTag=mssInitXmlTag("field",NULL);
    mssAddXmlTagAttributeInt(fieldTag,"no",fi->num+1,NULL);
    str=mssXmlTag2startTag(fieldTag, NULL);
    mssWriteStr(str,fp); mssFree(str);

    /* <name>fieldName</name> */
    mssWriteXmlTagStr(0,"name",fi->name,0,NULL,fp);

    /* <sort priority="1"><numeric/><reverse/></sort>*/
    if(0 != fi->priority){
      sortTag=mssInitXmlTag("sort",NULL);
      mssAddXmlTagAttributeInt(sortTag,"priority",fi->priority,NULL);
      str=mssXmlTag2startTag(sortTag, NULL);
      mssWriteStr(str,fp); mssFree(str);
      if(fi->revFlg){
        revTag=mssInitXmlTag("reverse",NULL);
        str=mssXmlTag2emptyTag(revTag, NULL);
        mssWriteStr(str,fp); mssFree(str);
        mssFreeXmlTag(revTag);
      }
      if(fi->numFlg){
        numTag=mssInitXmlTag("numeric",NULL);
        str=mssXmlTag2emptyTag(numTag, NULL);
        mssWriteStr(str,fp); mssFree(str);
        mssFreeXmlTag(numTag);
      }
      str=mssXmlTag2endTag(sortTag, NULL);
      mssWriteStr(str,fp); mssFree(str);
      mssFreeXmlTag(sortTag);
    }

    /*<length>10</length>*/
    if(fi->length!=0){
      mssWriteXmlTagInt(0,"length",fi->length,0,NULL,fp);
    }

    /*</field>*/
    str=mssXmlTag2endTag(fieldTag, NULL);
    mssWriteStr(str,fp); mssFree(str);
    mssFreeXmlTag(fieldTag);
    mssWriteRet(fp);
    break;

    /*XMLtable version 1.1*/
    /*<field num="1" name="̾" sort="1" numeric="1" reverse="1" length="10">ܥ<field> */
  case 11:
    fieldTag=mssInitXmlTag("field",NULL);
    mssAddXmlTagAttributeInt(fieldTag,"no"  ,fi->num+1,NULL);
    mssAddXmlTagAttributeStr(fieldTag,"name",fi->name ,NULL);
    if(0 != fi->priority){
      mssAddXmlTagAttributeInt(fieldTag,"sort",fi->priority ,NULL);
      if(fi->numFlg){
        mssAddXmlTagAttributeInt(fieldTag,"numeric",1 ,NULL);
      }
      if(fi->revFlg){
        mssAddXmlTagAttributeInt(fieldTag,"reverse",1 ,NULL);
      }
    }
    if(fi->length!=0){
      mssAddXmlTagAttributeInt(fieldTag,"length",fi->length ,NULL);
    }
    mssWriteXmlStartTag(fieldTag, NULL, fp);
    if(fi->comment!=NULL){
      mssWriteStr(fi->comment,fp);
    }
    mssWriteXmlEndTag(fieldTag, NULL, fp);
    mssWriteRet(fp);
    break;

  default:
    mssShowErrMsg("Internal Error: invalid XMLtable version");
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * # FUNCTION #
 * إåν񤭽Ф
 */
void mssWriteHeader( struct mssHeader *hd, struct mssFPW *fp)
{
  struct mssXmlTag *xtTag;
  struct mssXmlTag *hdTag;
  int i;
  char *version=NULL;
  char verStr[2][4]={"1.0","1.1"};

  if(mssGV.txtFlg)return;

  switch(hd->version){
  case 10:
    version=verStr[0];
    break;
  case 11:
    version=verStr[1];
    break;
  default:
    mssShowErrMsg("Internal Error: invalid XMLtable version");
    mssEnd(mssErrorNoDefault);
  }

  chkOtfFldName(hd,fp); /*Ϲ̾Υå*/

  mssWriteXmlDeclaration( hd->xmlver, hd->xmlenc ,fp);

  /*xmlTableإåν񤭽Ф<xmltbl version="1.1">*/
  xtTag=mssInitXmlTag("xmltbl",NULL);
  mssAddXmlTagAttributeStr(xtTag,"version",version,NULL);
  mssWriteXmlStartTag(xtTag,NULL,fp);
  mssFreeXmlTag(xtTag);
  mssWriteRet(fp);

  /*<header>*/
  hdTag=mssInitXmlTag("header",NULL);
  mssWriteXmlStartTag(hdTag,NULL,fp);
  mssWriteRet(fp);

  /*<title>*/
  mssWriteXmlTagStr(0,"title",hd->title,1,NULL,fp);

  /*<comment>*/
  mssWriteXmlTagStr(0,"comment",hd->comment,1,NULL,fp);

  /*<field>*/
  for(i=0; i<hd->flds->cnt; i++){    /*إåιܥ*/
    mssWriteFldInfo(*(hd->flds->fi+i), hd->version, fp);
  }

  /*<recCnt>*/
  if(-1 != hd->recCnt){
    mssWriteXmlTagInt(0,"recCnt",hd->recCnt,1,NULL,fp);
  }

  /*</header>*/
  mssWriteXmlEndTag(hdTag,NULL,fp);
  mssWriteRet(fp);
  mssFreeXmlTag(hdTag);

  /*<body><![CDATA[*/
  mssWriteStr(MssBeginBodyString, fp) ; mssWriteRet(fp);
  mssGV.writeHeaderFlg=1;
}

/**
 * # FUNCTION #
 * եåν񤭽Ф
 */
void mssWriteFooter(struct mssFPW *fp)
{

  if(fp==NULL) return;
  if(mssGV.txtFlg) return;
  mssWriteStr(MssEndBodyString, fp) ; mssWriteRet(fp);
  mssWriteStr("</xmltbl>", fp)  ; mssWriteRet(fp);

  mssGV.writeFooterFlg=1;
}

/**
 * # FUNCTION #
 * ǡxmlTable롣
 * Ϳ줿fldCntĤι̾fldName顢xmlTableإåιܤ롣
 * δؿϡxtmkdata,xtcalenderޥɤΤ褦ˡǡݤ
 * Ѥ롣ɬפʹ̾ȼäǡСϥǡȼä
 * եΤޤѲǽȤʤ롣
 */
void mssCreateBlankXtFile(char **fldName, int fldCnt, char *fname)
{
  struct mssHeader *hd;
  struct mssFPW *fpw;
  hd=mssMalloc( sizeof(struct mssHeader),"mkBlankXtFile" );

  hd->title  = NULL;
  hd->comment= NULL;
  hd->xmlver = mssStrdup(MssXmlDefVer);
  hd->xmlenc = mssStrdup(MssXmlDefEnc);
  hd->version= MssXtDefVer;
  hd->flds   = mssInitFields();
  hd->recCnt = -1;

  mssAddFieldsByStrList(hd->flds,fldName,fldCnt);

  /*ɸϥץ+إåեåν*/
  fpw=mssOpenFPW(fname, 0, 0);
  mssWriteHeader(hd, fpw);
  mssWriteFooter(fpw);
  mssCloseFPW(fpw);
  mssFreeHeader(hd);
}



static char numChr[MssFieldMaxCnt][4]; /*ֹȤƤι̾*/

/**
 * # FUNCTION #
 * إåɤ߹ߡ
 */
struct mssHeader *mssReadHeader( struct mssFPR *fp)
{

  struct mssHeader *hd;
  struct mssStrings *head;
  struct mssStrings *title;
  struct mssStrings *comment;
  struct mssStrings *recCnt;
  struct mssStrings *field;
  struct mssStrings *sort;

  char *tmpStr;
  char *pos;
  char *str;
  int i;
  int datFldCnt;  /*ǡιܿ*/
  int fldNum;
  int priority;
  int revFlg;
  int numFlg;
  int length;
  hd=mssMalloc( sizeof(struct mssHeader),"readHeader" );
  hd->flds=mssInitFields();

  /*---------------------------- plainTextξ*/
  if(mssGV.txtFlg){
    datFldCnt = mssGetFldCntOnData(fp); /*ǡιܿ򥫥*/
    hd->title   = NULL;        /*ȥ*/
    hd->comment = NULL;        /**/
    hd->recCnt  = -1;          /*쥳ɿ*/
    hd->xmlver  = NULL;        /*xml version*/
    hd->xmlenc  = NULL;        /*xml encoding*/
    /*ܤΥγ*/
    hd->flds->cnt = 0;   /*ܿ*/
    for(i=0; i<datFldCnt; i++){
      sprintf(numChr[i+1],"%d",i+1);
      mssAddFieldsByStr(hd->flds, mssStrdup(numChr[i+1]));
    }
  /*---------------------------- xmlTblξ*/
  }else{

    mssReadSetTop(hd, fp); /*xmlΥСenc⥻åȤ*/

    /*إå(<header>....</header>)ե뤫˥å*/
    head=mssReadTag("header", fp);
    if(head==NULL){
      mssShowErrMsg("cannot find header tag");
      mssEnd(mssErrorNoDefault);
    }

    /*ȥμ*/
    title=mssGetTag("title", head->str, &pos);
    if(title!=NULL){
      hd->title=mssGetTagCont(title->str,"title",1); /*titleƤ*/
      mssFreeStrings(title);
    }else{
      hd->title=NULL;
    }

    /*Ȥμ*/
    comment=mssGetTag("comment", head->str, &pos);
    if(comment!=NULL){
      hd->comment=mssGetTagCont(comment->str,"comment",0);
      mssFreeStrings(comment);
    }else{
      hd->comment=NULL;
    }

    /*쥳ɿμ*/
    hd->recCnt=-1;
    recCnt=mssGetTag("recCnt", head->str, &pos);
    if(recCnt!=NULL){
      str=mssGetTagCont(recCnt->str,"recCnt",1);
      if( NULL!= str ) hd->recCnt=atoi(str);
      mssFree(str);
      mssFreeStrings(recCnt);
    }else{
      hd->recCnt=-1;
    }

    /*ܾμ*/
    tmpStr=head->str;
    while(1) {
      /*fieldΥå*/
      field=mssGetTag("field", tmpStr, &pos);
      if( NULL == field ){
         break;
      }

      /*оݤʸ餹Ȥǡfieldθ*/
      tmpStr=pos+1;

      switch(hd->version){
      case 10:
        /*̾*/
        str = mssGetTagCont(field->str, "name",1);
        if(str!=NULL){
          mssAddFieldsByStr(hd->flds, str);
          mssFree(str);
        }else{
          mssShowErrMsg("Internal Error: invalid filed number");
          mssEnd(mssErrorNoDefault);
        }

        /*ֹ*/
        str = mssGetTagAtt(field->str, "field", "no");
        if(str!=NULL){
          fldNum=atoi(str);
          if(fldNum>0 && fldNum<MssFieldMaxCnt){
            mssSetFldInfoNum(*(hd->flds->fi+hd->flds->cnt-1), fldNum-1);
          }else{
            mssShowErrMsg("Internal Error: invalid filed number");
            mssEnd(mssErrorNoDefault);
          }
          mssFree(str);
        }else{
          mssShowErrMsg("Internal Error: invalid filed number");
          mssEnd(mssErrorNoDefault);
        }

        /*sortΥå (Υʤ0åȤ)*/
        priority = 0;
        revFlg   = 0;
        numFlg   = 0;
        sort=mssGetTag("sort", field->str, &pos);
        if( NULL != sort ){
          str = mssGetTagAtt(sort->str, "sort", "priority");
          priority = atoi(str);
          revFlg   = mssGetNullTag(sort->str, "reverse");
          numFlg   = mssGetNullTag(sort->str, "numeric");
          mssFree(str);
          mssFreeStrings(sort);
        }
        mssSetFldInfoSort(*(hd->flds->fi+hd->flds->cnt-1),
                                                      priority,revFlg,numFlg);

        /*lenghtΥå*/
        str = mssGetTagCont(field->str, "length",1);
        if(str!=NULL) length = atoi(str);
        else          length = 0;
        mssFree(str);
        mssSetFldInfoLength(*(hd->flds->fi+hd->flds->cnt-1),length);
        break;

      case 11:
        /*̾*/
        str = mssGetTagAtt(field->str, "field", "name");
        if(str!=NULL){
          mssAddFieldsByStr(hd->flds, str);
          mssFree(str);
        }else{
          mssShowErrMsg("Internal Error: invalid filed number");
          mssEnd(mssErrorNoDefault);
        }

        /*ֹ*/
        str = mssGetTagAtt(field->str, "field", "no");
        if(str!=NULL){
          fldNum=atoi(str);
          if(fldNum>0 && fldNum<MssFieldMaxCnt){
            mssSetFldInfoNum(*(hd->flds->fi+hd->flds->cnt-1), fldNum-1);
          }else{
            mssShowErrMsg("Internal Error: invalid filed number");
            mssEnd(mssErrorNoDefault);
          }
          mssFree(str);
        }else{
          mssShowErrMsg("Internal Error: invalid filed number");
          mssEnd(mssErrorNoDefault);
        }

        /*Ⱦ*/
        priority = 0;
        revFlg   = 0;
        numFlg   = 0;
        str = mssGetTagAtt(field->str, "field", "sort");
        if(str!=NULL){
          priority=atoi(str);
          mssFree(str);
          str = mssGetTagAtt(field->str, "field", "numeric");
          if(str!=NULL){
            numFlg=atoi(str);
            if(numFlg!=0 && numFlg!=1){
              mssShowErrMsg("Internal Error: invalid numeric value");
              mssEnd(mssErrorNoDefault);
            }
            mssFree(str);
          }

          str = mssGetTagAtt(field->str, "field", "reverse");
          if(str!=NULL){
            revFlg=atoi(str);
            if(revFlg!=0 && revFlg!=1){
              mssShowErrMsg("Internal Error: invalid reverse value");
              mssEnd(mssErrorNoDefault);
            }
            mssFree(str);
          }
          mssSetFldInfoSort(*(hd->flds->fi+hd->flds->cnt-1),
                                                      priority,revFlg,numFlg);
        }

        /*lenghtΥå*/
        str = mssGetTagAtt(field->str, "field","length");
        if(str!=NULL) length = atoi(str);
        else          length = 0;
        mssFree(str);
        mssSetFldInfoLength(*(hd->flds->fi+hd->flds->cnt-1),length);
        break;

        /**/
        str=mssGetTagCont(field->str,"field",0);
        mssSetFldInfoComment(*(hd->flds->fi+hd->flds->cnt-1), str);
        mssFree(str);
        break;

      default:
        mssShowErrMsg("Internal Error: invalid XMLtable version");
        mssEnd(mssErrorNoDefault);
      }
      mssFreeStrings(field);
    }
    mssFreeStrings(head);

    mssSkipToBody(fp);
  }

  chkInfFldName(hd,fp); /*Ϲ̾Υå*/
  return(hd);
}

/**
 * # FUNCTION #
 * إåν(ǥХå)
 */
void mssShowHeader(struct mssHeader *hd)
{
  printf("====================================\n");
  printf("         Header Information         \n");
  printf("====================================\n");
  printf("XML Table version : %d\n",hd->version);
  printf("title : %s\n",hd->title);
  printf("comment : %s\n",hd->comment);
  printf("fldCnt : %d\n",hd->flds->cnt);
  mssShowFields(hd->flds);
}

/**
 * # FUNCTION #
 * mssFields¤Τ˳ǼƤ륽ȾheaderΥȾӤ
 * mssFieldsΥȾ󤫤鸫ưפƤХȺѤȤߤʤ
 * numeric,reverseʤǡȤ̤ͥפƤ1֤
 * numeric,reverseǡȤ̤ͥפƤ2֤
 * mssFields(sf)ƱܤİʾȤƤХ顼λ
 */
int mssChkSorted( struct mssFields *sf, struct mssHeader *hd)
{

  int i;

  /*ꤵƤʤ(same,diff)ϥȤƤȤߤʤ*/
  if(sf->cnt<1) return(1);

  /*ƥȤξϥȤƤȤߤʤ*/
  if(mssGV.txtFlg) return(1);

  /*sfƱܤʤɤå*/
  for(i=0; i<sf->cnt-1; i++){
    if( (*(sf->fi+i))->num == (*(sf->fi+i+1))->num ){
      mssShowErrMsg("same field name is used two or more times on -k(-s)");
      mssEnd(mssErrorNoDefault);
    }
  }

  /*sfγƹܤhdγƹܤӤ*/
  for(i=0; i<sf->cnt; i++){
    if(mssFldNum2SrtRev(hd->flds,(*(sf->fi+i))->num) != (*(sf->fi+i))->revFlg){
      return(0);
    }
    if(mssFldNum2SrtNum(hd->flds,(*(sf->fi+i))->num) != (*(sf->fi+i))->numFlg){
      return(0);
    }
    if(mssFldNum2SrtPri(hd->flds,(*(sf->fi+i))->num)-1 != i ) {
      return(0);
    }
  }

  /*numeric,reverseꤵƤ뤫򸡺*/
  for(i=0; i<sf->cnt; i++){
    if( (*(sf->fi+i))->revFlg) return(2);
    if( (*(sf->fi+i))->numFlg) return(2);
  }
  return(1);
}

/**
 * # SECTION #
 *----------------------------------------------------------------------------- 
 * MssOptFLD,OptKey Ϣؿ
 *----------------------------------------------------------------------------- 
 */

/**
 * # FUNCTION #
 * ϥǡβܤιܤץȤƻꤵ줿ܤιܤˤĤ
 * ξ֤
 *   ex.) 
 *     ϥǡ̾:a  b  c  d  e
 *     -f c,e,a λ
 *     {2,-1,0,-1,1}֤
 */
static int *setFldNo2optNo(struct mssFields *flds, int headFldCnt)
{
  int i,j;
  int *fldNo2optNo;

  fldNo2optNo=mssMalloc(sizeof(int)*headFldCnt,"setFldNo2optNo");
  for(i=0; i<headFldCnt; i++){
    *(fldNo2optNo+i)=-1;
  }
  j=0;
  for(i=0; i<flds->cnt; i++){
    *(fldNo2optNo+ MssFlds2num(flds,i))=j++;
  }
  return(fldNo2optNo);
}

/**
 * # FUNCTION #
 * ̾ʸ֤
 * ̾̾ "-f nam:newNam"ηǻꤵ롣
 * ΤȤnamnewNameˤƿ̾ʸ֤
 * δؿǤϼλ˴Ťơ̾롣
 * 1. newNam'&'ʸޤޤƤСʸnamִ롣
 * 2. 1ִ̿̾ĹMssFieldMaxLenĶȥ顼&
 * 3. newNamNULLʤСnam֤
 * 4. ̾Τ˿ʸΰݤΤǡnam,newNameȤδ
 *    Ϥʤ
 *   ex.) 
 *     newNam = NULL        , nam="Jan" -> return("Jan")
 *     newNam = "amount(&)" , nam="Jan" -> return("amount(Jan)")
 */
static char *setNewFldNam(char *newNam,char *nam)
{
  char retStr[MssFieldMaxLen]; /*Ÿ뿷̾ΰХåե*/
  char *namPnt;
  int  i;

  i=0;
  if(newNam==NULL){
    namPnt=nam;
    while(*namPnt!='\0'){
      retStr[i++]=*namPnt++;
      if(i>=MssFieldMaxLen-1){
        mssShowErrMsg("new field name exceed maximum length:%s",nam);
        mssEnd(mssErrorNoDefault);
      }
    }

  }else{
    while(*newNam!='\0'){
      if(*newNam=='&'){
        namPnt=nam;
        while(*namPnt!='\0'){
          retStr[i++]=*namPnt++;
          if(i>=MssFieldMaxLen-1){
            mssShowErrMsg("new field name exceed maximum length:%s",nam);
            mssEnd(mssErrorNoDefault);
          }
        }
        newNam++;
      }else{
        retStr[i++]=*newNam++;
        if(i>=MssFieldMaxLen-1){
          mssShowErrMsg("new field name exceed maximum length:%s",nam);
         mssEnd(mssErrorNoDefault);
        }
      }
    }
  }
  retStr[i]='\0';
  return(mssStrdup(retStr));
}

/**
 * # FUNCTION #
 * MssOptFLD¤ΤˤĤoptFld->nam˻ꤵ줿磻ɥɤɾ
 * optFld->nam,newNam,fldOpt򹹿롣ΤȤ磻ɥɤɾоݤ
 * fldsܤȤ롣
 * ץ򥻥åȤؿmssSetOptionǤϡ磻ɥɤŸϤʤ
 * Ǥδؿˤƥ磻ɥɾоݹܤꤷƽŸǽ
 * ʤ롣
 *   ex.)
 *    flds->nam={"customer","date","amount1","amount2"}
 *    optFld->flds->nam={"amount*"}
 *    -->> optFld->flds->nam={"amount1","amount2"}
 */
static void evalOptFldNameGlob(MssOptFLD *optFLD, struct mssFields *flds)
{
  struct mssFldInfo **fiList;
  char **name=NULL;
  char **newName=NULL;
  char **fldOpt=NULL;

  int fiCnt=0;
  int cnt=0;
  int i;

  for(i=0 ; i<optFLD->cnt ; i++) { /*ץǻꤵ줿ƹ*/
    /*WC˥ޥåܥꥹȤfiList(ǸNULLǽ)*/
    fiCnt=0;

    /*globOKʤŸ*/
    if(optFLD->globFlg) {
      fiList = mssFldGlbNam2Add(flds,*(optFLD->nam+i));

    /*globNGʤñ˹̾Address*/
    }else{
      fiList = mssCalloc(sizeof(struct mssFldInfo *) * 2,"evalGlob");
      *fiList = mssFldNam2Add(flds,*(optFLD->nam+i));
    }

    while( *(fiList+fiCnt) != NULL ){

      /*磻ɥŸ塢optFld->maxCntۤ饨顼Υå*/
      if(cnt>=optFLD->maxCnt){
        mssShowErrMsg("the max number of fields in the option is %d: -%s %s",
          optFLD->maxCnt,optFLD->keyWord,optFLD->str);
        mssEnd(mssErrorNoDefault);
      }

      /*̾*/
      name=mssRealloc(name,sizeof(char *)*(cnt+1), "evalOptFldNameGlob");
      *(name+cnt) = mssStrdup((*(fiList+fiCnt))->name);

      /*̾*/
      newName=mssRealloc(newName,sizeof(char *)*(cnt+1), "evalOptFldNameGlob");
      *(newName+cnt)=setNewFldNam(*(optFLD->newNam+i),*(name+cnt));

      /*ܥץ*/
      fldOpt=mssRealloc(fldOpt,sizeof(char *)*(cnt+1), "evalOptFldNameGlob");
      *(fldOpt+cnt)=mssStrdup(*(optFLD->fldOpt+i));

      fiCnt++;
      cnt++;
    }
    mssFree(fiList);
  }

  mssFree(optFLD->nam   );
  mssFree(optFLD->newNam);
  mssFree(optFLD->fldOpt);

  optFLD->nam   =name;
  optFLD->newNam=newName;
  optFLD->fldOpt=fldOpt;
  optFLD->cnt   =cnt;
}

/**
 * # FUNCTION #
 * optFLD¤Τιܤإåιܤͤ碌ưʲΣĤ򤪤ʤ
 * 1.MssOptFLDǻꤵ줿̾(nam)˴ޤޤ磻ɥɤɾ
 *   optFld->nam,newNam,fldOpt򹹿롣
 * 2.optFLD->fldsˡإåбܾ򥳥ԡ롣
 * 3.إåιֹ->ץλ֤ꡣ
 *   ex.) -f customer%r,date:DATE%rn,amt*:new(&)
 *             optFLD->nam   ={"customer","date","amt*"}
 *             optFLD->newNam={NULL,"DATE","new(&)"}
 *             optFLD->fldOpt={"r","rn",NULL}
 *        ϥǡΥإå={"customer","class","date","time","amt1","amt2"}
 *           -->>
 *        optFLD->nam   ={"customer,"date","amt1","amt2"}
 *        optFLD->newNam={"customer,"DATE","new(amt1)","new(amt2)"}
 *        optFLD->fldOpt={"r","rn",NULL,NULL}
 *        optFLD->fldNo2optNo={0,-1,1,-1,2,3}
 *        optFLD->flds->fi
 *                 ->num ={0,2,4,5}
 *                 ->name={"customer","date","amt1","amt2"}
 */
void mssSetOptFld(MssOptFLD *optFLD, struct mssHeader *hd)
{
  int i;
  int rev,num;

  optFLD->flds=mssInitFields();

  /*磻ɥɤɾ*/
  evalOptFldNameGlob(optFLD, hd->flds);

  /*optFLDǻꤵ줿̾ΥإåܤؤΥݥ󥿤Ͽ*/
  for(i=0 ; i<optFLD->cnt ; i++) {
    mssAddFieldsByFldInfo(optFLD->flds, mssFldNam2Add(hd->flds,*(optFLD->nam+i)));

    /*̾Ͽ*/
    if(optFLD->newFlg){
      if(0 != strcmp(*(optFLD->nam+i), *(optFLD->newNam+i)) ){
        mssSetFldInfoName(*(optFLD->flds->fi+optFLD->flds->cnt-1),
                          *(optFLD->newNam+i));
      }
    }

    /* 硿߽硢ʸ硿ͽΥե饰 */
    rev=mssIsFldOptOn(optFLD,i,'r');
    num=mssIsFldOptOn(optFLD,i,'n');
    mssSetFldInfoSort(*(optFLD->flds->fi+i),0,rev,num);
  }

  /*ֹflag*/
  optFLD->fldNo2optNo=setFldNo2optNo(optFLD->flds,hd->flds->cnt);
}

/**
 * # FUNCTION #
 * MssOptKEY¤Τιܤإåιܤͤ碌ưʲ3ĤΤȤ򤪤ʤ
 * 1.optFLD->fldsˡإåбܾ򥳥ԡ롣
 * 2.إåιֹ->ץλ֤ꡣ
 * 3.ƱܤʣꤷƤХ顼ǽλ
 *   ex.) -f customer,date
 *             optFLD->nam   ={"customer","date"}
 *        ϥǡΥإå={"customer","class","date","time","amt1","amt2"}
 *           -->>
 *        optFLD->fldNo2optNo={0,-1,1,-1,-1,-1}
 *        optFLD->flds->fi
 *                 ->num ={0,2}
 *                 ->name={"customer","date"}
 */
void mssSetOptKey(MssOptKEY *optKEY, struct mssHeader *hd)
{
  int i,j;

  optKEY->flds=mssInitFields();

  /*optKEYǻꤵ줿̾ΥإåܤؤΥݥ󥿤Ͽ*/
  for(i=0 ; i<optKEY->cnt ; i++) {
    mssAddFieldsByFldInfo(optKEY->flds, mssFldNam2Add(hd->flds,*(optKEY->nam+i)));
    mssSetFldInfoSort(*(optKEY->flds->fi+i),0,0,0);
  }

  /*optKEYƱܤꤵ줿饨顼*/
  for(i=0 ; i<optKEY->cnt-1 ; i++) {
    for(j=i+1 ; j<optKEY->cnt ; j++) {
      if( MssFlds2num(optKEY->flds,i)==MssFlds2num(optKEY->flds,j) ){
        mssShowErrMsg("can not specify a same field in key field(s)");
        mssEnd(mssErrorNoDefault);
      }
    }
  }

  /*ֹflag*/
  optKEY->fldNo2optNo=setFldNo2optNo(optKEY->flds,hd->flds->cnt);
}
