
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "折れ線グラフの出力(SVG)"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "各点に対応する項目名"
#define KEYC "各点に対応する項目名"
#define KEYF "数値順,逆順"

/*-e*/
#define EXPT "凡例項目名"
#define EXPC "各線のカラーを表す項目名"
#define EXPF NULL

/*-c*/
#define COLT "複数グラフ表示の列項目名"
#define COLC "グラフを複数表示する際の列項目名"
#define COLF "数値順,逆順"

/*-r*/
#define ROWT "複数グラフ表示行項目名"
#define ROWC "グラフを複数表示する際の行項目名"
#define ROWF "数値順,逆順"

/*-f*/
#define FLDT "各点の値を表す項目名"
#define FLDC "各棒の値を表す項目名"
#define FLDF NULL

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*-W*/
#define WIDT "描画領域の幅"
#define WIDC "描画領域の幅"

/*-H*/
#define HITT "描画領域の高さ"
#define HITC "描画領域の高さ"

/*--fix*/
#define FIXT "スケールの固定"
#define FIXC "-r,-cが指定されたとき、スケールを固定する"

/*--adjust*/
#define ADJT "グラフサイズの調整"
#define ADJC "-r,-cが指定されたとき、各グラフの幅：高さを自動調整"

/*-title*/
#define TITT "タイトル"
#define TITC "最上段に表示されるグラフタイトル"

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "SVGフォーマットで折れ線グラフを出力する。最高四次元のデータを平面上に描画できる(-k,-e,-c,-r)。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtline -k 年月 -f 金額 -i dat.xt -o rsl.svg\n\
xtline -k 年月 -e 年代 -f 金額 -i dat.xt -o rsl.xt\n\
xtline -k 年月 -e 年代 -c 地域 -r 規模クラス -f 金額 -i dat.xt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtbar"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
