
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "csvからxmlTablへの変換"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-F*/
#define HFDT "一行目を項目名とみなす"
#define HFDC "csvファイルの一行目を項目名としてxmlTableのヘッダーに取り込む"

/*-a*/
#define FNMT "新しい項目名リスト"
#define FNMC "ここで指定した項目名リストをxmlTableのヘッダーに登録する"

/*-l*/
#define TITT "タイトル"
#define TITC "ここで指定したタイトルをxmlTableのヘッダーに登録する"

/*-c*/
#define COMT "コメント"
#define COMC "ここで指定したコメントをxmlTableのヘッダーに登録する"

/*-s*/
#define SPCT "文字列"
#define SPCC "テキスト内のスペースをどの文字列に置き換えるかを指定する"

/*-I*/
#define IMPT "インポートファイル名"
#define IMPC "ヘッダーをインポートし、そのヘッダー情報をxmlTableのヘッダーに登録する"

/*-f*/
#define FRCT "項目数ノーチェック"
#define FRCC "項目数のチェックをおこなわない。ヘッダーの項目数に合わせて処理する。"

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "CSV(Comma Separated Value)フォーマットのデータをxmlTableに変換する。CSVについての標準はないが、このコマンドでは次の４つを想定している。1)項目はカンマで区切られている。2)行は改行で区切られている。3)ダブルクオートで囲まれた文字列中のカンマはデータとして扱われる。4)3のにおいて連続する２つのダブルクオートは、ダブルクオート一文字に変換される。またスペース文字はデフォルトでアンダースコアに変換される(-s で変更可能)。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
  csv2xt -F -i dat.txt -o rsl.xt\n\
  csv2xt -a顧客コード,日付,商品,数量,金額 -i dat.txt -o rls.xt\n\
  csv2xt -F -i dat.txt -l サンプルデータ -c マニュアル用に作成 -o rsl.xt\n\
  csv2xt -I header.xt -i dat.txt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xt2csv,txt2xt,xt2txt,xt2xml,xml2xt"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
