// The copyright of this set of program codes, AGM, belongs to 
// A. Inokuchi, T. Washio and H. Motoda at I.S.I.R., Osaka University
//  AGMϥץ(Ver.4 )Ǥ
//  Apriori르ꥺ(å)¹Ԥޤ 
//  '2000/10/06
//
#include "apriorigen2.c"
#include "check2.c"
#include "cuttree.c"

extern unsigned long trie_pos;
extern unsigned long ntypenum;
extern struct trie_node trie[];
extern struct graph transaction[];
extern unsigned long transaction_num;

struct entry entries[entries_size];

void apriori4(double sup,char option)
{
	unsigned long i,j,pos1,pos2,pos3,dep=1;
	double lsup,duration,mktry=0.0,countt=0.0,keptime;
	char fname[300];
	struct new_node data[10000],data2;
	matrix numbox;
	FILE *fpr=NULL,*fpw;
	clock_t start_time=clock();


	numbox=mat(1,transaction_num);

	lsup=transaction_num*sup;
	
	mssShowMsg("-----------------------------------------------");
	mssShowMsg("  number_data --> tree of frequent graph");
	mssShowMsg("  l-support = %5.2lf%%",sup*100);

	mssShowMsg(" Apriori start ");

	for(i=0;i<ntypenum;i++)
		data[i].item.nodetypes=(unsigned long *)malloc(sizeof(unsigned long)*1);

	for(i=0;i<ntypenum;i++){
		data[i].item.size=1;
		data[i].item.nodetypes[0]=i+1;
		data[i].count=0;
	}

	for(i=0;i<transaction_num;i++){
		for(j=0;j<transaction[i].size;j++){
			if(option==0){
				data[transaction[i].nodetypes[j]-1].count++;
			}
			else{
				if(j==0 || transaction[i].nodetypes[j]!=transaction[i].nodetypes[j-1]){
					data[transaction[i].nodetypes[j]-1].count++;
				}
			}
		}
	}

	lsup=sup*transaction_num;
	trie_pos=2;
	for(i=0;i<ntypenum;i++){
		if(data[i].count>=lsup){
			mkblock(data[i],1,1);
		}
	}

	duration=(double)(clock()-start_time)/CLOCKS_PER_SEC;
	keptime=duration;
	
	mssShowMsg("tree depth.no.=%lu  elapse time=%f %lu",dep,duration,trie_pos);

	pos1=1;
	pos2=2;
	pos3=trie_pos;

	data2.item.nodetypes=(unsigned long *)malloc(sizeof(unsigned long)*ESFG);
	data2.item.code=(char *)malloc(sizeof(char)*ESFG*(ESFG-1)/2);

	while(1){
		apriorigen2(pos1,pos2,&data2);
		if(pos3==trie_pos){
			break;
		}
		
		dep++;
		if(dep==ESFG){
		  mssShowErrMsg("Increase ESFG");
 		  mssEnd(mssErrorNoDefault);
		}

		duration=(double)(clock()-start_time)/CLOCKS_PER_SEC;
		mktry=mktry+duration-keptime;
		keptime=duration;
	
		if(dep%2==0){
		  if(dep!=2){
		    sprintf(fname,"%s/xt##%d-agm-work1",wfp,(int)getpid());
		    fpr=fopen(fname,"r");
		  }
		  sprintf(fname,"%s/xt##%d-agm-work2",wfp,(int)getpid());
		  fpw=fopen(fname,"w");
		}
		else{
		  sprintf(fname,"%s/xt##%d-agm-work1",wfp,(int)getpid());
		  fpw=fopen(fname,"w");
		  sprintf(fname,"%s/xt##%d-agm-work2",wfp,(int)getpid());
		  fpr=fopen(fname,"r");
		}
		for(i=0;i<transaction_num;i++)
			check2(pos3,i,fpr,fpw,numbox,1);
		if(dep!=2)
			fclose(fpr);
		fclose(fpw);
		
		cuttree(pos3,lsup);

		duration=(double)(clock()-start_time)/CLOCKS_PER_SEC;
		countt=countt+duration-keptime;
		keptime=duration;

		mssShowMsg("tree depth.no.=%lu  elapse time=%f",dep,duration);

		pos1=pos2;
		pos2=pos3;
		pos3=trie_pos;
		while(trie[pos2].item.size==0 && pos2<trie_pos){
			pos2++;
		}
	}
	duration=(double)(clock()-start_time)/CLOCKS_PER_SEC;
	mktry=mktry+duration-keptime;
	keptime=duration;

	mssShowMsg("total elapse time=%f",duration);

	mssShowMsg("time to generate trie=%f\ntime to count support value=%f",mktry,countt);

	
	for(i=0;i<ntypenum;i++)
		free(data[i].item.nodetypes);
}
