/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/06/20                                           */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include <xtsedHelp.h>
struct mssComHelp comHelp={
  "xtsed",        /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};  
            
extern struct mssGlobalVariables mssGV;

/*ִʸ(-v)"&"ǥȡʬ䤷ʸꥹȤǼ빽¤*/
/*"&"ΰ̣ϡޥåʸ֤롢Ȥ*/
struct {
  int cnt;
  char **strList;
} REP;

int   GLB; /*Хִե饰*/
struct mssStrings *RepStr;
regex_t REG;

static void repCat(char *str, regmatch_t *mp){
  int i;

  mssCatStrings(RepStr,*(REP.strList+0));
  for(i=1; i<REP.cnt; i++){
    mssCatnStrings(RepStr,str+mp->rm_so,mp->rm_eo-mp->rm_so);
    mssCatStrings(RepStr,*(REP.strList+i));
  }
}

/*ʸstrΥޥåս-vʸ֤RepStr˥å*/
/*ex) str="abcde" reg="cd" v="###" -> RepStr="ab###" */
static char *setRepStr(char *str){
  regmatch_t mp;

  if( 0!=regexec(&REG, str, 1, &mp,0) ){
    mssCatStrings(RepStr,str);           /*ޥåʤstrcat*/
    return(NULL);
  }else{
    mssCatnStrings(RepStr,str,mp.rm_so); /*ޥå֤ޤǤʸcat*/
    repCat(str,&mp);                  /*ִʸcat*/
    str=str+mp.rm_eo;                 /*ʸƬ򥻥å*/
    return(str);
  }
}

static char *getRepStr(char *str){
  
  if(MssIsNull(str)) return(MssNullStr);
  mssFreeStrings(RepStr);
  RepStr=mssInitStrings();

  if(GLB){
    while(1) {
      if( NULL == (str=setRepStr(str)) ){
        break;
      }
    }
  }else{
    str=setRepStr(str);
    if(NULL!=str) mssCatStrings(RepStr,str);
  }
  if(RepStr->cnt >= MssFieldMaxLen){
    return(MssNullStr);
  }else if(mssIsValidStr(RepStr->str)){
    return(RepStr->str);
  }else{
    return(MssNullStr);
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*//*----------------------------------------------------------------------------*/
/* оݹ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ɽ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optREG={
    OSTR,   /* ץ󥿥                                             */
    "c",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    100,    /* ʸκĹ                                               */
    REGT,   /* ΥץΥȥ(Helpɽ)                         */
    REGC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ִʸ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optREP={
    OSTR,   /* ץ󥿥                                             */
    "v",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե                                                   */
    0,      /* ʸκǾĹ                                               */
    100,    /* ʸκĹ                                               */
    REPT,   /* ΥץΥȥ(Helpɽ)                         */
    REPC    /* ΥץΥ(Helpɽ)                         */
  };
     
/*----------------------------------------------------------------------------*/
/* ܤȤƽϤե饰                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNEW={
    OFLG,   /* ץ󥿥                                             */
    "A",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    NEWT,   /* ΥץΥȥ(Helpɽ)                         */
    NEWC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* Хִե饰                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLG optGLB={
    OFLG,   /* ץ󥿥                                             */
    "g",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    GLBT,   /* ΥץΥȥ(Helpɽ)                         */
    GLBC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optREG,&optREP,&optNEW,&optGLB,
               &optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr; /*ϥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFldRec    *fr;  /*-ԥХåե¤             */

  int i;
  char *pos;
  char tmp[MssFieldMaxLen];

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */
  mssSetOptFld(&optFLD, hdi);        /* -f ܤإåܤ˴ϢŤ     */

  if( strchr(optREP.str,'*') != NULL ){
    mssShowErrMsg("-v can not have NULL character");
    mssEnd(mssErrorNoDefault);
  }

  /*ִʸ"&"ˤȡʬ*/
  /*\&Τ褦ʥפ뤿ˡö&*Ѵƺ*/
  /* "*"ϻǤʤʸʤΤOK*/
  /* ޤ̵̣"\"Ͻ*/
  i=0;
  pos=optREP.str;
  while(*pos!='\0'){
    if(*pos=='\\'){
      if( *(pos+1) == '&' ){
        tmp[i]='&';
        i++;
        pos++;
      }
    }else if(*pos=='&'){
      tmp[i]='*'; i++;
    }else{
      tmp[i]=*pos; i++;
    }
    pos++;
  }
  tmp[i]='\0';

  REP.strList=mssTokByChr(tmp,'*',&REP.cnt,1);

  GLB =optGLB.set; /*Хִ*/

  /*ɽΥѥ*/
  if(regcomp(&REG,optREG.str,REG_EXTENDED) ){
    mssShowErrMsg("error in compiling regex");
    mssEnd(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdi);

  /*ϥإåܤɲ*/

  /*̾ɲä*/
  if(optNEW.set){
    mssAddFieldsByFields(hdo->flds,hdi->flds);
    mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*-fǻꤵ줿ܤ-f顢¾ϥإåܤɲä*/
  }else{
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);
  }

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/

  fr=mssInitFldRec(hdi->flds->cnt);
  RepStr=mssInitStrings();
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    /*ɲäξ*/
    if(optNEW.set){
      mssWriteFld(fr->pnt,fr->fldCnt,"",fpw);
      for(i=0; i<optFLD.flds->cnt; i++){
        mssWriteDlm(fpw);
        mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(optFLD.flds,i))),fpw);
      }
      mssWriteRet(fpw);

    /*ִξ*/
    }else{
      for(i=0; i<hdi->flds->cnt; i++){
        if( *(optFLD.fldNo2optNo+i)==-1){
          mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
        }else{
          mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(hdi->flds,i))),fpw);
        }
        if(i==hdi->flds->cnt-1) mssWriteRet(fpw);
        else                    mssWriteDlm(fpw);
      }
    }
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);
  mssFreeStrings(RepStr);
  mssFree(*REP.strList);
  mssFree(REP.strList);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);     /* եåν             */
  mssCloseFPR(fpr);        /* ϥեΥ     */
  mssCloseFPW(fpw);        /* ϥեΥ     */
  mssFreeHeader(hdi);      /* ϥإåΰ賫         */
  mssFreeHeader(hdo);      /* ϥإåΰ賫         */
  mssFreeOption(opt);      /* ץΰ賫         */
  mssShowEndMsg();         /* λå             */
  mssEnd(mssExitSuccess);  /* λ                       */                   
  return(0);               /* to avoid warning message   */
}
