/*============================================================================*/
/* xtrjoin -k -r%s|n -m -K -R field1%e|n,field2%e|n -f  -n -z -t              */
/*----------------------------------------------------------------------------*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 :  2004/08/01                                                  */
/* 1.1 : ʸӤɾ˴ؤХ 2004/10/09                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtnrjoinHelp.h>
struct mssComHelp comHelp={
  "xtnrjoin",     /* ޥ̾       */
  "1.1",          /* С       */
  HELPT,          /* ޥɥȥ */ 
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--Хѿ*/
static int fcT;          /*ϥǡιܿ*/
static int fcM;          /*ȥǡιܿ*/
static int statT;        /*mssReadFRK(Tra)Υơ*/
static int statM;        /*mssReadFRK(Mst)Υơ*/
static struct mssFPW *op;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTFLD;
static MssOptFLD *OPTVAL;
static MssOptFLD *OPTRNG;
static MssOptFLG *OPTRNL;
static int NSflg; /*ϰ(1)ʸϰ(0) */
static int EQflg0; /*ϰϤΥޤफե饰*/
static int EQflg1; /*λϰϤΥޤफե饰*/
static int StFldNo; /* -RγϹܤΰֹ */
static int EdFldNo; /* -Rνλܤΰֹ */

/**
 * # FUNCTION #
 * ɤ߹ޤƤTraMstΥͤӤ
 */
static int keyCmp(
  struct mssFldRecKey *frkT,
  struct mssFldRecKey *frkM){
  int cmp;
  int i;
  int fnT;
  int fnM;

  if(statT==EOF) return(1);  /*T>M*/
  if(statM==EOF) return(-1); /*T<M*/

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp( *(frkT->pnt+fnT), *(frkM->pnt+fnM) );
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

/**
 * # FUNCTION #
 * ޥܤȤơcntĤNULLͤȤƽ񤭽Ф
 * βԤϤ롣
 */
static void writeMstNul(int cnt){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteNull(op); mssWriteDlm(op);
  }
  mssWriteNull(op); mssWriteRet(op);
}

/**
 * # FUNCTION #
 * ȥ󥶥ܤȤstrcntĤǤ񤭽Ф
 * ϥڡϤ롣
 */
static void writeTraFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt; i++){
    mssWriteStr(*(str+i),op);
    mssWriteDlm(op);
  }
}

static int WriteFlg=0;

/**
 * # FUNCTION #
 * ȥ󥶥ȥޥåϰƤΥޥ񤭽Ф
 * 񤭽ФʤWriteFlg1˥åȤ롣
 */
static void writeMatchRec(struct mssFldRecKey *frkT, struct mssRBnode *node){

  if(!mssRBisExternalNode(node)){
    writeMatchRec(frkT,node->left);

    mssWriteFld(frkT->pnt,frkT->fldCnt,"",op);
    mssWriteStr( (char *)node->key->v.v.a,op);
    mssWriteRet(op);
    mssGV.outCnt++;
    WriteFlg=1;
    writeMatchRec(frkT,node->right);
  }
}

/**
 * # FUNCTION #
 * ȥ󥶥ϰϥǥåͤ碌ʤ񤭽Ф
 */
static void writeTMbyRng(struct mssFldRecKey *frkT,struct RangeIndex *rIndex){
  struct RangeNode *curNode=rIndex->list;
  struct mssRBnode *rb;
  char *val;
  MssValue v;
  int cmp;

  rb=mssRBinit(ADD);

  if( NSflg==1 ) mssVinit(&v,DBL);
  else           mssVinit(&v,STR);

  mssSeekTopFRK(frkT);
  while( EOF != mssReadFldRecFRK(frkT) ){
    /*ȥ󥶥-rܤͤ򥻥å*/
    val = *(frkT->pnt+MssFlds2num(OPTVAL->flds,0));

    /* ȥ󥶥NULL⤷ϥޥλξϡ
       -N åȤƤн */
Loop3:
    if(MssIsNull(val) || curNode==NULL) {
      if(OPTRNL->set){
        writeTraFld(frkT->fldCnt,frkT->pnt);
        writeMstNul(OPTFLD->flds->cnt);
      }
      continue;
    }
    /*ϰϤη˱Ѵ*/
    if( NSflg==1 ) v.v.d = atof(val);
    else           v.v.s = val;

Loop2:
    cmp=mssVcmp(v,curNode->v);
    if(cmp<0){ /* val<curNode */ 
      WriteFlg=0;
      writeMatchRec(frkT,rb->left);
      /* Ϥʤ-NꤵƤ*/
      if(WriteFlg==0 && OPTRNL->set){
        writeTraFld(frkT->fldCnt,frkT->pnt);
        writeMstNul(OPTFLD->flds->cnt);
      }
      continue;
    } else if(cmp==0) {
      mssProcLTGE(rb, curNode);
      WriteFlg=0;
      writeMatchRec(frkT,rb->left);
      /* Ϥʤ-NꤵƤ*/
      if(WriteFlg==0 && OPTRNL->set){
        writeTraFld(frkT->fldCnt,frkT->pnt);
        writeMstNul(OPTFLD->flds->cnt);
      }
      continue;
    } else if(cmp>0) {
      mssProcLTGE(rb, curNode);
      mssProcLEGT(rb, curNode);
      curNode=curNode->next;
      if(curNode==NULL) goto Loop3;
      goto Loop2;
    }
  }

  mssRBfree(rb);
}

/**
 * # FUNCTION #
 * ߤΥȥ󥶥ȥޥ礷η̤Ϥ롣
 * frkT⤷frkMΤ줫NULLͿ뤳ȤˤꡢouterJOINԤ
 * η̤Ϥ롣
 */
static void writeTM(struct mssFldRecKey *frkT,struct mssFldRecKey *frkM){
  struct RangeIndex *rIndex;

  /*ޥEOFλ*/
  if(frkM==NULL){
    mssSeekTopFRK(frkT);
    while( EOF != mssReadFldRecFRK(frkT) ){
      writeTraFld(frkT->fldCnt,frkT->pnt);
      writeMstNul(OPTFLD->flds->cnt);
      mssGV.outCnt++;
    }

  /*ȥ顢ޥξ*/
  /*ȥ餬EOFλmain롼ǽλƤ*/
  }else{

    /* ޥϰϾ狼ϰϥǥå*/
    rIndex=mssSetRangeIndexFrk(frkM, OPTFLD->flds,StFldNo,EdFldNo,
                               NSflg,EQflg0,EQflg1);

    /*mssShowRangeIndex(rIndex);*/
    mssSeekTopFRK(frkT);
    while( EOF != mssReadFldRecFRK(frkT) ){
      writeTMbyRng(frkT,rIndex);
    }

    mssFreeRangeIndex(rIndex);
  }
}

/*============================================================================*/
/* version 1.00 2000/07/07  hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    TKYT,   /* ΥץΥȥ(Helpɽ)                         */
    TKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϰӤ()                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optVAL={
    OFLD,   /* ץ󥿥                                             */
    "v",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    VALT,   /* ΥץΥȥ(Helpɽ)                         */
    VALC,   /* ΥץΥ(Helpɽ)                         */
    VALF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };


/*----------------------------------------------------------------------------*/
/* ȥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* ץ󥿥                                             */
    "K",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    MKYT,   /* ΥץΥȥ(Helpɽ)                         */
    MKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϰϹ()                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRNG={
    OFLD,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    2,      /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "en",   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    RNGT,   /* ΥץΥȥ(Helpɽ)                         */
    RNGC,   /* ΥץΥ(Helpɽ)                         */
    RNGF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ȥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* ץ󥿥                                             */
    "m",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    MSTT,   /* ΥץΥȥ(Helpɽ)                         */
    MSTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* outerJoin                                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTNL={
    OFLG,   /* ץ󥿥                                             */
    "n",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TNLT,   /* ΥץΥȥ(Helpɽ)                         */
    TNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*ޥrangeˤҤȤĤޥåʤϤե饰                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optRNL={
    OFLG,   /* ץ󥿥                                             */
    "N",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    RNLT,   /* ΥץΥȥ(Helpɽ)                         */
    RNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optVAL,&optMKY,&optMST,&optRNG,&optFLD,&optTNL,&optRNL,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdM; /*ȥե<head>Ǽ¤*/
  struct mssHeader    *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fprT;/*ϥե빽¤                */
  struct mssFPR       *fprM;/*ȥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFields    *sfT; /*ȹܹ¤                  */
  struct mssFields    *sfM; /*ȹܹ¤                  */
  int sortedT;              /*Ⱥѥå                */
  int sortedM;              /*Ⱥѥå                */

  /*key break joinˤ*/
  struct mssFldRecKey *frkT=NULL;
  struct mssFldRecKey *frkM=NULL;

  int kc;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  
  /*-KꤵƤʤ-k򥳥ԡ*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }
  
  fprT=mssOpenFPR(optINF.str,4);    /*ե륪ץ*/
  fprM=mssOpenFPR(optMST.str,128);  /*ޥե륪ץ*/
  hdT=mssReadHeader(fprT);          /*̾ɤ߹*/
  hdM=mssReadHeader(fprM);          /*̾ɤ߹*/
  
  mssSetOptKey(&optTKY, hdT);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optVAL, hdT);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptKey(&optMKY, hdM);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optRNG, hdM);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optFLD, hdM);       /* ץܤإåܤ˴ϢŤ*/
  
  /*traȹܤκ*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sfT,optVAL.flds);/* -r ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfT);        /* ֹͥϿˤդ   */
  sortedT=mssChkSorted(sfT,hdT);        /* ȺѤå                 */
  
  /*mstȹܤκ*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfM);        /* ֹͥϿˤդ   */
  sortedM=mssChkSorted(sfM,hdM);        /* ȺѤå                 */
  
/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdT);

  /*ϥإåܤɲ*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*̾ɲä*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*ȤɬפʤsfΥȾȿ*/
  if(!sortedT){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*Хѿå*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTFLD=&optFLD;
  OPTVAL=&optVAL;
  OPTRNG=&optRNG;
  OPTRNL=&optRNL;
  op=fpw;

  StFldNo=MssFlds2num(OPTRNG->flds,0);
  EdFldNo=MssFlds2num(OPTRNG->flds,1);

  /*ϰϤʸϰϤ򥻥åȤ(ǥեȤϿϰ)*/
  NSflg=0;
  if(mssIsFldOptOn(&optVAL,0,'n') ){
    NSflg=1;
  }

 /*ϰϤΥޤफե饰*/
  EQflg0=1;
  EQflg1=0;
  if(mssIsFldOptOn(&optRNG,0,'n') ) EQflg0=0;
  if(mssIsFldOptOn(&optRNG,1,'e') ) EQflg1=1;
  if(!sortedT){
    fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
  }
  if(!sortedM){
    fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
  } 


  frkT=mssInitFRK(fcT,&optTKY,optTMP.str);
  frkM=mssInitFRK(fcM,&optMKY,optTMP.str);

  statT=mssReadFRK(fprT,frkT);
  statM=mssReadFRK(fprM,frkM);
  mssGV.inCnt += frkT->keyRecCnt;

  while(1){

    /*TraEndλ*/
    if(statT==EOF) break;

    /*MstEndλ*/
    if(statM==EOF){
      if(!optTNL.set) break;
    }

    /* Tra,MstκǽΰԤ򥭡ͤӤΤɤ߹*/
    mssReadFldRecFRK(frkT);
    mssReadFldRecFRK(frkM);
    kc=keyCmp(frkT,frkM);
    if(kc == 1){       /*T>M*/
      statM=mssReadFRK(fprM,frkM);
    }else if(kc ==-1){ /*T<M*/
      if(optTNL.set) writeTM(frkT,NULL);
      statT=mssReadFRK(fprT,frkT);
      if(statT!=EOF) mssGV.inCnt += frkT->keyRecCnt;
    }else{             /*T==M*/
      writeTM(frkT,frkM);
      statT=mssReadFRK(fprT,frkT);
      if(statT!=EOF) mssGV.inCnt += frkT->keyRecCnt;
      statM=mssReadFRK(fprM,frkM);
    }
  }
  mssFreeFRK(frkT);
  mssFreeFRK(frkM);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν              */
  mssCloseFPR(fprT);      /*ϥեΥ      */
  mssCloseFPR(fprM);      /*ϥեΥ      */
  mssCloseFPW(fpw);       /*ϥեΥ      */
  mssFreeFields(sfT);     /*ȹܹ¤Τΰ賫  */
  mssFreeFields(sfM);     /*ȹܹ¤Τΰ賫  */
  mssFreeHeader(hdT);     /*ϥإåΰ賫          */
  mssFreeHeader(hdM);     /*ϥإåΰ賫          */
  mssFreeHeader(hdo);     /*ϥإåΰ賫          */
  mssFreeOption(opt);     /*ץΰ賫          */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
