/**********************************************************************

  widgetsbase.cpp

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <unistd.h>

#include <qvaluelist.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qtextcodec.h>

#include <qapplication.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <qtabwidget.h>
#include <qtable.h>
#include <qcanvas.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qstringlist.h>
#include <qprocess.h>
#include <qcombobox.h>
#include <qlist.h>
#include <qslider.h>
#include <qpoint.h>

#include <qmessagebox.h>

#include "widgetsbase.h"
#include "soolist.h"
#include "asrulelist.h"
#include "canvas.h"
#include "tabledialog.h"
#include "graphdialog.h"
#include <stdlib.h>

const int  TABLE_ROW_MAX     =  256;
const int  TABLE_KEY_ROW_MAX = 4096;
//const int  TABLE_KEY_ROW_MAX = 8192;



WidgetsBase::WidgetsBase( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
    WidgetsBaseLayout = new QGridLayout( this, 4, 1, 4, 2, "WidgetsBaseLayout" );

    QTextCodec* codec = QTextCodec::codecForName("eucJP");

    hbutton1 = new QWidget( this, "hbutton1" );
    Hbox1 = new QHBoxLayout( hbutton1 , 1 , 1 , "Hbox1" );
    openbutton = new QPushButton( codec->toUnicode("ե") , hbutton1 , "openbutton" );
    quitbutton = new QPushButton( codec->toUnicode("λ"), hbutton1 , "quitbutton" );
    keymakebutton = new QPushButton( codec->toUnicode("key"), hbutton1 , "keymakebutton" );
    keyanabutton = new QPushButton( codec->toUnicode("keyʬ"), hbutton1 , "keyanabutton" );
    Hbox1->addWidget( openbutton );
    Hbox1->addWidget( keymakebutton );
    Hbox1->addWidget( keyanabutton );
    Hbox1->addWidget( quitbutton );

    connect( openbutton, SIGNAL( clicked () ), this, SLOT( loadFilename() ) );
    connect( keymakebutton, SIGNAL( clicked () ), this, SLOT( makeKeyword() ) );
    connect( keyanabutton, SIGNAL( clicked () ), this, SLOT( anaKeyword() ) );
    connect( quitbutton, SIGNAL( clicked () ), qApp, SLOT( quit() ) );


    WidgetsBaseLayout->addWidget( hbutton1, 0, 0 );
    

    hbutton2 = new QWidget( this, "hbutton2" );
    Hbox2 = new QHBoxLayout( hbutton2 , 1 , 1 , "Hbox2" );
    integbutton = new QPushButton( codec->toUnicode(""), hbutton2 , "integbutton" );
    integbutton->setMaximumWidth( 60 );
    sepabutton  = new QPushButton( codec->toUnicode("ʬΥ"), hbutton2 , "sepabutton" );
    sepabutton->setMaximumWidth( 60 );
    sortbutton  = new QPushButton( codec->toUnicode(""), hbutton2 , "sortbutton" );
    sortbutton->setMaximumWidth( 60 );
    morebutton  = new QPushButton( codec->toUnicode("ܺ"), hbutton2 , "morebutton" );
    morebutton->setMaximumWidth( 60 );
    addpartbutton = new QPushButton( codec->toUnicode("ɲ"), hbutton2 , "addpartbutton" );
    addpartbutton->setMaximumWidth( 60 );
    rmvpartbutton = new QPushButton( codec->toUnicode(""), hbutton2 , "rmvpartbutton" );
    rmvpartbutton->setMaximumWidth( 60 );
    boxuse = new QComboBox( FALSE, hbutton2 );
    boxuseno = new QComboBox( FALSE, hbutton2 );
    slimit = new QComboBox( FALSE, hbutton2 );
    slimit->setMaximumWidth( 50 );
    climit = new QComboBox( FALSE, hbutton2 );
    climit->setMaximumWidth( 50 );
    QStringList clusterItem;
    clusterItem.append( "0.1" );
    clusterItem.append( "0.01" );
    clusterItem.append( "0.001" );
    slimit->insertStringList( clusterItem );
    climit->insertStringList( clusterItem );
    Hbox2->addWidget( integbutton );
    Hbox2->addWidget( sepabutton );
    Hbox2->addWidget( sortbutton );
    Hbox2->addWidget( morebutton );
    Hbox2->addWidget( boxuse );
    Hbox2->addWidget( rmvpartbutton );
    Hbox2->addWidget( addpartbutton );
    Hbox2->addWidget( boxuseno );
    Hbox2->addWidget( slimit );
    Hbox2->addWidget( climit );

    connect( boxuse, SIGNAL( highlighted( int ) ), this, SLOT( boxuseHighlighted( int ) ) );
    connect( rmvpartbutton, SIGNAL( clicked () ), this, SLOT( rmvSoByPart() ) );
    connect( addpartbutton, SIGNAL( clicked () ), this, SLOT( addSoByPart() ) );
    connect( integbutton, SIGNAL( clicked () ), this, SLOT( integSo() ) );
    connect( sepabutton,  SIGNAL( clicked () ), this, SLOT( sepaSo()  ) );
    connect( sortbutton,  SIGNAL( clicked () ), this, SLOT( sortList()  ) );
    connect( morebutton,  SIGNAL( clicked () ), this, SLOT( moreInfo()  ) );

    WidgetsBaseLayout->addWidget( hbutton2, 1, 0 );


    hbutton3 = new QWidget( this, "hbutton3" );
    Hbox3 = new QHBoxLayout( hbutton3 , 1 , 1 , "Hbox3" );
        
    dirLabel = new QLabel ( "  dir : " , hbutton3 , "dirLabel" );
    dirLabel->setFrameStyle( QFrame::Panel );
    dirLabel->setText( "  dir : " );
    dirLabeS = new QLabel ( "" , hbutton3 , "dirLabeS" );
    dirLabeS->setFrameStyle( QFrame::Panel );
    dirLabeS->setText( " S:0" );
    dirLabeS->setMaximumWidth( 80 );
    dirLabeC = new QLabel ( "" , hbutton3 , "dirLabeC" );
    dirLabeC->setFrameStyle( QFrame::Panel );
    dirLabeC->setText( " C:0" );
    dirLabeC->setMaximumWidth( 80 );
    dirLabeL = new QLabel ( "" , hbutton3 , "dirLabeL" );
    dirLabeL->setFrameStyle( QFrame::Panel );
    dirLabeL->setText( " L:0" );
    dirLabeL->setMaximumWidth( 80 );
    Hbox3->addWidget( dirLabel );
    Hbox3->addWidget( dirLabeS );
    Hbox3->addWidget( dirLabeC );
    Hbox3->addWidget( dirLabeL );
    Smax=0.0; Smin=0.0;
    Cmax=0.0; Cmin=0.0;
    Lmax=0.0; Lmin=0.0;

    WidgetsBaseLayout->addWidget( hbutton3, 2, 0 );


    hbutton4 = new QWidget( this, "hbutton4" );
    Hbox4 = new QHBoxLayout( hbutton4 , 1 , 1 , "Hbox4" );

    TabWidget2 = new QTabWidget( hbutton4, "TabWidget2" );
    //TabWidget2 = new QTabWidget( this, "TabWidget2" );
    tab_2 = new QWidget( TabWidget2, "tab_2" );
    tabLayout_2 = new QGridLayout( tab_2, 1, 1, 4, 2, "tabLayout_2"); 
    
    
    table_file = new QTable( TABLE_ROW_MAX , 3 , tab_2  );
    QHeader *header_file = table_file->horizontalHeader();
    header_file->setLabel( 0, QObject::tr( "check" ), 80 );
    header_file->setLabel( 1, QObject::tr( "file_index" ), 80 );
    header_file->setLabel( 2, QObject::tr( "file_name" ), 600 );
    header_file->setMovingEnabled(TRUE);
    table_file->setColumnReadOnly( 1 , TRUE );
    table_file->setColumnReadOnly( 2 , TRUE );

    for( long prvIndex = 0 ; prvIndex < TABLE_ROW_MAX ; prvIndex++ ){
         QCheckTableItem *qcti = new QCheckTableItem( table_file, "chk" );
         qcti->setChecked( FALSE );
         table_file->setItem( prvIndex, 0, qcti );
    }

    
    tabLayout_2->addWidget( table_file , 0, 0 );
    TabWidget2->insertTab( tab_2, QString("filename") );

      

    tab_3 = new QWidget( TabWidget2, "tab_3" );
    tabLayout_3 = new QGridLayout( tab_3, 2, 1, 4, 2, "tabLayout_3"); 

    table_key = new QTable( TABLE_KEY_ROW_MAX , 10 , tab_3  );
    QHeader *header_key = table_key->horizontalHeader();
    header_key->setLabel( 0, QObject::tr( "check" ), 80 );
    header_key->setLabel( 1, QObject::tr( "index" ), 60 );
    header_key->setLabel( 2, QObject::tr( "count" ), 60 );
    header_key->setLabel( 3, QObject::tr( "word" ) );
    header_key->setLabel( 4, QObject::tr( "kana" ) );
    header_key->setLabel( 5, QObject::tr( "base" ) );
    header_key->setLabel( 6, QObject::tr( "part" ) );
    header_key->setLabel( 7, QObject::tr( "reserve1" ) );
    header_key->setLabel( 8, QObject::tr( "reserve2" ) );
    header_key->setLabel( 9, QObject::tr( "filename" ) );
    header_key->setMovingEnabled(TRUE);
    table_key->setColumnReadOnly( 1 , TRUE );
    table_key->setColumnReadOnly( 2 , TRUE );
    table_key->setColumnReadOnly( 3 , TRUE );
    table_key->setColumnReadOnly( 4 , TRUE );
    table_key->setColumnReadOnly( 5 , TRUE );
    table_key->setColumnReadOnly( 6 , TRUE );
    table_key->setColumnReadOnly( 7 , TRUE );
    table_key->setColumnReadOnly( 8 , TRUE );
    table_key->setColumnReadOnly( 9 , TRUE );

    for( long prvIndex = 0 ; prvIndex < TABLE_KEY_ROW_MAX ; prvIndex++ ){
         QCheckTableItem *qcti = new QCheckTableItem( table_key, "chk" );
         qcti->setChecked( FALSE );
         table_key->setItem( prvIndex, 0, qcti );
    }

    tabLayout_3->addWidget( table_key, 0, 0 );
    TabWidget2->insertTab( tab_3, QString("keyword") );
    
    
    
    tab_4 = new QWidget( TabWidget2, "tab_4" );
    tabLayout_4 = new QGridLayout( tab_4, 3, 1, 4, 2, "tabLayout_4"); 
    canvas_key = new QCanvas( tab_4 , "canvas_key" );
    canvas_key->resize( 720,507 );
    //editor = new FigureEditor( (*canvas_key) , tab_4  );
    editor = new FigureEditor( &NodeArray, &keyArray, &solistlist, &asList, (*canvas_key) , tab_4  );
    tabLayout_4->addWidget( editor, 0, 0 );
    TabWidget2->insertTab( tab_4, QString("keygraph") );

    Hbox4->addWidget( TabWidget2 );
    
    sliderS = new QSlider( Qt::Vertical, hbutton4, "sliderS" );
    sliderC = new QSlider( Qt::Vertical, hbutton4, "sliderC" );
    sliderL = new QSlider( Qt::Vertical, hbutton4, "sliderL" );
    sliderS->setRange ( 0, 1000 );
    sliderS->setValue ( 1000 );
    sliderC->setRange ( 0, 1000 );
    sliderC->setValue ( 1000 );
    sliderL->setRange ( 0, 1000 );
    sliderL->setValue ( 1000 );
    Hbox4->addWidget( sliderS );
    Hbox4->addWidget( sliderC );
    Hbox4->addWidget( sliderL );
    
    connect( sliderS,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderC,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderL,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderS,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispS( int ) ) );
    connect( sliderC,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispC( int ) ) );
    connect( sliderL,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispL( int ) ) );


    //WidgetsBaseLayout->addWidget( TabWidget2 , 3 , 0 );
    WidgetsBaseLayout->addWidget( hbutton4 , 3 , 0 );


    fileDialog = new QFileDialog( "./", "Text (*.txt)", this,
                    "open file dialog", "Choose a file to open" );
    fileDialog->setMode( QFileDialog::ExistingFiles );
    
    keymake_state = TRUE;
    
    static int r=24;
    srand(++r);
    
    numSentIndex = 0;
    
    //tableDlist.setAutoDelete( TRUE );

}


void WidgetsBase::loadFilename()
{
    if( TabWidget2->currentPageIndex() != 0 ){
        return;
    }

    if( fileDialog->exec() == QDialog::Accepted ){

        long prvFileNum = filelist.count();
        if( prvFileNum > TABLE_ROW_MAX ){
            prvFileNum = TABLE_ROW_MAX;
        }
        for( long prvIndex = 0 ; prvIndex < prvFileNum ; prvIndex++ ){
             QTableItem *qcti = table_file->item( prvIndex, 0 );
             if( qcti != NULL ){
                 QCheckTableItem *citem = (QCheckTableItem*)qcti;
                 citem->setChecked( FALSE );
             }
             table_file->setText( prvIndex , 1 , "");
             table_file->setText( prvIndex , 2 , "");
        }


        filelist = fileDialog->selectedFiles();


        long index_t = 0;
        for( QStringList::Iterator it = filelist.begin(); it != filelist.end(); ++it ) {
            if( index_t < TABLE_ROW_MAX ){
                table_file->setText( index_t , 1 , QString::number( index_t ) );
                table_file->setText( index_t , 2 , (*it) );
            
                QTableItem *qcti = table_file->item( index_t, 0 );
                if( qcti != NULL ){
                   QCheckTableItem *citem = (QCheckTableItem*)qcti;
                   citem->setChecked( TRUE );
                }

            }
            index_t++;
        }

        dirpath  = fileDialog->dirPath();
        QString tmp( "  dir : " );
        tmp = tmp + dirpath;
        dirLabel->setText( tmp );

        TabWidget2->setCurrentPage( 0 );

        partlist.clear();
        partlistno.clear();
        boxuse->clear();
        boxuseno->clear();

        long prvKeyNum = solistlist.count();
        if( prvKeyNum > TABLE_KEY_ROW_MAX ){
            prvKeyNum = TABLE_KEY_ROW_MAX;
        }
        for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
             QTableItem *qcti = table_key->item( prvIndex, 0 );
             if( qcti != NULL ){
                 QCheckTableItem *citem = (QCheckTableItem*)qcti;
                 citem->setChecked( FALSE );
             }
             table_key->setText( prvIndex , 1 , "");
             table_key->setText( prvIndex , 2 , "");
             table_key->setText( prvIndex , 3 , "");
             table_key->setText( prvIndex , 4 , "");
             table_key->setText( prvIndex , 5 , "");
             table_key->setText( prvIndex , 6 , "");
             table_key->setText( prvIndex , 7 , "");
             table_key->setText( prvIndex , 8 , "");
             table_key->setText( prvIndex , 9 , "");
        }

        editor->clear();
        NodeArray.resize( 0 );
        keyArray.resize( 0 );
        positionArray.resize( 0 );
        positionArrayKey.resize( 0 );
       
        TabWidget2->setCurrentPage( 0 );
    }

}

void WidgetsBase::makeKeyword()
{

    if( TabWidget2->currentPageIndex() != 0 ){
        return;
    }


    long prvFileNum = filelist.count();
    if( prvFileNum > TABLE_ROW_MAX ){
        prvFileNum = TABLE_ROW_MAX;
    }
    long fileNumToUse = 0;
    for( long prvIndex = 0 ; prvIndex < prvFileNum ; prvIndex++ ){
        QTableItem *qcti = table_file->item( prvIndex, 0 );
        QCheckTableItem *citem = (QCheckTableItem*)qcti;
        if( citem->isChecked() && (NULL!=table_file->text( prvIndex, 1 )) ){
            fileNumToUse++;
        }
    }

    if( fileNumToUse >= 2 ){
        if( keymake_state == TRUE ){
            keymake_state = FALSE;

            partlist.clear();
            partlistno.clear();
            boxuse->clear();
            boxuseno->clear();
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                (*itLL).clear();
            }
            solistlist.clear();

            dirpath4work = fileDialog->dirPath();
            dirpath4work.append( "/work" );

            QProcess proc00( this );
            proc00.addArgument( "/bin/rm" );
            proc00.addArgument( "-r" );
            proc00.addArgument( dirpath4work );
            if( !proc00.start() ){
                // error handling
                return;
            }
            //sleep(1) ;
            if( proc00.isRunning() == TRUE ) sleep(1) ;

            QProcess proc( this );
            proc.addArgument( "mkdir" );
            proc.addArgument( dirpath4work );
            //sleep(1) ;
            if( !proc.start() ){
                // error handling
                return;
            }
            if( proc.isRunning() == TRUE ) sleep(1) ;

            QString shellfile = dirpath4work;
            shellfile.append( "/aa.sh" );
            QFile fout( shellfile );
            if( fout.open(IO_WriteOnly) ) {
                QTextStream tout( &fout );
                //tout.setEncoding( QTextStream::UnicodeUTF8 );
                tout << "#! /bin/bash" << "\n";
                tout << "#!" << "\n\n";

                for( long prvIndex2 = 0 ; prvIndex2 < prvFileNum ; prvIndex2++ ){
                     QTableItem *qcti2 = table_file->item( prvIndex2, 0 );
                     QCheckTableItem *citem2 = (QCheckTableItem*)qcti2;
                     if( citem2->isChecked() && (NULL!=table_file->text( prvIndex2, 1 )) ){
                         QString orgDirPlusFile = table_file->text( prvIndex2 , 2 );
                         QStringList list = QStringList::split( "/" , orgDirPlusFile );
                         QStringList::Iterator it = list.end(); it--;
                         QString tmpFile = (*it);
                         QString sooDirPlusFile = dirpath4work;
                         sooDirPlusFile.append( "/" );
                         sooDirPlusFile.append( tmpFile );
                         sooDirPlusFile.append( ".rlt" );
                         QString uniDirPlusFile = dirpath4work;
                         uniDirPlusFile.append( "/" );
                         uniDirPlusFile.append( tmpFile );
                         uniDirPlusFile.append( ".utf8" );

                         tout << "chasen -o " << sooDirPlusFile << " " << orgDirPlusFile << "\n";
                         tout << "lv -Ou8 " << sooDirPlusFile << " > " << sooDirPlusFile << ".utf8\n" ;
                         tout << "lv -Ou8 " << orgDirPlusFile << " > " << uniDirPlusFile << "\n" ;
                     }
                }

                tout << flush;
                fout.close();

            }

            QProcess proc4chmod( this );
	    proc4chmod.addArgument( "chmod" );
	    proc4chmod.addArgument( "+x" );
            proc4chmod.addArgument( shellfile );
            if( !proc4chmod.start() ){
                // error handling
                return;
            }
            sleep(1) ;
            if( proc4chmod.isRunning() == TRUE ) sleep(1) ;

            QProcess proc4shexec( this );
            proc4shexec.addArgument( shellfile );
            if( !proc4shexec.start() ){
                // error handling
                return;
            }
            //sleep(1);
            sleep(100);
            if( proc4shexec.isRunning() == TRUE ) sleep(1) ;

    
    
            long    index_key = 0;
            QTextCodec* codec = QTextCodec::codecForName("eucJP");

            int     sentIndex = 0;
            numSentIndex = 0;

            for( long prvIndex3 = 0 ; prvIndex3 < prvFileNum ; prvIndex3++ ){
                QTableItem *qcti2 = table_file->item( prvIndex3, 0 );
                QCheckTableItem *citem2 = (QCheckTableItem*)qcti2;
                if( citem2->isChecked() && (NULL!=table_file->text( prvIndex3, 1 )) ){
                        QString orgDirPlusFile = table_file->text( prvIndex3 , 2 );
                        QStringList list = QStringList::split( "/" , orgDirPlusFile );
                        QStringList::Iterator it = list.end(); it--;
                        QString tmpFile = (*it);
                        QString sooDirPlusFile = dirpath4work;
                        sooDirPlusFile.append( "/" );
                        sooDirPlusFile.append( tmpFile );
                        sooDirPlusFile.append( ".rlt.utf8" );
                        QString uniDirPlusFile = dirpath4work;
                        uniDirPlusFile.append( "/" );
                        uniDirPlusFile.append( tmpFile );
                        uniDirPlusFile.append( ".utf8" );


                        QFile f( sooDirPlusFile );
                        if( f.open(IO_ReadOnly) ) {    // ե򳫤Τ
                             QTextStream t( &f );        // ƥȥȥ꡼Ѥ
                             t.setEncoding( QTextStream::UnicodeUTF8 );
                             QString s;

                             while ( !t.eof() ) {        // եޤ...
                                 s = t.readLine();       // line of text excluding '\n'
                                 QStringList list = QStringList::split( codec->toUnicode("\t") , s );

                                 QString str1, str2, str3, str4, str5, str6;
                                 QStringList::Iterator it;

                                 if( list.count() >= 4 ){

                                     it = list.begin();
                                     str1 = (*it); ++it;
                                     str2 = (*it); ++it;
                                     str3 = (*it); ++it;
                                     str4 = (*it); ++it;

                                     if( list.count() >= 5 ){
                                         str5 = (*it); ++it;
                                         if( list.count() >= 6 ){
                                             str6 = (*it);
                                         }
                                     }

                                     bool sit = FALSE;
                                     for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                                          if( sit == FALSE ){
                                              SooList::Iterator itL = (*itLL).begin();
                                              if( (*itL).getWordBase() == str3 ){
                                                  (*itLL).append( Soo( orgDirPlusFile , index_key , str1 , 
                                                                       str2 , str3 , str4 , str5 , str6 , TRUE , 
                                                                       prvIndex3 , uniDirPlusFile , sooDirPlusFile ,
                                                                       sentIndex ) );
                                                   sit = TRUE ;
                                              }
                                          }
                                     }
                                     if( sit == FALSE ){
                                          solist.clear();
                                          solist.append( Soo( orgDirPlusFile , index_key , str1 , 
                                                             str2 , str3 , str4 , str5 , str6 , TRUE ,
                                                             prvIndex3 , uniDirPlusFile , sooDirPlusFile ,
                                                             sentIndex ) );
                                          solistlist.append( solist );
                                     }

                                     index_key++;

                                     if( str3 == codec->toUnicode("") ){
                                         sentIndex++;
                                     }

                                 }

	                     }

                             f.close();
                       }



                  }
              }
              numSentIndex = sentIndex;
              
              //partlist.clear();
              //partlistno.clear();
              //for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
              //      SooList::Iterator itL = (*itLL).begin();
              //      QString partFromSo = (*itL).getWordPart();
              //
              //      bool exist = FALSE;
              //      for( QStringList::Iterator itPA = partlist.begin(); itPA != partlist.end(); ++itPA ){
              //          if( exist == FALSE ){
              //              if( (*itPA) == partFromSo ){
              //                  exist = TRUE ;
              //              }
              //          }
              //      }
              //      if( exist == FALSE ){
              //          partlist.append( partFromSo );
              //      }
              //
              //}
              //partlist.sort();
              //boxuse->insertStringList( partlist );

              partlist.clear();
              partlistno.clear();
              for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                    SooList::Iterator itLf = (*itLL).begin();
                    QString partFromSo = (*itLf).getWordPart();
                    if( (partFromSo.find( codec->toUnicode("̾") ) != -1) ||
                        (partFromSo.find( codec->toUnicode("ƻ") ) != -1)    ){
                        bool exist = FALSE;
                        for( QStringList::Iterator itPA = partlist.begin(); itPA != partlist.end(); ++itPA ){
                            if( exist == FALSE ){
                                if( (*itPA) == partFromSo ){
                                    exist = TRUE ;
                                }
                            }
                        }
                        if( exist == FALSE ){
                            partlist.append( partFromSo );
                        }
                    }
                    else{
                        bool exist = FALSE;
                        for( QStringList::Iterator itPA = partlistno.begin(); itPA != partlistno.end(); ++itPA ){
                            if( exist == FALSE ){
                                if( (*itPA) == partFromSo ){
                                    exist = TRUE ;
                                }
                            }
                        }
                        if( exist == FALSE ){
                            partlistno.append( partFromSo );
                        }                    
                    }
                    
                    for( SooList::Iterator itL = (*itLL).begin(); itL != (*itLL).end(); ++itL ){
                        QString currentText = (*itL).getWordPart();
                        if( (currentText.find( codec->toUnicode("̾") ) == -1) &&
                            (currentText.find( codec->toUnicode("ƻ") ) == -1)    ){
                            (*itL).setUseOrNot( FALSE );
                        }
                    }


              }
              partlist.sort();
              boxuse->insertStringList( partlist );
              partlistno.sort();
              boxuseno->insertStringList( partlistno );

              long index_table = 0;
              for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                  if( index_table < TABLE_KEY_ROW_MAX ){
                      SooList::Iterator itL = (*itLL).begin();
                      
                      if( (*itL).getUseOrNot() == TRUE ){
                          table_key->setText( index_table , 9 , (*itL).getFileName() );
                          table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                          table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                          table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                          table_key->setText( index_table , 4 , (*itL).getWordKana() );
                          table_key->setText( index_table , 5 , (*itL).getWordBase() );
                          table_key->setText( index_table , 6 , (*itL).getWordPart() );
                          table_key->setText( index_table , 7 , (*itL).getReserve1() );
                          table_key->setText( index_table , 8 , (*itL).getReserve2() );

                          index_table++;
                      }

                  }
              }



           }
           keymake_state = TRUE;

           if( table_key->text( 0 , 1 ) != "" ){
               TabWidget2->setCurrentPage( 1 );
           }
       
           editor->clear();
           NodeArray.resize( 0 );
           keyArray.resize( 0 );
           positionArray.resize( 0 );
           positionArrayKey.resize( 0 );
        }

}

void WidgetsBase::boxuseHighlighted( int index )
{
        QString HighlightedText = boxuse->text( index );
/*        long prvWordNum = solistlist.count();
        if( prvWordNum > TABLE_KEY_ROW_MAX ){
            prvWordNum = TABLE_KEY_ROW_MAX;
        }

        for( long index = 0 ; index < prvWordNum ; index++ ){
             QRect cr = table_key->cellGeometry ( index , 6 );
             QColorGroup g;
             g.setColor( QColorGroup::Base, red );
             table_key->paintCell();
        }
*/
}

void WidgetsBase::rmvSoByPart()
{
       if( TabWidget2->currentPageIndex() != 1 ){
           return;
       }

       if( boxuse->count() <= 0 ){
            return;
       }

       QString currentText = boxuse->currentText();
       for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
           for( SooList::Iterator itL = (*itLL).begin(); itL != (*itLL).end(); ++itL ){

               if( (*itL).getWordPart() ==  currentText ){
                   (*itL).setUseOrNot( FALSE );
               }
            
           }
       }
       

       long prvKeyNum = solistlist.count();
       if( prvKeyNum > TABLE_KEY_ROW_MAX ){
           prvKeyNum = TABLE_KEY_ROW_MAX;
       }

       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
           QTableItem *qcti = table_key->item( prvIndex, 0 );
           if( qcti != NULL ){
               QCheckTableItem *citem = (QCheckTableItem*)qcti;
               if( citem->isChecked() == TRUE ){
                   QString StrIndex = table_key->text( prvIndex , 1 );
                   checklist.append( StrIndex.toInt() );
               }
           }
       }
       
       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
             QTableItem *qcti = table_key->item( prvIndex, 0 );
             if( qcti != NULL ){
                 QCheckTableItem *citem = (QCheckTableItem*)qcti;
                 citem->setChecked( FALSE );
             }
             table_key->setText( prvIndex , 1 , "");
             table_key->setText( prvIndex , 2 , "");
             table_key->setText( prvIndex , 3 , "");
             table_key->setText( prvIndex , 4 , "");
             table_key->setText( prvIndex , 5 , "");
             table_key->setText( prvIndex , 6 , "");
             table_key->setText( prvIndex , 7 , "");
             table_key->setText( prvIndex , 8 , "");
             table_key->setText( prvIndex , 9 , "");
       }

       long index_table = 0;
       for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
           if( index_table < TABLE_KEY_ROW_MAX ){
               SooList::Iterator itL = (*itLL).begin();
               if( (*itL).getUseOrNot() == TRUE ){

                      table_key->setText( index_table , 9 , (*itL).getFileName() );
                      table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                      table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                      table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                      table_key->setText( index_table , 4 , (*itL).getWordKana() );
                      table_key->setText( index_table , 5 , (*itL).getWordBase() );
                      table_key->setText( index_table , 6 , (*itL).getWordPart() );
                      table_key->setText( index_table , 7 , (*itL).getReserve1() );
                      table_key->setText( index_table , 8 , (*itL).getReserve2() );

                      index_table++;
                }
            }
       }


       for( IntList::Iterator itI = checklist.begin(); itI != checklist.end(); ++itI ){
           int tmpIndex = (*itI);
           for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
               QString StrIndex = table_key->text( prvIndex , 1  );
               int IndexFromTable = StrIndex.toInt();
               if( IndexFromTable == tmpIndex ){
                   QTableItem *qcti = table_key->item( prvIndex, 0 );
                   if( qcti != NULL ){
                       QCheckTableItem *citem = (QCheckTableItem*)qcti;
                       citem->setChecked( TRUE );
                   }
               }
           }
       }
       checklist.clear();

       partlistno.append( currentText );
       partlistno.sort();
       QStringList::Iterator itPART = partlist.find( currentText );
       partlist.remove ( itPART );
       partlist.sort();
       
       boxuse->clear();
       boxuse->insertStringList( partlist );
       boxuseno->clear();
       boxuseno->insertStringList( partlistno );

       
}


void WidgetsBase::addSoByPart()
{

       if( TabWidget2->currentPageIndex() != 1 ){
           return;
       }

       if( boxuseno->count() <= 0 ){
            return;
       }

       QString currentText = boxuseno->currentText();
       for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
            for( SooList::Iterator itL = (*itLL).begin(); itL != (*itLL).end(); ++itL ){

                if( (*itL).getWordPart() ==  currentText ){
                    (*itL).setUseOrNot( TRUE );
                }
            
            }
       }


       long prvKeyNum = solistlist.count();
       if( prvKeyNum > TABLE_KEY_ROW_MAX ){
           prvKeyNum = TABLE_KEY_ROW_MAX;
       }
       
       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
           QTableItem *qcti = table_key->item( prvIndex, 0 );
           if( qcti != NULL ){
               QCheckTableItem *citem = (QCheckTableItem*)qcti;
               if( (citem->isChecked() == TRUE) && (NULL!=table_key->text( prvIndex, 1 )) ){
                   QString StrIndex = table_key->text( prvIndex , 1 );
                   checklist.append( StrIndex.toInt() );
               }
           }
       }

       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
           QTableItem *qcti = table_key->item( prvIndex, 0 );
           if( qcti != NULL ){
               QCheckTableItem *citem = (QCheckTableItem*)qcti;
               citem->setChecked( FALSE );
           }
           table_key->setText( prvIndex , 1 , "");
           table_key->setText( prvIndex , 2 , "");
           table_key->setText( prvIndex , 3 , "");
           table_key->setText( prvIndex , 4 , "");
           table_key->setText( prvIndex , 5 , "");
           table_key->setText( prvIndex , 6 , "");
           table_key->setText( prvIndex , 7 , "");
           table_key->setText( prvIndex , 8 , "");
           table_key->setText( prvIndex , 9 , "");
       }

       long index_table = 0;
       for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
           if( index_table < TABLE_KEY_ROW_MAX ){
                 SooList::Iterator itL = (*itLL).begin();
                 if( (*itL).getUseOrNot() == TRUE ){

                      table_key->setText( index_table , 9 , (*itL).getFileName() );
                      table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                      table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                      table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                      table_key->setText( index_table , 4 , (*itL).getWordKana() );
                      table_key->setText( index_table , 5 , (*itL).getWordBase() );
                      table_key->setText( index_table , 6 , (*itL).getWordPart() );
                      table_key->setText( index_table , 7 , (*itL).getReserve1() );
                      table_key->setText( index_table , 8 , (*itL).getReserve2() );

                      index_table++;
                  }
             }
       }

       
       for( IntList::Iterator itI = checklist.begin(); itI != checklist.end(); ++itI ){
            int tmpIndex = (*itI);
            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                 QString StrIndex = table_key->text( prvIndex , 1  );
                 int IndexFromTable = StrIndex.toInt();
                 if( IndexFromTable == tmpIndex ){
                     QTableItem *qcti = table_key->item( prvIndex, 0 );
                     if( qcti != NULL ){
                         QCheckTableItem *citem = (QCheckTableItem*)qcti;
                         citem->setChecked( TRUE );
                     }
                 }
            }
       }
       checklist.clear();

       
       partlist.append( currentText );
       partlist.sort();
       QStringList::Iterator itPART = partlistno.find( currentText );
       partlistno.remove ( itPART );
       partlistno.sort();
       
       boxuse->clear();
       boxuse->insertStringList( partlist );
       boxuseno->clear();
       boxuseno->insertStringList( partlistno );

}

void WidgetsBase::integSo()
{

        if( TabWidget2->currentPageIndex() != 1 ){
            return;
        }


        long prvKeyNum = solistlist.count();
        if( prvKeyNum > TABLE_KEY_ROW_MAX ){
            prvKeyNum = TABLE_KEY_ROW_MAX;
        }
        long keyIndex4Max = -1;
        long keyCount4Max = 0;
        for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
            QTableItem *qcti = table_key->item( prvIndex, 0 );
            QCheckTableItem *citem = (QCheckTableItem*)qcti;
            if( citem->isChecked() && ( NULL!=table_key->text( prvIndex, 1 )) ){
                QString tmpCount = table_key->text( prvIndex , 2 );
                if( tmpCount.toLong() > keyCount4Max ){
                    keyCount4Max = tmpCount.toLong();
                    QString tmpIndex = table_key->text( prvIndex , 1 );
                    keyIndex4Max = tmpIndex.toLong();
                }
            }
        }

        if( keyIndex4Max != -1 ){
            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                QTableItem *qcti = table_key->item( prvIndex, 0 );
                QCheckTableItem *citem = (QCheckTableItem*)qcti;
                if( citem->isChecked() && NULL!=table_key->text( prvIndex , 1 ) ){
                    QString tmpIndex = table_key->text( prvIndex , 1 );
                    if( tmpIndex.toLong() != keyIndex4Max ){

                        SooListList::Iterator itLL4IndexMax;
                        SooListList::Iterator itLL4IndexTmp;
                        for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                            SooList::Iterator itL = (*itLL).begin();
                            if( (*itL).getIndex() == keyIndex4Max ){
                                 itLL4IndexMax = itLL;
                            }
                            if( (*itL).getIndex() == tmpIndex.toLong() ){
                                 itLL4IndexTmp = itLL;
                            }

                        }

                        for( SooList::Iterator itLMve = (*itLL4IndexTmp).begin(); itLMve != (*itLL4IndexTmp).end(); ++itLMve ){
                                 (*itLL4IndexMax).append( Soo( (*itLMve).getFileName() , (*itLMve).getIndex() , 
                                                               (*itLMve).getWordOrg()  , (*itLMve).getWordKana() , 
                                                               (*itLMve).getWordBase() , (*itLMve).getWordPart() , 
                                                               (*itLMve).getReserve1() , (*itLMve).getReserve2() , 
                                                               (*itLMve).getUseOrNot() , (*itLMve).getFileIndex() ,
                                                               (*itLMve).getFileNameUni() , (*itLMve).getFileNameSooUni() ,
                                                               (*itLMve).getSentIndex()
                                                          ) );
                        }

                        solistlist.remove( itLL4IndexTmp );
                    }
                }
            }

            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                QTableItem *qcti = table_key->item( prvIndex, 0 );
                if( qcti != NULL ){
                    QCheckTableItem *citem = (QCheckTableItem*)qcti;
                    citem->setChecked( FALSE );
                }
                table_key->setText( prvIndex , 1 , "");
                table_key->setText( prvIndex , 2 , "");
                table_key->setText( prvIndex , 3 , "");
                table_key->setText( prvIndex , 4 , "");
                table_key->setText( prvIndex , 5 , "");
                table_key->setText( prvIndex , 6 , "");
                table_key->setText( prvIndex , 7 , "");
                table_key->setText( prvIndex , 8 , "");
                table_key->setText( prvIndex , 9 , "");
            }

            long index_table = 0;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
	        if( index_table < TABLE_KEY_ROW_MAX ){
                    SooList::Iterator itL = (*itLL).begin();
                    if( (*itL).getUseOrNot() == TRUE ){

                         table_key->setText( index_table , 9 , (*itL).getFileName() );
                         table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                         table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                         table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                         table_key->setText( index_table , 4 , (*itL).getWordKana() );
                         table_key->setText( index_table , 5 , (*itL).getWordBase() );
                         table_key->setText( index_table , 6 , (*itL).getWordPart() );
                         table_key->setText( index_table , 7 , (*itL).getReserve1() );
                         table_key->setText( index_table , 8 , (*itL).getReserve2() );

                         index_table++;
                    }
                }
            }

	    
	}

}

void WidgetsBase::sepaSo()
{

        if( TabWidget2->currentPageIndex() != 1 ){
           return;
        }


        long prvKeyNum = solistlist.count();
        if( prvKeyNum > TABLE_KEY_ROW_MAX ){
            prvKeyNum = TABLE_KEY_ROW_MAX;
        }
        long keyIndex4Max = -1;
        long keyCount4Max = 0;
        for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
            QTableItem *qcti = table_key->item( prvIndex, 0 );
            QCheckTableItem *citem = (QCheckTableItem*)qcti;
            if( citem->isChecked() && (NULL!=table_key->text( prvIndex , 1 ))  ){
                QString tmpCount = table_key->text( prvIndex , 2 );
                 if( tmpCount.toLong() > keyCount4Max ){
                     keyCount4Max = tmpCount.toLong();
                     QString tmpIndex = table_key->text( prvIndex , 1 );
                     keyIndex4Max = tmpIndex.toLong();
                 }
            }
        }

        if( keyIndex4Max != -1 ){

            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                QTableItem *qcti = table_key->item( prvIndex, 0 );
                QCheckTableItem *citem = (QCheckTableItem*)qcti;
                if( citem->isChecked() && (NULL!=table_key->text( prvIndex , 1 )) ){
                        QString tmpIndex = table_key->text( prvIndex , 1 );

                        SooListList::Iterator itLL4IndexTmp;
                        for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                             SooList::Iterator itL = (*itLL).begin();
                             if( (*itL).getIndex() == tmpIndex.toLong() ){
                                 itLL4IndexTmp = itLL;
                             }

                        }

                        for( SooList::Iterator itLMve = (*itLL4IndexTmp).begin(); itLMve != (*itLL4IndexTmp).end(); ++itLMve ){
                                 
                             bool sit = FALSE;
                             for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                                 if( sit == FALSE ){
                                      SooList::Iterator itL = (*itLL).begin();
                                      if( (*itL).getWordBase() == (*itLMve).getWordBase() ){
                                        if( itLL != itLL4IndexTmp ){
                                           (*itLL).append( Soo( (*itLMve).getFileName() , (*itLMve).getIndex() , 
                                                                (*itLMve).getWordOrg()  , (*itLMve).getWordKana() , 
                                                                (*itLMve).getWordBase() , (*itLMve).getWordPart() , 
                                                                (*itLMve).getReserve1() , (*itLMve).getReserve2() , 
                                                                (*itLMve).getUseOrNot() , (*itLMve).getFileIndex() ,
                                                                (*itLMve).getFileNameUni() , (*itLMve).getFileNameSooUni() ,
                                                                (*itLMve).getSentIndex()
                                                             ) );
                                            sit = TRUE ;
                                         }
                                      }
                                  }
                             }
                             if( sit == FALSE ){
                                  solist.clear();
                                  solist.append( Soo( (*itLMve).getFileName() , (*itLMve).getIndex() , 
                                                      (*itLMve).getWordOrg()  , (*itLMve).getWordKana() , 
                                                      (*itLMve).getWordBase() , (*itLMve).getWordPart() , 
                                                      (*itLMve).getReserve1() , (*itLMve).getReserve2() , 
                                                      (*itLMve).getUseOrNot() , (*itLMve).getFileIndex() ,
                                                      (*itLMve).getFileNameUni() , (*itLMve).getFileNameSooUni() ,
                                                      (*itLMve).getSentIndex()
                                                ) );
                                  solistlist.append( solist );
                            }

                        }

                        solistlist.remove( itLL4IndexTmp );

                 }
            }

            // sort by index
            typedef QValueList<long>     longList;
            longList                     indexList;
            SooListList                  templistlist;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                 SooList::Iterator itL = (*itLL).begin();
                 indexList.append( (*itL).getIndex() );
            }
            qHeapSort( indexList );
            for( longList::Iterator itSL = indexList.begin(); itSL != indexList.end(); ++itSL ){
                 SooListList::Iterator itLLsave = solistlist.begin();
                 for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                      SooList::Iterator itL = (*itLL).begin();
                      if( (*itSL) == (*itL).getIndex() ){
                           SooList templist = (*itLL);
                           templistlist.append( templist );
                      }
                 }
                 ++itLLsave;
            }
            solistlist = templistlist;


            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                QTableItem *qcti = table_key->item( prvIndex, 0 );
                if( qcti != NULL ){
                    QCheckTableItem *citem = (QCheckTableItem*)qcti;
                    citem->setChecked( FALSE );
                }
                table_key->setText( prvIndex , 1 , "");
                table_key->setText( prvIndex , 2 , "");
                table_key->setText( prvIndex , 3 , "");
                table_key->setText( prvIndex , 4 , "");
                table_key->setText( prvIndex , 5 , "");
                table_key->setText( prvIndex , 6 , "");
                table_key->setText( prvIndex , 7 , "");
                table_key->setText( prvIndex , 8 , "");
                table_key->setText( prvIndex , 9 , "");
            }

            long index_table = 0;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                if( index_table < TABLE_KEY_ROW_MAX ){
                    SooList::Iterator itL = (*itLL).begin();
                    if( (*itL).getUseOrNot() == TRUE ){

                         table_key->setText( index_table , 9 , (*itL).getFileName() );
                         table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                         table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                         table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                         table_key->setText( index_table , 4 , (*itL).getWordKana() );
                         table_key->setText( index_table , 5 , (*itL).getWordBase() );
                         table_key->setText( index_table , 6 , (*itL).getWordPart() );
                         table_key->setText( index_table , 7 , (*itL).getReserve1() );
                         table_key->setText( index_table , 8 , (*itL).getReserve2() );


                         index_table++;
                    }
                }
            }
       }
}

void WidgetsBase::sortList()
{

       if( TabWidget2->currentPageIndex() != 1 ){
           return;
       }

       long prvKeyNum = solistlist.count();
       if( prvKeyNum > TABLE_KEY_ROW_MAX ){
           prvKeyNum = TABLE_KEY_ROW_MAX;
       }
       
       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
             QTableItem *qcti = table_key->item( prvIndex, 0 );
            if( qcti != NULL ){
                 QCheckTableItem *citem = (QCheckTableItem*)qcti;
                 if( (citem->isChecked() == TRUE) && ( NULL!=table_key->text( prvIndex, 1 )) ){
                     QString StrIndex = table_key->text( prvIndex , 1 );
                     checklist.append( StrIndex.toInt() );
                 }
            }
       }

       
       long currentCol = table_key->currentColumn();
       
       if( currentCol == 1 ){
            // sort by index
            typedef QValueList<long>     longList;
            longList                     indexList;
            SooListList                  templistlist1;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                 SooList::Iterator itL = (*itLL).begin();
                 indexList.append( (*itL).getIndex() );
            }
            qHeapSort( indexList );
                 for( longList::Iterator itSL = indexList.begin(); itSL != indexList.end(); ++itSL ){
                 SooListList::Iterator itLLsave = solistlist.begin();
                 for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                      SooList::Iterator itL = (*itLL).begin();
                      if( (*itSL) == (*itL).getIndex() ){
                           SooList templist = (*itLL);
                           templistlist1.append( templist );
                      }
                 }
                 ++itLLsave;
            }
            solistlist = templistlist1;

       }

       if( currentCol == 2 ){
            // sort by count
            typedef QValueList<uint>     uintList;
            uintList                     countList4uniq;
            uintList                     countList4reverse;
            SooListList                  templistlist2;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                 bool sit = FALSE;
                 for( uintList::Iterator itU = countList4uniq.begin(); itU != countList4uniq.end(); ++itU ){
                      if( (*itLL).count() == (*itU) ){
                          sit = TRUE;
                      }
                 }
                 if( sit == FALSE ){
                      countList4uniq.append( (*itLL).count() );
                 }
            }
            qHeapSort( countList4uniq );
            uintList::Iterator itUR = countList4uniq.end(); --itUR;
            for( uintList::Iterator itU = countList4uniq.begin(); itU != countList4uniq.end(); ++itU ){
                 countList4reverse.append( (*itUR) );
                 --itUR;
            }
            countList4uniq = countList4reverse;
            for( uintList::Iterator itSL = countList4uniq.begin(); itSL != countList4uniq.end(); ++itSL ){
                 SooListList::Iterator itLLsave = solistlist.begin();
                 for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){

                      if( (*itSL) == (*itLL).count() ){
                           SooList templist = (*itLL);
                           templistlist2.append( templist );
                      }
                 }
                 ++itLLsave;
            }
            solistlist = templistlist2;

       }

       
       if( currentCol == 5 ){
            // sort by index
            QStringList                  baseList;
            QStringList                  baseListRev;
            SooListList                  templistlist5;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                 SooList::Iterator itL = (*itLL).begin();
                 baseList.append( (*itL).getWordBase() );
            }
            qHeapSort( baseList );
            QStringList::Iterator itUR = baseList.end(); --itUR;
            for( QStringList::Iterator itU = baseList.begin(); itU != baseList.end(); ++itU ){
                 baseListRev.append( (*itUR) );
                 --itUR;
            }
            baseList = baseListRev;
            for( QStringList::Iterator itSL = baseList.begin(); itSL != baseList.end(); ++itSL ){
                 SooListList::Iterator itLLsave = solistlist.begin();
                 for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                      SooList::Iterator itL = (*itLL).begin();
                      if( (*itSL) == (*itL).getWordBase() ){
                           SooList templist = (*itLL);
                           templistlist5.append( templist );
                      }
                 }
                 ++itLLsave;
            }
            solistlist = templistlist5;

       }

       if( currentCol == 6 ){
            // sort by count
            QStringList                  countList4uniq;
            QStringList                  countList4reverse;
            SooListList                  templistlist6;
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                 bool sit = FALSE;
                 SooList::Iterator itL = (*itLL).begin();
                 for( QStringList::Iterator itU = countList4uniq.begin(); itU != countList4uniq.end(); ++itU ){
                     if( (*itL).getWordPart() == (*itU) ){
                         sit = TRUE;
                     }
                 }
                 if( sit == FALSE ){
                     countList4uniq.append( (*itL).getWordPart() );
                 }
            }
            qHeapSort( countList4uniq );
            QStringList::Iterator itUR = countList4uniq.end(); --itUR;
            for( QStringList::Iterator itU = countList4uniq.begin(); itU != countList4uniq.end(); ++itU ){
                 countList4reverse.append( (*itUR) );
                 --itUR;
            }
            countList4uniq = countList4reverse;
            for( QStringList::Iterator itSL = countList4uniq.begin(); itSL != countList4uniq.end(); ++itSL ){
                 SooListList::Iterator itLLsave = solistlist.begin();
                 for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                      SooList::Iterator itL = (*itLL).begin();
                      if( (*itSL) == (*itL).getWordPart() ){
                           SooList templist = (*itLL);
                           templistlist6.append( templist );
                      }
                 }
                 ++itLLsave;
            }
            solistlist = templistlist6;

       }

       
       
              
       for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                QTableItem *qcti = table_key->item( prvIndex, 0 );
                if( qcti != NULL ){
                    QCheckTableItem *citem = (QCheckTableItem*)qcti;
                    citem->setChecked( FALSE );
                }
                table_key->setText( prvIndex , 1 , "");
                table_key->setText( prvIndex , 2 , "");
                table_key->setText( prvIndex , 3 , "");
                table_key->setText( prvIndex , 4 , "");
                table_key->setText( prvIndex , 5 , "");
                table_key->setText( prvIndex , 6 , "");
                table_key->setText( prvIndex , 7 , "");
                table_key->setText( prvIndex , 8 , "");
                table_key->setText( prvIndex , 9 , "");
        }

        long index_table = 0;
        for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                if( index_table < TABLE_KEY_ROW_MAX ){
                    SooList::Iterator itL = (*itLL).begin();
                    if( (*itL).getUseOrNot() == TRUE ){

                         table_key->setText( index_table , 9 , (*itL).getFileName() );
                         table_key->setText( index_table , 1 , QString::number( (*itL).getIndex() ) );
                         table_key->setText( index_table , 2 , QString::number( (*itLL).count() ) );
                         table_key->setText( index_table , 3 , (*itL).getWordOrg() );
                         table_key->setText( index_table , 4 , (*itL).getWordKana() );
                         table_key->setText( index_table , 5 , (*itL).getWordBase() );
                         table_key->setText( index_table , 6 , (*itL).getWordPart() );
                         table_key->setText( index_table , 7 , (*itL).getReserve1() );
                         table_key->setText( index_table , 8 , (*itL).getReserve2() );

                         index_table++;
                    }
                }
        }

        for( IntList::Iterator itI = checklist.begin(); itI != checklist.end(); ++itI ){
            int tmpIndex = (*itI);
            for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                 QString StrIndex = table_key->text( prvIndex , 1  );
                 int IndexFromTable = StrIndex.toInt();
                 if( IndexFromTable == tmpIndex ){
                     QTableItem *qcti = table_key->item( prvIndex, 0 );
                     if( qcti != NULL ){
                         QCheckTableItem *citem = (QCheckTableItem*)qcti;
                         citem->setChecked( TRUE );
                     }
                 }
            }
       }
       checklist.clear();

       
}


void WidgetsBase::anaKeyword()
{
        if( TabWidget2->currentPageIndex() != 1 ){
            return;
        }

        long prvKeyNum = solistlist.count();
        if( prvKeyNum > TABLE_KEY_ROW_MAX ){
            prvKeyNum = TABLE_KEY_ROW_MAX;
        }
        long keyNumToUse = 0;
        for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
             QTableItem *qcti = table_key->item( prvIndex, 0 );
             QCheckTableItem *citem = (QCheckTableItem*)qcti;
             if( citem->isChecked() && (NULL!=table_key->text( prvIndex, 1 )) ){
                keyNumToUse++;
             }
        }


        //QString ClusterNumStr = clusternum->currentText();
        //if( keyNumToUse <= ClusterNumStr.toLong() ){
        //    return;
        //}

        if( keyNumToUse < 5 ){
            return;
        }


        QString dat_xt_utf8 = dirpath4work;
        dat_xt_utf8.append( "/dat.xt.utf8" );
        QFile fdout( dat_xt_utf8 );
        if( fdout.open(IO_WriteOnly) ){
            QTextStream tout( &fdout );
            tout.setEncoding( QTextStream::UnicodeUTF8 );
            tout << "<?xml version=\"1.0\" encoding=\"euc-jp\"?>" << "\n";
            tout << "<xmltbl version=\"1.1\">" << "\n";
            tout << "<header>" << "\n";
            tout << "<field no=\"1\" name=\"position\"></field>" << "\n";
            tout << "<field no=\"2\" name=\"keyword\"></field>" << "\n";
            tout << "</header>" << "\n";
            tout << "<body><![CDATA[" << "\n";

            for( long sentIndex = 0 ; sentIndex < numSentIndex ; sentIndex++ ){
                SooList     samePosList;
                samePosList.clear();
                typedef QValueList<long>     longList;
                longList                     wordIndexList;
                wordIndexList.clear();

                for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
                    QTableItem *qcti = table_key->item( prvIndex, 0 );
                    QCheckTableItem *citem = (QCheckTableItem*)qcti;
                    if( citem->isChecked() && (NULL!=table_key->text( prvIndex , 1 ))  ){
                        QString keyIndexStr = table_key->text( prvIndex , 1 );
                        int keyIndex = keyIndexStr.toInt();

                        for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                            SooList::Iterator itLfirst = (*itLL).begin();
                            int firstIndex = (*itLfirst).getIndex();
                            if( keyIndex == firstIndex ){
                                for( SooList::Iterator itL = (*itLL).begin(); itL != (*itLL).end(); ++itL ){
                                    if( sentIndex == (*itL).getSentIndex() ){
                                        samePosList.append( Soo( "dum" , (*itL).getIndex() , "dum" , 
                                                "dum" , "dum" , "dum" , "dum" , "dum" , TRUE , // UseOrNotʻˤѤƤ
                                                keyIndex , "dum" , "dum" ,
                                                sentIndex ) );
                                        wordIndexList.append( (*itL).getIndex() );
                                    }
                                }
                            }
                        }
                    }
                }
                qHeapSort( wordIndexList );
                for( longList::Iterator itSL = wordIndexList.begin(); itSL != wordIndexList.end(); ++itSL ){
                    for( SooList::Iterator itL = samePosList.begin(); itL != samePosList.end(); ++itL ){
                        if( (*itSL) == (*itL).getIndex() ){
                            int keyIndex = (*itL).getFileIndex();
                            tout << QString::number( sentIndex ) << " " << QString::number( keyIndex ) <<"\n";
                        }
                    }
                }
            }

            tout << "]]></body>" << "\n";
            tout << "</xmltbl>" << "\n";
            tout << flush;
            fdout.close();
        }

        QString slimitStr = slimit->currentText();
        QString climitStr = climit->currentText();
        QString dat_xt = dirpath4work;
        dat_xt.append( "/dat.xt" );
        QString shellfile = dirpath4work;
        shellfile.append( "/bb.sh" );
        QFile fsout( shellfile );
        if( fsout.open(IO_WriteOnly) ) {
            QTextStream tout( &fsout );
            tout << "#! /bin/bash" << "\n";
            tout << "#!" << "\n\n";

            tout << "lv -Iu8 -Oej " << dat_xt_utf8 << " > " << dat_xt << "\n" ;

            tout << "xtasrule -k position -f keyword -S " << slimitStr << " -C " << climitStr << " " ;
            tout << "-i " << dat_xt << " -o " << dat_xt << ".mrsl\n" ;

            tout << "lv -Ou8 " << dat_xt << ".mrsl" << " > " << dat_xt << ".mrsl.utf8" << "\n" ;

            tout << flush;
            fsout.close();
        }


        QProcess proc4chmod( this );
        proc4chmod.addArgument( "chmod" );
        proc4chmod.addArgument( "+x" );
        proc4chmod.addArgument( shellfile );
        if( !proc4chmod.start() ){
            // error handling
            return;
        }
        //sleep(1) ;
        if( proc4chmod.isRunning() == TRUE ) sleep(1) ;

        QProcess proc4shexec( this );
        proc4shexec.addArgument( shellfile );
        if( !proc4shexec.start() ){
            // error handling
            return;
        }
        sleep(1);
        if( proc4shexec.isRunning() == TRUE ) sleep(1) ;


        TabWidget2->setCurrentPage( 2 );
        editor->clear();

        NodeArray.resize(keyNumToUse);
        keyArray.resize(keyNumToUse);
        //QMemArray<NodeItem*> NodeArray(keyNumToUse);
        //QMemArray<int>       keyArray(keyNumToUse);
        //AsRuleSooList        asList;        
        asList.clear();
        int NodeNum = 0;
        for( long prvIndex = 0 ; prvIndex < prvKeyNum ; prvIndex++ ){
            QTableItem *qcti = table_key->item( prvIndex, 0 );
            QCheckTableItem *citem = (QCheckTableItem*)qcti;
            if( citem->isChecked() && (NULL!=table_key->text( prvIndex , 1 ))  ){
                QString keyIndexStr = table_key->text( prvIndex , 1 );
                int keyIndex = keyIndexStr.toInt();

                for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                    SooList::Iterator itLfirst = (*itLL).begin();
                    int firstIndex = (*itLfirst).getIndex();
                    if( keyIndex == firstIndex ){

                        keyIndexStr.append( " " );
                        keyIndexStr.append( (*itLfirst).getWordBase() );
                        
                        if( NodeNum < keyNumToUse ){
                            NodeItem* nl = new NodeItem( canvas_key );
                            if( nl != NULL ){
                                //(new TextItem( nl, keyStr , canvas_key ))->show();
                                TextItem* tI = new TextItem( nl, keyIndexStr , canvas_key );
                                if( tI != NULL ){
                                    tI->show();
                                }
                                //nl->setBrush( QColor( 191, 191, 191 ) );
                                QPoint tmpPoint( -1, -1 );
                                for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                    if( keyIndex == positionArrayKey[index] ){
                                        tmpPoint.setX( positionArray[index].x() );
                                        tmpPoint.setY( positionArray[index].y() );
                                    }
                                }
                                if( tmpPoint.x() >= 0 ){
                                    nl->move( tmpPoint.x() , tmpPoint.y() );
                                }else{
                                    nl->move(rand()%canvas_key->width(),rand()%canvas_key->height());
                                }
                                //el->move( 100, 100 );
                                nl->show();

                                NodeArray[NodeNum] = nl;
                                keyArray[NodeNum] = keyIndex;
                                NodeNum++;
                            }
                        }

                    }
                }
            }
        }
        
        QTextCodec* codec = QTextCodec::codecForName("eucJP");
        QString dat_xt_mrsl_utf8 = dat_xt;
        dat_xt_mrsl_utf8.append( ".mrsl.utf8" );
        QFile fdin( dat_xt_mrsl_utf8 );
        if( fdin.open(IO_ReadOnly) ) {    // ե򳫤Τ
            QTextStream tin( &fdin );     // ƥȥȥ꡼Ѥ
            tin.setEncoding( QTextStream::UnicodeUTF8 );
            QString tmp;

            bool body1 = FALSE;
            bool body2 = FALSE;
            while( !tin.eof() ) {        // եޤ...
                tmp = tin.readLine();    // line of text excluding '\n'
                if( tmp.find( "body" ) != -1 ){
                    if( body1 == FALSE ){
                        body1 = TRUE;
                        tmp = tin.readLine();
                    }
                    else{
                        body2 = TRUE;
                    }
                }
                if( (body1 == TRUE) && (body2 == FALSE) ){
                    QStringList list = QStringList::split( codec->toUnicode(" ") , tmp );
                    QStringList::Iterator it;
                    if( list.count() == 10 ){
                        QString str1, str2, str3, str4, str5;
                        QString str6, str7, str8, str9, str10;
                        QString straa0, straa1, straa2;
                        int antece0 = -1;
                        int antece1 = -1;
                        int antece2 = -1;
                        int conseq, itemsize, anteceCnt;
                        int conseqCnt, conseqTot, totalCnt;
                        double support, confidence, lift;

                        it = list.begin();
                        str1 = (*it); ++it;
                        str2 = (*it); ++it;
                        str3 = (*it); ++it;
                        str4 = (*it); ++it;
                        str5 = (*it); ++it;
                        str6 = (*it); ++it;
                        str7 = (*it); ++it;
                        str8 = (*it); ++it;
                        str9 = (*it); ++it;
                        str10 = (*it);
                        if( str1.compare( "*" ) != 0 ){
                            QStringList anteceList = QStringList::split( codec->toUnicode(",") , str1 );
                            if( (1 <= anteceList.count()) && (anteceList.count() <= 3) ){
                                QStringList::Iterator itAnt;
                                if( anteceList.count() == 3 ){
                                    itAnt = anteceList.begin();
                                    straa0 = (*itAnt); ++itAnt;
                                    straa1 = (*itAnt); ++itAnt;
                                    straa2 = (*itAnt);
                                    antece0 = straa0.toInt();
                                    antece1 = straa1.toInt();
                                    antece2 = straa2.toInt();
                                }
                                if( anteceList.count() == 2 ){
                                    itAnt = anteceList.begin();
                                    straa0 = (*itAnt); ++itAnt;
                                    straa1 = (*itAnt);
                                    antece0 = straa0.toInt();
                                    antece1 = straa1.toInt();
                                    antece2 = -1;
                                }
                                if( anteceList.count() == 1 ){
                                    itAnt = anteceList.begin();
                                    straa0 = (*itAnt);
                                    antece0 = straa0.toInt();
                                    antece1 = -1;
                                    antece2 = -1;
                                }
                                conseq     = str2.toInt();
                                itemsize   = str3.toInt();
                                anteceCnt  = str4.toInt();
                                conseqCnt  = str5.toInt();
                                conseqTot  = str6.toInt();
                                totalCnt   = str7.toInt();
                                support    = str8.toDouble();
                                confidence = str9.toDouble();
                                lift       = str10.toDouble();
                                bool sit = FALSE;
                                for( AsRuleSooList::Iterator itAs = asList.begin(); itAs != asList.end(); ++itAs ){
                                     if( (anteceList.count()==(*itAs).getAntCount()) &&
                                         (antece0==(*itAs).getAntece0()) &&
                                         (antece1==(*itAs).getAntece1()) &&
                                         (antece2==(*itAs).getAntece2()) &&
                                         (conseq==(*itAs).getConseq())      ){
                                         sit = TRUE;
                                     }
                                }
                                if( sit == FALSE ){
                                    asList.append( AsRuleSoo(
                                                           anteceList.count(),
                                                           antece0, antece1, antece2,
                                                           conseq, itemsize, anteceCnt,
                                                           conseqCnt, conseqTot, totalCnt,
                                                           support, confidence, lift
                                                        ) 
                                                 );
                                }
                            }
                        }
                    }
                }

            }

            fdin.close();

            if( (body1 == TRUE) && (body2 == TRUE) ){

                Smax = slimitStr.toDouble();
                Cmax = climitStr.toDouble();
                Lmax = 0.0;
                Smin = slimitStr.toDouble();
                Cmin = climitStr.toDouble();
                Lmin = 0.0;

                for( AsRuleSooList::Iterator itAs = asList.begin(); itAs != asList.end(); ++itAs ){
                     if( 1 == (*itAs).getAntCount() ){
                         int antece0 = (*itAs).getAntece0();
                         int conseq  = (*itAs).getConseq();
                         if( antece0 != conseq ){
                             int antIndex = -1;
                             int conIndex = -1;
                             for( int tmpIndex = 0 ; tmpIndex < keyNumToUse ; tmpIndex++ ){
                                 if( antece0 == keyArray[tmpIndex] )   antIndex = tmpIndex;
                                 if( conseq  == keyArray[tmpIndex] )   conIndex = tmpIndex;
                             }
                             if( (antIndex != -1) && (conIndex != -1) ){
                                 EdgeItem* eI = new EdgeItem( NodeArray[antIndex], NodeArray[conIndex] , canvas_key );
                                 if( eI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     eI->show();
                                 }
                                 QString strSupport( "S=" );
                                 strSupport.append( QString::number( (*itAs).getSupport() ) );
                                 strSupport.append( "\n" );
                                 strSupport.append( "C=" );
                                 strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                 strSupport.append( "\n" );
                                 strSupport.append( "L=" );
                                 strSupport.append( QString::number( (*itAs).getLift() ) );
                                 TextItem* tI = new TextItem( eI, strSupport, canvas_key );
                                 if( tI != NULL ){
                                     tI->show();
                                 }
                                 
                                 if( (*itAs).getSupport() > Smax )    Smax = (*itAs).getSupport();
                                 if( (*itAs).getConfidence() > Cmax ) Cmax = (*itAs).getConfidence();
                                 if( (*itAs).getLift() > Lmax )       Lmax = (*itAs).getLift();
                             }
                         }
                     }
                     if( 2 == (*itAs).getAntCount() ){
                         int antece0 = (*itAs).getAntece0();
                         int antece1 = (*itAs).getAntece1();
                         int conseq  = (*itAs).getConseq();
                         if( (antece0 != conseq) && (antece1 != conseq) && (antece0 != antece1) ){
                             int antIndex0 = -1;
                             int antIndex1 = -1;
                             int conIndex = -1;
                             for( int tmpIndex = 0 ; tmpIndex < keyNumToUse ; tmpIndex++ ){
                                 if( antece0 == keyArray[tmpIndex] )   antIndex0 = tmpIndex;
                                 if( antece1 == keyArray[tmpIndex] )   antIndex1 = tmpIndex;
                                 if( conseq  == keyArray[tmpIndex] )   conIndex = tmpIndex;
                             }
                             if( (antIndex0 != -1) && (antIndex1 != -1) && (conIndex != -1) ){
                                 FriendItem* fI = new FriendItem( NodeArray[antIndex0], NodeArray[antIndex1], NodeArray[conIndex] , canvas_key );
                                 if( fI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     fI->show();
                                     EdgeItem* eI = new EdgeItem( fI, NodeArray[conIndex] , canvas_key );
                                     if( eI != NULL ){
                                         //eI->setPen( QColor( 191, 191, 191 ) );
                                         //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                         eI->show();
                                         QString strSupport( "S=" );
                                         strSupport.append( QString::number( (*itAs).getSupport() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "C=" );
                                         strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "L=" );
                                         strSupport.append( QString::number( (*itAs).getLift() ) );
                                         TextItem* tI = new TextItem( eI, strSupport, canvas_key );
                                         if( tI != NULL ){
                                             tI->show();
                                         }

                                     }

                                 }
                                 
                                 if( (*itAs).getSupport() > Smax )    Smax = (*itAs).getSupport();
                                 if( (*itAs).getConfidence() > Cmax ) Cmax = (*itAs).getConfidence();
                                 if( (*itAs).getLift() > Lmax )       Lmax = (*itAs).getLift();
                             }
                         }
                     }

                }
                sliderS->setValue( sliderS->maxValue() );
                sliderC->setValue( sliderC->maxValue() );
                sliderL->setValue( sliderL->maxValue() );
                
                dirLabeS->setText( " S:"+slimitStr );
                dirLabeC->setText( " C:"+climitStr );
                dirLabeL->setText( " L:0" );

            }
        }
        for( int index = 0 ; index < (int)NodeArray.count() ; index++ ){
            NodeArray[index]->checkConnect4color();
            NodeArray[index]->checkConnect4pos( canvas_key->height() );
        }

        canvas_key->update();

}

void WidgetsBase::moreInfo()
{

       if( TabWidget2->currentPageIndex() == 1 ){
       
           int currentRow = table_key->currentRow();
           if( currentRow < 0 )                  return;
           if( currentRow >= TABLE_KEY_ROW_MAX ) return;
           QString indexStr = table_key->text( currentRow , 1 );
           if( indexStr == "" )                  return;
       
           int index = indexStr.toInt();
       
           bool sit = FALSE;
           SooListList::Iterator itLLsave;
           for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                SooList::Iterator itL = (*itLL).begin();
                if( (*itL).getIndex() == index ){
                    itLLsave = itLL;
                    sit = TRUE;
                }
           }
           if( sit == FALSE ) return;
       
           //for( int ptrindex = tableDlist.count()-1 ; ptrindex >= 0 ; ptrindex-- ){
           //     if( TRUE == tableDlist.at( uint(ptrindex) )->getKillFlag() ){
           //         tableDlist.remove( uint(ptrindex) );
           //     }
           //}
       

           //tableDlist.append( new tableDialog( (*itLLsave) , &tableDlist , &solistlist, &asList, this ) );
           //tableDlist.last()->show();
           tableDialog* tableD = new tableDialog( (*itLLsave) , &solistlist, &asList, this );
           if( tableD != NULL ){
               tableD->show();
           }

       }

       if( TabWidget2->currentPageIndex() == 2 ){
       
           //graphDialog *graphD = new graphDialog();
           //graphD->show();
       
       }

}

void WidgetsBase::thresChanged()
{
        if( TabWidget2->currentPageIndex() != 2 ){
            return;
        }

        double Slimit = (double)(sliderS->maxValue()-sliderS->value())*(Smax-Smin) /
                        (double)(sliderS->maxValue()-sliderS->minValue())+Smin;
        double Climit = (double)(sliderC->maxValue()-sliderC->value())*(Cmax-Cmin) /
                        (double)(sliderC->maxValue()-sliderC->minValue())+Cmin;
        double Llimit = (double)(sliderL->maxValue()-sliderL->value())*(Lmax-Lmin) /
                        (double)(sliderL->maxValue()-sliderL->minValue())+Lmin;

        dirLabeS->setText( " S:"+QString::number( Slimit ) );
        dirLabeC->setText( " C:"+QString::number( Climit ) );
        dirLabeL->setText( " L:"+QString::number( Llimit ) );

        int NodeCount = NodeArray.count();
        positionArray.resize(NodeCount);
        positionArrayKey.resize(NodeCount);
        for( int nodeIndex = 0 ; nodeIndex < NodeCount ; nodeIndex++ ){
             if( NodeArray[nodeIndex] != NULL ){
                 QPoint position( (int)NodeArray[nodeIndex]->x() , (int)NodeArray[nodeIndex]->y() );
                 positionArray[nodeIndex] = position;
                 positionArrayKey[nodeIndex] = keyArray[nodeIndex];
             }
             else{
                 QPoint position( -1 , -1 );
                 positionArray[nodeIndex] = position;
                 positionArrayKey[nodeIndex] = -1;
             }
        }

        editor->clear();
        
        for( int nodeIndex = 0 ; nodeIndex < NodeCount ; nodeIndex++ ){
            int keyIndex = positionArrayKey[nodeIndex];
            QString keyIndexStr = QString::number( keyIndex );
            for( SooListList::Iterator itLL = solistlist.begin(); itLL != solistlist.end(); ++itLL ){
                SooList::Iterator itLfirst = (*itLL).begin();
                int firstIndex = (*itLfirst).getIndex();
                if( keyIndex == firstIndex ){
                    keyIndexStr.append( " " );
                    keyIndexStr.append( (*itLfirst).getWordBase() );
                }
            }
            NodeItem* nl = new NodeItem( canvas_key );
            if( nl != NULL ){
                //(new TextItem( nl, keyStr , canvas_key ))->show();
                TextItem* tI = new TextItem( nl, keyIndexStr , canvas_key );
                if( tI != NULL ){
                                    tI->show();
                }
                //nl->setBrush( QColor( 191, 191, 191 ) );
                nl->move( positionArray[nodeIndex].x() , positionArray[nodeIndex].y() );
                //el->move( 100, 100 );
                nl->show();

                NodeArray[nodeIndex] = nl;
            }

        }

        for( AsRuleSooList::Iterator itAs = asList.begin(); itAs != asList.end(); ++itAs ){
             if( 1 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int conseq  = (*itAs).getConseq();
                 if( antece0 != conseq ){
                     int antIndex = -1;
                     int conIndex = -1;
                     for( int tmpIndex = 0 ; tmpIndex < NodeCount ; tmpIndex++ ){
                         if( antece0 == positionArrayKey[tmpIndex] )   antIndex = tmpIndex;
                         if( conseq  == positionArrayKey[tmpIndex] )   conIndex = tmpIndex;
                     }
                     if( (antIndex != -1) && (conIndex != -1) ){
                         if(      (*itAs).getSupport() >= Slimit && 
                                  (*itAs).getConfidence() >= Climit &&
                                  (*itAs).getLift() >= Llimit          ){
                             EdgeItem* eI = new EdgeItem( NodeArray[antIndex], NodeArray[conIndex] , canvas_key );
                             if( eI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     eI->show();
                             }
                             QString strSupport( "S=" );
                             strSupport.append( QString::number( (*itAs).getSupport() ) );
                             strSupport.append( "\n" );
                             strSupport.append( "C=" );
                             strSupport.append( QString::number( (*itAs).getConfidence() ) );
                             strSupport.append( "\n" );
                             strSupport.append( "L=" );
                             strSupport.append( QString::number( (*itAs).getLift() ) );
                             TextItem* tI = new TextItem( eI, strSupport, canvas_key );
                             if( tI != NULL ){
                                     tI->show();
                             }
                         }
                    }
                }
             }
             if( 2 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int antece1 = (*itAs).getAntece1();
                 int conseq  = (*itAs).getConseq();
                 if( (antece0 != conseq) && (antece1 != conseq) && (antece0 != antece1) ){
                     int antIndex0 = -1;
                     int antIndex1 = -1;
                     int conIndex = -1;
                     for( int tmpIndex = 0 ; tmpIndex < NodeCount ; tmpIndex++ ){
                         if( antece0 == positionArrayKey[tmpIndex] )   antIndex0 = tmpIndex;
                         if( antece1 == positionArrayKey[tmpIndex] )   antIndex1 = tmpIndex;
                         if( conseq  == positionArrayKey[tmpIndex] )   conIndex = tmpIndex;
                     }
                     if( (antIndex0 != -1) && (antIndex1 != -1) && (conIndex != -1) ){
                         if(      (*itAs).getSupport() >= Slimit && 
                                  (*itAs).getConfidence() >= Climit &&
                                  (*itAs).getLift() >= Llimit          ){
                             FriendItem* fI = new FriendItem( NodeArray[antIndex0], NodeArray[antIndex1], NodeArray[conIndex] , canvas_key );
                             if( fI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     fI->show();
                                     EdgeItem* eI = new EdgeItem( fI, NodeArray[conIndex] , canvas_key );
                                     if( eI != NULL ){
                                         //eI->setPen( QColor( 191, 191, 191 ) );
                                         //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                         eI->show();
                                         QString strSupport( "S=" );
                                         strSupport.append( QString::number( (*itAs).getSupport() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "C=" );
                                         strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "L=" );
                                         strSupport.append( QString::number( (*itAs).getLift() ) );
                                         TextItem* tI = new TextItem( eI, strSupport, canvas_key );
                                         if( tI != NULL ){
                                             tI->show();
                                         }

                                     }

                             }
                         
                         }
                    }
                }
            }

        }
        for( int index = 0 ; index < (int)NodeArray.count() ; index++ ){
            NodeArray[index]->checkConnect4color();
        }

        canvas_key->update();
}

void WidgetsBase::thresDispS( int value )
{
        if( TabWidget2->currentPageIndex() != 2 ){
            return;
        }
        
        double Slimit = (double)(sliderS->maxValue()-value)*(Smax-Smin) /
                        (double)(sliderS->maxValue()-sliderS->minValue())+Smin;

        dirLabeS->setText( " S:"+QString::number( Slimit ) );

}

void WidgetsBase::thresDispC( int value )
{
        if( TabWidget2->currentPageIndex() != 2 ){
            return;
        }
        
        double Climit = (double)(sliderC->maxValue()-value)*(Cmax-Cmin) /
                        (double)(sliderC->maxValue()-sliderC->minValue())+Cmin;

        dirLabeC->setText( " C:"+QString::number( Climit ) );

}

void WidgetsBase::thresDispL( int value )
{
        if( TabWidget2->currentPageIndex() != 2 ){
            return;
        }
        
        double Llimit = (double)(sliderL->maxValue()-value)*(Lmax-Lmin) /
                        (double)(sliderL->maxValue()-sliderL->minValue())+Lmin;

        dirLabeL->setText( " L:"+QString::number( Llimit ) );

}

