/**********************************************************************

  graphdialog.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Fri. May.21  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qlayout.h>
#include <qpushbutton.h>
#include <qcanvas.h>
#include <qtextcodec.h>
#include <qlabel.h>
#include <qslider.h>

#include <qmessagebox.h>

#include "graphdialog.h"
//#include "textdialog.h"
#include "asrulelist.h"
#include "soolist.h"

//void graphDialog::moreInfo()
//{
//
//}

graphDialog::graphDialog( int tmpkeyIndex, 
                          SooListList* psoolistlist, AsRuleSooList* paslist, QWidget * parent )
    : QDialog( parent )

{
    resize( 540, 440 );

    keyIndex = tmpkeyIndex;
    tmpSooListList = psoolistlist;
    tmpAsList      = paslist;
    
    //int keyMax = psoolistlist->count();
    keyMax = 256;

    //QTextCodec* codec = QTextCodec::codecForName("eucJP");
    
    //tableButtonBox = new QVBoxLayout( this, 11, 6, "table button box layout" );
    WidgetsBaseLayout = new QGridLayout( this, 2, 1, 4, 2, "WidgetsBaseLayout" );
/*    
    labelWidget = new QWidget( this, "labelWidget" );
    labelBox = new QHBoxLayout( labelWidget , 1 , 1 , "labelBox" );

    dirLabel = new QLabel ( "  " , labelWidget , "dirLabel" );
    dirLabel->setFrameStyle( QFrame::Panel );
    dirLabel->setText( " " );
    dirLabeS = new QLabel ( "" , labelWidget , "dirLabeS" );
    dirLabeS->setFrameStyle( QFrame::Panel );
    dirLabeS->setText( " S:0" );
    dirLabeS->setMaximumWidth( 80 );
    dirLabeC = new QLabel ( "" , labelWidget , "dirLabeC" );
    dirLabeC->setFrameStyle( QFrame::Panel );
    dirLabeC->setText( " C:0" );
    dirLabeC->setMaximumWidth( 80 );
    dirLabeL = new QLabel ( "" , labelWidget , "dirLabeL" );
    dirLabeL->setFrameStyle( QFrame::Panel );
    dirLabeL->setText( " L:0" );
    dirLabeL->setMaximumWidth( 80 );
    
    labelBox->addWidget( dirLabel );
    labelBox->addWidget( dirLabeS );
    labelBox->addWidget( dirLabeC );
    labelBox->addWidget( dirLabeL );
    //tableButtonBox->addWidget( labelWidget );
    WidgetsBaseLayout->addWidget( labelWidget, 0, 0 );
*/    

    canvasWidget = new QWidget( this, "canvasWidget" );
    if( canvasWidget == NULL ) return;
    canvasBox = new QHBoxLayout( canvasWidget, 0, 6, "canvas box layout" );
    if( canvasBox == NULL ) return;

    canvas_graph = new QCanvas( canvasWidget , "canvas_graph" );
    if( canvas_graph == NULL ) return;
    canvas_graph->resize( 455, 390 );
    //editor = new FigureEditor( (*canvas_graph) , this  );
    editor = new FigureEditor( &NodeArray, &keyArray, tmpSooListList, tmpAsList, 
                               (*canvas_graph) , canvasWidget  );
    if( editor == NULL ) return;

    sliderS = new QSlider( Qt::Vertical, canvasWidget, "sliderS" );
    sliderC = new QSlider( Qt::Vertical, canvasWidget, "sliderC" );
    sliderL = new QSlider( Qt::Vertical, canvasWidget, "sliderL" );
    if( (sliderS == NULL) || (sliderC == NULL) || (sliderL == NULL) )  return;
    sliderS->setRange ( 0, 1000 );
    sliderS->setValue ( 1000 );
    sliderC->setRange ( 0, 1000 );
    sliderC->setValue ( 1000 );
    sliderL->setRange ( 0, 1000 );
    sliderL->setValue ( 1000 );
    Smax=0.0; Smin=0.0;
    Cmax=0.0; Cmin=0.0;
    Lmax=0.0; Lmin=0.0;

    canvasBox->addWidget( editor );
    canvasBox->addWidget( sliderS );
    canvasBox->addWidget( sliderC );
    canvasBox->addWidget( sliderL );

    connect( sliderS,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderC,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderL,  SIGNAL(  sliderReleased () ), this, SLOT(  thresChanged() ) );
    connect( sliderS,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispS( int ) ) );
    connect( sliderC,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispC( int ) ) );
    connect( sliderL,  SIGNAL(  valueChanged ( int ) ), this, SLOT(  thresDispL( int ) ) );

    
    //tableButtonBox->addWidget( editor );
    WidgetsBaseLayout->addWidget( canvasWidget, 0, 0 );

    buttonWidget = new QWidget( this, "buttonWidget" );
    if( buttonWidget == NULL ) return;
    buttonBox = new QHBoxLayout( buttonWidget, 0, 6, "button box layout" );
    if( buttonBox == NULL ) return;
    //QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding,
    //                                             QSizePolicy::Minimum );
    //buttonBox->addItem( spacer );
    //moreButton = new QPushButton( this, "morebutton" );
    //moreButton->setText( codec->toUnicode("ܺ") );
    //buttonBox->addWidget( moreButton );
    dirLabel = new QLabel ( "  " , buttonWidget , "dirLabel" );
    if( dirLabel == NULL ) return;
    dirLabel->setFrameStyle( QFrame::Panel );
    dirLabel->setText( " " );
    dirLabeS = new QLabel ( "" , buttonWidget , "dirLabeS" );
    if( dirLabeS == NULL ) return;
    dirLabeS->setFrameStyle( QFrame::Panel );
    dirLabeS->setText( " S:0" );
    dirLabeS->setMaximumWidth( 80 );
    dirLabeC = new QLabel ( "" , buttonWidget , "dirLabeC" );
    if( dirLabeC == NULL ) return;
    dirLabeC->setFrameStyle( QFrame::Panel );
    dirLabeC->setText( " C:0" );
    dirLabeC->setMaximumWidth( 80 );
    dirLabeL = new QLabel ( "" , buttonWidget , "dirLabeL" );
    if( dirLabeL == NULL ) return;
    dirLabeL->setFrameStyle( QFrame::Panel );
    dirLabeL->setText( " L:0" );
    dirLabeL->setMaximumWidth( 80 );
    
    closeButton = new QPushButton( buttonWidget, "closebutton" );
    if( closeButton == NULL ) return;
    closeButton->setText( "close" );
    closeButton->setDefault( TRUE );
    closeButton->setMaximumWidth( 80 );

    buttonBox->addWidget( dirLabel );
    buttonBox->addWidget( dirLabeS );
    buttonBox->addWidget( dirLabeC );
    buttonBox->addWidget( dirLabeL );

    buttonBox->addWidget( closeButton );

    //tableButtonBox->addWidget( buttonWidget );
    WidgetsBaseLayout->addWidget( buttonWidget, 1, 0 );

    connect( closeButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    //connect( moreButton, SIGNAL( clicked() ), this, SLOT( moreInfo() ) );
    
    QMemArray<NodeItem*> fstNodeArray;
    QMemArray<int>       fstkeyArray;
    if( TRUE != fstNodeArray.resize(keyMax)) return;
    if( TRUE != fstkeyArray.resize(keyMax) ) return;
    NodeNum = 0;
    QString keyIndexStr;
    for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
        SooList::Iterator itLfirst = (*itLL).begin();
        int firstIndex = (*itLfirst).getIndex();
        if( keyIndex == firstIndex ){
            keyIndexStr.append( QString::number( keyIndex ) );
            keyIndexStr.append( " " );
            keyIndexStr.append( (*itLfirst).getWordBase() );

            if( NodeNum < keyMax ){
                NodeItem* nl = new NodeItem( canvas_graph );
                if( nl != NULL ){

                    TextItem* tI = new TextItem( nl, keyIndexStr , canvas_graph );
                    if( tI != NULL ){
                        tI->show();
                    }

                    QPoint tmpPoint( -1, -1 );
                    for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                         if( keyIndex == positionArrayKey[index] ){
                             tmpPoint.setX( positionArray[index].x() );
                             tmpPoint.setY( positionArray[index].y() );
                         }
                    }
                    if( tmpPoint.x() >= 0 ){
                        nl->move( tmpPoint.x() , tmpPoint.y() );
                    }else{
                        //nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                        nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                    }
                    //nl->setSize( 50 , 50 );
                    nl->show();

                    fstNodeArray[NodeNum] = nl;
                    fstkeyArray[NodeNum] = keyIndex;
                    NodeNum++;
                }

            }

        }
    }

    setCaption( keyIndexStr );

    if( NodeNum > 0 ){
        Smax = 0.0;
        Cmax = 0.0;
        Lmax = 0.0;
        Smin = 0.0;
        Cmin = 0.0;
        Lmin = 0.0;

        for( AsRuleSooList::Iterator itAs = paslist->begin(); itAs != paslist->end(); ++itAs ){
             if( 1 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int conseq  = (*itAs).getConseq();
                 if( (antece0 == keyIndex) || (conseq == keyIndex) ){
                         if( antece0 != conseq ){
                             int antIndex = -1;
                             int conIndex = -1;
                             for( int tmpIndex = 0 ; tmpIndex < NodeNum ; tmpIndex++ ){
                                 if( antece0 == fstkeyArray[tmpIndex] )   antIndex = tmpIndex;
                                 if( conseq  == fstkeyArray[tmpIndex] )   conIndex = tmpIndex;
                             }
                             if( (antIndex == -1) && (NodeNum < keyMax) ){
                                 NodeItem* nl = new NodeItem( canvas_graph );
                                 if( nl != NULL ){
                                     QString tmpIndexStr;
                                     for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                                         SooList::Iterator itLfirst = (*itLL).begin();
                                         int firstIndex = (*itLfirst).getIndex();
                                         if( antece0 == firstIndex ){
                                             tmpIndexStr.append( QString::number( antece0 ) );
                                             tmpIndexStr.append( " " );
                                             tmpIndexStr.append( (*itLfirst).getWordBase() );
                                         }
                                     }
                                     TextItem* tI = new TextItem( nl, tmpIndexStr , canvas_graph );
                                     if( tI != NULL ){
                                         tI->show();
                                     }
                                     QPoint tmpPoint( -1, -1 );
                                     for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                         if( keyIndex == positionArrayKey[index] ){
                                             tmpPoint.setX( positionArray[index].x() );
                                             tmpPoint.setY( positionArray[index].y() );
                                         }
                                     }
                                     if( tmpPoint.x() >= 0 ){
                                         nl->move( tmpPoint.x() , tmpPoint.y() );
                                     }else{
                                         nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                                         //nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                                     }
                                     nl->show();

                                     antIndex = NodeNum;
                                     fstNodeArray[NodeNum] = nl;
                                     fstkeyArray[NodeNum] = antece0;
                                     NodeNum++;

                                 }

                             }
                             if( (conIndex == -1) && (NodeNum < keyMax) ){
                                 NodeItem* nl = new NodeItem( canvas_graph );
                                 if( nl != NULL ){
                                     QString tmpIndexStr;
                                     for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                                         SooList::Iterator itLfirst = (*itLL).begin();
                                         int firstIndex = (*itLfirst).getIndex();
                                         if( conseq == firstIndex ){
                                             tmpIndexStr.append( QString::number( conseq ) );
                                             tmpIndexStr.append( " " );
                                             tmpIndexStr.append( (*itLfirst).getWordBase() );
                                         }
                                     }
                                     TextItem* tI = new TextItem( nl, tmpIndexStr , canvas_graph );
                                     if( tI != NULL ){
                                         tI->show();
                                     }
                                     QPoint tmpPoint( -1, -1 );
                                     for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                         if( keyIndex == positionArrayKey[index] ){
                                             tmpPoint.setX( positionArray[index].x() );
                                             tmpPoint.setY( positionArray[index].y() );
                                         }
                                     }
                                     if( tmpPoint.x() >= 0 ){
                                         nl->move( tmpPoint.x() , tmpPoint.y() );
                                     }else{
                                         nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                                         //nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                                     }
                                     nl->show();

                                     conIndex = NodeNum;
                                     fstNodeArray[NodeNum] = nl;
                                     fstkeyArray[NodeNum] = conseq;
                                     NodeNum++;

                                 }

                             }
                             
                             
                             if( (antIndex != -1) && (conIndex != -1) ){
                                 EdgeItem* eI = new EdgeItem( fstNodeArray[antIndex], fstNodeArray[conIndex] , canvas_graph );
                                 if( eI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     eI->show();
                                 }
                                 QString strSupport( "S=" );
                                 strSupport.append( QString::number( (*itAs).getSupport() ) );
                                 strSupport.append( "\n" );
                                 strSupport.append( "C=" );
                                 strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                 strSupport.append( "\n" );
                                 strSupport.append( "L=" );
                                 strSupport.append( QString::number( (*itAs).getLift() ) );
                                 TextItem* tI = new TextItem( eI, strSupport, canvas_graph );
                                 if( tI != NULL ){
                                     tI->show();
                                 }
                                 
                                 if( (*itAs).getSupport() > Smax )    Smax = (*itAs).getSupport();
                                 if( (*itAs).getConfidence() > Cmax ) Cmax = (*itAs).getConfidence();
                                 if( (*itAs).getLift() > Lmax )       Lmax = (*itAs).getLift();
                             }
                         }
                 }
             }
             if( 2 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int antece1 = (*itAs).getAntece1();
                 int conseq  = (*itAs).getConseq();
                 if( (antece0 == keyIndex) || (antece1 == keyIndex) || (conseq == keyIndex) ){
                     if( (antece0 != conseq) && (antece1 != conseq) && (antece0 != antece1) ){
                             int antIndex0 = -1;
                             int antIndex1 = -1;
                             int conIndex = -1;
                             for( int tmpIndex = 0 ; tmpIndex < NodeNum ; tmpIndex++ ){
                                 if( antece0 == fstkeyArray[tmpIndex] )   antIndex0 = tmpIndex;
                                 if( antece1 == fstkeyArray[tmpIndex] )   antIndex1 = tmpIndex;
                                 if( conseq  == fstkeyArray[tmpIndex] )   conIndex = tmpIndex;
                             }
                             if( (antIndex0 == -1) && (NodeNum < keyMax) ){
                                 NodeItem* nl = new NodeItem( canvas_graph );
                                 if( nl != NULL ){
                                     QString tmpIndexStr;
                                     for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                                         SooList::Iterator itLfirst = (*itLL).begin();
                                         int firstIndex = (*itLfirst).getIndex();
                                         if( antece0 == firstIndex ){
                                             tmpIndexStr.append( QString::number( antece0 ) );
                                             tmpIndexStr.append( " " );
                                             tmpIndexStr.append( (*itLfirst).getWordBase() );
                                         }
                                     }
                                     TextItem* tI = new TextItem( nl, tmpIndexStr , canvas_graph );
                                     if( tI != NULL ){
                                         tI->show();
                                     }
                                     QPoint tmpPoint( -1, -1 );
                                     for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                         if( keyIndex == positionArrayKey[index] ){
                                             tmpPoint.setX( positionArray[index].x() );
                                             tmpPoint.setY( positionArray[index].y() );
                                         }
                                     }
                                     if( tmpPoint.x() >= 0 ){
                                         nl->move( tmpPoint.x() , tmpPoint.y() );
                                     }else{
                                         nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                                         //nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                                     }
                                     nl->show();

                                     antIndex0 = NodeNum;
                                     fstNodeArray[NodeNum] = nl;
                                     fstkeyArray[NodeNum] = antece0;
                                     NodeNum++;

                                 }

                             }
                             if( (antIndex1 == -1) && (NodeNum < keyMax) ){
                                 NodeItem* nl = new NodeItem( canvas_graph );
                                 if( nl != NULL ){
                                     QString tmpIndexStr;
                                     for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                                         SooList::Iterator itLfirst = (*itLL).begin();
                                         int firstIndex = (*itLfirst).getIndex();
                                         if( antece1 == firstIndex ){
                                             tmpIndexStr.append( QString::number( antece1 ) );
                                             tmpIndexStr.append( " " );
                                             tmpIndexStr.append( (*itLfirst).getWordBase() );
                                         }
                                     }
                                     TextItem* tI = new TextItem( nl, tmpIndexStr , canvas_graph );
                                     if( tI != NULL ){
                                         tI->show();
                                     }
                                     QPoint tmpPoint( -1, -1 );
                                     for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                         if( keyIndex == positionArrayKey[index] ){
                                             tmpPoint.setX( positionArray[index].x() );
                                             tmpPoint.setY( positionArray[index].y() );
                                         }
                                     }
                                     if( tmpPoint.x() >= 0 ){
                                         nl->move( tmpPoint.x() , tmpPoint.y() );
                                     }else{
                                         nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                                         //nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                                     }
                                     nl->show();

                                     antIndex1 = NodeNum;
                                     fstNodeArray[NodeNum] = nl;
                                     fstkeyArray[NodeNum] = antece1;
                                     NodeNum++;

                                 }

                             }
                             if( (conIndex == -1) && (NodeNum < keyMax) ){
                                 NodeItem* nl = new NodeItem( canvas_graph );
                                 if( nl != NULL ){
                                     QString tmpIndexStr;
                                     for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                                         SooList::Iterator itLfirst = (*itLL).begin();
                                         int firstIndex = (*itLfirst).getIndex();
                                         if( conseq == firstIndex ){
                                             tmpIndexStr.append( QString::number( conseq ) );
                                             tmpIndexStr.append( " " );
                                             tmpIndexStr.append( (*itLfirst).getWordBase() );
                                         }
                                     }
                                     TextItem* tI = new TextItem( nl, tmpIndexStr , canvas_graph );
                                     if( tI != NULL ){
                                         tI->show();
                                     }
                                     QPoint tmpPoint( -1, -1 );
                                     for( int index = 0 ; index < (int)positionArray.count() ; index++ ){
                                         if( keyIndex == positionArrayKey[index] ){
                                             tmpPoint.setX( positionArray[index].x() );
                                             tmpPoint.setY( positionArray[index].y() );
                                         }
                                     }
                                     if( tmpPoint.x() >= 0 ){
                                         nl->move( tmpPoint.x() , tmpPoint.y() );
                                     }else{
                                         nl->move(rand()%canvas_graph->width(),rand()%canvas_graph->height());
                                         //nl->move(canvas_graph->width()/2,canvas_graph->height()/2);
                                     }
                                     nl->show();

                                     conIndex = NodeNum;
                                     fstNodeArray[NodeNum] = nl;
                                     fstkeyArray[NodeNum] = conseq;
                                     NodeNum++;

                                 }

                             }

                             if( (antIndex0 != -1) && (antIndex1 != -1) && (conIndex != -1) ){
                                 FriendItem* fI = new FriendItem( fstNodeArray[antIndex0], fstNodeArray[antIndex1], fstNodeArray[conIndex] , canvas_graph );
                                 if( fI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     fI->show();
                                     EdgeItem* eI = new EdgeItem( fI, fstNodeArray[conIndex] , canvas_graph );
                                     if( eI != NULL ){
                                         //eI->setPen( QColor( 191, 191, 191 ) );
                                         //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                         eI->show();
                                         QString strSupport( "S=" );
                                         strSupport.append( QString::number( (*itAs).getSupport() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "C=" );
                                         strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "L=" );
                                         strSupport.append( QString::number( (*itAs).getLift() ) );
                                         TextItem* tI = new TextItem( eI, strSupport, canvas_graph );
                                         if( tI != NULL ){
                                             tI->show();
                                         }

                                     }

                                 }
                                 
                                 if( (*itAs).getSupport() > Smax )    Smax = (*itAs).getSupport();
                                 if( (*itAs).getConfidence() > Cmax ) Cmax = (*itAs).getConfidence();
                                 if( (*itAs).getLift() > Lmax )       Lmax = (*itAs).getLift();
                             }
                     }
                 }
             }
             //if( (*itAs).getSupport() > Smax )    Smax = (*itAs).getSupport();
             //if( (*itAs).getConfidence() > Cmax ) Cmax = (*itAs).getConfidence();
             //if( (*itAs).getLift() > Lmax )       Lmax = (*itAs).getLift();

        }
        
        if( NodeNum > keyMax )  NodeNum = keyMax;
        if( TRUE != NodeArray.resize(NodeNum)) return;
        if( TRUE != keyArray.resize(NodeNum) ) return;
        for( int tmpindex = 0 ; tmpindex < NodeNum ; tmpindex++ ){
            NodeArray[tmpindex] = fstNodeArray[tmpindex];
            keyArray[tmpindex]  = fstkeyArray[tmpindex];
        }
        
        sliderS->setValue( sliderS->maxValue() );
        sliderC->setValue( sliderC->maxValue() );
        sliderL->setValue( sliderL->maxValue() );
                
        //dirLabeS->setText( " S:"+slimitStr );
        //dirLabeC->setText( " C:"+climitStr );
        dirLabeS->setText( " S:0" );
        dirLabeC->setText( " C:0" );
        dirLabeL->setText( " L:0" );

    }
    
    canvas_graph->update();

}


/* graphDialog::~graphDialog()
{
    NodeArray.resize( 0 );
    keyArray.resize( 0 );
}*/


void graphDialog::accept()
{

    QDialog::accept();
}


void graphDialog::thresChanged()
{
        //if( TabWidget2->currentPageIndex() != 2 ){
        //    return;
        //}

        double Slimit = (double)(sliderS->maxValue()-sliderS->value())*(Smax-Smin) /
                        (double)(sliderS->maxValue()-sliderS->minValue())+Smin;
        double Climit = (double)(sliderC->maxValue()-sliderC->value())*(Cmax-Cmin) /
                        (double)(sliderC->maxValue()-sliderC->minValue())+Cmin;
        double Llimit = (double)(sliderL->maxValue()-sliderL->value())*(Lmax-Lmin) /
                        (double)(sliderL->maxValue()-sliderL->minValue())+Lmin;

        dirLabeS->setText( " S:"+QString::number( Slimit ) );
        dirLabeC->setText( " C:"+QString::number( Climit ) );
        dirLabeL->setText( " L:"+QString::number( Llimit ) );

        //int NodeCount = NodeNum;
        positionArray.resize( NodeArray.count() );
        positionArrayKey.resize( keyArray.count() );
        //for( int nodeIndex = 0 ; nodeIndex < NodeCount ; nodeIndex++ ){
        for( int nodeIndex = 0 ; nodeIndex < (int)NodeArray.count() ; nodeIndex++ ){
             if( NodeArray[nodeIndex] != NULL ){
                 QPoint position( (int)NodeArray[nodeIndex]->x() , (int)NodeArray[nodeIndex]->y() );
                 positionArray[nodeIndex] = position;
                 positionArrayKey[nodeIndex] = keyArray[nodeIndex];
             }
             else{
                 QPoint position( -1 , -1 );
                 positionArray[nodeIndex] = position;
                 positionArrayKey[nodeIndex] = -1;
             }
        }

        editor->clear();

        //for( int nodeIndex = 0 ; nodeIndex < NodeCount ; nodeIndex++ ){
        for( int nodeIndex = 0 ; nodeIndex <  (int)positionArrayKey.count() ; nodeIndex++ ){
            int kkkIndex = positionArrayKey[nodeIndex];
            QString kkkIndexStr = QString::number( kkkIndex );
            for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
                SooList::Iterator itLfirst = (*itLL).begin();
                int firstIndex = (*itLfirst).getIndex();
                if( kkkIndex == firstIndex ){
                    kkkIndexStr.append( " " );
                    kkkIndexStr.append( (*itLfirst).getWordBase() );
                }
            }
            NodeItem* nl = new NodeItem( canvas_graph );
            if( nl != NULL ){
                //(new TextItem( nl, keyStr , canvas_key ))->show();
                TextItem* tI = new TextItem( nl, kkkIndexStr , canvas_graph );
                if( tI != NULL ){
                                    tI->show();
                }
                //nl->setBrush( QColor( 191, 191, 191 ) );
                nl->move( positionArray[nodeIndex].x() , positionArray[nodeIndex].y() );
                //el->move( 100, 100 );
                nl->show();

                NodeArray[nodeIndex] = nl;
            }

        }

        for( AsRuleSooList::Iterator itAs = tmpAsList->begin(); itAs != tmpAsList->end(); ++itAs ){
             if( 1 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int conseq  = (*itAs).getConseq();
                 if( (antece0 == keyIndex) || (conseq == keyIndex) ){
                 if( antece0 != conseq ){
                     int antIndex = -1;
                     int conIndex = -1;
                     for( int tmpIndex = 0 ; tmpIndex < (int)positionArrayKey.count() ; tmpIndex++ ){
                         if( antece0 == positionArrayKey[tmpIndex] )   antIndex = tmpIndex;
                         if( conseq  == positionArrayKey[tmpIndex] )   conIndex = tmpIndex;
                     }
                     if( (antIndex != -1) && (conIndex != -1) ){
                         if(      (*itAs).getSupport() >= Slimit && 
                                  (*itAs).getConfidence() >= Climit &&
                                  (*itAs).getLift() >= Llimit          ){
                             EdgeItem* eI = new EdgeItem( NodeArray[antIndex], NodeArray[conIndex] , canvas_graph );
                             if( eI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     eI->show();
                             }
                             QString strSupport( "S=" );
                             strSupport.append( QString::number( (*itAs).getSupport() ) );
                             strSupport.append( "\n" );
                             strSupport.append( "C=" );
                             strSupport.append( QString::number( (*itAs).getConfidence() ) );
                             strSupport.append( "\n" );
                             strSupport.append( "L=" );
                             strSupport.append( QString::number( (*itAs).getLift() ) );
                             TextItem* tI = new TextItem( eI, strSupport, canvas_graph );
                             if( tI != NULL ){
                                     tI->show();
                             }
                         }
                     }
                 }
                 }
             }
             if( 2 == (*itAs).getAntCount() ){
                 int antece0 = (*itAs).getAntece0();
                 int antece1 = (*itAs).getAntece1();
                 int conseq  = (*itAs).getConseq();
                 if( (antece0 == keyIndex) || (antece1 == keyIndex) || (conseq == keyIndex) ){
                 if( (antece0 != conseq) && (antece1 != conseq) && (antece0 != antece1) ){
                     int antIndex0 = -1;
                     int antIndex1 = -1;
                     int conIndex = -1;
                     for( int tmpIndex = 0 ; tmpIndex < (int)positionArrayKey.count() ; tmpIndex++ ){
                         if( antece0 == positionArrayKey[tmpIndex] )   antIndex0 = tmpIndex;
                         if( antece1 == positionArrayKey[tmpIndex] )   antIndex1 = tmpIndex;
                         if( conseq  == positionArrayKey[tmpIndex] )   conIndex = tmpIndex;
                     }
                     if( (antIndex0 != -1) && (antIndex1 != -1) && (conIndex != -1) ){
                         if(      (*itAs).getSupport() >= Slimit && 
                                  (*itAs).getConfidence() >= Climit &&
                                  (*itAs).getLift() >= Llimit          ){
                             FriendItem* fI = new FriendItem( NodeArray[antIndex0], NodeArray[antIndex1], NodeArray[conIndex] , canvas_graph );
                             if( fI != NULL ){
                                     //eI->setPen( QColor( 191, 191, 191 ) );
                                     //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                     fI->show();
                                     EdgeItem* eI = new EdgeItem( fI, NodeArray[conIndex] , canvas_graph );
                                     if( eI != NULL ){
                                         //eI->setPen( QColor( 191, 191, 191 ) );
                                         //eI->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
                                         eI->show();
                                         QString strSupport( "S=" );
                                         strSupport.append( QString::number( (*itAs).getSupport() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "C=" );
                                         strSupport.append( QString::number( (*itAs).getConfidence() ) );
                                         strSupport.append( "\n" );
                                         strSupport.append( "L=" );
                                         strSupport.append( QString::number( (*itAs).getLift() ) );
                                         TextItem* tI = new TextItem( eI, strSupport, canvas_graph );
                                         if( tI != NULL ){
                                             tI->show();
                                         }

                                     }

                             }
                         
                         }
                     }
                 }
                 }
             }

        }
        for( int index = 0 ; index < (int)NodeArray.count() ; index++ ){
        //for( int index = 0 ; index < NodeCount ; index++ ){
            NodeArray[index]->checkConnect4color();
        }

        canvas_graph->update();
}

void graphDialog::thresDispS( int value )
{
        //if( TabWidget2->currentPageIndex() != 2 ){
        //    return;
        //}
        
        double Slimit = (double)(sliderS->maxValue()-value)*(Smax-Smin) /
                        (double)(sliderS->maxValue()-sliderS->minValue())+Smin;

        dirLabeS->setText( " S:"+QString::number( Slimit ) );

}

void graphDialog::thresDispC( int value )
{
        //if( TabWidget2->currentPageIndex() != 2 ){
        //    return;
        //}
        
        double Climit = (double)(sliderC->maxValue()-value)*(Cmax-Cmin) /
                        (double)(sliderC->maxValue()-sliderC->minValue())+Cmin;

        dirLabeC->setText( " C:"+QString::number( Climit ) );

}

void graphDialog::thresDispL( int value )
{
        //if( TabWidget2->currentPageIndex() != 2 ){
        //    return;
        //}
        
        double Llimit = (double)(sliderL->maxValue()-value)*(Lmax-Lmin) /
                        (double)(sliderL->maxValue()-sliderL->minValue())+Lmin;

        dirLabeL->setText( " L:"+QString::number( Llimit ) );

}

