 
#ifndef CANVAS_H
#define CANVAS_H
/**********************************************************************

  canvas.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
**********************************************************************/
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qintdict.h>
#include <qcanvas.h>
#include <qstring.h>
#include <qpoint.h>
#include <qptrlist.h>
#include "asrulelist.h"
#include "soolist.h"

class TextItem;
class EdgeItem;
class NodeItem;
class FriendItem;

class TextItem: public QCanvasText
{
public:
    TextItem( NodeItem*, const QString & t , QCanvas *canvas );
    TextItem( EdgeItem*, const QString & t , QCanvas *canvas );
    static int count() { return c; }
private:
    static int c;
};

class QCanvasLineDT: public QCanvasLine
{
public:
    void moveBy(double dx, double dy);
    QCanvasLineDT( QCanvas *canvas );
private:
};
class QCanvasEllipseDT: public QCanvasEllipse
{
public:
    //void moveBy(double dx, double dy);
    QCanvasEllipseDT( int sx,int sy, QCanvas *canvas );
private:
};

class EdgeItem: public QCanvasLine
{
public:
    EdgeItem( NodeItem*, NodeItem*, QCanvas *canvas );
    EdgeItem( FriendItem*, NodeItem*, QCanvas *canvas );
    void addText( TextItem *tttt ) { textList.append( tttt ); }
    void setFromPoint( int x, int y ) ;
    void setToPoint( int x, int y );
    static int count() { return c; }
    void moveBy(double dx, double dy);
private:
    static int c;
    QPtrList<TextItem> textList;
    QCanvasLineDT* motoLine;
    QCanvasLineDT* sakiLine;
};
class FriendItem: public QCanvasLine
{
public:
    FriendItem( NodeItem*, NodeItem*, NodeItem*, QCanvas *canvas );
    FriendItem( NodeItem*, NodeItem*, NodeItem*, NodeItem*, QCanvas *canvas );
    void addOutEdge( EdgeItem *edge ) { outList.append( edge ); }
    void setTotalPos();
    void moveBy(double dx, double dy);
    int x()  { return (int)(motoCen->x()); }
    int y()  { return (int)(motoCen->y()); }
    
private:
    static int c;
    int        countS;
    //QPtrList<TextItem> textList;
    QCanvasLineDT* motoLine1;
    QCanvasLineDT* motoLine2;
    QCanvasLineDT* motoLine3;
    NodeItem*    cmoto1;
    NodeItem*    cmoto2;
    NodeItem*    cmoto3;
    NodeItem*    csaki;
    QCanvasEllipseDT* motoCen;
    
    QPtrList<EdgeItem> outList;
};

class NodeItem: public QCanvasEllipse
{
public:
    NodeItem( QCanvas *canvas );
    ~NodeItem() {}
    void addText( TextItem *tttt ) { textList.append( tttt ); }
    void addFriend( FriendItem *ffff ) { friendList.append( ffff ); }
    void addInEdge( EdgeItem *edge ) { inList.append( edge ); }
    void addOutEdge( EdgeItem *edge ) { outList.append( edge ); }
    void moveBy(double dx, double dy);
    void checkConnect4color();
    void checkConnect4pos( int canvasYsize );
private:
    QPtrList<TextItem> textList;
    QPtrList<EdgeItem> inList;
    QPtrList<EdgeItem> outList;
    QPtrList<FriendItem> friendList;
};


class FigureEditor : public QCanvasView {
    Q_OBJECT
public:
    //FigureEditor(QCanvas&, QWidget* parent=0, const char* name=0, WFlags f=0);
    FigureEditor( QMemArray<NodeItem*>*, QMemArray<int>*,
                  SooListList*, AsRuleSooList*, 
                  QCanvas&, QWidget* parent=0, const char* name=0, WFlags f=0);
    void clear();
protected:
    void contentsMousePressEvent(QMouseEvent*);
    void contentsMouseMoveEvent(QMouseEvent*);
    void contentsContextMenuEvent( QContextMenuEvent *e );
signals:
    void status(const QString&);
private:
    QCanvasItem* moving;
    QPoint moving_start;
    
    QPopupMenu *optionsMenu;
    
    SooListList* tmpSooListList;
    AsRuleSooList* tmpAsList;
    QMemArray<NodeItem*>* tmpNodeArray;
    QMemArray<int>*       tmpkeyArray;

    QPoint tmpPoint;

private slots:
    void menuMoreInfo();
    void menuCutGraph();

};

#endif

