
/**********************************************************************

  canvas.cpp

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qaction.h>
#include <qtextcodec.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qmainwindow.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qmenubar.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpoint.h>
#include <qlabel.h>
#include <qimage.h>
#include <qprogressdialog.h>
#include <qstring.h>
#include <qcolor.h>
#include <qpopupmenu.h>
#include <qptrlist.h>
#include "canvas.h"
#include "tabledialog.h"
#include "graphdialog.h"
#include "asrulelist.h"
#include "soolist.h"
#include <stdlib.h>
#include <math.h>

//static QBrush* tb = new QBrush( Qt::yellow );
//static QPen*   tp = new QPen( Qt::black );
//static QPen*   tp = new QPen( QColor( 127, 127, 127 ) );


QPoint calMidPoint( double sx , double sy , double ex , double ey )
{
    double x1_3 = (ex*2.0 + sx*1.0) / 3.0;
    double y1_3 = (ey*2.0 + sy*1.0) / 3.0;
    double vx = ex - sx;
    double vy = ey - sy; vy = -1.0 * vy;
    double mainDist  = sqrt( vx*vx + vy*vy );
    double subDist   = mainDist / 24.0;
    double mainAngle = atan2( vy, vx );
    double subAngle  = mainAngle - (M_PI/2.0);
    double subVx = subDist * cos( subAngle );
    double subVy = subDist * sin( subAngle );
    int cenx = (int)(x1_3 + subVx);
    int ceny = (int)(y1_3 - subVy);

    return QPoint( cenx , ceny );
}


static const int imageRTTI = 984376;
class ImageItem: public QCanvasRectangle
{
public:
    ImageItem( QImage img, QCanvas *canvas );
    int rtti () const { return imageRTTI; }
    bool hit( const QPoint&) const;
protected:
    void drawShape( QPainter & );
private:
    QImage image;
    QPixmap pixmap;
};
ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );
#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
}
void ImageItem::drawShape( QPainter &p )
{
// Qt/Embedded Ǥϡ® QPixmap Ȥ QImage 褹뤳ȤǤ롣
// ¾ΥץåȥեǤ QPixmap Ȥɬפ
#if defined(Q_WS_QWS)
    p.drawImage( int(x()), int(y()), image, 0, 0, -1, -1, OrderedAlphaDither );
#else
    p.drawPixmap( int(x()), int(y()), pixmap );
#endif
}
bool ImageItem::hit( const QPoint &p ) const
{
    int ix = p.x()-int(x());
    int iy = p.y()-int(y());
    if ( !image.valid( ix , iy ) )
        return FALSE;
    QRgb pixel = image.pixel( ix, iy );
    return qAlpha( pixel ) != 0;
}



int TextItem::c = 0;
//void TextItem::moveBy(double , double )
//{
//    //⤷ʤ
//    //QCanvasText::move( dx , dy );
//}
TextItem::TextItem( NodeItem *node, const QString & t , QCanvas *canvas )
    : QCanvasText( t , canvas )
{
    c++;
    QColor selectColor( 0, 63, 255 );
    setColor( selectColor );
    node->addText( this );
    setX( double(node->x()) );
    setY( double(node->y()) );
    //move( double(node->x()) , double(node->y()) );
    setZ( 129 );
}
TextItem::TextItem( EdgeItem *eeee, const QString & t , QCanvas *canvas )
    : QCanvasText( t , canvas )
{
    c++;
    QColor selectColor( 0, 191, 0 );
    setColor( selectColor );
    eeee->addText( this );
    QPoint midPoint = calMidPoint( eeee->startPoint().x() , eeee->startPoint().y() ,
                                   eeee->endPoint().x() ,   eeee->endPoint().y()     );
    setX( (double)midPoint.x() );
    setY( (double)midPoint.y() );
    //move( double(node->x()) , double(node->y()) );
    setZ( 129 );
}

void QCanvasLineDT::moveBy(double, double)
{
    //⤷ʤ
}
QCanvasLineDT::QCanvasLineDT( QCanvas *canvas )
    : QCanvasLine( canvas )
{
}
//void QCanvasEllipseDT::moveBy(double, double)
//{
//    //⤷ʤ
//}
QCanvasEllipseDT::QCanvasEllipseDT( int sx , int sy, QCanvas *canvas )
    : QCanvasEllipse( sx, sy,canvas )
{
}

int EdgeItem::c = 0;
void EdgeItem::moveBy(double, double)
{
    //⤷ʤ
}
EdgeItem::EdgeItem( NodeItem *from, NodeItem *to, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    //setPen( *tp );
    setPen( QPen( QColor( 255, 255, 255 ) , (uint)0 ) );
    setBrush( QBrush( Qt::black ) );
    from->addOutEdge( this );
    to->addInEdge( this );
    setPoints( int(from->x()), int(from->y()), int(to->x()), int(to->y()) );
    setZ( 120 );

    QPoint midPoint = calMidPoint( from->x() , from->y() ,
                                   to->x()   , to->y()     );
    motoLine = new QCanvasLineDT( canvas );
    if( motoLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        motoLine->setPoints ( int(from->x()), int(from->y()), midPoint.x(), midPoint.y() );
        motoLine->setZ( 127 );
        motoLine->show();
    }
    sakiLine = new QCanvasLineDT( canvas );
    if( sakiLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        sakiLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        sakiLine->setPoints ( midPoint.x(), midPoint.y(), int(to->x()), int(to->y()) );
        sakiLine->setZ( 127 );
        sakiLine->show();
    }

}
EdgeItem::EdgeItem( FriendItem *from, NodeItem *to, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    //setPen( *tp );
    setPen( QPen( QColor( 255, 255, 255 ) , (uint)0 ) );
    setBrush( QBrush( Qt::black ) );
    from->addOutEdge( this );
    to->addInEdge( this );
    setPoints( int(from->x()), int(from->y()), int(to->x()), int(to->y()) );
    setZ( 120 );

    QPoint midPoint = calMidPoint( from->x() , from->y() ,
                                   to->x()   , to->y()     );
    motoLine = new QCanvasLineDT( canvas );
    if( motoLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        motoLine->setPoints ( int(from->x()), int(from->y()), midPoint.x(), midPoint.y() );
        motoLine->setZ( 127 );
        motoLine->show();
    }
    sakiLine = new QCanvasLineDT( canvas );
    if( sakiLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        sakiLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        sakiLine->setPoints ( midPoint.x(), midPoint.y(), int(to->x()), int(to->y()) );
        sakiLine->setZ( 127 );
        sakiLine->show();
    }

}
void EdgeItem::setFromPoint( int x, int y )
{
    QPoint midPoint = calMidPoint( x , y , endPoint().x() , endPoint().y() );

    setPoints( x,y, endPoint().x(), endPoint().y() );
    QPtrListIterator<TextItem> itT( textList );
    TextItem *tttt;
    while (( tttt = itT.current() )) {
        ++itT;
        tttt->setX( (double)midPoint.x() );
	tttt->setY( (double)midPoint.y() );
    }

    if( motoLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        //motoLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        motoLine->setPoints ( x, y, midPoint.x(), midPoint.y() );
        //motoLine->show();
    }
    if( sakiLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        //sakiLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        sakiLine->setPoints ( midPoint.x(), midPoint.y(), endPoint().x(), endPoint().y() );
        //sakiLine->show();
    }

}
void EdgeItem::setToPoint( int x, int y )
{
    QPoint midPoint = calMidPoint( startPoint().x() , startPoint().y() , x , y );

    setPoints( startPoint().x(), startPoint().y(), x, y );
    QPtrListIterator<TextItem> itT( textList );
    TextItem *tttt;
    while (( tttt = itT.current() )) {
        ++itT;
        tttt->setX( (double)midPoint.x() );
	tttt->setY( (double)midPoint.y() );
    }

    if( motoLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        //motoLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        motoLine->setPoints ( startPoint().x(), startPoint().y(), midPoint.x(), midPoint.y() );
        //motoLine->show();
    }
    if( sakiLine != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        //sakiLine->setPen( QPen( QColor( 127, 127, 127 ) , (uint)0 ) );
        sakiLine->setPoints ( midPoint.x(), midPoint.y(), x, y );
        //sakiLine->show();
    }

}
int FriendItem::c = 0;
void FriendItem::moveBy(double, double)
{
    //
}
void FriendItem::setTotalPos()
{
    if( countS == 2 ){
        if( (cmoto1 != NULL) && (cmoto2 != NULL) && (csaki != NULL) ){
            int motoCenx = (((int)(cmoto1->x()+cmoto2->x()) / 2)*9 + (int)(csaki->x())*1 ) /10;
            int motoCeny = (((int)(cmoto1->y()+cmoto2->y()) / 2)*9 + (int)(csaki->y())*1 ) /10;
            if( motoLine1 != NULL ){
                motoLine1->setPoints ( int(cmoto1->x()), int(cmoto1->y()), motoCenx, motoCeny );
            }
            if( motoLine2 != NULL ){
                motoLine2->setPoints ( int(cmoto2->x()), int(cmoto2->y()), motoCenx, motoCeny );
            }
            if( motoCen != NULL ){
                motoCen->move ( motoCenx, motoCeny );
            }
        }
        QPtrListIterator<EdgeItem> it2( outList );
        EdgeItem *edge;
        while (( edge = it2.current() )) {
            ++it2;
            edge->setFromPoint( int(x()), int(y()) );
        }
    }
    if( countS == 3 ){
        if( (cmoto1 != NULL) && (cmoto2 != NULL) && (cmoto3 != NULL) && (csaki != NULL) ){
            int motoCenx = (((int)(cmoto1->x()+cmoto2->x()+cmoto3->x()) / 3)*9 + (int)(csaki->x())*1 ) /10;
            int motoCeny = (((int)(cmoto1->y()+cmoto2->y()+cmoto3->y()) / 3)*9 + (int)(csaki->y())*1 ) /10;
            if( motoLine1 != NULL ){
                motoLine1->setPoints ( int(cmoto1->x()), int(cmoto1->y()), motoCenx, motoCeny );
            }
            if( motoLine2 != NULL ){
                motoLine2->setPoints ( int(cmoto2->x()), int(cmoto2->y()), motoCenx, motoCeny );
            }
            if( motoLine3 != NULL ){
                motoLine3->setPoints ( int(cmoto3->x()), int(cmoto3->y()), motoCenx, motoCeny );
            }
            if( motoCen != NULL ){
                motoCen->move ( motoCenx, motoCeny );
            }
        }
        QPtrListIterator<EdgeItem> it2( outList );
        EdgeItem *edge;
        while (( edge = it2.current() )) {
            ++it2;
            edge->setFromPoint( int(x()), int(y()) );
        }
    }
}
FriendItem::FriendItem( NodeItem *moto1, NodeItem *moto2, NodeItem *saki, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    countS = 2;
    //setPen( *tp );
    setPen( QPen( QColor( 255, 255, 255 ) , (uint)0 ) );
    setBrush( QBrush( Qt::black ) );
    //from->addOutEdge( this );
    moto1->addFriend( this );
    moto2->addFriend( this );
    saki->addFriend( this );
    setPoints( int(moto1->x()), int(moto1->y()), int(moto2->x()), int(moto2->y()) );
    setZ( 120 );

    cmoto1 = moto1;
    cmoto2 = moto2;
    cmoto3 = NULL;
    csaki  = saki;
    int motoCenx = (((int)(cmoto1->x()+cmoto2->x()) / 2)*9 + (int)(csaki->x())*1 ) /10;
    int motoCeny = (((int)(cmoto1->y()+cmoto2->y()) / 2)*9 + (int)(csaki->y())*1 ) /10;

    motoLine1 = new QCanvasLineDT( canvas );
    if( motoLine1 != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine1->setPen( QPen( QColor( 223, 223, 223 ) , (uint)5 ) );
        motoLine1->setPoints ( int(cmoto1->x()), int(cmoto1->y()), motoCenx, motoCeny );
        motoLine1->setZ( 126 );
        motoLine1->show();
    }
    motoLine2 = new QCanvasLineDT( canvas );
    if( motoLine2 != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine2->setPen( QPen( QColor( 223, 223, 223 ) , (uint)5 ) );
        motoLine2->setPoints ( int(cmoto2->x()), int(cmoto2->y()), motoCenx, motoCeny );
        motoLine2->setZ( 126 );
        motoLine2->show();
    }
    motoCen = new QCanvasEllipseDT( 10, 10, canvas );
    if( motoCen != NULL ){
        motoCen->setBrush( QColor( 223, 223, 223 ) );
        motoCen->move ( motoCenx, motoCeny );
        motoCen->setZ( 126 );
        motoCen->show();
    }
}
FriendItem::FriendItem( NodeItem *moto1, NodeItem *moto2, NodeItem *moto3, NodeItem *saki, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    countS = 3;
    //setPen( *tp );
    setPen( QPen( QColor( 255, 255, 255 ) , (uint)0 ) );
    setBrush( QBrush( Qt::black ) );
    //from->addOutEdge( this );
    moto1->addFriend( this );
    moto2->addFriend( this );
    moto3->addFriend( this );
    saki->addFriend( this );
    setPoints( int(moto1->x()), int(moto1->y()), int(moto2->x()), int(moto2->y()) );
    setZ( 120 );

    cmoto1 = moto1;
    cmoto2 = moto2;
    cmoto3 = moto3;
    csaki  = saki;
    int motoCenx = (((int)(cmoto1->x()+cmoto2->x()+cmoto3->x()) / 3)*9 + (int)(csaki->x())*1 ) /10;
    int motoCeny = (((int)(cmoto1->y()+cmoto2->y()+cmoto3->x()) / 3)*9 + (int)(csaki->y())*1 ) /10;

    motoLine1 = new QCanvasLineDT( canvas );
    if( motoLine1 != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine1->setPen( QPen( QColor( 223, 223, 223 ) , (uint)5 ) );
        motoLine1->setPoints ( int(cmoto1->x()), int(cmoto1->y()), motoCenx, motoCeny );
        motoLine1->setZ( 126 );
        motoLine1->show();
    }
    motoLine2 = new QCanvasLineDT( canvas );
    if( motoLine2 != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine2->setPen( QPen( QColor( 223, 223, 223 ) , (uint)5 ) );
        motoLine2->setPoints ( int(cmoto2->x()), int(cmoto2->y()), motoCenx, motoCeny );
        motoLine2->setZ( 126 );
        motoLine2->show();
    }
    motoLine3 = new QCanvasLineDT( canvas );
    if( motoLine3 != NULL ){
        //eI->setPen( QColor( 191, 191, 191 ) );
        motoLine3->setPen( QPen( QColor( 223, 223, 223 ) , (uint)5 ) );
        motoLine3->setPoints ( int(cmoto3->x()), int(cmoto3->y()), motoCenx, motoCeny );
        motoLine3->setZ( 126 );
        motoLine3->show();
    }
    motoCen = new QCanvasEllipseDT( 10, 10, canvas );
    if( motoCen != NULL ){
        motoCen->setBrush( QColor( 223, 223, 223 ) );
        motoCen->move ( motoCenx, motoCeny );
        motoCen->setZ( 126 );
        motoCen->show();
    }
}

void NodeItem::moveBy(double dx, double dy)
{
    QCanvasEllipse::moveBy( dx, dy );
    
    QPtrListIterator<TextItem> itT( textList );
    TextItem *tttt;
    while (( tttt = itT.current() )) {
        ++itT;
        tttt->setX( double(x()) );
	tttt->setY( double(y()) );
    }
    
    QPtrListIterator<EdgeItem> it1( inList );
    EdgeItem *edge;
    while (( edge = it1.current() )) {
        ++it1;
        edge->setToPoint( int(x()), int(y()) );
    }
    QPtrListIterator<EdgeItem> it2( outList );
    while (( edge = it2.current() )) {
        ++it2;
        edge->setFromPoint( int(x()), int(y()) );
    }
    QPtrListIterator<FriendItem> itF( friendList );
    FriendItem *ffff;
    while (( ffff = itF.current() )) {
        ++itF;
        ffff->setTotalPos();
    }
}
void NodeItem::checkConnect4color()
{
    //QPtrListIterator<EdgeItem> it1( inList );
    //QPtrListIterator<EdgeItem> it2( outList );
    //QPtrListIterator<FriendItem> itF( friendList );
    //if( it1.count()==0 && it2.count()==0 && itF.count()==0 )   setBrush( QColor( 239, 239, 239 ) );
    //if( it1.count()==0 && it2.count()==0 && itF.count()==0 )   ;
    if( inList.count()==0 && outList.count()==0 && friendList.count()==0 )   setBrush( QColor( 239, 239, 239 ) );
}
void NodeItem::checkConnect4pos( int canvasYsize )
{
    //QPtrListIterator<EdgeItem> it1( inList );
    //QPtrListIterator<EdgeItem> it2( outList );
    //QPtrListIterator<FriendItem> itF( friendList );
    //if( it1.count()==0 && it2.count()==0 && itF.count()==0 )   move( 20, rand()%canvasYsize);
    if( inList.count()==0 && outList.count()==0 && friendList.count()==0 )   move( 20, rand()%canvasYsize);
}
NodeItem::NodeItem( QCanvas *canvas )
    : QCanvasEllipse( 40, 40, canvas )
{
    setPen( Qt::black );
    setBrush( QColor( 191, 191, 191 ) );
    //setBrush( *tb );
    setZ( 128 );

    //textList.clear();
    //inList.clear();
    //outList.claer();
    //friendList.clear();
}
//FigureEditor::FigureEditor(
//        QCanvas& c, QWidget* parent,
//        const char* name, WFlags f) :
//    QCanvasView(&c,parent,name,f)
FigureEditor::FigureEditor(
        QMemArray<NodeItem*>* pNodeArray, QMemArray<int>* pkeyArray, 
        SooListList* psoolistlist, AsRuleSooList* paslist,
        QCanvas& c, QWidget* parent,
        const char* name, WFlags f) :
    QCanvasView(&c,parent,name,f)
{

    QTextCodec* codec = QTextCodec::codecForName("eucJP");

    QAction *optionsMoreInfo;
    //optionsMoreInfo = new QAction(
    //        "More Info",
    //        "More &Info...", CTRL+Key_M, this, "More Info" );
    optionsMoreInfo = new QAction(
            codec->toUnicode("ܺ") , codec->toUnicode("ܺ..."),
            CTRL+Key_M, this, "More Info" );
    connect( optionsMoreInfo, SIGNAL( activated() ),
             this, SLOT( menuMoreInfo() ) );
    
    QAction *optionsCutGraph;
    //optionsCutGraph = new QAction(
    //        "Cut Graph",
    //        "Cut &Graph...", CTRL+Key_C, this, "Cut Graph" );
    optionsCutGraph = new QAction(
            codec->toUnicode("ڽ") , codec->toUnicode("ڽ..."),
            CTRL+Key_C, this, "Cut Graph" );
    connect( optionsCutGraph, SIGNAL( activated() ),
             this, SLOT( menuCutGraph() ) );

    optionsMenu = new QPopupMenu( this );
    optionsMoreInfo->addTo( optionsMenu );
    optionsCutGraph->addTo( optionsMenu );
    
    tmpSooListList = psoolistlist;
    tmpAsList      = paslist;
    tmpNodeArray   = pNodeArray;
    tmpkeyArray    = pkeyArray;

}
void FigureEditor::contentsMousePressEvent(QMouseEvent* e)
{
    QPoint p = inverseWorldMatrix().map(e->pos());
    QCanvasItemList l=canvas()->collisions(p);
    for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
        if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item= (ImageItem*)(*it);
            if ( !item->hit( p ) )
                 continue;
        }
        moving = *it;
        moving_start = p;
        return;
    }
    moving = 0;
}
void FigureEditor::clear()
{
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }
}
void FigureEditor::contentsMouseMoveEvent(QMouseEvent* e)
{
    if ( moving ) {
        QPoint p = inverseWorldMatrix().map(e->pos());
        moving->moveBy(p.x() - moving_start.x(),
                       p.y() - moving_start.y());
        moving_start = p;
        canvas()->update();
    }
}
void FigureEditor::contentsContextMenuEvent( QContextMenuEvent * )
{
    tmpPoint = QCursor::pos();
    optionsMenu->exec( tmpPoint );
}
void FigureEditor::menuMoreInfo()
{
    QPoint tmpLocalPoint = this->mapFromGlobal( tmpPoint );

    int nearIndex = -1;
    for( int index = 0 ; index < (int)tmpNodeArray->count() ; index++ ){
        double xdif = (*tmpNodeArray)[index]->x() - (double)tmpLocalPoint.x();
        double ydif = (*tmpNodeArray)[index]->y() - (double)tmpLocalPoint.y();
        double dist = sqrt( xdif*xdif + ydif*ydif );
        if( (*tmpNodeArray)[index]->width() > (int)dist )     nearIndex = index;
    }
    if( nearIndex == -1 ) return;

    bool sit = FALSE;
    SooListList::Iterator itLLsave;
    for( SooListList::Iterator itLL = tmpSooListList->begin(); itLL != tmpSooListList->end(); ++itLL ){
         SooList::Iterator itL = (*itLL).begin();
         if( (*itL).getIndex() == (*tmpkeyArray)[nearIndex] ){
             itLLsave = itLL;
             sit = TRUE;
         }
    }
    if( sit == FALSE ) return;
    
    tableDialog* tableD = new tableDialog( (*itLLsave) , tmpSooListList , tmpAsList , this );
    if( tableD != NULL ){
        tableD->show();
    }


}
void FigureEditor::menuCutGraph()
{
    QPoint tmpLocalPoint = this->mapFromGlobal( tmpPoint );

    int nearIndex = -1;
    for( int index = 0 ; index < (int)tmpNodeArray->count() ; index++ ){
        double xdif = (*tmpNodeArray)[index]->x() - (double)tmpLocalPoint.x();
        double ydif = (*tmpNodeArray)[index]->y() - (double)tmpLocalPoint.y();
        double dist = sqrt( xdif*xdif + ydif*ydif );
        if( (*tmpNodeArray)[index]->width() > (int)dist )     nearIndex = index;
    }

    //nearIndex = 0;
    if( nearIndex >= 0 ){   
        graphDialog *graphD = new graphDialog( (*tmpkeyArray)[nearIndex],
                                               tmpSooListList , tmpAsList , this );
        graphD->show();
    }
}
