
#ifndef ASRULELIST_H
#define ASRULELIST_H
/**********************************************************************

  asrulelist.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qstring.h>

 
// for AsRuleSoo hold
class AsRuleSoo
{
public:
        AsRuleSoo(){  }
        AsRuleSoo( uint antCount,
                   int antece0,    int antece1,       int antece2,
                   int conseq,     int itemsize,      int anteceCnt,
                   int conseqCnt,  int conseqTot,     int totalCnt,
                   double support, double confidence, double lift
                 )
             {
               antCount_ = antCount   ;
               antece0_ = antece0     ; antece1_ = antece1       ; antece2_ = antece2     ;
               conseq_  = conseq      ; itemsize_ = itemsize     ; anteceCnt_ = anteceCnt ;
               conseqCnt_ = conseqCnt ; conseqTot_ = conseqTot   ; totalCnt_  = totalCnt  ;
               support_ = support     ; confidence_ = confidence ; lift_ = lift           ;
             }

        uint         getAntCount()                { return antCount_;     }

        int         getAntece0()                  { return antece0_;      }
        int         getAntece1()                  { return antece1_;      }
        int         getAntece2()                  { return antece2_;      }

        int         getConseq()                   { return conseq_;       }
        int         getItemsize()                 { return itemsize_;     }
        int         getAnteceCnt()                { return anteceCnt_;    }
        
        int         getConseqCnt()                { return conseqCnt_;    }
        int         getConseqTot()                { return conseqTot_;    }
        int         getTotalCnt()                 { return totalCnt_;     }

        double      getSupport()                  { return support_;      }
        double      getConfidence()               { return confidence_;   }
        double      getLift()                     { return lift_;         }

private:
        uint        antCount_;
        int         antece0_;
        int         antece1_;
        int         antece2_;
        int         conseq_;
        int         itemsize_;
        int         anteceCnt_;
        int         conseqCnt_;
        int         conseqTot_;
        int         totalCnt_;
        double      support_;
        double      confidence_;
        double      lift_;

};


typedef QValueList<AsRuleSoo>     AsRuleSooList;


#endif
