/*
 * stdlib.h
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef stdlib_h
#define stdlib_h


#include<sys/types.h>


enum{
	EXIT_SUCCESS=0,
	EXIT_FAILURE,

	RAND_MAX,
	MB_CUR_MAX,
};


/* Returned by the div() function.  */
typedef struct{
	int quot;			/* Quotient.  */
	int rem;			/* Remainder.  */
}div_t;

/* Returned by the ldiv() function.  */
typedef struct{
    long int quot;
    long int rem;
}ldiv_t;

/* Returned by the lldiv() function.  */
typedef struct{
    long long int quot;
    long long int rem;
}lldiv_t;


/* Function declarations. */
extern int           atoi(const char *);
extern void          exit(int) __attribute__ ((__noreturn__));
extern void          free(void *);
extern void         *malloc(size_t);

/* ̤ */
extern void          _Exit(int);
extern void          abort(void);
extern int           abs(int);
extern int           atexit(void (*)(void));
extern double        atof(const char *);
extern long          atol(const char *);
extern long long     atoll(const char *);
extern void         *bsearch(const void *, const void *, size_t, size_t,int (*)(const void *, const void *));
extern void         *calloc(size_t, size_t);
extern div_t         div(int, int);
extern char         *getenv(const char *);
extern long          labs(long);
extern ldiv_t        ldiv(long, long);
extern long long     llabs(long long);
extern lldiv_t       lldiv(long long, long long);
extern int           mblen(const char *, size_t);
extern size_t        mbstowcs(wchar_t *, const char *, size_t);
extern int           mbtowc(wchar_t *, const char *, size_t);
extern void          qsort(void *, size_t, size_t, int (*)(const void *,const void *));
extern int           rand(void);
extern void         *realloc(void *, size_t);
extern void          srand(unsigned);
extern double        strtod(const char *, char **);
extern float         strtof(const char *, char **);
extern long          strtol(const char *, char **, int);
extern long double   strtold(const char *, char **);
extern long long     strtoll(const char *, char **, int);
extern unsigned long strtoul(const char *, char **, int);
extern unsigned long long strtoull(const char *, char **, int);
extern int           system(const char *);
extern size_t        wcstombs(char *, const wchar_t *, size_t);
extern int           wctomb(char *, wchar_t);


#endif
