/*
 * stdio.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<string.h>
#include<stdio.h>


/***************************************************************************
 *
 * ʸϴؿ
 *
 ***************************************************************************/

typedef int (*TRANSFER)(const char*,int,char*,int);


/*
 * PRIVATE
 * ʸɸϤ롣
 * parameters : string,string size,baffer,buffer size
 */
static int transferStdout(const char *str,int size,char *buf,int buf_size)
{
	if(size>0)return write(STDOUT_FILENO,str,size);
	else return 0;
}


/*
 * PRIVATE
 * ʸѴƥХåե롣
 * Ѵ%d,%u,%x,%sˤб
 * parameters : string,argument address,transfer function
 * return : input size
 */
static int inputString(const char *str,char *buf,int buf_size,uint *arg,TRANSFER transfer)
{
	enum{BUF_SIZE=16};

	char temp[BUF_SIZE];
	int crt_pos=0;
	int ivalue;
	uint uvalue;
	int i,j,begin,rest;


	for(i=begin=0;str[i]!='\0';++i)
	{
		if(str[i]=='%')
		{
			if((rest=transfer(&str[begin],i-begin,&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
			crt_pos+=rest;

			switch(str[++i])
			{
				case 'd':							/* Ѵ */
					ivalue=*arg++;
					j=BUF_SIZE-1;
					if(ivalue>=0)
						for(;;--j)
						{
							temp[j]=ivalue%10+'0';
							if(!(ivalue/=10))break;
						}
					else
					{
						for(;;--j)
						{
							temp[j]=(ivalue%10)*-1+'0';
							if(!(ivalue/=10))break;
						}
						temp[--j]='-';
					}
					if((rest=transfer(&temp[j],BUF_SIZE-j,&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
					crt_pos+=rest;
					begin=i+1;
					break;
				case 'u':							/* ̵Ѵ */
					uvalue=*arg++;
					j=BUF_SIZE-1;
					for(;;--j)
					{
						temp[j]=uvalue%10+'0';
						if(!(uvalue/=10))break;
					}
					if((rest=transfer(&temp[j],BUF_SIZE-j,&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
					crt_pos+=rest;
					begin=i+1;
					break;
				case 'x':							/* 16ʿѴ */
					uvalue=*arg++;
					j=BUF_SIZE-1;
					for(;;--j)
					{
						temp[j]=uvalue%16+'0';
						if(temp[j]>'9')temp[j]+='a'-'9'-1;
						if(!(uvalue/=16))break;
					}
					if((rest=transfer(&temp[j],BUF_SIZE-j,&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
					crt_pos+=rest;
					begin=i+1;
					break;
				case 's':							/* ʸɽ */
					if((rest=transfer((char*)*arg,strlen((char*)*arg),&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
					crt_pos+=rest;
					++arg;
					begin=i+1;
					break;
				case '%':
					begin=i;
					break;
				default:
					begin=--i;
			}
		}
	}

	if((rest=transfer(&str[begin],i-begin,&buf[crt_pos],buf_size-crt_pos))==-1)return -1;
	crt_pos+=rest;

	return crt_pos;
}


int printf(const char *str,...)
{
	return inputString(str,NULL,0,(uint*)&str+1,transferStdout);
}
