/*
 * keyboard.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * keyboard driver
 */


#include"types.h"
#include"lib.h"
#include"interrupt.h"
#include"keyboard.h"


enum{
	IRQ_NO=1		/* IRQ number */
};


/*
 * keyboard interrupt handler
 * return : no task switch
 */
static int keyboardIntrHandler()
{
	enum{
		KEY_BREAK=0x80	/* key up bit. */
	};

	uchar key_coad;

/******************************************************************
	printk("Interrupt IRQ1\n");
*******************************************************************/

	/* KeyUpʤ餹λ */
	if((key_coad=inb(KEYBOARD_OUTPUT_REG))&KEY_BREAK)return 0;

/********************************************************************/
	{
		volatile int *keyDown=(int*)0x9f000;

		*keyDown=1;
	}
/********************************************************************/

	return 0;
}


/*
 * init keyboard driver
 */
void initKeyboard()
{
	/* clear data register */
	inb(KEYBOARD_OUTPUT_REG);

	/* ߤ */
	irq_entry[IRQ1]=keyboardIntrHandler;
	release_irq_mask(IRQ_NO);
}
