/*
 * orig_fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥸʥե륷ƥ
 */


#include"config.h"
#include"types.h"
#include"lib.h"
#include"errno.h"
#include"mm.h"
#include"fs.h"
#include"device.h"
#include"orig_fs.h"


enum{
	MAX_NAME_SIZE=127,								/* ե̾ */
	MAX_DIR_NUM=4,									/* ǥ쥯ȥ */
	INODE_BLOCK_NUM=(BLOCK_SIZE-44)/sizeof(uint),	/* inode֥å */
};


/* Inode */
typedef struct{
	int file_type;					/* File type */
	ushort owner_id;				/* Owner UID */
	ushort group_id;				/* Group ID */
	size_t size;					/* File size by byte */
	uint64 access_time;				/* Last access time */
	uint64 create_time;				/* Create time */
	uint64 modificat_time;			/* Last modification time */
	uint my_secter;					/* my block number */
	uint parent_sect;				/* ƥǥ쥯ȥꥻ */
	uint secter[INODE_BLOCK_NUM];	/* file secter number */
}INODE;

/* Directory entry */
typedef struct{
	uchar type;			/* File or directory */
	uchar size;			/* entry size */
	char parent_dir;	/* parent entry directory */
	uchar parent;		/* parent entry offset */
	char low_dir;		/* low entry directory */
	uchar low;			/* low entry offset */
	char high_dir;		/* high entry directory */
	uchar high;			/* high entry offset */
	ushort low_num;		/* lowȥ꡼ */
	ushort high_num;	/* highȥ꡼ */
	uint secter;		/* secter number */
	char name[0];		/* Name string */
}DIR_ENT;


static SUPER_BLOCK *super_block[MAX_DEVICE_OPEN];
static ENPTY_BLOCK *empty_blk[MAX_DEVICE_OPEN];


static uint mount(int);
static int umount(int);
static int open(const char*,int,uint);
static int close(int,uint);
static int read(int,uint,void*,size_t,size_t);
static int write(int,uint,void*,size_t,size_t);
static int ioctr(int,uint,int,void*);
static int rename(int,uint,const char*);
static int creat(const char*,int,uint);
static uint opendir(const char*,int,uint);
static int mkdir(const char*,int,uint);


static FS orig_fs={
	"orig_fs",mount,umount,open,close,read,write,ioctr,rename,creat,opendir,mkdir
};


/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =0 or =1 or =-1;
 */
extern inline int cmp_path(const char *path1,const char *path2)
{
	while(*path1++==*path2++)
		if(*(path1-1)=='\0')return 0;

	if((*--path1=='\0')&&(*--path2=='/'))return 0;
	if(*path1<*path2)return 1;

	return -1;
}


/************************************************************************************
 *
 * Init functions
 *
 ************************************************************************************/

int init_orig_fs()
{
	int i;


	for(i=0;i<MAX_DEVICE_OPEN;++i)
	{
		super_block[i]=NULL;
		empty_blk[i]=NULL;
	}

	return regist_fs(&orig_fs);
}


/************************************************************************************
 *
 * block  functions
 *
 ************************************************************************************/

/*
 * ֥å롣
 * parameters : device inode
 * return : empty block secter or error=0
 */
uint get_empty_blk(int din)
{
	uint secter;


	if(empty_blk[din]==NULL)return 0;

	secter=empty_blk[din]->empty[empty_blk[din]->current];

	if(--empty_blk[din]->current<0)
	{
		if(empty_blk[din]->next==0)
		{
			kfree(empty_blk[din]);
			empty_blk[din]=NULL;
		}
		else
		{
			super_block[din]->empty_blk=empty_blk[din]->next;
			if(read_direct(din,empty_blk[din],super_block[din]->blk_per_sect,empty_blk[din]->next)!=super_block[din]->blk_per_sect)
				return 0;

		}
	}

	return secter;
}


/*
 * ֥åơ֥åǥå˲ä롣
 * parameters :
 * return : 0 or error=-1
 */
int release_blk(int din,uint blk)
{
	/* ǥåʤ硣 */
	if(empty_blk[din]==NULL)
	{
		if((empty_blk[din]=(ENPTY_BLOCK*)kmalloc(super_block[din]->block_size))==NULL)return -1;
		super_block[din]->empty_blk=blk;
		empty_blk[din]->next=0;
		empty_blk[din]->current=-1;
	}

	/* ǥåäѤξ硣 */
	if(++empty_blk[din]->current>=(super_block[din]->block_size-sizeof(ENPTY_BLOCK)/sizeof(uint)))
	{
		--empty_blk[din]->current;
		empty_blk[din]->next=blk;
		if((write_direct(din,empty_blk[din],super_block[din]->block_size,super_block[din]->empty_blk))!=super_block[din]->block_size)
			return -1;
		super_block[din]->empty_blk=blk;
		empty_blk[din]->next=0;
		empty_blk[din]->current=0;
	}

	empty_blk[din]->empty[empty_blk[din]->current]=blk;

	return 0;
}


/***********************************************************************************
 *
 * directory functions
 *
 ************************************************************************************/

DIR_ENT *round_low(DIR_ENT *top,ushort *root,uint buf_add)
{
	return NULL;
}


DIR_ENT *round_high(DIR_ENT *top,ushort *root,uint buf_add)
{
	return NULL;
}


/*
 * ǥ쥯ȥΥȥ꡼õ
 *
 * return : directory entry or error=NULL
 */
DIR_ENT *search_dir_entry(const char *path,DIR **dir)
{
	DIR_ENT *p[MAX_DIR_NUM+1],*q;
	int i,rest;


	if(dir[0]->ent_topdir==-1)return NULL;

	/* directory entry bufferꡣ */
	p[0]=(DIR_ENT*)dir[0]->entry;
	for(i=1;dir[i]!=NULL;++i)p[i]=(DIR_ENT*)&dir[0]->ent_topdir;

	for(q=&p[dir[0]->ent_topdir][dir[0]->entry_top];;)
	{
		rest=cmp_path(q->name,path);

		if(rest>0)
		{
			if(q->high_dir==-1)break;
			q=&p[q->high_dir][q->high];
		}
		else if(rest<0)
		{
			if(q->low_dir==-1)break;
			q=&p[q->low_dir][q->low];
		}
		else return q;
	}

	return NULL;
}


void add_dir_entry(DIR_ENT *entry,DIR **dir)
{

}


/*
 * ǥ쥯ȥζȥ꡼롣
 * parameters : ѥΥ,directory pointer
 * return : directory entry or error=NULL
 */
DIR_ENT *get_empty_dir_entry(int path_len,DIR **dir)
{
	enum{MIM_EMPTY_SIZE=2};		/* ȥ꡼ǺǾλĤ */

	int entry_len;
	int i,k;
	EMPTY_ENT *p;


	/* ̾Υǧ */
	if(path_len>MAX_NAME_SIZE)return NULL;

	entry_len=(path_len+sizeof(DIR_ENT))/sizeof(DIR_ENT)+1;		/* sizeof(DIR_ENT)ñ̤Ƿ夲 */

	/* ȥ꡼򸡺 */
	for(i=0,p=(EMPTY_ENT*)dir[i]->entry;dir[i]!=NULL;++i,p=(EMPTY_ENT*)&dir[i]->entry_top)
	{
		for(k=dir[i]->empty_top;k!=0;k=p[k].next)
			if(p[k].size>entry_len)
			{
				if(p[k].size>entry_len+MIM_EMPTY_SIZE)
				{
					p[k+entry_len].prev=p[k].prev;
					p[k+entry_len].next=p[k].next;
					p[k+entry_len].size=p[k].size-entry_len;
				}
				else if(p[k].next==k)dir[i]->empty_top=0;
				else
				{
					p[p[k].prev].next=p[k].next;
					p[p[k].next].prev=p[k].prev;
				}

				return (DIR_ENT*)&p[k];
			}
	}

	return NULL;
}


/*
 * ȥ꡼ξʤزžʬǥȥ꡼򲼹ߤơ󥯤롣
 * parameters :
 * return : delete entry or error=NULL
 */
DIR_ENT *del_dir_entry(const char *path,DIR **dir)
{
	return NULL;
}


/*
 * ʬ٨ʿؿ
 * ¦Υȥ꡼ȿ¦Υȥ꡼2ܤ¿
 * ¦¦Υȥ꡼¦Υȥ꡼1/2꾯ʤ硢ȿ¦زž롣
 * parameters : top entry,root entry address pointer,directory buffer address
 * return : new top entyr or error=NULL
 */
DIR_ENT *splay(DIR_ENT *top,DIR **dir)
{
	return NULL;
}


/*
 * ѥκǸΥǥ쥯ȥꥨȥ꡼õ
 *
 * return : directory entry or error=NULL
 */
DIR_ENT *get_last_dir_entry(const char *path,DIR *dir,int din)
{
	return NULL;
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

/*
 * parameters : device inode
 * return : root directory block or error=0
 */
uint mount(int din)
{
	void *buf;
	int block;			/* BLOCK_SIZE/secter */
	DEV_STAT dev_stat;


	/* Ǥ˥ޥȤƤ뤫ǧ */
	if(super_block[din]!=NULL)return 0;

	/* Read super block */
	if(get_dev_stat(din,&dev_stat)==-1)return 0;
	block=BLOCK_SIZE/dev_stat.sect_size;
	if((buf=kmalloc(BLOCK_SIZE))==NULL)return 0;
	if(read_direct(din,buf,block,SBLOCK_SECTER)!=block)return 0;
	if(((SUPER_BLOCK*)buf)->magic_number!=SBLOCK_MAGIC)return 0;
	super_block[din]=(SUPER_BLOCK*)buf;

	/* Read empty block */
	if((buf=kmalloc(BLOCK_SIZE))==NULL)goto ERR;
	if(read_direct(din,buf,block,super_block[din]->empty_blk)!=block)goto ERR;
	empty_blk[din]=(ENPTY_BLOCK*)buf;

	return super_block[din]->root_blk;

ERR:
	kfree(super_block[din]);
	super_block[din]=NULL;
	kfree(empty_blk[din]);
	empty_blk[din]=NULL;

	return 0;
}


/*
 * parameters : device inode
 * return : 0 or error=-1
 */
int umount(int din)
{
	return 0;
}


/*
 * parameters : path,device inode,directory block
 * return : inode block or error=-1
 */
int open(const char *path,int din,uint dir)
{
	return 0;
}


/*
 * parameters : device inode,inode block
 * return : 0 or error=-1
 */
int close(int din,uint inode)
{
	return 0;
}


int read(int din,uint inode,void *buf,size_t size,size_t begnin)
{
	return 0;
}


int write(int din,uint inode,void *buf,size_t size,size_t begin)
{
	return 0;
}


int ioctr(int din,uint inode,int cmd,void *param)
{
	return 0;
}


int rename(int din,uint inode,const char *name)
{
	return 0;
}


int creat(const char *path,int din,uint dir)
{
	return 0;
}


uint opendir(const char *path,int din,uint dir)
{
	return 0;
}


int mkdir(const char *path,int din,uint dir)
{
	return 0;
}
/*****************************************************************************************/
void test_orig_fs()
{
	int fd,din;


	if(init_orig_fs()==-1)
	{
		printk("Failed init_orig_fs\n");
		return;
	}

	if(sys_mount("/dev/hdb7","orig_fs","/")==-1)
	{
		printk("Failed sys_mount\n");
		return;
	}

	if((fd=sys_open("/dev/hdb7",0))==-1)return;
	if((din=get_inode(fd))==-1)return;

	printk("get_empty_blk()=%d\n",get_empty_blk(din));
}
/******************************************************************************************/
