/*
 * mkfs.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꥸʥե륷ƥۤ롣
 */


#include"types.h"
#include"lib.h"
#include"mm.h"
#include"fs.h"
#include"device.h"
#include"orig_fs.h"


/*
 * parameters : device path
 * return : 0 or error=-1
 */
int mk_orig_fs(const char *dev_path)
{
	int fd;
	int din;
	SUPER_BLOCK *sbuf;
	DIR *dbuf;
	ENPTY_BLOCK *ebuf;
	DEV_STAT dev_stat;
	int i,j,last,emp_num;


	/* Device open */
	if((fd=sys_open(dev_path,0))==-1)return -1;
	if((din=get_inode(fd))==-1)return -1;

	/* ѡƥ󥿥פγǧ */
	if(get_dev_stat(din,&dev_stat)==-1)return -1;
	if(dev_stat.prt_type!=PT_TYPE_ORIG)return -1;

	/* ѡ֥åꡣ */
	if((sbuf=(SUPER_BLOCK*)kmalloc(sizeof(SUPER_BLOCK)))==NULL)return -1;
	sbuf->block_size=(dev_stat.sect_size>BLOCK_SIZE)?dev_stat.sect_size:BLOCK_SIZE;
	sbuf->blk_per_sect=sbuf->block_size/dev_stat.sect_size;
	sbuf->all_blk=dev_stat.all_sect/sbuf->blk_per_sect;
	sbuf->magic_number=SBLOCK_MAGIC;
	sbuf->useable_blk=(dev_stat.all_sect-SBLOCK_SECTER)/sbuf->blk_per_sect-1;

	/* root directory  */
	sbuf->root_blk=SBLOCK_SECTER+sbuf->blk_per_sect;
	if((dbuf=(DIR*)kmalloc(sizeof(DIR)))==NULL)goto ERR;
	dbuf->my_secter=sbuf->root_blk;
	dbuf->size=sbuf->block_size;
	dbuf->empty_top=0;
	dbuf->ent_topdir=-1;
	dbuf->entry_top=0;
	write_direct(din,dbuf,sizeof(DIR),sbuf->root_blk);		/* ǥХؽ񤭹ߡ */
	kfree(dbuf);

	/* ֥åǥåꡣ */
	if((ebuf=(ENPTY_BLOCK*)kmalloc(sbuf->block_size))==NULL)goto ERR;
	emp_num=(sbuf->block_size-sizeof(ENPTY_BLOCK))/sizeof(uint);
	dev_stat.all_sect=ROUNDDOWN(dev_stat.all_sect-sbuf->blk_per_sect+1,sbuf->blk_per_sect);
	last=dev_stat.all_sect-emp_num*sbuf->blk_per_sect;
	for(i=sbuf->root_blk+sbuf->blk_per_sect;i<last;)
	{
		/* ֥åǥåκ */
		for(j=emp_num-1;j>=0;--j)
		{
			ebuf->empty[j]=i;
			i+=sbuf->blk_per_sect;
		}
		ebuf->next=i;
		ebuf->current=emp_num-1;
		write_direct(din,ebuf,sbuf->block_size,i-sbuf->blk_per_sect);		/* ǥХؽ񤭹ߡ */
		
		/* ʹԾɽ */
		printk("Init empty index %d%%\r",i/(dev_stat.all_sect/100));
	}
	/* ֥åǥåκ */
	emp_num=(dev_stat.all_sect-i)/sbuf->blk_per_sect;
	for(j=emp_num;j>=0;--j,i+=sbuf->blk_per_sect)ebuf->empty[j]=i;
	ebuf->next=0;
	ebuf->current=emp_num;
	write_direct(din,ebuf,sbuf->block_size,i-sbuf->blk_per_sect);		/* ǥХؽ񤭹ߡ */
	
	/* ʹԾɽ */
	printk("Init empty index 100%%\n");

	kfree(ebuf);

	sbuf->empty_blk=SBLOCK_SECTER+sbuf->blk_per_sect+
		((sbuf->block_size-sizeof(ENPTY_BLOCK))/sizeof(uint)-1)*sbuf->blk_per_sect;
	write_direct(din,sbuf,sizeof(SUPER_BLOCK),SBLOCK_SECTER);		/* ѡ֥å񤭹ࡣ */
	kfree(sbuf);

	/* device close */
	return sys_close(fd);

ERR:
	kfree(sbuf);
	sys_close(fd);

	return -1;
}
