/*
 * fpathconf.c
 */


#include<sys/types.h>
#include<sys/stat.h>

#include<callgate.h>
#include<sys/system.h>
#include<errno.h>
#include<string.h>
#include<signal.h>
#include<stdio.h>
#include<stropts.h>
#include<unistd.h>


long fpathconf(int filedes, int name)
{
	struct stat st;


	if(fstat(filedes,&st)==-1)return -1;

	switch(name)
	{
		case _PC_LINK_MAX:
			return _POSIX_LINK_MAX;
		case _PC_MAX_CANON:
			return _POSIX_MAX_CANON;
		case _PC_MAX_INPUT:
			return _POSIX_MAX_INPUT;
		case _PC_NAME_MAX:
			return NAME_MAX;
		case _PC_PATH_MAX:
			return _POSIX_PATH_MAX;
		case _PC_PIPE_BUF:
			return _POSIX_PIPE_BUF;
		case _PC_CHOWN_RESTRICTED:
			return st.st_uid;
		case _PC_NO_TRUNC:
			return 0;
		case _PC_VDISABLE:
			return 0;
		default:
			return _error(EINVAL);
	}
}
