/*
 * unistd.h
 */


#ifndef unistd_h
#define unistd_h


#include <sys/types.h>
#include <stddef.h>
#include <sys/unistd.h>


/* Symbolic constants for the access() function. */
#define	F_OK	1<<0		/* ե뤬¸ߤ뤫 */
#define	R_OK	1<<1		/* ե뤬¸ߤɤ߹ߵĤ뤫 */
#define	W_OK	1<<2		/* ե뤬¸ߤƽ񤭹ߵĤ뤫 */
#define	X_OK	1<<3		/* ե뤬¸ߤƼ¹ԵĤ뤫 */

	/* Version Test Symbolic Constants. */
#define	_POSIX_VERSION		199009L
#define	_POSIX2_VERSION		200112L
#define	_POSIX_JOB_CONTROL	1
#define	_POSIX_SAVED_IDS	0

	/* Execution-Time Symbolic Constants. */
#define	_POSIX_ASYNC_IO	-1
#define	_POSIX_PRIO_IO	-1
#define	_POSIX_SYNC_IO	-1

/* Symbolic constants for the confstr() function. */
#define	_CS_PATH							0
#define	_CS_POSIX_V6_ILP32_OFF32_CFLAGS		1
#define	_CS_POSIX_V6_ILP32_OFF32_LDFLAGS	2
#define	_CS_POSIX_V6_ILP32_OFF32_LIBS		3
#define	_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS	4
#define	_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS	5
#define	_CS_POSIX_V6_ILP32_OFFBIG_LIBS		6
#define	_CS_POSIX_V6_LP64_OFF64_CFLAGS		7
#define	_CS_POSIX_V6_LP64_OFF64_LDFLAGS		8
#define	_CS_POSIX_V6_LP64_OFF64_LIBS		9
#define	_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS	10
#define	_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS	11
#define	_CS_POSIX_V6_LPBIG_OFFBIG_LIBS		12
#define	_CS_POSIX_V6_WIDTH_RESTRICTED_ENVS	13

	/* Symbolic constants as possible values for the function argument to the lockf() function. */
#define	F_LOCK	0
#define	F_TEST	1
#define	F_TLOCK	2
#define	F_ULOCK	3

	/* Symbolic constants for the pathconf() function. */
#define	_PC_ALLOC_SIZE_MIN		0
#define	_PC_ASYNC_IO			1
#define	_PC_CHOWN_RESTRICTED	2
#define	_PC_FILESIZEBITS		3
#define	_PC_LINK_MAX			4
#define	_PC_MAX_CANON			5
#define	_PC_MAX_INPUT			6
#define	_PC_NAME_MAX			7
#define	_PC_NO_TRUNC			8
#define	_PC_PATH_MAX			9
#define	_PC_PIPE_BUF			10
#define	_PC_PRIO_IO				11
#define	_PC_REC_INCR_XFER_SIZE	12
#define	_PC_REC_MAX_XFER_SIZE	13
#define	_PC_REC_MIN_XFER_SIZE	14
#define	_PC_REC_XFER_ALIGN		15
#define	_PC_SYNC_IO				16
#define	_PC_VDISABLE			17
#define	_POSIX_VDISABLE			-1

	/* Symbolic constants for the sysconf() function. */
#define	_SC_2_C_BIND					0
#define	_SC_2_C_DEV						1
#define	_SC_2_C_VERSION					2
#define	_SC_2_CHAR_TERM					3
#define	_SC_2_FORT_DEV					4
#define	_SC_2_FORT_RUN					5
#define	_SC_2_LOCALEDEF					6
#define	_SC_2_PBS						7
#define	_SC_2_PBS_ACCOUNTING			8
#define	_SC_2_PBS_CHECKPOINT			9
#define	_SC_2_PBS_LOCATE				10
#define	_SC_2_PBS_MESSAGE				11
#define	_SC_2_PBS_TRACK					12
#define	_SC_2_SW_DEV					13
#define	_SC_2_UPE						14
#define	_SC_2_VERSION					15
#define	_SC_ADVISORY_INFO				16
#define	_SC_ARG_MAX						17
#define	_SC_AIO_LISTIO_MAX				18
#define	_SC_AIO_MAX						19
#define	_SC_AIO_PRIO_DELTA_MAX			20
#define	_SC_ASYNCHRONOUS_IO				21
#define	_SC_BC_BASE_MAX					22
#define	_SC_BC_DIM_MAX					23
#define	_SC_BC_SCALE_MAX				24
#define	_SC_BC_STRING_MAX				25
#define	_SC_CHILD_MAX					26
#define	_SC_CLK_TCK						27
#define	_SC_COLL_WEIGHTS_MAX			28
#define	_SC_CPUTIME						29
#define	_SC_DELAYTIMER_MAX				30
#define	_SC_EXPR_NEST_MAX				31
#define	_SC_FILE_LOCKING				32
#define	_SC_FSYNC						33
#define	_SC_GETGR_R_SIZE_MAX			34
#define	_SC_GETPW_R_SIZE_MAX			35
#define	_SC_HOST_NAME_MAX				36
#define	_SC_JOB_CONTROL					37
#define	_SC_LINE_MAX					38
#define	_SC_LOGIN_NAME_MAX				39
#define	_SC_MAPPED_FILES				40
#define	_SC_MEMLOCK						41
#define	_SC_MEMLOCK_RANGE				42
#define	_SC_MEMORY_PROTECTION			43
#define	_SC_MESSAGE_PASSING				44
#define	_SC_MQ_OPEN_MAX					45
#define	_SC_MQ_PRIO_MAX					46
#define	_SC_NGROUPS_MAX					47
#define	_SC_OPEN_MAX					48
#define	_SC_PRIORITIZED_IO				49
#define	_SC_PRIORITY_SCHEDULING			50
#define	_SC_RE_DUP_MAX					51
#define	_SC_REALTIME_SIGNALS			52
#define	_SC_REGEXP						53
#define	_SC_RTSIG_MAX					54
#define	_SC_SAVED_IDS					55
#define	_SC_SEMAPHORES					56
#define	_SC_SEM_NSEMS_MAX				57
#define	_SC_SEM_VALUE_MAX				58
#define	_SC_SHARED_MEMORY_OBJECTS		59
#define	_SC_SHELL						60
#define	_SC_SIGQUEUE_MAX				61
#define	_SC_SPAWN						62
#define	_SC_SPORADIC_SERVER				63
#define	_SC_STREAM_MAX					64
#define	_SC_SYNCHRONIZED_IO				65
#define	_SC_THREAD_ATTR_STACKADDR		66
#define	_SC_THREAD_ATTR_STACKSIZE		67
#define	_SC_THREAD_CPUTIME				68
#define	_SC_THREAD_DESTRUCTOR_ITERATIONS	69
#define	_SC_THREAD_KEYS_MAX				70
#define	_SC_THREAD_PRIO_INHERIT			71
#define	_SC_THREAD_PRIO_PROTECT			72
#define	_SC_THREAD_PRIORITY_SCHEDULING	73
#define	_SC_THREAD_PROCESS_SHARED		74
#define	_SC_THREAD_SAFE_FUNCTIONS		75
#define	_SC_THREAD_SPORADIC_SERVER		76
#define	_SC_THREAD_STACK_MIN			77
#define	_SC_THREAD_THREADS_MAX			78
#define	_SC_TIMEOUTS					79
#define	_SC_THREADS						80
#define	_SC_TIMER_MAX					81
#define	_SC_TIMERS						82
#define	_SC_TTY_NAME_MAX				83
#define	_SC_TZNAME_MAX					84
#define	_SC_V6_ILP32_OFF32				85
#define	_SC_V6_ILP32_OFFBIG				86
#define	_SC_V6_LP64_OFF64				87
#define	_SC_V6_LPBIG_OFFBIG				88
#define	_SC_VERSION						89

	/* Symbolic constants for file streams. */
#define	STDIN_FILENO	0
#define	STDOUT_FILENO	1
#define	STDERR_FILENO	2


extern char *optarg;
extern int optind, opterr, optopt;


/* Function declarations. */
extern int          access(const char *, int);
extern unsigned     alarm(unsigned);
extern int          chdir(const char *);
extern int          chown(const char *, uid_t, gid_t);
extern int          close(int);
extern int          dup(int);
extern int          dup2(int, int);
extern int          execve(const char *, char *const [], char *const []);
extern int          execl(const char *, const char *, ...);
extern int          execle(const char *, const char *, ...);
extern int          execlp(const char *, const char *, ...);
extern int          execv(const char *, char *const []);
extern int          execvp(const char *, char *const []);
extern void        _exit(int);
extern int          fchdir(int);
extern int          fchown(int, uid_t, gid_t);
extern pid_t        fork(void);
extern long         fpathconf(int, int);
extern int          fsync(int);
extern int          ftruncate(int, off_t);
extern char        *getcwd(char *, size_t);
extern gid_t        getegid(void);
extern uid_t        geteuid(void);
extern gid_t        getgid(void);
extern int          gethostname(char *, size_t);
extern char        *getlogin(void);
extern pid_t        getpgid(pid_t);
extern pid_t        getpid(void);
extern int          getgroups(int, gid_t []);
extern pid_t        getpgrp(void);
extern pid_t        getppid(void);
extern uid_t        getuid(void);
extern int          isatty(int);
extern int          lchown(const char *, uid_t, gid_t);
extern int          link(const char *, const char *);
extern off_t        lseek(int, off_t, int);
extern long         pathconf(const char *, int);
extern int          pause(void);
extern int          pipe(int [2]);
extern ssize_t      read(int, void *, size_t);
extern ssize_t      readlink(const char *, char *, size_t);
extern int          rmdir(const char *);
extern int          setegid(gid_t);
extern int          seteuid(uid_t);
extern int          setgid(gid_t);
extern int          sethostname(const char*, size_t);
extern int          setpgid(pid_t, pid_t);
extern pid_t        setsid(void);
extern int          setuid(uid_t);
extern unsigned     sleep(unsigned);
extern int          symlink(const char *, const char *);
extern long         sysconf(int);
extern pid_t        tcgetpgrp(int);
extern int          tcsetpgrp(int, pid_t);
extern int          truncate(const char *, off_t);
extern char        *ttyname(int);
extern ssize_t      write(int, const void *, size_t);
extern int          unlink(const char *);
extern int          getopt(int argc, char * const argv[], const char *optstring);
extern void        *setmode(const char *);
extern mode_t       getmode(void *bbox, mode_t omode);
extern size_t       confstr(int, char *, size_t);
extern pid_t		 getsid(pid_t pid);
extern char			*getpass(const char *);
extern int			 getpagesize(void);
extern int			 getdtablesize(void);
extern void	 		 usleep(unsigned int);


/* ץޥ */
#ifndef ROUNDUP
#define ROUNDUP(a,b)	(((uint)(a)+(b)-1)/(b)*(b))
#endif
#ifndef ROUNDDOWN
#define ROUNDDOWN(a,b)	((uint)(a)/(b)*(b))
#endif
#ifndef MIN
#define	MIN(a,b)		(((a)<(b))?(a):(b))
#endif
#ifndef MAX
#define	MAX(a,b)		(((a)>(b))?(a):(b))
#endif

/* ץؿ */
extern int brk(void*);
extern int reboot(int);
extern void *sbrk(ptrdiff_t);
extern void sync(void);
extern int  mkstemp (char *);


#endif
