/*
 * sys/wait.h
 */


#ifndef sys_wait_h
#define sys_wait_h


#include<sys/types.h>
#include<share/wait.h>


/*
 * Macros for analysis of process status values.
 */
/* True if child exited normally. */
#define	WIFEXITED(stat)		((int)((stat)&0xFF) == 0)
/* True if child exited due to uncaught signal. */
#define	WIFSIGNALED(stat)	((int)((stat)&0xFF) > 0 && (int)((stat)&0xFF00) == 0)
/* True if child is currently stopped. */
#define	WIFSTOPPED(stat)	((int)((stat)&0xFF) == 0x7F && (int)((stat)&0xFF00) != 0)
/* Return exit status. */
#define	WEXITSTATUS(stat)	((int)(((stat)>>8)&0xFF))
/* Return signal number that caused process to terminate. */
#define	WTERMSIG(stat)		((int)((stat)&0x7F))
/* Return signal number that caused process to stop. */
#define	WSTOPSIG(stat)		((int)(((stat)>>8)&0xFF))


extern pid_t  wait(int *);
extern pid_t  waitpid(pid_t, int *, int);


#endif
