/*
 * sys/types.h
 */


#ifndef sys_types_h
#define sys_types_h


#include <machine/limits.h>
#include <sys/stdint.h>
#include <stddef.h>


#ifndef ASM_FILE


typedef int					blkcnt_t;		/* Used for file block counts. */
typedef int					blksize_t;		/* Used	for block sizes.*/
typedef unsigned int		gid_t;			/* Used for group IDs. */
typedef unsigned int		ino_t;			/* Used for file serial numbers. */
typedef unsigned int		mode_t;			/* Used for some file attributes. */
typedef unsigned short		nlink_t;		/* Used for link counts. */
typedef long long			off_t;			/* Used for file sizes. */
typedef int					pid_t;			/* Used for process IDs and process group IDs. */
typedef int					ssize_t;		/* Used for a count of bytes or an error indication. */
typedef int					time_t;			/* Used for time in seconds. */
typedef unsigned int		uid_t;			/* Used for user IDs. */
typedef unsigned int		clock_t;		/* Used for system times in clock ticks or CLOCKS_PER_SEC. */
typedef long				suseconds_t;	/* Used for time in microseconds. */
typedef unsigned int		id_t;
typedef unsigned int		fixpt_t;		/* fixed point number */
typedef char				*caddr_t;		/* core address */
typedef	int32_t				segsz_t;		/* segment size */
typedef unsigned int		fsblkcnt_t;
typedef unsigned int		fsfilcnt_t;
typedef	unsigned int		vm_offset_t;

/*
 * POSIX Extensions
 */
typedef	unsigned char		uchar_t;
typedef	unsigned short		ushort_t;
typedef	unsigned int		uint_t;
typedef	unsigned long		ulong_t;
typedef	int32_t				daddr_t;		/* disk address */

/* ץ */
typedef unsigned char 		u_char;
typedef unsigned short		u_short;
typedef unsigned int		u_int;
typedef unsigned long		u_long;
typedef unsigned char		uchar;
typedef unsigned short		ushort;
typedef unsigned int		uint;
typedef	long long			quad_t;
typedef	unsigned long long	u_quad_t;
typedef	quad_t 				*qaddr_t;
typedef	quad_t				rlim_t;			/* resource limit */
typedef unsigned long		sector_t;
typedef	u_int32_t			udev_t;			/* device number */


#ifdef KERNEL

typedef struct specinfo* dev_t;

#else

typedef	u_int32_t	dev_t;					/* device number */
typedef	long	fd_mask;
#define	NBBY	CHAR_BIT					/* number of bits in a byte */
#define	NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#define	major(x)	((int)(((u_int)(x) >> 8)&0xff))	/* major number */
#define	minor(x)	((int)((x)&0xffff00ff))			/* minor number */
#define	makedev(x,y)	((dev_t)(((x) << 8) | (y)))	/* create dev_t */

#endif


#endif


#endif
